/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.accountset;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.tree.TreeFilterParameter;
import kd.taxc.tcvvt.common.util.DateUtils;
import kd.taxc.tcvvt.common.util.PermissionUtils;

public class AccountSetPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String BOS_ORG_TYPE_RELATION = "bos_org_typerelation";
    private static final String BOS_ORG = "bos_org";

    public void registerListener(EventObject e) {
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxorg = (BasedataEdit)this.getControl("taxorg");
        taxorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit jtdm = (BasedataEdit)this.getControl("jt_dm");
        jtdm.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        Object pk = this.getModel().getDataEntity().getPkValue();
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"tcvvt_clique_accountset", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", pk)});
        if (load == null || load.length == 0) {
            HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(this.getView());
            if (!hasPermOrgResult.hasAllOrgPerm()) {
                HasPermOrgResult orgsByUserId = PermissionUtils.getAllPermOrgsByUserId("tcvvt", "tcvvt_clique_accountset", "47156aff000000ac", RequestContext.get().getCurrUserId());
                if (orgsByUserId != null) {
                    if (this.getView().getFormShowParameter().getCustomParam("org") != null) {
                        String oid = (String)this.getView().getFormShowParameter().getCustomParam("org");
                        if (!orgsByUserId.hasAllOrgPerm() && orgsByUserId.getHasPermOrgs().contains(Long.valueOf(oid))) {
                            this.getView().getModel().setValue("org", (Object)Long.valueOf(oid));
                            this.getModel().setValue("ztmc", (Object)((DynamicObject)this.getView().getModel().getValue("org")).getString("name"));
                            this.getModel().setDataChanged(false);
                        }
                    } else {
                        this.getView().getModel().setValue("org", null);
                    }
                } else {
                    this.getView().getModel().setValue("org", null);
                }
            } else if (this.getView().getFormShowParameter().getCustomParam("org") != null) {
                String oid = (String)this.getView().getFormShowParameter().getCustomParam("org");
                this.getView().getModel().setValue("org", (Object)Long.valueOf(oid));
                this.getModel().setValue("ztmc", (Object)((DynamicObject)this.getView().getModel().getValue("org")).getString("name"));
                this.getModel().setDataChanged(false);
            }
            Object org = this.getModel().getValue("org");
            if (org != null) {
                this.setDefaultTaxOrg((DynamicObject)org);
            }
        }
    }

    public void setDefaultTaxOrg(DynamicObject org) {
        if (org == null) {
            return;
        }
        DynamicObject[] ogs = BusinessDataServiceHelper.load((String)BOS_ORG_TYPE_RELATION, (String)"id", (QFilter[])new QFilter[]{new QFilter("totype", "=", (Object)"40").and("fromtype", "=", (Object)"10")});
        boolean flag = true;
        if (ogs != null && ogs.length > 0) {
            HasPermOrgResult orgsByUserId;
            long forg;
            DynamicObject[] orgs;
            Long number = ogs[0].getLong("id");
            DynamicObject[] toorg = BusinessDataServiceHelper.load((String)"bos_org_orgrelation", (String)"toorg,fromorg", (QFilter[])new QFilter[]{new QFilter("fromorg", "=", (Object)org.getLong("id")).and("typerelation", "=", (Object)number)});
            if (toorg != null && toorg.length == 1 && (orgs = BusinessDataServiceHelper.load((String)"bastax_taxorg", (String)"id,name,unifiedsocialcode", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(forg = ((DynamicObject)toorg[0].get("toorg")).getLong("id")))})) != null && orgs.length == 1 && (orgsByUserId = PermissionUtils.getAllPermOrgsByUserId("tcvvt", "tcvvt_clique_accountset", "47156aff000000ac", RequestContext.get().getCurrUserId())) != null && (orgsByUserId.hasAllOrgPerm() || orgsByUserId.getHasPermOrgs().contains(orgs[0].getLong("id")))) {
                this.getModel().setValue("taxorg", (Object)orgs[0].getLong("id"));
                this.getModel().setValue("nsrsbh", orgs[0].get("unifiedsocialcode"));
                flag = false;
            }
        }
        if (flag) {
            this.getModel().setValue("taxorg", null);
            this.getModel().setValue("nsrsbh", null);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject[] orgs;
        String key = e.getProperty().getName();
        if ("org".equalsIgnoreCase(key)) {
            if (this.getModel().getValue("org") != null) {
                this.getModel().setValue("ztmc", (Object)((DynamicObject)this.getView().getModel().getValue("org")).getString("name"));
                this.setDefaultTaxOrg((DynamicObject)this.getModel().getValue("org"));
            }
        } else if ("taxorg".equalsIgnoreCase(key) && this.getModel().getValue("taxorg") != null && (orgs = BusinessDataServiceHelper.load((String)"bastax_taxorg", (String)"id,name,unifiedsocialcode", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)((DynamicObject)this.getModel().getValue("taxorg")).getLong("id")).and("status", "=", (Object)"1")})) != null && orgs.length == 1) {
            this.getModel().setValue("nsrsbh", orgs[0].get("unifiedsocialcode"));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = event.getProperty().getName();
        if ("taxorg".equalsIgnoreCase(key)) {
            QFilter qFilter = new QFilter("status", "=", (Object)"1").and("istaxpayer", "=", (Object)"1");
            DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bastax_taxorg", (String)"id", (QFilter[])new QFilter[]{qFilter});
            List ids = Arrays.stream(orgs).map(o -> o.get("id")).collect(Collectors.toList());
            HasPermOrgResult orgsByUserId = PermissionUtils.getAllPermOrgsByUserId("tcvvt", "tcvvt_clique_accountset", "47156aff000000ac", RequestContext.get().getCurrUserId());
            List hasPermOrgs = null;
            if (orgsByUserId != null && !orgsByUserId.hasAllOrgPerm()) {
                hasPermOrgs = orgsByUserId.getHasPermOrgs();
            }
            if (hasPermOrgs != null && ids != null) {
                ids.retainAll(hasPermOrgs);
            }
            ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
            listShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", ids));
            TreeFilterParameter treeFilterParameter = ((ListShowParameter)event.getFormShowParameter()).getTreeFilterParameter();
            treeFilterParameter.getQFilters().add(new QFilter("id", "in", ids));
        } else if ("org".equalsIgnoreCase(key)) {
            HasPermOrgResult orgsByUserId = PermissionUtils.getAllPermOrgsByUserId("tcvvt", "tcvvt_clique_accountset", "47156aff000000ac", RequestContext.get().getCurrUserId());
            QFilter filter = null;
            if (orgsByUserId != null && !orgsByUserId.hasAllOrgPerm()) {
                filter = new QFilter("id", "in", (Object)orgsByUserId.getHasPermOrgs());
            }
            if (filter != null) {
                ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
                listShowParameter.getListFilterParameter().setFilter(filter);
                TreeFilterParameter treeFilterParameter = ((ListShowParameter)event.getFormShowParameter()).getTreeFilterParameter();
                treeFilterParameter.getQFilters().add(filter);
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map sourceData = e.getSourceData();
        String y = sourceData.get("nd_dm").toString();
        if (y.length() <= 4 && y.matches("[0-9]+")) {
            if (Integer.parseInt(y) < 2000 || Integer.parseInt(y) > 2099) {
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5e74\u5ea6\u4ee3\u7801\u5fc5\u987b\u57282000~2099\u4e4b\u95f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AccountSetPlugin_0", (String)"taxc-tcvvt", (Object[])new Object[0]));
                e.setCancel(true);
            }
            sourceData.put("year", DateUtils.stringToDate(y + "-01-01"));
        } else {
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5e74\u5ea6\u4ee3\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"AccountSetPlugin_1", (String)"taxc-tcvvt", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }
}

