/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.confirm;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tcvvt.common.util.DateUtils;
import kd.taxc.tcvvt.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class TcvvtMessagePlugin
extends AbstractFormPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillList billlistap = (BillList)this.getControl("billlistap");
        this.setSelectedItem(billlistap);
        this.initCommonData();
    }

    private void setSelectedItem(BillList billlistap) {
        String operationStatus;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String string = operationStatus = customParams.get("operation_status") != null ? customParams.get("operation_status").toString() : OperationStatus.EDIT.name();
        if (OperationStatus.VIEW.name().equalsIgnoreCase(operationStatus)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"cardselectorap"});
        }
        String newListSelected = customParams.get("selectids") != null ? (String)customParams.get("selectids") : "";
        List<Long> selectedIds = new ArrayList<Long>();
        if (StringUtil.isNotEmpty((CharSequence)newListSelected)) {
            selectedIds = SerializationUtils.fromJsonStringToList((String)newListSelected, Long.class);
        }
        List<DynamicObject> dynamicObjects = this.setValidSelectList(selectedIds, operationStatus);
        List idList = dynamicObjects.stream().map(m -> m.getLong("id")).collect(Collectors.toList());
        QFilter idFilter = new QFilter("id", "in", idList);
        billlistap.setFilter(idFilter);
        ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
        if (!idList.containsAll(selectedIds) && ObjectUtils.isNotEmpty(idList)) {
            selectedIds = idList.subList(0, 2);
            this.getView().getParentView().getModel().setValue("selectids", (Object)SerializationUtils.toJsonString(selectedIds));
        }
        if (ObjectUtils.isNotEmpty(idList)) {
            for (Long newListSelectedId : selectedIds) {
                listSelectedRowCollection.add((Object)new ListSelectedRow((Object)newListSelectedId));
            }
            billlistap.putSelectedRows(listSelectedRowCollection);
        }
    }

    private List<DynamicObject> setValidSelectList(List<Long> selectedIds, String operationStatus) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String templateType = customParams.get("templateType") != null ? customParams.get("templateType").toString() : null;
        DynamicObjectCollection entryentity = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        if (StringUtil.isEmpty((CharSequence)templateType) && entryentity.size() == 0) {
            return new ArrayList<DynamicObject>();
        }
        QFilter filter = new QFilter("type", "=", (Object)templateType);
        if (CollectionUtils.isNotEmpty(selectedIds) && OperationStatus.VIEW.name().equalsIgnoreCase(operationStatus)) {
            filter.and(new QFilter("id", "in", selectedIds));
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tcvvt_check_report", (String)"iconsurl,mainname,introname,id", (QFilter[])new QFilter[]{filter}, (String)"id");
        BillList billlistap = (BillList)this.getControl("billlistap");
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            HashMap<String, String> propertiesMap = new HashMap<String, String>(8);
            HashMap<String, HashMap<String, String>> pmap = new HashMap<String, HashMap<String, String>>(8);
            propertiesMap.put("src", ((DynamicObject)dynamicObjects.get(i)).getString("iconsurl"));
            pmap.put("imageap6", propertiesMap);
            billlistap.setCustomProperties(billlistap.getKey(), i, pmap);
        }
        return dynamicObjects;
    }

    private void initCommonData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgid = customParams.get("orgid") != null ? (String)customParams.get("orgid") : "0";
        String startDate = customParams.get("skssqq") != null ? (String)customParams.get("skssqq") : null;
        String endDate = customParams.get("skssqz") != null ? (String)customParams.get("skssqz") : null;
        String reporttype = customParams.get("reporttype") != null ? (String)customParams.get("reporttype") : "";
        String type = customParams.get("type") != null ? (String)customParams.get("type") : "";
        String templateid = customParams.get("templateid") != null ? (String)customParams.get("templateid") : "";
        Date start = DateUtils.stringToDate(startDate);
        Date end = DateUtils.stringToDate(endDate);
        this.getModel().setValue("startdate", (Object)start);
        this.getModel().setValue("enddate", (Object)end);
        this.getModel().setValue("reporttype", (Object)reporttype);
        this.getModel().setValue("orgid", (Object)orgid);
        this.getModel().setValue("status", (Object)"1");
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        Long accountingstandards = 0L;
        if (ObjectUtils.isNotEmpty(customParams.get("accountingstandards"))) {
            accountingstandards = Long.parseLong(customParams.get("accountingstandards").toString());
        } else if (ObjectUtils.isNotEmpty((Object)pageCache.get("cache_accountingstandards"))) {
            accountingstandards = Long.parseLong(pageCache.get("cache_accountingstandards"));
        }
        String newrule = "";
        if (ObjectUtils.isNotEmpty(customParams.get("newrule"))) {
            newrule = customParams.get("newrule").toString();
        } else if (ObjectUtils.isNotEmpty((Object)pageCache.get("cache_newrule"))) {
            newrule = pageCache.get("cache_newrule");
        }
        String registeraddress = "";
        if (ObjectUtils.isNotEmpty(customParams.get("registeraddress"))) {
            registeraddress = customParams.get("registeraddress").toString();
        } else if (ObjectUtils.isNotEmpty((Object)pageCache.get("cache_registeraddress"))) {
            registeraddress = pageCache.get("cache_registeraddress");
        }
        this.getModel().setValue("accountingstandards", (Object)accountingstandards);
        this.getModel().setValue("newrule", (Object)newrule);
        this.getModel().setValue("registeraddress", (Object)registeraddress);
        this.getModel().setValue("type", (Object)type);
        this.getModel().setValue("templateid", (Object)templateid);
    }
}

