/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.confirm;

import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.DeclareStepsUtils;
import kd.taxc.tcvvt.common.constant.TaxStepsConstant;
import kd.taxc.tcvvt.common.util.DateUtils;

@Deprecated
public class TcvvtPolicyPlugin
extends AbstractFormPlugin {
    private static final String ORG_ID = "orgid";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final int FIRST_DAY = 1;
    private IPageCache parentPageCache;

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String skssqq = (String)customParams.get("skssqq");
        String skssqz = (String)customParams.get("skssqz");
        String orgid = (String)customParams.get(ORG_ID);
        this.getModel().setValue(ORG_ID, (Object)orgid);
        Date start = DateUtils.stringToDate(skssqq);
        this.getModel().setValue(START_DATE, (Object)start);
        Date end = DateUtils.stringToDate(skssqz);
        this.getModel().setValue(END_DATE, (Object)end);
        int monthDiff = DateUtils.getMonthDiff(end, start);
        if (monthDiff == 11) {
            QFilter q1 = new QFilter("orgrow.orgid", "=", (Object)Long.parseLong(orgid));
            QFilter q2 = new QFilter("orgrow.level", "=", (Object)1);
            QFilter q3 = new QFilter(START_DATE, "<=", (Object)start);
            QFilter q4 = new QFilter(END_DATE, "is null", null).or(new QFilter(END_DATE, ">=", (Object)end));
            boolean exists = QueryServiceHelper.exists((String)"tcvvt_group_book", (QFilter[])new QFilter[]{q1, q2, q3, q4});
            if (exists) {
                this.getModel().setValue("showmcinfo", (Object)Boolean.TRUE);
                IPageCache parentPageCache = this.getParentPageCache();
                parentPageCache.put("showmcinfo", "true");
                this.initTreeEntryEntity(orgid, start, end);
            }
        }
    }

    private void initTreeEntryEntity(String orgid, Date start, Date end) {
        QFilter q1 = new QFilter("orgrow.parentid", "=", (Object)Long.parseLong(orgid));
        QFilter q2 = new QFilter("orgrow.orgid", "=", (Object)Long.parseLong(orgid));
        QFilter q3 = new QFilter(START_DATE, "<=", (Object)start);
        QFilter q4 = new QFilter(END_DATE, "is null", null).or(new QFilter(END_DATE, ">=", (Object)end));
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"tcvvt_group_book", (String)"orgrow.orgid, orgrow.parentid", (QFilter[])new QFilter[]{q1.or(q2), q3, q4});
        DynamicObjectCollection treeentryentity = this.getModel().getEntryEntity("treeentryentity");
        DynamicObjectType dynamicObjectType = treeentryentity.getDynamicObjectType();
        long[] pks = DBServiceHelper.genLongIds((String)"tcvvt_policy_confirm.treeentryentity", (int)objects.size());
        HashMap<Long, Integer> map = new HashMap<Long, Integer>(pks.length);
        for (int i = 0; i < pks.length; ++i) {
            map.put(((DynamicObject)objects.get(i)).getLong("orgrow.orgid"), i);
            DynamicObject dd = new DynamicObject(dynamicObjectType);
            dd.set("id", (Object)pks[i]);
            if (i != 0) {
                Integer a = (Integer)map.get(((DynamicObject)objects.get(i)).getLong("orgrow.parentid"));
                dd.set("pid", a == null ? null : Long.valueOf(pks[a]));
            }
            int row = this.getModel().createNewEntryRow("treeentryentity", dd);
            this.getModel().setValue("taxorg", (Object)((DynamicObject)objects.get(i)).getLong("orgrow.orgid"), row);
        }
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        treeEntry.setCollapse(false);
    }

    public void afterBindData(EventObject e) {
        Boolean showmcinfo = (Boolean)this.getModel().getValue("showmcinfo");
        this.getParentPageCache().put("showmcinfo", showmcinfo.toString());
        this.getView().setVisible(showmcinfo, new String[]{"syzqybdb", "fz", "hbsyzqybdb", "hbfz", "mcflex"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (propertyName.equals(START_DATE) || propertyName.equals(END_DATE)) {
            Date endDate;
            Date startDate = (Date)this.getModel().getValue(START_DATE);
            if (this.checkTaxDate(startDate, endDate = (Date)this.getModel().getValue(END_DATE)) && this.getView().getParentView() != null) {
                IDataModel parentModel = this.getView().getParentView().getModel();
                parentModel.setValue(START_DATE, (Object)startDate);
                parentModel.setValue(END_DATE, (Object)endDate);
                this.getView().sendFormAction(this.getView().getParentView());
            }
        } else if (propertyName.equals(ORG_ID)) {
            if (e.getChangeSet()[0].getNewValue() != null) {
                IDataModel parentModel = this.getView().getParentView().getModel();
                Object orgid = e.getChangeSet()[0].getNewValue();
                parentModel.setValue("org", orgid);
                this.getView().sendFormAction(this.getView().getParentView());
            }
        } else {
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"tcvvt_policy_confirm", (DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)}, (OperateOption)OperateOption.create());
            if (result.isSuccess()) {
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                String orgid = customParams.get(ORG_ID) != null ? (String)customParams.get(ORG_ID) : "0";
                String startDate = (String)customParams.get("skssqq");
                String endDate = (String)customParams.get("skssqz");
                DeclareStepsUtils.updateStatus((Map)customParams, (String)orgid, (String)startDate, (String)endDate, (IFormView)this.getView());
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TcvvtPolicyPlugin_0", (String)"taxc-tcvvt", (Object[])new Object[0]));
                DeclareStepsUtils.resetParentSteps((int)TaxStepsConstant.getTcvvt().size(), (String)"1", (String)"1", (IFormView)this.getView());
            } else {
                this.getView().getParentView().showErrorNotification(((OperateErrorInfo)((ValidateResult)result.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage());
            }
        }
    }

    private boolean checkTaxDate(Date startDate, Date endDate) {
        boolean isFullDate4;
        if (startDate == null || endDate == null) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        int startDay = calendar.get(5);
        int startMonth = calendar.get(2) + 1;
        int startYear = calendar.get(1);
        calendar.setTime(endDate);
        int endDay = calendar.get(5);
        int endMonth = calendar.get(2) + 1;
        int endYear = calendar.get(1);
        calendar.setTime(DateUtils.getLastDateOfMonth(endDate));
        int lastDay = calendar.get(5);
        if (startDay != 1 || endDay != lastDay) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u671f\u4e0d\u5408\u6cd5\uff0c\u5fc5\u987b\u4e3a\u6574\u5e74\u3001\u5b63\u6216\u6708\u3002", (String)"TcvvtPolicyPlugin_1", (String)"taxc-tcvvt", (Object[])new Object[0]));
            return false;
        }
        if (startYear != endYear) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u671f\u8d77\u548c\u6240\u5c5e\u671f\u6b62\u5fc5\u987b\u5728\u540c\u4e00\u5e74\u3002", (String)"TcvvtPolicyPlugin_2", (String)"taxc-tcvvt", (Object[])new Object[0]));
            return false;
        }
        int monthDiff = endMonth - startMonth;
        boolean isFullDate1 = monthDiff != 0 && monthDiff != 2 && monthDiff != 5 && monthDiff != 11;
        boolean isFullDate2 = monthDiff == 2 && startMonth != 1 && startMonth != 4 && startMonth != 7 && startMonth != 10;
        boolean isFullDate3 = monthDiff == 5 && startMonth != 1 && startMonth != 7;
        boolean bl = isFullDate4 = monthDiff == 11 && startMonth != 1;
        if (isFullDate1 || isFullDate2 || isFullDate3 || isFullDate4) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u671f\u4e0d\u5408\u6cd5\uff0c\u5fc5\u987b\u4e3a\u6574\u5e74\u3001\u5b63\u6216\u6708\u3002", (String)"TcvvtPolicyPlugin_1", (String)"taxc-tcvvt", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private IPageCache getParentPageCache() {
        if (this.parentPageCache == null) {
            this.parentPageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        }
        return this.parentPageCache;
    }
}

