/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.declare;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;
import kd.taxc.bdtaxr.common.vo.TemplateVo;
import kd.taxc.tcvvt.common.model.response.DeclareResponseModel;
import kd.taxc.tcvvt.common.util.DateUtils;
import kd.taxc.tcvvt.common.util.EmptyCheckUtils;
import kd.taxc.tcvvt.common.util.JsonUtil;
import kd.taxc.tcvvt.common.util.MainReportUtil;
import kd.taxc.tcvvt.common.util.StringUtil;
import kd.taxc.tcvvt.formplugin.facility.DeclareCheckFacility;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class DeductTZDetailFormPlugin
extends AbstractFormPlugin
implements SelectRowsEventListener {
    private static final String ORG = "org";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String RULEID = "ruleid";
    private static final String ENTRYENTITY_CARD = "entryentitycard";
    private static final String ENTRYENTITY_LIST = "entryentitylist";
    private static final String TCVVT_MAIN_DETAIL = "tcvvt_main_detail";
    private static final String SERIALNO = "serialno";
    private static final String TCVVT_MAIN_ADJUST = "tcvvt_main_adjust";
    public static final String DECLARE_PAGE_ID = "declarepageid";

    public void initialize() {
        CardEntry cardEntry = (CardEntry)this.getControl(ENTRYENTITY_CARD);
        cardEntry.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgId = customParams.get(ORG).toString();
        BigDecimal cellvalue = new BigDecimal(customParams.get("cellvalue").toString());
        Date skssqq = DateUtils.stringToDate((String)customParams.get(SKSSQQ));
        Date skssqz = DateUtils.stringToDate((String)customParams.get(SKSSQZ));
        String cellId = customParams.get("cellid").toString();
        String operation = customParams.get("operation") != null ? customParams.get("operation").toString() : "";
        this.getModel().setValue("operation", (Object)operation);
        ImmutablePair<String, String> immutablePair = this.getAccessprojectidAndSerialno();
        String accessprojectid = (String)immutablePair.left;
        String serialNo = (String)immutablePair.right;
        this.setCartModel(Long.parseLong(orgId), skssqq, skssqz, cellId, cellvalue, accessprojectid, serialNo);
        this.clearEntry(ENTRYENTITY_LIST);
        if (StringUtils.isNotEmpty((CharSequence)serialNo)) {
            this.setEntryentitylist(Long.parseLong(orgId), skssqq, skssqz, serialNo);
        }
    }

    public void afterBindData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgId = customParams.get(ORG).toString();
        if (MainReportUtil.isZeroDeclareOrg(orgId)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"amount", "adjustamount", "totalamount", "btnok"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"amount", "adjustamount", "totalamount", "btnok"});
        }
    }

    private void setCartModel(Long orgId, Date skssqq, Date skssqz, String cellId, BigDecimal cellValue, String accessprojectid, String serialNo) {
        boolean hasSaveOldValue = this.hasSaveOldValue(orgId, skssqq, skssqz, null);
        if (!hasSaveOldValue) {
            DeclareResponseModel declareData = (DeclareResponseModel)TreeUtils.getCache((IPageCache)this.getView().getParentView().getPageCache(), (String)"declareData", DeclareResponseModel.class);
            List<String> cellIdList = this.getCellIdList(orgId, skssqq, skssqz);
            Map<String, String> stringMap = declareData.getData().entrySet().stream().filter(m -> cellIdList.contains(m.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            List<DynamicObject> dynamicObjects = stringMap.entrySet().stream().map(entry -> this.saveNewAdjust((String)entry.getKey(), orgId, skssqq, skssqz, new BigDecimal((String)entry.getValue()))).collect(Collectors.toList());
            if (dynamicObjects.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
            }
        } else {
            hasSaveOldValue = this.hasSaveOldValue(orgId, skssqq, skssqz, cellId);
            if (!hasSaveOldValue) {
                DynamicObject newAdjust = this.saveNewAdjust(cellId, orgId, skssqq, skssqz, cellValue);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newAdjust});
            }
        }
        int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY_CARD);
        String titleName = this.getTitleName(accessprojectid, serialNo);
        this.getModel().setValue("titlename", (Object)titleName, rowIndex);
        BigDecimal amount = this.getAmount(orgId, skssqq, skssqz, cellId, serialNo);
        this.getModel().setValue("amount", (Object)amount, rowIndex);
        BigDecimal sumAmount = this.getSumAmount(orgId, skssqq, skssqz, cellId);
        this.getModel().setValue("sumamount", (Object)sumAmount);
        if (StringUtil.isNotEmpty((CharSequence)serialNo)) {
            sumAmount = amount;
            this.getModel().setValue("sumamount", (Object)sumAmount);
        } else {
            this.getModel().setValue("amount", this.getModel().getValue("sumamount"), rowIndex);
        }
        this.getModel().setValue("adjustsumamount", (Object)cellValue);
        BigDecimal adjustamount = this.getAdjustamount(orgId, skssqq, skssqz, cellId, serialNo, sumAmount, cellValue);
        this.getModel().setValue("adjustamount", (Object)adjustamount, rowIndex);
        IPageCache parentCache = this.getView().getParentView().getParentView().getParentView().getPageCache();
        if (!ObjectUtils.isEmpty((Object)parentCache.get("needRuleFeatch")) && "1".equalsIgnoreCase(parentCache.get("needRuleFeatch"))) {
            adjustamount = BigDecimalUtil.subtractObject((Object)cellValue, (Object)this.getModel().getValue("amount"));
            this.getModel().setValue("adjustamount", (Object)adjustamount, rowIndex);
        }
        if (StringUtil.isNotEmpty((CharSequence)serialNo)) {
            BigDecimal totalAmount = this.getTotalAmount(amount, adjustamount);
            this.getModel().setValue("totalamount", (Object)totalAmount, rowIndex);
        } else {
            amount = new BigDecimal(this.getModel().getValue("sumamount").toString());
            BigDecimal totalAmount = this.getTotalAmount(amount, adjustamount);
            this.getModel().setValue("totalamount", (Object)totalAmount, rowIndex);
        }
        this.getModel().setValue(RULEID, (Object)serialNo);
    }

    private DynamicObject saveNewAdjust(String cellId, Object orgid, Date skssqq, Date skssqz, BigDecimal value) {
        DynamicObject adjustObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCVVT_MAIN_ADJUST));
        adjustObj.set(ORG, orgid);
        adjustObj.set("cellid", (Object)cellId);
        adjustObj.set(SKSSQQ, (Object)skssqq);
        adjustObj.set(SKSSQZ, (Object)skssqz);
        adjustObj.set("titlename", (Object)ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u91d1\u989d", (String)"DeductTZDetailFormPlugin_0", (String)"taxc-tcvvt", (Object[])new Object[0]));
        adjustObj.set("oldamount", (Object)value);
        return adjustObj;
    }

    private boolean hasSaveOldValue(Long orgId, Date skssqq, Date skssqz, String cellValue) {
        QFilter qFilter = new QFilter(ORG, "=", (Object)orgId).and(new QFilter(SKSSQQ, "=", (Object)skssqq)).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        if (StringUtils.isNotEmpty((CharSequence)cellValue)) {
            qFilter.and(new QFilter("cellid", "=", (Object)cellValue));
        }
        return QueryServiceHelper.exists((String)TCVVT_MAIN_ADJUST, (QFilter[])qFilter.toArray());
    }

    private List<String> getCellIdList(Long orgId, Date skssqq, Date skssqz) {
        String templatetype = "";
        if (!ObjectUtils.isEmpty(this.getView().getParentView().getPageCache().getAll().get("htmlTemplate"))) {
            TemplateVo htmlTemplate = (TemplateVo)SerializationUtils.fromJsonString((String)((String)this.getView().getParentView().getPageCache().getAll().get("htmlTemplate")), TemplateVo.class);
            String templateNumber = htmlTemplate.getTemplateNumber();
            if (!ObjectUtils.isEmpty((Object)templateNumber)) {
                QFilter numberQ = new QFilter("templatenum", "=", (Object)templateNumber);
                DynamicObject template = QueryServiceHelper.queryOne((String)"tpo_formula_edit", (String)"taxtype.number as templatetype", (QFilter[])new QFilter[]{numberQ});
                templatetype = template.getString("templatetype");
            }
        } else {
            DynamicObject templateDyo = DeclareCheckFacility.getTemplateType(orgId.toString(), skssqq, skssqz);
            if (!ObjectUtils.isEmpty((Object)templateDyo)) {
                templatetype = templateDyo.getString("type.number");
            }
        }
        if (StringUtils.isEmpty((CharSequence)templatetype)) {
            return new ArrayList<String>();
        }
        QFilter qFilter = new QFilter("taxtype", "=", (Object)templatetype).and(new QFilter("celltype", "=", (Object)"6"));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tpo_formula_edit", (String)"formulakey", (QFilter[])qFilter.toArray());
        return dynamicObjects.stream().map(m -> m.getString("formulakey")).collect(Collectors.toList());
    }

    private String getTitleName(String accessprojectid, String serialNo) {
        if (StringUtils.isEmpty((CharSequence)serialNo)) {
            return ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u91d1\u989d", (String)"DeductTZDetailFormPlugin_0", (String)"taxc-tcvvt", (Object[])new Object[0]);
        }
        QFilter idFilter = new QFilter("id", "=", (Object)Long.parseLong(accessprojectid));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tpo_bbbscwbb_tree", (String)"name", (QFilter[])new QFilter[]{idFilter});
        return dynamicObject.getString("name");
    }

    private BigDecimal getAmount(Long orgId, Date skssqq, Date skssqz, String cellId, String serialNo) {
        if (StringUtil.isEmpty((CharSequence)serialNo)) {
            return BigDecimal.ZERO;
        }
        DynamicObjectCollection calDetailList = this.getDetailData(orgId, skssqq, skssqz, serialNo);
        BigDecimal sum = calDetailList.stream().map(s -> s.getBigDecimal("fetchamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sum.setScale(2, 4);
    }

    private BigDecimal getAdjustamount(Long orgId, Date skssqq, Date skssqz, String cellId, String serialNo, BigDecimal sumAmount, BigDecimal cellValue) {
        Map<String, String> updateCellMap;
        IPageCache parentCache = this.getView().getParentView().getParentView().getParentView().getPageCache();
        String updateCellListStr = parentCache.get("updateCellMap");
        Map map = updateCellMap = StringUtils.isEmpty((CharSequence)updateCellListStr) ? new HashMap() : JsonUtil.fromJson(updateCellListStr, Map.class);
        if (StringUtil.isEmpty((CharSequence)serialNo)) {
            BigDecimal subtract = cellValue.subtract(sumAmount);
            updateCellMap.put(cellId, subtract.toString());
            parentCache.put("updateCellMap", JsonUtil.toJson(updateCellMap));
            return subtract;
        }
        String value = (String)updateCellMap.get(cellId);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return new BigDecimal(value);
        }
        DynamicObject adjustData = this.getAdjustData(orgId, skssqq, skssqz, cellId);
        if (adjustData != null) {
            return adjustData.getBigDecimal("adjustamount");
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getTotalAmount(BigDecimal amount, BigDecimal adjustAmount) {
        return amount.add(adjustAmount);
    }

    private BigDecimal getSumAmount(Long orgId, Date skssqq, Date skssqz, String cellId) {
        BigDecimal result = BigDecimal.ZERO;
        DynamicObject adjustDetail = this.getAdjustData(orgId, skssqq, skssqz, cellId);
        if (EmptyCheckUtils.isNotEmpty(adjustDetail)) {
            result = adjustDetail.getBigDecimal("oldamount");
        }
        return result;
    }

    private DynamicObject getAdjustData(Long orgId, Date skssqq, Date skssqz, String cellId) {
        String selectPrope = "id,org,skssqq,skssqz,cellid,titlename,adjustamount,oldamount";
        QFilter orgFilter = new QFilter(ORG, "=", (Object)orgId).and(new QFilter(SKSSQQ, "=", (Object)skssqq)).and(new QFilter(SKSSQZ, "=", (Object)skssqz)).and(new QFilter("cellid", "=", (Object)cellId));
        return QueryServiceHelper.queryOne((String)TCVVT_MAIN_ADJUST, (String)selectPrope, (QFilter[])orgFilter.toArray());
    }

    private DynamicObjectCollection getDetailData(Long orgId, Date skssqq, Date skssqz, String serialno) {
        String selectPrope = "skssqq,absolute,bizname,table,amountfield,datadirection,fetchamount,filtercondition,ruleid,serialno";
        QFilter orgFilter = new QFilter(ORG, "=", (Object)orgId).and(new QFilter(SKSSQQ, "=", (Object)skssqq)).and(new QFilter(SKSSQZ, "=", (Object)skssqz)).and(new QFilter(SERIALNO, "=", (Object)serialno));
        return QueryServiceHelper.query((String)TCVVT_MAIN_DETAIL, (String)selectPrope, (QFilter[])orgFilter.toArray());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if ("adjustamount".equals(name) || "totalamount".equals(name)) {
            if ("adjustamount".equals(name)) {
                BigDecimal adjustamount = (BigDecimal)changeData.getNewValue();
                BigDecimal amount = (BigDecimal)this.getModel().getValue("amount", rowIndex);
                this.getModel().setValue("totalamount", (Object)adjustamount.add(amount), rowIndex);
            } else {
                BigDecimal totalamount = (BigDecimal)changeData.getNewValue();
                BigDecimal amount = (BigDecimal)this.getModel().getValue("amount", rowIndex);
                BigDecimal adjustamount = totalamount.subtract(amount);
                this.getModel().setValue("adjustamount", (Object)adjustamount, rowIndex);
            }
            this.refreshAdjustSumAmount();
        }
    }

    private void refreshAdjustSumAmount() {
        DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
        BigDecimal adjustsumamount = entryentitycard.stream().map(s -> s.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue("adjustsumamount", (Object)adjustsumamount);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing && "save".equals(((Donothing)args.getSource()).getOperateKey())) {
            IPageCache parentCache = this.getView().getParentView().getParentView().getParentView().getPageCache();
            String updateCellListStr = parentCache.get("updateCellMap");
            Map<String, String> updateCellMap = StringUtils.isEmpty((CharSequence)updateCellListStr) ? new HashMap() : JsonUtil.fromJson(updateCellListStr, Map.class);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object cellId = customParams.get("cellid");
            BigDecimal adjustamount = (BigDecimal)this.getModel().getValue("adjustamount");
            updateCellMap.put(cellId.toString(), adjustamount.toString());
            parentCache.put("updateCellMap", JsonUtil.toJson(updateCellMap));
            customParams.put("adjustsumamout", this.getModel().getValue("adjustsumamount").toString());
            customParams.put("adjustamount", this.getModel().getValue("adjustamount"));
            this.getView().returnDataToParent((Object)customParams);
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        }
    }

    private void setEntryentitylist(Long orgId, Date skssqq, Date skssqz, String serialno) {
        DynamicObjectCollection collection = this.getDetailData(orgId, skssqq, skssqz, serialno);
        String startDate = DateUtils.format(skssqq, new DateUtils().yyyymmChinese());
        String endDate = DateUtils.format(skssqz, new DateUtils().yyyymmChinese());
        String taxperiod = startDate + "-" + endDate;
        for (DynamicObject object : collection) {
            int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY_LIST);
            this.getModel().setValue("taxperiod", (Object)taxperiod, rowIndex);
            this.getModel().setValue("bizname", object.get("bizname"), rowIndex);
            this.getModel().setValue("table", object.get("table"), rowIndex);
            this.getModel().setValue("amountfield", object.get("amountfield"), rowIndex);
            this.getModel().setValue("absolute", object.get("absolute"), rowIndex);
            this.getModel().setValue("datadirection", object.get("datadirection"), rowIndex);
            this.getModel().setValue("fetchamount", object.get("fetchamount"), rowIndex);
            this.getModel().setValue("filtercondition", (Object)Optional.ofNullable(object.getString("filtercondition")).orElse("").replace(" ", ""), rowIndex);
            this.getModel().setValue("filtercondition_tag", (Object)Optional.ofNullable(object.getString("filtercondition")).orElse("").replace(" ", ""), rowIndex);
        }
    }

    private void clearEntry(String ... entryNames) {
        for (String entry : entryNames) {
            this.getModel().deleteEntryData(entry);
        }
    }

    private ImmutablePair<String, String> getAccessprojectidAndSerialno() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String cellId = customParams.get("cellid").toString();
        String orgId = customParams.get(ORG).toString();
        Date skssqq = DateUtils.stringToDate((String)customParams.get(SKSSQQ));
        Date skssqz = DateUtils.stringToDate((String)customParams.get(SKSSQZ));
        QFilter orgidFilter = new QFilter(ORG, "=", (Object)Long.parseLong(orgId));
        QFilter startDataFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
        QFilter endDataFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
        QFilter formulakeyFilter = new QFilter("formulakey", "=", (Object)cellId);
        DynamicObject mainAccount = QueryServiceHelper.queryOne((String)"tcvvt_main_account", (String)"id,serialno,accessprojectid", (QFilter[])new QFilter[]{orgidFilter, startDataFilter, endDataFilter, formulakeyFilter});
        if (mainAccount == null) {
            return ImmutablePair.of(null, null);
        }
        return ImmutablePair.of((Object)mainAccount.getString("accessprojectid"), (Object)mainAccount.getString(SERIALNO));
    }

    public void showDetailDialog(String cellid, JSONObject params, IFormView view, IFormPlugin plugin) {
        String replaceCellId = cellid.replace("#", "_");
        IPageCache childPageCache = view.getPageCache();
        Map updateMap = (Map)TreeUtils.getCache((IPageCache)childPageCache, (String)"updata_cellid", Map.class);
        if (!CollectionUtils.isEmpty((Map)updateMap) && updateMap.containsKey(replaceCellId)) {
            params.put("cellvalue", (Object)updateMap.get(replaceCellId).toString());
        }
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)32);
        Map viewParams = view.getFormShowParameter().getCustomParams();
        DeclareRequestModel declareModel = (DeclareRequestModel)SerializationUtils.fromJsonString((String)childPageCache.get("declareRequest"), DeclareRequestModel.class);
        customParams.put(ORG, declareModel.getOrgId().toString());
        customParams.put(SKSSQQ, declareModel.getSkssqq());
        customParams.put(SKSSQZ, declareModel.getSkssqz());
        customParams.put("operation", params.getString("operation"));
        for (Map.Entry entry : params.entrySet()) {
            customParams.put(entry.getKey(), entry.getValue());
        }
        customParams.put("cellid", cellid);
        customParams.put("fromForm", "tcvvt_detail_tz_dialog");
        FormShowParameter param = new FormShowParameter();
        param.setFormId("tcvvt_detail_tz_dialog");
        param.setCustomParams((Map)customParams);
        if (customParams.get("customCaption") != null) {
            param.setCaption((String)customParams.get("customCaption"));
        }
        param.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack(plugin, "cell_click_popup");
        param.setCloseCallBack(closeCallBack);
        view.showForm(param);
    }
}

