/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.declare;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.tcvvt.business.finance.TcvvtInitReportDataBusinessImpl;
import kd.taxc.tcvvt.common.util.DateUtils;
import kd.taxc.tcvvt.common.util.TcvvtTemplateUtils;
import kd.taxc.tcvvt.common.util.table.YbnsrService;
import org.apache.commons.lang3.ObjectUtils;

public enum InitParamsEnum {
    FR0001("FR0001"){

        @Override
        public void buildBizParam(DeclareRequestModel requestModel, String nickSheetName, Map<String, String> param) {
            String templateType;
            InitParamsEnum.setInitParams(requestModel, param);
            if ("zcfzb".equalsIgnoreCase(nickSheetName)) {
                InitParamsEnum.getSbbIdLogic(requestModel, param);
            } else if ("lrb".equalsIgnoreCase(nickSheetName) || "xjllb".equalsIgnoreCase(nickSheetName)) {
                String sameTimePeriodLastYearSbbid = InitParamsEnum.getSbbidOnSameTimePeriodOfLastYear(requestModel);
                param.put(InitParamsEnum.PRE_YEAR_PERIOD_SBBID, sameTimePeriodLastYearSbbid);
            } else if ("syzqyb".equalsIgnoreCase(nickSheetName) && ((templateType = requestModel.getTemplateType()).equalsIgnoreCase("FR0001") || templateType.equalsIgnoreCase("FR0002") || templateType.equalsIgnoreCase("FR0005"))) {
                InitParamsEnum.getSbbIdLogic(requestModel, param);
            }
        }
    }
    ,
    FR0002("FR0002"){

        @Override
        public void buildBizParam(DeclareRequestModel requestModel, String nickSheetName, Map<String, String> param) {
            InitParamsEnum.setInitParams(requestModel, param);
            FR0001.buildBizParam(requestModel, nickSheetName, param);
        }
    }
    ,
    FR0003("FR0003"){

        @Override
        public void buildBizParam(DeclareRequestModel requestModel, String nickSheetName, Map<String, String> param) {
            InitParamsEnum.setInitParams(requestModel, param);
            if ("zcfzb".equalsIgnoreCase(nickSheetName)) {
                FR0001.buildBizParam(requestModel, nickSheetName, param);
            } else if ("lrb".equalsIgnoreCase(nickSheetName) || "xjllb".equalsIgnoreCase(nickSheetName)) {
                Boolean firstPeriod = InitParamsEnum.isFirstPeriod(requestModel);
                param.put(InitParamsEnum.IS_FIRST_PERIOD, firstPeriod.toString());
                String sbbIdOnLastPeriod = InitParamsEnum.getSbbIdOnLastPeriod(requestModel);
                param.put(InitParamsEnum.PRE_PERIOD_SBBID, sbbIdOnLastPeriod);
            }
        }
    }
    ,
    FR0004("FR0004"){

        @Override
        public void buildBizParam(DeclareRequestModel requestModel, String nickSheetName, Map<String, String> param) {
            InitParamsEnum.setInitParams(requestModel, param);
            if ("zcfzb".equalsIgnoreCase(nickSheetName) || "lrb".equalsIgnoreCase(nickSheetName) || "syzqyb".equalsIgnoreCase(nickSheetName)) {
                FR0001.buildBizParam(requestModel, nickSheetName, param);
            }
            if ("lrb".equalsIgnoreCase(nickSheetName)) {
                String sameTimePeriodLastYearSbbid = InitParamsEnum.getSbbidOnSameTimePeriodOfLastYear(requestModel);
                param.put(InitParamsEnum.LRB_PRE_YEAR_PERIOD_SBBID, sameTimePeriodLastYearSbbid);
            }
        }
    }
    ,
    FR0005("FR0005"){

        @Override
        public void buildBizParam(DeclareRequestModel requestModel, String nickSheetName, Map<String, String> param) {
            InitParamsEnum.setInitParams(requestModel, param);
            FR0001.buildBizParam(requestModel, nickSheetName, param);
        }
    }
    ,
    FR0011("FR0011"){

        @Override
        public void buildBizParam(DeclareRequestModel requestModel, String nickSheetName, Map<String, String> param) {
            InitParamsEnum.setInitParams(requestModel, param);
            if ("zcfzb".equalsIgnoreCase(nickSheetName) || "syzqyb".equalsIgnoreCase(nickSheetName)) {
                InitParamsEnum.getSbbIdLogic(requestModel, param);
            } else if ("lrb".equalsIgnoreCase(nickSheetName) || "xjllb".equalsIgnoreCase(nickSheetName)) {
                String sameTimePeriodLastYearSbbid = InitParamsEnum.getSbbidOnSameTimePeriodOfLastYear(requestModel);
                param.put(InitParamsEnum.PRE_YEAR_PERIOD_SBBID, sameTimePeriodLastYearSbbid);
            }
        }
    };

    private static final String PRE_YEAR_END_SBBID = "preyearendsbbid";
    private static final String PRE_YEAR_PERIOD_SBBID = "preyearperiodsbbid";
    private static final String LRB_PRE_YEAR_PERIOD_SBBID = "lrbpreyearperiodsbbid";
    private static final String IS_FIRST_PERIOD = "isfirstperiod";
    private static final String HAVE_PRE_YEAR_END_SBBID = "havepreyearendsbbid";
    private static final String PRE_PERIOD_SBBID = "preperiodsbbid";
    private static final String ISINIT = "isInit";
    private static final String CURRENTSBBID = "currentsbbid";
    private static final String MIDDLESBBID = "middlesbbid";
    private final String type;

    private static String getSbbidOnSameTimePeriodOfLastYear(DeclareRequestModel requestModel) {
        String preStartData = DateUtils.format(DateUtils.addYear(DateUtils.stringToDate(requestModel.getSkssqq()), -1));
        String preEndData = DateUtils.format(DateUtils.addYear(DateUtils.stringToDate(requestModel.getSkssqz()), -1));
        DynamicObject template = TcvvtTemplateUtils.getTemplateType(String.valueOf(requestModel.getOrgId()), DateUtils.stringToDate(requestModel.getSkssqq()), DateUtils.stringToDate(requestModel.getSkssqz()));
        HashMap<String, Object> extendParams = new HashMap<String, Object>(1);
        DynamicObject prePeriod = YbnsrService.queryYbnsr(requestModel.getOrgId().toString(), requestModel.getTemplateType(), preStartData, preEndData, extendParams);
        return prePeriod != null ? prePeriod.getString("id") : "";
    }

    private static String getSbbIdOnLastPeriod(DeclareRequestModel requestModel) {
        Date skssqq = DateUtils.stringToDate(requestModel.getSkssqq());
        Date skssqz = DateUtils.stringToDate(requestModel.getSkssqz());
        List<Date> dateList = DateUtils.getPreDate(skssqq, skssqz);
        DynamicObject prePeriod = YbnsrService.queryYbnsr(requestModel.getOrgId().toString(), requestModel.getTemplateType(), DateUtils.format(dateList.get(0)), DateUtils.format(dateList.get(1)), Collections.emptyMap());
        return prePeriod != null ? prePeriod.getString("id") : "";
    }

    private static Boolean isYearReport(DeclareRequestModel requestModel) {
        String skssqq = requestModel.getSkssqq();
        return skssqq.endsWith("-01-01") && skssqq.endsWith("-12-31");
    }

    private static Boolean isFirstPeriod(DeclareRequestModel requestModel) {
        String skssqq = requestModel.getSkssqq();
        Date startDate = DateUtils.stringToDate(skssqq, "yyyy-MM-dd");
        skssqq = DateUtils.format(startDate, "yyyy-MM-dd");
        return skssqq.endsWith("-01-01");
    }

    private static Boolean isSecondSeason(DeclareRequestModel requestModel) {
        String skssqq = requestModel.getSkssqq();
        String skssqz = requestModel.getSkssqz();
        Date startDate = DateUtils.stringToDate(skssqq, "yyyy-MM-dd");
        Date endDate = DateUtils.stringToDate(skssqz, "yyyy-MM-dd");
        skssqq = DateUtils.format(startDate, "yyyy-MM-dd");
        skssqz = DateUtils.format(endDate, "yyyy-MM-dd");
        return skssqq.endsWith("-04-01") && skssqz.endsWith("-06-30");
    }

    private static String getTimeStr(String preStartData, String endStr) {
        return preStartData.substring(0, 4) + endStr;
    }

    private InitParamsEnum(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public static InitParamsEnum getMethodByType(String type) {
        for (InitParamsEnum initParamsEnum : InitParamsEnum.values()) {
            if (!initParamsEnum.getType().equals(type)) continue;
            return initParamsEnum;
        }
        return null;
    }

    public abstract void buildBizParam(DeclareRequestModel var1, String var2, Map<String, String> var3);

    private static String setPreyearendsbbid(DeclareRequestModel requestModel, Map<String, String> param) {
        String preYearLastMonthStrat = InitParamsEnum.getTimeStr(requestModel.getSkssqq(), "-01-01");
        String preYearLastMonthEnd = InitParamsEnum.getTimeStr(requestModel.getSkssqz(), "-12-31");
        List<Date> dateList = DateUtils.getPreDate(DateUtils.stringToDate(preYearLastMonthStrat), DateUtils.stringToDate(preYearLastMonthEnd));
        DynamicObject template = TcvvtTemplateUtils.getTemplateType(String.valueOf(requestModel.getOrgId()), dateList.get(0), dateList.get(1));
        HashMap<String, Object> extendParams = new HashMap<String, Object>(1);
        DynamicObject prePeriod = YbnsrService.queryYbnsr(requestModel.getOrgId().toString(), requestModel.getTemplateType(), DateUtils.format(dateList.get(0)), DateUtils.format(dateList.get(1)), extendParams);
        if (prePeriod == null) {
            preYearLastMonthStrat = InitParamsEnum.getTimeStr(requestModel.getSkssqq(), "-10-01");
            Date startDate = DateUtils.addYear(DateUtils.stringToDate(preYearLastMonthStrat), -1);
            Date endDate = DateUtils.addYear(DateUtils.stringToDate(preYearLastMonthEnd), -1);
            prePeriod = YbnsrService.queryYbnsr(requestModel.getOrgId().toString(), requestModel.getTemplateType(), DateUtils.format(startDate), DateUtils.format(endDate), extendParams);
            if (prePeriod == null) {
                preYearLastMonthStrat = InitParamsEnum.getTimeStr(requestModel.getSkssqq(), "-12-01");
                startDate = DateUtils.addYear(DateUtils.stringToDate(preYearLastMonthStrat), -1);
                prePeriod = YbnsrService.queryYbnsr(requestModel.getOrgId().toString(), requestModel.getTemplateType(), DateUtils.format(startDate), DateUtils.format(endDate), extendParams);
            }
        }
        param.put(PRE_YEAR_END_SBBID, prePeriod != null ? prePeriod.getString("id") : "");
        return prePeriod != null ? prePeriod.getString("id") : "";
    }

    private static String getSecondSeasonYearsbbId(DeclareRequestModel requestModel, Map<String, String> param) {
        DynamicObject prePeriod = InitParamsEnum.getPrePeriod(requestModel);
        param.put(PRE_YEAR_END_SBBID, prePeriod != null ? prePeriod.getString("id") : "");
        return prePeriod != null ? prePeriod.getString("id") : "";
    }

    private static DynamicObject getPrePeriod(DeclareRequestModel requestModel) {
        String preYearLastMonthStrat = InitParamsEnum.getTimeStr(requestModel.getSkssqq(), "-01-01");
        String preYearLastMonthEnd = InitParamsEnum.getTimeStr(requestModel.getSkssqz(), "-12-31");
        List<Date> dateList = DateUtils.getPreDate(DateUtils.stringToDate(preYearLastMonthStrat), DateUtils.stringToDate(preYearLastMonthEnd));
        DynamicObject template = TcvvtTemplateUtils.getTemplateType(String.valueOf(requestModel.getOrgId()), dateList.get(0), dateList.get(1));
        HashMap<String, Object> extendParams = new HashMap<String, Object>(1);
        extendParams.put("templateid", ObjectUtils.isNotEmpty((Object)template) ? template.getString("id") : null);
        return YbnsrService.queryYbnsr(requestModel.getOrgId().toString(), requestModel.getTemplateType(), DateUtils.format(dateList.get(0)), DateUtils.format(dateList.get(1)), extendParams);
    }

    private static void getSbbIdLogic(DeclareRequestModel requestModel, Map<String, String> param) {
        Boolean firstPeriod = InitParamsEnum.isFirstPeriod(requestModel);
        param.put(IS_FIRST_PERIOD, InitParamsEnum.isFirstPeriod(requestModel).toString());
        param.put(HAVE_PRE_YEAR_END_SBBID, Boolean.FALSE.toString());
        Boolean secondSeason = InitParamsEnum.isSecondSeason(requestModel);
        if (secondSeason.booleanValue()) {
            String secondSeasonSbbId = InitParamsEnum.getSecondSeasonYearsbbId(requestModel, param);
            if (StringUtils.isNotBlank((CharSequence)secondSeasonSbbId)) {
                param.put(HAVE_PRE_YEAR_END_SBBID, Boolean.TRUE.toString());
                param.put(PRE_YEAR_END_SBBID, secondSeasonSbbId);
            } else {
                String sbbIdOnLastPeriod = InitParamsEnum.getSbbIdOnLastPeriod(requestModel);
                param.put(PRE_PERIOD_SBBID, sbbIdOnLastPeriod);
            }
        } else if (firstPeriod.booleanValue()) {
            InitParamsEnum.setPreyearendsbbid(requestModel, param);
        } else {
            String sbbIdOnLastPeriod = InitParamsEnum.getSbbIdOnLastPeriod(requestModel);
            param.put(PRE_PERIOD_SBBID, sbbIdOnLastPeriod);
        }
    }

    private static void setInitParams(DeclareRequestModel requestModel, Map<String, String> param) {
        String skssqq = requestModel.getSkssqq();
        String skssqz = requestModel.getSkssqz();
        String templatetype = requestModel.getTemplateType();
        Long orgId = requestModel.getOrgId();
        HashMap<String, Object> extendParams = new HashMap<String, Object>(1);
        DynamicObject currentsbb = YbnsrService.queryYbnsr(orgId.toString(), templatetype, skssqq, skssqz, extendParams);
        String middlesbbid = TcvvtInitReportDataBusinessImpl.queryMiddlesbbid(orgId, DateUtils.stringToDate(skssqq), DateUtils.stringToDate(skssqz), templatetype);
        if (!ObjectUtils.isEmpty((Object)middlesbbid) || !ObjectUtils.isEmpty(requestModel.getBusinessMap().get(ISINIT)) && "1".equalsIgnoreCase((String)requestModel.getBusinessMap().get(ISINIT))) {
            param.put(ISINIT, "1");
            if (!ObjectUtils.isEmpty((Object)currentsbb)) {
                String currentsbbid = currentsbb.getString("id");
                param.put(CURRENTSBBID, currentsbbid);
            }
            param.put(MIDDLESBBID, middlesbbid);
        }
    }
}

