/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.declare;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.declare.initparam.InitParams;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.tcvvt.common.util.UUID;
import kd.taxc.tcvvt.formplugin.declare.InitParamsEnum;

public class TcvvtInitParams
implements InitParams {
    private static Log logger = LogFactory.getLog(TcvvtInitParams.class);
    private static final String START_DATE = "startDate";
    private static final String END_DATE = "endDate";
    private final List<String> lrbNameList = Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u5229\u6da6\u8868", (String)"TcvvtInitParams_0", (String)"taxc-tcvvt", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5229\u6da6\u8868\uff08\u6708\u3001\u5b63\u62a5\uff09", (String)"TcvvtInitParams_1", (String)"taxc-tcvvt", (Object[])new Object[0])});
    private final List<String> xjllbNameList = Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u8868", (String)"TcvvtInitParams_2", (String)"taxc-tcvvt", (Object[])new Object[0]), ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u8868\uff08\u6708\u3001\u5b63\u62a5\uff09", (String)"TcvvtInitParams_3", (String)"taxc-tcvvt", (Object[])new Object[0])});
    private final List<String> syzqybNameList = Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u6240\u6709\u8005\u6743\u76ca\u53d8\u52a8\u8868", (String)"TcvvtInitParams_4", (String)"taxc-tcvvt", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6240\u6709\u8005\u6743\u76ca\uff08\u6216\u80a1\u4e1c\u6743\u76ca\uff09\u589e\u51cf\u53d8\u52a8\u8868", (String)"TcvvtInitParams_5", (String)"taxc-tcvvt", (Object[])new Object[0])});

    public Map<String, String> buildBizParam(DeclareRequestModel requestModel) {
        HashMap<String, String> param = new HashMap<String, String>();
        String sheetName = "";
        if (!ObjectUtils.isEmpty((Object)requestModel.getSheetName())) {
            if (requestModel.getSheetName().contains("-")) {
                String[] sheetNames = requestModel.getSheetName().split("-");
                sheetName = sheetNames[1];
            } else {
                sheetName = requestModel.getSheetName();
            }
        }
        param.put("orgId", requestModel.getOrgId().toString());
        param.put(START_DATE, requestModel.getSkssqq());
        param.put(END_DATE, requestModel.getSkssqz());
        String templateType = requestModel.getTemplateType();
        InitParamsEnum initParamsEnum = InitParamsEnum.getMethodByType(templateType);
        param.put("cacheKey", UUID.randomUUID());
        if (initParamsEnum != null && sheetName != null) {
            String[] sheetNameList;
            for (String sheet : sheetNameList = sheetName.split(",")) {
                String prefix = null;
                if (ResManager.loadKDString((String)"\u8d44\u4ea7\u8d1f\u503a\u8868", (String)"TcvvtInitParams_6", (String)"taxc-tcvvt", (Object[])new Object[0]).equalsIgnoreCase(sheet)) {
                    prefix = "zcfzb";
                } else if (this.lrbNameList.contains(sheet)) {
                    prefix = "lrb";
                } else if (this.xjllbNameList.contains(sheet)) {
                    prefix = "xjllb";
                } else if (this.syzqybNameList.contains(sheet)) {
                    prefix = "syzqyb";
                }
                if (prefix == null) continue;
                initParamsEnum.buildBizParam(requestModel, prefix, param);
            }
        }
        param.putAll(requestModel.getBusinessMap());
        logger.info("\u7533\u62a5\u6a21\u578b\u52a0\u8f7d\u524d\u6dfb\u52a0\u81ea\u5b9a\u4e49\u53c2\u6570\uff1a {}", (Object)SerializationUtils.toJsonString(param));
        return param;
    }
}

