/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.declare;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.taxc.bdtaxr.business.formula.impl.FormulaServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.mutex.MutexServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.DeclareRequestServiceImpl;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.TemplateFormulaServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.finance.TcvvtCategoryInfoBusinessImpl;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.DeclareStepsUtils;
import kd.taxc.bdtaxr.common.taxdeclare.NsrxxValidatorUtils;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;
import kd.taxc.tcvvt.business.finance.TcvvtInitReportDataBusinessImpl;
import kd.taxc.tcvvt.business.finance.TcvvtLicenseCheckBusinessImpl;
import kd.taxc.tcvvt.business.taxorg.TcvvtTaxOrgCommonBusiness;
import kd.taxc.tcvvt.common.constant.TaxStepsConstant;
import kd.taxc.tcvvt.common.enums.CheckReportEnum;
import kd.taxc.tcvvt.common.enums.DeclarePageType;
import kd.taxc.tcvvt.common.helper.OrgServiceHelper;
import kd.taxc.tcvvt.common.helper.TcvvtDeclareServiceHelper;
import kd.taxc.tcvvt.common.util.DateUtils;
import kd.taxc.tcvvt.common.util.EmptyCheckUtils;
import kd.taxc.tcvvt.common.util.JsonUtil;
import kd.taxc.tcvvt.common.util.MainReportUtil;
import kd.taxc.tcvvt.common.util.PermissionUtils;
import kd.taxc.tcvvt.common.util.StringUtil;
import kd.taxc.tcvvt.common.util.TcvvtTemplateUtils;
import kd.taxc.tcvvt.common.util.datasource.TcvvtEngineUtils;
import kd.taxc.tcvvt.common.util.engine.EngineModel;
import kd.taxc.tcvvt.common.util.step.IStatusService;
import kd.taxc.tcvvt.formplugin.facility.DeclareCheckFacility;
import kd.taxc.tcvvt.formplugin.status.StatusServiceReport;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class TcvvtMainPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(TcvvtMainPlugin.class);
    private static final String REPORTTYPE = "reporttype";
    private static final String TCTB_TAX_MAIN = "tctb_tax_main";
    private static final String BAR = "toolbarap";
    private static final String TOOL_BAR_DECLARE = "toolbarapdeclare";
    private static final String CONTENT_TAB = "tabcontent";
    private static final String ORGID_KEY = "orgid";
    private static final String NEXT_KEY = "next";
    private static final String FORWARD_KEY = "forward";
    private static final String EDIT_KEY = "edit";
    private static final String SAVE_KEY = "save";
    private static final String CANCEL_EDIT = "cancel_edit";
    private static final String CLOSE_KEY = "close";
    private static final String REDUCE_KEY = "reduce_key";
    private static final String ACTION_STATUS = "actionStatus";
    private static final String SUBMIT_KEY = "submit";
    private static final String CANCEL_SUBMIT = "cancel_submit";
    private static final String AUDIT_KEY = "audit";
    private static final String UNAUDIT = "unaudit";
    private static final String RECALC_KEY = "recalc";
    private static final String INIT_KEY = "init";
    private static final String ORG_SEL = "org";
    private static final String TAXAUTHORITY = "taxauthority";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String FOCUS_PAGE = "focuspage";
    private static final String STATUS = "status";
    private static final String CACHE_UPDATA_CELLID_SAVE = "updata_cellid_save";
    private static final String CACHE_DECLARE_REQUEST = "declareRequest";
    private static final String CACHE_DECLARE_DATA = "declareData";
    private static final String MAX_STATUS = "maxStatus";
    private static final String NUMBER = "number";
    private static final String TYPE = "type";
    private static final String FR0005 = "FR0005";
    private static final String ISINIT = "isInit";
    private static final String MIDDLESBBID = "middlesbbid";
    private static final String CURRENTSBBID = "currentsbid";
    private static final String TCVVT_FINANCE_INIT_RECORD = "tcvvt_finance_init_record";
    public static final String TCVVT_MESSAGE = "tcvvt_message";
    private static final String SHOW_CONFIRM_SCENE = "show_confirm_scene";
    private static final String ENTRYENTITY = "entryentity";
    private static final String SELECTIDS = "selectids";
    private static final String CHECK_RESULT_LIST = "checkResultList";
    private static final List<String> INITREPORTTYPELIST = new ArrayList<String>(){
        {
            this.add("FR0002");
            this.add("FR0003");
        }
    };
    private Map<String, List<String>> btnMap = new HashMap<String, List<String>>(){
        {
            this.put("1-VIEW", Arrays.asList(TcvvtMainPlugin.EDIT_KEY, TcvvtMainPlugin.CLOSE_KEY, TcvvtMainPlugin.NEXT_KEY));
            this.put("2-VIEW", Arrays.asList(TcvvtMainPlugin.EDIT_KEY, TcvvtMainPlugin.SUBMIT_KEY, TcvvtMainPlugin.AUDIT_KEY, TcvvtMainPlugin.CLOSE_KEY, TcvvtMainPlugin.FORWARD_KEY));
            this.put("1-EDIT", Arrays.asList(TcvvtMainPlugin.RECALC_KEY, TcvvtMainPlugin.CANCEL_EDIT, TcvvtMainPlugin.NEXT_KEY, TcvvtMainPlugin.INIT_KEY));
            this.put("2-EDIT", Arrays.asList(TcvvtMainPlugin.SAVE_KEY, TcvvtMainPlugin.RECALC_KEY, TcvvtMainPlugin.CANCEL_EDIT, TcvvtMainPlugin.FORWARD_KEY, TcvvtMainPlugin.INIT_KEY));
        }
    };
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String TCVVT_MAIN_ADJUST = "tcvvt_main_adjust";
    private Map<String, DeclarePageType> declarePageMap = new HashMap<String, DeclarePageType>();
    private IStatusService statusService;

    private Map<String, DeclarePageType> getDeclarePageMap() {
        return this.declarePageMap;
    }

    private void setDeclarePageMap(Map<String, DeclarePageType> declarePageMap) {
        this.declarePageMap = declarePageMap;
    }

    private IStatusService getStatusService() {
        return this.statusService;
    }

    private void setStatusService(IStatusService statusService) {
        this.statusService = statusService;
    }

    public TcvvtMainPlugin() {
        this.setDeclarePageMap(TaxStepsConstant.getTcvvtReport());
        this.setStatusService(new StatusServiceReport());
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        if (event.getProperty() instanceof OrgProp) {
            ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
            QFilter istaxpayerQ = new QFilter("taxorg.istaxpayer", "=", (Object)Boolean.TRUE);
            QFilter statusQ = new QFilter("taxorg.status", "=", (Object)"1");
            QFilter billStatusQ = new QFilter("billstatus", "=", (Object)"C");
            DynamicObjectCollection col = QueryServiceHelper.query((String)TCTB_TAX_MAIN, (String)"taxorg", (QFilter[])new QFilter[]{istaxpayerQ, statusQ, billStatusQ});
            List idList = col.stream().map(o -> o.getLong("taxorg")).collect(Collectors.toList());
            List ids = TcvvtCategoryInfoBusinessImpl.querycwbbCategoryInfoByOrgIds(idList);
            QFilter idQ = new QFilter("id", "in", (Object)ids);
            formShowParameter.getListFilterParameter().getQFilters().add(idQ);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        try {
            boolean hasNotShowCloseModal;
            String orgId = this.getModel().getValue(ORG_SEL) == null ? null : ((DynamicObject)this.getModel().getValue(ORG_SEL)).getString("id");
            String reportType = (String)this.getModel().getValue(REPORTTYPE);
            Long taxauthority = (Long)this.getModel().getValue(TAXAUTHORITY);
            Date startdate = (Date)this.getModel().getValue(START_DATE);
            Date enddate = (Date)this.getModel().getValue(END_DATE);
            String sksqq = DateUtils.format(startdate, "yyyy-MM-dd");
            String sksqz = DateUtils.format(enddate, "yyyy-MM-dd");
            boolean check = this.checkBeforeOpt(orgId, taxauthority, reportType, sksqq, sksqz, false, false);
            if (!check) {
                return;
            }
            boolean bl = hasNotShowCloseModal = !"Y".equalsIgnoreCase(this.getPageCache().get("hasShowCloseModal"));
            if (hasNotShowCloseModal) {
                boolean checkDataChange = this.checkModelDataHasChanged(true, orgId, sksqq, sksqz);
                String status = this.getPageCache().get(ACTION_STATUS);
                String focusPage = (String)this.getModel().getValue(FOCUS_PAGE);
                if (!checkDataChange || Objects.equals(status, OperationStatus.VIEW.name()) || "1".equals(focusPage)) {
                    return;
                }
                String mainDesc = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u9700\u8981\u4fdd\u5b58\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"TcvvtMainPlugin_0", (String)"taxc-tcvvt", (Object[])new Object[0]);
                String cancelDesc = ResManager.loadKDString((String)"\u786e\u8ba4\u53d6\u6d88", (String)"TcvvtMainPlugin_1", (String)"taxc-tcvvt", (Object[])new Object[0]);
                String okDesc = ResManager.loadKDString((String)"\u4fdd\u5b58\u5e76\u5173\u95ed", (String)"TcvvtMainPlugin_2", (String)"taxc-tcvvt", (Object[])new Object[0]);
                this.showConfirm(CLOSE_KEY, mainDesc, cancelDesc, okDesc, CLOSE_KEY);
                e.setCancel(true);
            }
        }
        catch (Exception ex) {
            logger.error("\u5173\u95ed\u51fa\u73b0\u5f02\u5e38\uff0c\u8df3\u8fc7\u5f02\u5e38:", (Object)ex.getMessage());
        }
    }

    private String getTaxLimits(String reporttype) {
        if (null == reporttype) {
            reporttype = (String)this.getModel().getValue(REPORTTYPE);
        }
        if ("ajsb".equals(reporttype)) {
            return "season";
        }
        if ("ansb".equals(reporttype)) {
            return "year";
        }
        if ("aysb".equals(reporttype)) {
            return "month";
        }
        return " ";
    }

    public void registerListener(EventObject e) {
        for (int step = 1; step <= this.declarePageMap.size(); ++step) {
            this.addClickListeners(new String[]{STATUS + step});
        }
        this.addItemClickListeners(new String[]{BAR, TOOL_BAR_DECLARE});
        OrgEdit orgEdit = (OrgEdit)this.getView().getControl(ORG_SEL);
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        Long taxauthority;
        String orgId = this.getModel().getValue(ORG_SEL) == null ? null : ((DynamicObject)this.getModel().getValue(ORG_SEL)).getString("id");
        Date startdate = (Date)this.getModel().getValue(START_DATE);
        Date enddate = (Date)this.getModel().getValue(END_DATE);
        String reportType = (String)this.getModel().getValue(REPORTTYPE);
        Long l = taxauthority = this.getModel().getValue(TAXAUTHORITY) == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue(TAXAUTHORITY)).getLong("id"));
        if (orgId == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"TcvvtMainPlugin_3", (String)"taxc-tcvvt", (Object[])new Object[0]));
            return;
        }
        if (startdate == null || enddate == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u65e5\u671f\u201d\u3002", (String)"TcvvtMainPlugin_4", (String)"taxc-tcvvt", (Object[])new Object[0]));
            return;
        }
        if (reportType == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7533\u62a5\u7c7b\u578b\u201d\u3002", (String)"TcvvtMainPlugin_5", (String)"taxc-tcvvt", (Object[])new Object[0]));
            return;
        }
        String sksqq = DateUtils.format(startdate, "yyyy-MM-dd");
        String sksqz = DateUtils.format(enddate, "yyyy-MM-dd");
        boolean isImport = MainReportUtil.isImport(orgId, sksqq, sksqz);
        try {
            TcvvtLicenseCheckBusinessImpl.orgLicenseCheck(orgId, "tcvvt");
        }
        catch (KDBizException ex) {
            this.getView().showErrorNotification(ex.getMessage());
            return;
        }
        if (isImport) {
            return;
        }
        String key = ((Control)evt.getSource()).getKey();
        if (key.startsWith(STATUS)) {
            String focuspage;
            String step = key.replace(STATUS, "");
            if (step.equals(focuspage = (String)this.getModel().getValue(FOCUS_PAGE))) {
                return;
            }
            if ("2".equals(step)) {
                this.nextStep(orgId, taxauthority, sksqq, sksqz, reportType);
            } else if ("1".equals(step)) {
                DeclareCheckFacility.checkOrgAndDate(null, orgId, taxauthority, reportType, DateUtils.stringToDate(sksqq), DateUtils.stringToDate(sksqz), this.getView());
                this.forwardStep(orgId, sksqq, sksqz);
            }
        }
    }

    private void hideAllButton() {
        HashSet totalBtns = new HashSet();
        this.btnMap.forEach((key, value) -> totalBtns.addAll(value));
        for (String btn : totalBtns) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{btn});
        }
    }

    private void setButtonVisible(String focuspage, String actionStatus, DynamicObject nsrxx) {
        HashSet totalBtns = new HashSet();
        String appId = this.getView().getFormShowParameter().getAppId();
        this.btnMap.forEach((key, value) -> totalBtns.addAll(value));
        List<String> stepBtns = this.btnMap.get(focuspage + "-" + actionStatus);
        for (String btn : totalBtns) {
            this.getView().setVisible(Boolean.valueOf(stepBtns.contains(btn)), new String[]{btn});
        }
        if (OperationStatus.VIEW.name().equals(actionStatus)) {
            String billstatus;
            if ("1".equals(focuspage)) {
                if (nsrxx != null && !"A".equalsIgnoreCase(billstatus = nsrxx.getString("billstatus"))) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{EDIT_KEY});
                }
            } else if (nsrxx != null) {
                billstatus = nsrxx.getString("billstatus");
                if ("B".equals(billstatus)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{EDIT_KEY, UNAUDIT, INIT_KEY});
                    this.getView().setEnable(Boolean.FALSE, new String[]{SUBMIT_KEY});
                    this.getView().setVisible(Boolean.TRUE, new String[]{SUBMIT_KEY, CANCEL_SUBMIT, AUDIT_KEY});
                    this.getView().setEnable(Boolean.TRUE, new String[]{AUDIT_KEY, CANCEL_SUBMIT});
                } else if ("C".equals(billstatus)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{EDIT_KEY, SUBMIT_KEY, CANCEL_SUBMIT, INIT_KEY});
                    this.getView().setEnable(Boolean.FALSE, new String[]{AUDIT_KEY});
                    this.getView().setVisible(Boolean.TRUE, new String[]{AUDIT_KEY, UNAUDIT});
                    this.getView().setEnable(Boolean.TRUE, new String[]{UNAUDIT});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{CANCEL_SUBMIT, AUDIT_KEY, UNAUDIT});
                    this.getView().setVisible(Boolean.TRUE, new String[]{EDIT_KEY, SUBMIT_KEY});
                    this.getView().setEnable(Boolean.TRUE, new String[]{SUBMIT_KEY, INIT_KEY});
                }
            }
        }
        if (nsrxx != null && "2".equalsIgnoreCase(nsrxx.getString("datatype"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap", "flexpanelap7"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap", "flexpanelap7"});
        }
        if (nsrxx == null || "1".equalsIgnoreCase(focuspage)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{RECALC_KEY, INIT_KEY});
        }
        Date skssqq = (Date)this.getModel().getValue(START_DATE);
        Date skssqz = (Date)this.getModel().getValue(END_DATE);
        if (MainReportUtil.isZeroDeclareOrg(this.getModel().getDataEntity().getString("org.id"), skssqq, skssqz)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{EDIT_KEY, RECALC_KEY, CANCEL_EDIT, INIT_KEY});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{EDIT_KEY, RECALC_KEY, CANCEL_EDIT, INIT_KEY});
        }
        if ("wftask".equalsIgnoreCase(appId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"toolbarapflex"});
            this.getView().setEnable(Boolean.FALSE, new String[]{ORG_SEL, REPORTTYPE, START_DATE, END_DATE});
        }
    }

    public void afterCreateNewData(EventObject e) {
        try {
            String appId = this.getView().getFormShowParameter().getAppId();
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            List<TreeNode> nodeList = OrgServiceHelper.getAllPermNodes(appId, this.getView().getEntityId(), null);
            this.hideAllButton();
            if (!nodeList.isEmpty()) {
                String orgId = this.setOrgId(nodeList);
                String reportType = this.setReportType(orgId);
                Long taxauthority = this.setTaxauthority(orgId);
                this.initStartAndEndDate(false);
                Date startdate = (Date)this.getModel().getValue(START_DATE);
                Date enddate = (Date)this.getModel().getValue(END_DATE);
                String startdateStr = DateUtils.format(startdate, "yyyy-MM-dd");
                String enddateStr = DateUtils.format(enddate, "yyyy-MM-dd");
                Object billno = customParams.get("billno");
                if (ObjectUtils.isEmpty(billno)) {
                    this.getModel().setValue("billno", (Object)this.getBillno(enddate, orgId));
                } else {
                    this.getModel().setValue("billno", (Object)billno.toString());
                }
                this.zeroDeclareCheckAndTipNotification(orgId, startdateStr, enddateStr);
                boolean isImport = MainReportUtil.isImport(orgId, startdateStr, enddateStr);
                this.setSelectIds(orgId, startdateStr, enddateStr);
                if (customParams.containsKey("isHyperLinkClick") || isImport) {
                    this.showInnerTbPage("2", orgId, null);
                } else {
                    this.showInnerTbPage("1", orgId, null);
                }
                boolean checkResult = this.checkBeforeOpt(orgId, taxauthority, reportType, startdateStr, enddateStr, true, false);
                if (!checkResult) {
                    return;
                }
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8bbe\u7f6e\u8fdb\u884c\u914d\u7f6e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TcvvtMainPlugin_6", (String)"taxc-tcvvt", (Object[])new Object[0]));
            }
        }
        catch (Exception ex) {
            if ("KDBizException".equalsIgnoreCase(ex.getClass().getSimpleName())) {
                String code = ((KDBizException)((Object)ex)).getErrorCode().getCode();
                if ("nsrxxReviewed".equalsIgnoreCase(code)) {
                    this.getView().showErrorNotification(((KDBizException)((Object)ex)).getErrorCode().getMessage());
                } else if ("allRequiredField".equalsIgnoreCase(code)) {
                    this.getView().showErrorNotification(((KDBizException)((Object)ex)).getErrorCode().getMessage());
                }
            }
            String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
            logger.error("\u7f16\u5236\u62a5\u8868\u52a0\u8f7d\u9875\u9762\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)exceptionStackTraceMessage);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TcvvtMainPlugin_7", (String)"taxc-tcvvt", (Object[])new Object[0]));
        }
    }

    private Long setTaxauthority(String orgId) {
        Long taxauthorityid = null;
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByCustomFilter(Collections.singletonList(Long.parseLong(orgId)), (Long)TaxationsysMappingEnum.CHN.getId(), (String)"taxoffice", null, null);
        if (!ObjectUtils.isEmpty((Object)result) && !ObjectUtils.isEmpty((Object)result.getData())) {
            DynamicObject dyo = (DynamicObject)((DynamicObjectCollection)result.getData()).get(0);
            taxauthorityid = dyo.getLong("taxoffice");
        }
        this.getModel().setValue(TAXAUTHORITY, taxauthorityid);
        return taxauthorityid;
    }

    private String setOrgId(List<TreeNode> nodeList) {
        String currOrgId;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get(ORGID_KEY) != null) {
            this.getModel().setValue(ORG_SEL, (Object)customParams.get(ORGID_KEY).toString());
            currOrgId = customParams.get(ORGID_KEY).toString();
        } else {
            List<Long> orgIds = nodeList.stream().filter(node -> StringUtil.isNotEmpty((CharSequence)node.getId())).map(o -> Long.valueOf(o.getId())).collect(Collectors.toList());
            List<Long> list = OrgServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm(RequestContext.get().getCurrUserId(), orgIds);
            if (ObjectUtils.isNotEmpty(list) && !list.contains(RequestContext.get().getOrgId())) {
                this.getModel().setValue(ORG_SEL, (Object)list.get(0));
                currOrgId = String.valueOf(list.get(0));
            } else {
                this.getModel().setValue(ORG_SEL, (Object)RequestContext.get().getOrgId());
                currOrgId = String.valueOf(RequestContext.get().getOrgId());
            }
        }
        return currOrgId;
    }

    private List<Long> getIsTaxpayerOrg() {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(this.getView());
        List<Object> taxOrgs = EmptyCheckUtils.isNotEmpty(hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm() && EmptyCheckUtils.isNotEmpty(hasPermOrgResult.getHasPermOrgs()) ? TcvvtTaxOrgCommonBusiness.queryTaxcOrgByOrgIdAndIsTaxpayer(hasPermOrgResult.getHasPermOrgs()) : TcvvtTaxOrgCommonBusiness.queryTaxcOrgIdByIsTaxpayer();
        return CollectionUtils.isEmpty(taxOrgs) ? new ArrayList() : taxOrgs;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        if (changeData == null || changeData.length == 0) {
            return;
        }
        switch (e.getProperty().getName()) {
            case "selectids": 
            case "focuspage": 
            case "templatetype": {
                return;
            }
            case "org": {
                DynamicObject newOrg = (DynamicObject)changeData[0].getNewValue();
                this.getView().getModel().setValue(ORG_SEL, (Object)newOrg);
                if (null != newOrg) {
                    String neworgid = newOrg.getString("id");
                    String reportType = this.setReportType(neworgid);
                    Long taxauthority = this.setTaxauthority(neworgid);
                    Date startdate = (Date)this.getModel().getValue(START_DATE);
                    Date enddate = (Date)this.getModel().getValue(END_DATE);
                    String startdateStr = DateUtils.format(startdate, "yyyy-MM-dd");
                    String enddateStr = DateUtils.format(enddate, "yyyy-MM-dd");
                    this.zeroDeclareCheckAndTipNotification(neworgid, startdateStr, enddateStr);
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"TcvvtMainPlugin_3", (String)"taxc-tcvvt", (Object[])new Object[0]));
                return;
            }
            case "reporttype": {
                this.getView().getModel().setValue(REPORTTYPE, changeData[0].getNewValue());
                if (!ObjectUtils.isEmpty((Object)this.getPageCache().get("reporttypeChanged")) && !this.getPageCache().get("reporttypeChanged").equalsIgnoreCase("false")) {
                    this.initStartAndEndDate(true);
                    break;
                }
                this.getPageCache().put("reporttypeChanged", "true");
                break;
            }
            case "startdate": {
                if (StringUtil.isNotEmpty((CharSequence)this.getPageCache().get("code_change_start2"))) {
                    this.getPageCache().remove("code_change_start2");
                    return;
                }
                Date startDate = (Date)changeData[0].getNewValue();
                Date endDate = (Date)this.getModel().getValue(END_DATE);
                this.getView().getModel().setValue(START_DATE, (Object)startDate);
                if (startDate == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u65e5\u671f\u201d\u3002", (String)"TcvvtMainPlugin_4", (String)"taxc-tcvvt", (Object[])new Object[0]));
                    return;
                }
                if (this.setReportTypeBy(startDate, endDate)) break;
                return;
            }
            case "enddate": {
                if (StringUtil.isNotEmpty((CharSequence)this.getPageCache().get("code_change_end2"))) {
                    this.getPageCache().remove("code_change_end2");
                    return;
                }
                Date endDate = (Date)changeData[0].getNewValue();
                Date startDate = (Date)this.getModel().getValue(START_DATE);
                this.getView().getModel().setValue(END_DATE, (Object)endDate);
                if (endDate == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u65e5\u671f\u201d\u3002", (String)"TcvvtMainPlugin_4", (String)"taxc-tcvvt", (Object[])new Object[0]));
                    return;
                }
                if (this.setReportTypeBy(startDate, endDate)) break;
                return;
            }
        }
        this.getView().getModel().setValue("templatetype", null);
        Date startdate = (Date)this.getModel().getValue(START_DATE);
        Date enddate = (Date)this.getModel().getValue(END_DATE);
        String orgId = this.getModel().getValue(ORG_SEL) == null ? null : ((DynamicObject)this.getModel().getValue(ORG_SEL)).getString("id");
        Long taxauthority = this.getModel().getValue(TAXAUTHORITY) == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue(TAXAUTHORITY)).getLong("id"));
        TcvvtLicenseCheckBusinessImpl.orgLicenseCheck(orgId, "tcvvt");
        if (orgId != null && startdate != null && enddate != null) {
            boolean flag = this.checkBeforeOpt(orgId, taxauthority, (String)this.getModel().getValue(REPORTTYPE), startdate, enddate, true, false);
            if (!flag) {
                return;
            }
            String startdateStr = DateUtils.format(startdate, "yyyy-MM-dd");
            String enddateStr = DateUtils.format(enddate, "yyyy-MM-dd");
            this.setSelectIds(orgId, startdateStr, enddateStr);
            boolean isImport = MainReportUtil.isImport(orgId, startdateStr, enddateStr);
            if (isImport) {
                this.showInnerTbPage("2", orgId, null);
            } else {
                this.showInnerTbPage("1", orgId, null);
            }
        }
    }

    private void setSelectIds(String orgId, String startdateStr, String enddateStr) {
        DynamicObject tcvvtMessage = MainReportUtil.getTcvvtMessage(orgId, startdateStr, enddateStr);
        List<Object> ids = new ArrayList();
        if (tcvvtMessage != null) {
            ids = tcvvtMessage.getDynamicObjectCollection(ENTRYENTITY).stream().map(s -> Long.parseLong(s.get("selectid").toString())).sorted().collect(Collectors.toList());
        } else {
            String[] split1;
            List collect;
            DynamicObject template = MainReportUtil.getTemplateType(orgId, startdateStr, enddateStr);
            logger.info("template-------" + template);
            QFilter typeFilter = new QFilter(TYPE, "=", (Object)(ObjectUtils.isNotEmpty((Object)template) && ObjectUtils.isNotEmpty((Object)template.getString(NUMBER)) ? template.getString(NUMBER) : ""));
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tcvvt_check_report", (String)"id", (QFilter[])new QFilter[]{typeFilter}, (String)"id");
            DynamicObject cwbbCategoryInfo = TcvvtCategoryInfoBusinessImpl.querycwbbCategoryInfoByOrgId((String)orgId);
            String submissionform = "";
            if (!ObjectUtils.isEmpty((Object)cwbbCategoryInfo)) {
                submissionform = cwbbCategoryInfo.getString("submissionform");
            }
            if (!ObjectUtils.isEmpty(collect = Arrays.stream(split1 = submissionform.split(",")).filter(o -> !ObjectUtils.isEmpty((Object)o)).collect(Collectors.toList()))) {
                String[] split;
                List allIds = dynamicObjects.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
                ArrayList<Long> selectIds = new ArrayList<Long>();
                for (String s2 : split = submissionform.split(",")) {
                    CheckReportEnum checkReportEnum;
                    if (ObjectUtils.isEmpty((Object)s2) || ObjectUtils.isEmpty((Object)((Object)(checkReportEnum = CheckReportEnum.valueOf(s2))))) continue;
                    selectIds.addAll(checkReportEnum.getReportIds());
                }
                allIds.retainAll(selectIds);
                ids = allIds;
            } else if (dynamicObjects != null && dynamicObjects.size() >= 2) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    ids.add(dynamicObject.getLong("id"));
                }
            }
        }
        String listSelectedJsonStr = SerializationUtils.toJsonString(ids);
        this.getModel().setValue(SELECTIDS, (Object)listSelectedJsonStr);
    }

    private void nextStep(String orgId, Long taxauthority, String startdate, String enddate, String reportType) {
        try {
            boolean calDataResult;
            boolean check = this.checkBeforeOpt(orgId, taxauthority, reportType, startdate, enddate, true, false);
            if (!check) {
                return;
            }
            String actionStatus = this.getPageCache().get(ACTION_STATUS);
            String policypageid = this.getPageCache().get("declarepageid");
            BillList billlistap = (BillList)this.getView().getView(policypageid).getControl("billlistap");
            Object[] primaryKeyValues = billlistap.getSelectedRows().getPrimaryKeyValues();
            if (OperationStatus.EDIT.name().equals(actionStatus) && (primaryKeyValues == null || primaryKeyValues.length == 0)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u9700\u62a5\u9001\u7684\u8868\u5355\u3002", (String)"TcvvtMainPlugin_8", (String)"taxc-tcvvt", (Object[])new Object[0]));
                return;
            }
            DynamicObject queryNsrxx = MainReportUtil.queryNsrxx(orgId, startdate, enddate);
            ArrayList<DynamicObject> accountList = new ArrayList<DynamicObject>();
            if (queryNsrxx == null && !MainReportUtil.isZeroDeclareOrg(orgId) && !(calDataResult = this.calData(orgId, startdate, enddate, accountList))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TcvvtMainPlugin_7", (String)"taxc-tcvvt", (Object[])new Object[0]));
                return;
            }
            if (OperationStatus.EDIT.name().equals(actionStatus)) {
                List ids = Arrays.stream(primaryKeyValues).map(m -> Long.parseLong(m.toString())).sorted().collect(Collectors.toList());
                String listSelectedJsonStr = SerializationUtils.toJsonString(ids);
                this.getModel().setValue(SELECTIDS, (Object)listSelectedJsonStr);
            }
            HashMap<String, String> customCalMap = new HashMap<String, String>();
            accountList.forEach(m -> customCalMap.put(m.getString("formulakey"), m.getString("fetchamount")));
            DynamicObject template = MainReportUtil.getTemplateType(orgId, startdate, enddate);
            QFilter taxTypeFilter = new QFilter("taxtype", "=", (Object)template.getString("type.number"));
            QFilter formulaname = new QFilter("formula", "like", (Object)"{P%");
            QFilter formulaTypeFilter = new QFilter("formulatype", "=", (Object)"1");
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bdtaxr_formula_edit", (String)"id,formulaname,formulakey", (QFilter[])new QFilter[]{taxTypeFilter, formulaname, formulaTypeFilter});
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                if (customCalMap.containsKey(dynamicObject.getString("formulakey"))) continue;
                customCalMap.put(dynamicObject.getString("formulakey"), "0.00");
            }
            this.showInnerTbPage("2", orgId, customCalMap);
        }
        catch (Exception ex) {
            if ("KDBizException".equalsIgnoreCase(ex.getClass().getSimpleName())) {
                String code = ((KDBizException)((Object)ex)).getErrorCode().getCode();
                if ("nsrxxReviewed".equalsIgnoreCase(code)) {
                    this.getView().showErrorNotification(((KDBizException)((Object)ex)).getErrorCode().getMessage());
                } else if ("allRequiredField".equalsIgnoreCase(code)) {
                    this.getView().showErrorNotification(((KDBizException)((Object)ex)).getErrorCode().getMessage());
                }
            }
            String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
            logger.error("\u7528\u6237\u70b9\u51fb\u4e0b\u4e00\u6b65\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)exceptionStackTraceMessage);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TcvvtMainPlugin_7", (String)"taxc-tcvvt", (Object[])new Object[0]));
        }
    }

    private boolean calData(String orgId, String startdate, String enddate, List<DynamicObject> accountList) {
        EngineModel engineModel = new EngineModel(orgId, startdate, enddate);
        DynamicObject template = MainReportUtil.getTemplateType(orgId, startdate, enddate);
        engineModel.setDeclareType(template.getString("type.number"));
        engineModel.setPageCache(this.getPageCache());
        ArrayList<EngineModel> engineModels = new ArrayList<EngineModel>();
        engineModels.add(engineModel);
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            accountList.addAll(TcvvtEngineUtils.execute(RequestContext.getOrCreate(), engineModels));
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            h.markRollback();
            logger.error("\u8ba1\u7b97\u51fa\u73b0\u5f02\u5e38:" + t);
            if (t instanceof TimeoutException) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8ba1\u7b97\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"TcvvtMainPlugin_9", (String)"taxc-tcvvt", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TcvvtMainPlugin_10", (String)"taxc-tcvvt", (Object[])new Object[0]));
            }
            boolean bl = false;
            return bl;
        }
    }

    private void forwardStep(String orgId, String sksqq, String sksqz) {
        if (OperationStatus.VIEW.name().equalsIgnoreCase(this.getPageCache().get(ACTION_STATUS))) {
            this.showInnerTbPage("1", orgId, null);
            return;
        }
        boolean checkModelDataChange = this.checkModelDataHasChanged(false, orgId, sksqq, sksqz);
        if (checkModelDataChange) {
            String mainDesc = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u9700\u8981\u4fdd\u5b58\u540e\u8fd4\u56de\u4e0a\u4e00\u6b65\uff1f\r\n\u82e5\u76f4\u63a5\u8fd4\u56de\u4e0a\u4e00\u6b65\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"TcvvtMainPlugin_11", (String)"taxc-tcvvt", (Object[])new Object[0]);
            String cancelDesc = ResManager.loadKDString((String)"\u76f4\u63a5\u8fd4\u56de\u4e0a\u4e00\u6b65", (String)"TcvvtMainPlugin_12", (String)"taxc-tcvvt", (Object[])new Object[0]);
            String okDesc = ResManager.loadKDString((String)"\u4fdd\u5b58\u540e\u8fd4\u56de\u4e0a\u4e00\u6b65", (String)"TcvvtMainPlugin_13", (String)"taxc-tcvvt", (Object[])new Object[0]);
            this.showConfirm(FORWARD_KEY, mainDesc, cancelDesc, okDesc, FORWARD_KEY);
        } else {
            this.showInnerTbPage("1", orgId, null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        try {
            boolean checkResult;
            if (evt.getOperationResult() == null || !evt.getOperationResult().isSuccess()) {
                return;
            }
            String orgId = this.getModel().getValue(ORG_SEL) == null ? null : ((DynamicObject)this.getModel().getValue(ORG_SEL)).getString("id");
            Long taxauthority = this.getModel().getValue(TAXAUTHORITY) == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue(TAXAUTHORITY)).getLong("id"));
            Date startdate = (Date)this.getModel().getValue(START_DATE);
            Date enddate = (Date)this.getModel().getValue(END_DATE);
            String sksqq = DateUtils.format(startdate, "yyyy-MM-dd");
            String sksqz = DateUtils.format(enddate, "yyyy-MM-dd");
            String reportType = (String)this.getModel().getValue(REPORTTYPE);
            try {
                TcvvtLicenseCheckBusinessImpl.orgLicenseCheck(orgId, "tcvvt");
            }
            catch (KDBizException ex) {
                this.getView().showErrorNotification(ex.getMessage());
                return;
            }
            if (orgId == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"TcvvtMainPlugin_3", (String)"taxc-tcvvt", (Object[])new Object[0]));
                return;
            }
            if (startdate == null || enddate == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u65e5\u671f\u201d\u3002", (String)"TcvvtMainPlugin_4", (String)"taxc-tcvvt", (Object[])new Object[0]));
                return;
            }
            if (reportType == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7533\u62a5\u7c7b\u578b\u201d\u3002", (String)"TcvvtMainPlugin_5", (String)"taxc-tcvvt", (Object[])new Object[0]));
                return;
            }
            String key = evt.getOperateKey();
            String focusPage = (String)this.getModel().getValue(FOCUS_PAGE);
            if (!(CANCEL_EDIT.equalsIgnoreCase(key) || CLOSE_KEY.equalsIgnoreCase(key) || (checkResult = this.checkBeforeOpt(orgId, taxauthority, reportType, sksqq, sksqz, true, false)))) {
                return;
            }
            switch (key) {
                case "next": {
                    this.nextStep(orgId, taxauthority, sksqq, sksqz, reportType);
                    break;
                }
                case "forward": {
                    this.forwardStep(orgId, sksqq, sksqz);
                    break;
                }
                case "edit": {
                    this.edit(orgId, sksqq, sksqz, focusPage);
                    break;
                }
                case "save": {
                    this.saveStepTwo(orgId, taxauthority, sksqq, sksqz, reportType, focusPage);
                    break;
                }
                case "cancel_edit": {
                    this.cancelEditToView(orgId, sksqq, sksqz, focusPage);
                    break;
                }
                case "submit": {
                    this.submit(true, SUBMIT_KEY, orgId, sksqq, sksqz, key);
                    break;
                }
                case "recalc": {
                    this.recalc();
                    break;
                }
                case "close": {
                    this.getView().close();
                    break;
                }
                case "cancel_submit": {
                    this.submit(false, "", orgId, sksqq, sksqz, key);
                    break;
                }
                case "audit": {
                    this.submit(true, AUDIT_KEY, orgId, sksqq, sksqz, key);
                    break;
                }
                case "unaudit": {
                    this.submit(true, UNAUDIT, orgId, sksqq, sksqz, key);
                    break;
                }
                case "init": {
                    this.initData();
                    break;
                }
            }
        }
        catch (Exception ex) {
            if ("KDBizException".equalsIgnoreCase(ex.getClass().getSimpleName())) {
                String code = ((KDBizException)((Object)ex)).getErrorCode().getCode();
                if ("nsrxxReviewed".equalsIgnoreCase(code)) {
                    this.getView().showErrorNotification(((KDBizException)((Object)ex)).getErrorCode().getMessage());
                } else if ("allRequiredField".equalsIgnoreCase(code)) {
                    this.getView().showErrorNotification(((KDBizException)((Object)ex)).getErrorCode().getMessage());
                }
            }
            String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
            logger.error("\u7f16\u5236\u64cd\u4f5c\u6309\u94ae\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)exceptionStackTraceMessage);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TcvvtMainPlugin_7", (String)"taxc-tcvvt", (Object[])new Object[0]));
        }
    }

    private void cancelEditToView(String orgId, String sksqq, String skqqz, String focusPage) {
        boolean checkDateChange = this.checkModelDataHasChanged(true, orgId, sksqq, skqqz);
        if (checkDateChange) {
            if ("1".equalsIgnoreCase(focusPage)) {
                boolean hasNsrxxInfo;
                boolean bl = hasNsrxxInfo = MainReportUtil.queryNsrxx(orgId, sksqq, skqqz) != null;
                if (!hasNsrxxInfo) {
                    this.getPageCache().put("hasShowCloseModal", "Y");
                    this.getView().close();
                } else {
                    this.setSelectIds(orgId, sksqq, skqqz);
                    this.getPageCache().put(ACTION_STATUS, OperationStatus.VIEW.name());
                    this.showInnerTbPage(focusPage, orgId, null);
                }
            } else {
                String cancelDesc = ResManager.loadKDString((String)"\u786e\u8ba4\u53d6\u6d88", (String)"TcvvtMainPlugin_1", (String)"taxc-tcvvt", (Object[])new Object[0]);
                String okDesc = ResManager.loadKDString((String)"\u4fdd\u5b58\u5e76\u9000\u51fa\u7f16\u8f91", (String)"TcvvtMainPlugin_16", (String)"taxc-tcvvt", (Object[])new Object[0]);
                String mainDesc = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u9700\u8981\u4fdd\u5b58\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"TcvvtMainPlugin_0", (String)"taxc-tcvvt", (Object[])new Object[0]);
                this.showConfirm(CANCEL_EDIT, mainDesc, cancelDesc, okDesc, CANCEL_EDIT);
            }
        } else {
            this.getPageCache().put(ACTION_STATUS, OperationStatus.VIEW.name());
            DynamicObject nsrxx = MainReportUtil.queryNsrxx(orgId, sksqq, skqqz);
            if (nsrxx != null) {
                this.setSelectIds(orgId, sksqq, skqqz);
                this.showInnerTbPage(focusPage, orgId, null);
            } else {
                this.getView().close();
            }
            this.releaseMutexLock(EDIT_KEY, orgId, sksqq, skqqz);
        }
    }

    public void edit(String orgId, String sksqq, String sksqz, String focusPage) {
        DynamicObject declare = MainReportUtil.queryNsrxx(orgId, sksqq, sksqz);
        if (declare != null) {
            String billStatus = declare.getString("billstatus");
            if (!"A".equals(billStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u7f16\u8f91\u6682\u5b58\u72b6\u6001\u4e0b\u7684\u62a5\u8868\u6570\u636e\u3002", (String)"TcvvtMainPlugin_14", (String)"taxc-tcvvt", (Object[])new Object[0]));
                return;
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5f53\u524d\u6761\u4ef6\u4e0b\u7684\u7533\u62a5\u8868\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TcvvtMainPlugin_15", (String)"taxc-tcvvt", (Object[])new Object[0]));
            return;
        }
        try {
            String sbbid = declare.getString("id");
            String entityname = this.getModel().getDataEntityType().getName();
            MutexServiceImpl mutexService = new MutexServiceImpl();
            HashMap<String, String> customparam = new HashMap<String, String>();
            customparam.put("dataObjId", sbbid);
            customparam.put("entityKey", "tcvvt_main_declare_list");
            customparam.put("operationKey", EDIT_KEY);
            customparam.put("groupId", "declare_edit");
            mutexService.setMutexLockInfo(customparam);
            boolean isSuccessLock = mutexService.setMutexLock();
            logger.info("DynamicEntity:{},Entity:{} lock : {}", new Object[]{entityname, "tcvvt_main_declare_list", isSuccessLock});
            if (!isSuccessLock && this.checkLockedMutexLock(sbbid)) {
                return;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        this.getPageCache().put(ACTION_STATUS, OperationStatus.EDIT.name());
        this.showInnerTbPage(focusPage, orgId, null);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        try {
            String callBackId = e.getCallBackId();
            String orgId = this.getModel().getValue(ORG_SEL) == null ? null : ((DynamicObject)this.getModel().getValue(ORG_SEL)).getString("id");
            Long taxauthority = this.getModel().getValue(TAXAUTHORITY) == null ? null : Long.valueOf(((DynamicObject)this.getModel().getValue(TAXAUTHORITY)).getLong("id"));
            Date startdate = (Date)this.getModel().getValue(START_DATE);
            Date enddate = (Date)this.getModel().getValue(END_DATE);
            String sksqq = DateUtils.format(startdate, "yyyy-MM-dd");
            String sksqz = DateUtils.format(enddate, "yyyy-MM-dd");
            String reportType = (String)this.getModel().getValue(REPORTTYPE);
            switch (callBackId) {
                case "recalc": {
                    this.recalCallBack(e, orgId, sksqq, sksqz);
                    break;
                }
                case "cancel_edit": {
                    this.cancelEditCallBack(e.getResult(), orgId, taxauthority, sksqq, sksqz, reportType);
                    break;
                }
                case "close": {
                    this.closePageCallBack(e.getResult(), orgId, taxauthority, sksqq, sksqz);
                    break;
                }
                case "reduce_key": {
                    this.reduceCallBack(e, orgId, sksqq, sksqz);
                    break;
                }
                case "forward": {
                    this.fowardStepCallBack(e, orgId, taxauthority, sksqq, sksqz, reportType);
                    break;
                }
                case "init": {
                    this.initData(e, orgId, sksqq, sksqz, reportType);
                    break;
                }
            }
        }
        catch (Exception ex) {
            if ("KDBizException".equalsIgnoreCase(ex.getClass().getSimpleName())) {
                String code = ((KDBizException)((Object)ex)).getErrorCode().getCode();
                if ("nsrxxReviewed".equalsIgnoreCase(code)) {
                    this.getView().showErrorNotification(((KDBizException)((Object)ex)).getErrorCode().getMessage());
                } else if ("allRequiredField".equalsIgnoreCase(code)) {
                    this.getView().showErrorNotification(((KDBizException)((Object)ex)).getErrorCode().getMessage());
                }
            }
            String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
            logger.error("\u5f39\u7a97\u5904\u7406\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)exceptionStackTraceMessage);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TcvvtMainPlugin_7", (String)"taxc-tcvvt", (Object[])new Object[0]));
        }
    }

    private boolean checkModelDataHasChanged(boolean checkAllPage, String orgId, String sksqq, String sksqz) {
        try {
            String focuspage = (String)this.getModel().getValue(FOCUS_PAGE);
            IFormView childPage = this.getView().getView(this.getPageCache().get("declarepageid"));
            if ("1".equals(focuspage)) {
                return this.checkStepOneDataChanged(orgId, sksqq, sksqz, childPage, true);
            }
            IPageCache childPageCache = childPage.getPageCache();
            Map updateMap = (Map)TreeUtils.getCache((IPageCache)childPageCache, (String)"updata_cellid", Map.class);
            if (checkAllPage) {
                boolean stepOneHasChanged = false;
                if (!MainReportUtil.isImport(orgId, sksqq, sksqz)) {
                    stepOneHasChanged = this.checkStepOneDataChanged(orgId, sksqq, sksqz, childPage, false);
                }
                return updateMap != null && updateMap.size() > 0 || stepOneHasChanged;
            }
            return updateMap != null && updateMap.size() > 0;
        }
        catch (Exception e) {
            String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            logger.error("\u68c0\u67e5\u9875\u9762\u672a\u4fdd\u5b58\u6570\u636e\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)exceptionStackTraceMessage);
            return false;
        }
    }

    private boolean checkStepOneDataChanged(String orgId, String sksqq, String sksqz, IFormView childPage, boolean isStepOne) {
        DynamicObject tcvvtMessage = MainReportUtil.getTcvvtMessage(orgId, sksqq, sksqz);
        if (tcvvtMessage == null) {
            return false;
        }
        List selectidsOld = tcvvtMessage.getDynamicObjectCollection(ENTRYENTITY).stream().map(s -> s.getLong("selectid")).sorted().collect(Collectors.toList());
        String selectidsOldStr = SerializationUtils.toJsonString(selectidsOld);
        String newListSelected = null;
        if (isStepOne) {
            List billlistapSelectIds = ((BillList)childPage.getControl("billlistap")).getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).sorted().collect(Collectors.toList());
            newListSelected = SerializationUtils.toJsonString(billlistapSelectIds);
        } else {
            newListSelected = this.getModel().getValue(SELECTIDS) != null ? (String)this.getModel().getValue(SELECTIDS) : "";
        }
        return !selectidsOldStr.equals(newListSelected);
    }

    private void saveStepTwo(String orgId, Long taxauthority, String sksqq, String sksqz, String reportType, String focusPage) {
        NsrxxValidatorUtils.nsrxxReviewed((Long)Long.parseLong(orgId));
        if ("1".equals(focusPage)) {
            return;
        }
        boolean checkResult = this.checkBeforeOpt(orgId, taxauthority, reportType, sksqq, sksqz, true, true);
        if (checkResult) {
            this.saveStepOne(orgId, sksqq, sksqz, MainReportUtil.getTemplateType(orgId, sksqq, sksqz));
            this.saveDeclare(true);
            this.showInnerTbPage(focusPage, orgId, null);
        }
    }

    private void saveAdjust(String orgid, String startdate, String enddate) {
        try {
            NsrxxValidatorUtils.nsrxxReviewed((Long)Long.parseLong(orgid));
            IFormView childPage = this.getView().getView(this.getPageCache().get("declarepageid"));
            IPageCache childPageCache = childPage.getPageCache();
            Map updateMap = (Map)TreeUtils.getCache((IPageCache)childPageCache, (String)"updata_cellid", Map.class);
            Date skssqq = DateUtils.stringToDate(startdate);
            Date skssqz = DateUtils.stringToDate(enddate);
            if (updateMap == null) {
                return;
            }
            String updateCellListStr = this.getPageCache().get("updateCellMap");
            Map updateCellMap = StringUtils.isEmpty((CharSequence)updateCellListStr) ? new HashMap() : JsonUtil.fromJson(updateCellListStr, Map.class);
            for (Map.Entry entry : updateCellMap.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                this.saveAdjust(orgid, skssqq, skssqz, key, new BigDecimal(value));
            }
        }
        catch (Exception e) {
            String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            logger.error("\u4fdd\u5b58\u4e34\u65f6\u4fee\u6539\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)exceptionStackTraceMessage);
        }
    }

    private void saveAdjust(String orgid, Date skssqq, Date skssqz, String cellId, BigDecimal value) {
        QFilter orgFilter = new QFilter(ORG_SEL, "=", (Object)Long.parseLong(orgid));
        QFilter startFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
        QFilter endFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
        QFilter cellIdFilter = new QFilter("cellid", "=", (Object)cellId);
        QFilter[] filters = new QFilter[]{orgFilter, startFilter, endFilter, cellIdFilter};
        DynamicObject adjust = BusinessDataServiceHelper.loadSingle((String)TCVVT_MAIN_ADJUST, (String)"adjustamount", (QFilter[])filters);
        if (adjust == null) {
            this.saveNewAdjust(cellId, Long.parseLong(orgid), skssqq, skssqz, value);
        } else {
            adjust.set("adjustamount", (Object)value);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{adjust});
        }
    }

    private void saveNewAdjust(String cellId, Object orgid, Date skssqq, Date skssqz, BigDecimal value) {
        DynamicObject adjustObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCVVT_MAIN_ADJUST));
        adjustObj.set(ORG_SEL, orgid);
        adjustObj.set("cellid", (Object)cellId);
        adjustObj.set(SKSSQQ, (Object)skssqq);
        adjustObj.set(SKSSQZ, (Object)skssqz);
        adjustObj.set("titlename", (Object)ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u91d1\u989d", (String)"TcvvtMainPlugin_17", (String)"taxc-tcvvt", (Object[])new Object[0]));
        adjustObj.set("adjustamount", (Object)value);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{adjustObj});
    }

    private String setReportType(String orgid) {
        String reportType;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (!ObjectUtils.isEmpty(customParams.get("taxlimit"))) {
            reportType = DeclareCheckFacility.getReportType(customParams.get("taxlimit").toString());
        } else if (customParams.get(REPORTTYPE) != null) {
            reportType = customParams.get(REPORTTYPE).toString();
        } else {
            reportType = this.getReportTypeByOrgId(orgid);
            if (reportType == null) {
                reportType = "aysb";
            }
        }
        this.getModel().setValue(REPORTTYPE, (Object)reportType);
        return reportType;
    }

    private String getReportTypeByOrgId(String orgId) {
        String reportType = null;
        DynamicObject dynamicObject = TcvvtCategoryInfoBusinessImpl.querycwbbCategoryInfoByOrgId((String)orgId);
        if (!ObjectUtils.isEmpty((Object)dynamicObject)) {
            reportType = dynamicObject.getString("declareperiod");
        }
        return reportType;
    }

    private boolean checkBeforeOpt(String orgId, Long taxauthority, String reporttype, Date startdate, Date enddate, boolean showErrorInfo, boolean isSave) {
        try {
            String startDateStr = DateUtils.format(startdate, "yyyy-MM-dd");
            String endDateStr = DateUtils.format(enddate, "yyyy-MM-dd");
            return this.checkBeforeOpt(orgId, taxauthority, reporttype, startDateStr, endDateStr, showErrorInfo, isSave);
        }
        catch (KDBizException e) {
            this.getView().showErrorNotification(e.getMessage());
            return false;
        }
    }

    private boolean checkBeforeOpt(String orgId, Long taxauthority, String reporttype, String startdate, String enddate, boolean showErrorInfo, boolean isUpdate) {
        try {
            String billStatus;
            DynamicObject declare;
            if (isUpdate && (declare = MainReportUtil.queryNsrxx(orgId, startdate, enddate)) != null && !"A".equals(billStatus = declare.getString("billstatus"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u7f16\u8f91\u6682\u5b58\u72b6\u6001\u4e0b\u7684\u62a5\u8868\u6570\u636e\u3002", (String)"TcvvtMainPlugin_14", (String)"taxc-tcvvt", (Object[])new Object[0]));
                return false;
            }
            Date startDate = DateUtils.stringToDate(startdate, "yyyy-MM-dd");
            Date endDate = DateUtils.stringToDate(enddate, "yyyy-MM-dd");
            DeclareCheckFacility.checkOrgAndDate(null, orgId, taxauthority, reporttype, startDate, endDate, this.getView());
            return true;
        }
        catch (KDBizException e) {
            if (showErrorInfo) {
                this.getView().showErrorNotification(e.getMessage());
            }
            return false;
        }
    }

    private void showInnerTbPage(String focuspage, String orgId, Map<String, String> customCalMap) {
        String isInit1;
        String maxStatus = this.getPageCache().get(MAX_STATUS);
        if (maxStatus == null || Integer.parseInt(focuspage) > Integer.parseInt(maxStatus)) {
            this.getPageCache().put(MAX_STATUS, focuspage);
        }
        this.getModel().setValue(FOCUS_PAGE, (Object)focuspage);
        if ("1".equals(focuspage)) {
            this.getPageCache().remove("updateCellMap");
        }
        String actionStatus = this.getPageCache().get(ACTION_STATUS);
        Date startdate = (Date)this.getModel().getValue(START_DATE);
        Date enddate = (Date)this.getModel().getValue(END_DATE);
        Long taxauthority = ((DynamicObject)this.getModel().getValue(TAXAUTHORITY)).getLong("id");
        String sksqq = DateUtils.format(startdate, "yyyy-MM-dd");
        String sksqz = DateUtils.format(enddate, "yyyy-MM-dd");
        this.cacheTcvvtMessage(orgId, sksqq, sksqz);
        DynamicObject nsrxx = MainReportUtil.queryNsrxx(orgId, sksqq, sksqz);
        if (nsrxx == null) {
            actionStatus = OperationStatus.EDIT.name();
        }
        this.getPageCache().put("sbbid", ObjectUtils.isNotEmpty((Object)nsrxx) ? nsrxx.getString("id") : "0");
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)actionStatus)) {
            actionStatus = nsrxx != null ? OperationStatus.VIEW.name() : OperationStatus.EDIT.name();
        }
        this.getPageCache().put(ACTION_STATUS, actionStatus);
        String status = this.getStatus(orgId, sksqq, sksqz);
        this.getPageCache().put(STATUS, status);
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put(ORGID_KEY, orgId);
        customParams.put(STATUS, status);
        customParams.put(TAXAUTHORITY, taxauthority);
        customParams.put("operation_status", actionStatus);
        String rootPageId = this.getView().getPageId();
        customParams.put("rootPageId", rootPageId);
        customParams.put(SKSSQQ, sksqq);
        customParams.put(REPORTTYPE, this.getModel().getValue(REPORTTYPE));
        customParams.put(SKSSQZ, sksqz);
        customParams.put("statusclass", this.getStatusService().getClass().getName());
        customParams.put("totalsteps", this.getDeclarePageMap().size());
        customParams.put(FOCUS_PAGE, focuspage);
        if (!ObjectUtils.isEmpty(customCalMap) && !ObjectUtils.isEmpty((Object)customCalMap.get(CACHE_DECLARE_DATA))) {
            customParams.put(CACHE_DECLARE_DATA, customCalMap.get(CACHE_DECLARE_DATA));
        }
        customParams.put("planid", this.getPageCache().get("planid"));
        DynamicObject template = MainReportUtil.getTemplateType(orgId, sksqq, sksqz);
        String templateType = ObjectUtils.isNotEmpty((Object)template) ? template.getString(NUMBER) : "";
        String type = ObjectUtils.isNotEmpty((Object)template) ? template.getString("type.number") : "";
        String templateid = ObjectUtils.isNotEmpty((Object)template) ? template.getString("id") : "";
        customParams.put("templateType", templateType);
        customParams.put(TYPE, type);
        this.getPageCache().put("templatetype", type);
        Boolean isInit = TcvvtInitReportDataBusinessImpl.queryInitReport(Long.parseLong(orgId), DateUtils.stringToDate(sksqq), DateUtils.stringToDate(sksqz), type);
        if (!ObjectUtils.isEmpty(customCalMap) && !ObjectUtils.isEmpty((Object)customCalMap.get(ISINIT)) && "1".equalsIgnoreCase(isInit1 = customCalMap.get(ISINIT))) {
            isInit = true;
        }
        if (isInit.booleanValue()) {
            this.getPageCache().put("needRuleFeatch", "1");
        }
        customParams.put("templateid", templateid);
        QFilter orgFilter = new QFilter(ORGID_KEY, "=", (Object)Long.parseLong(orgId));
        if (null == nsrxx) {
            TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgIdsWithNoStatus(Collections.singletonList(Long.parseLong(orgId)), (Long)TaxationsysMappingEnum.CHN.getId());
            if (!ObjectUtils.isEmpty((Object)result) && !ObjectUtils.isEmpty((Object)result.getData())) {
                List data = (List)result.getData();
                DynamicObject dTctb = (DynamicObject)data.get(0);
                customParams.put("accountingstandards", dTctb.get("accountingstandards.id"));
                customParams.put("newrule", dTctb.get("newrule"));
                customParams.put("registeraddress", dTctb.get("registeraddress"));
            }
        } else {
            QFilter skssqqQ = new QFilter(START_DATE, "=", (Object)startdate);
            QFilter skssqzQ = new QFilter(END_DATE, "=", (Object)enddate);
            QFilter typeQ = new QFilter(TYPE, "=", (Object)type);
            QFilter templateidQ = new QFilter("templateid", "=", (Object)templateid);
            DynamicObject meg = QueryServiceHelper.queryOne((String)TCVVT_MESSAGE, (String)"type,templateid,accountingstandards,newrule,registeraddress", (QFilter[])new QFilter[]{orgFilter, skssqqQ, skssqzQ, typeQ, templateidQ});
            if (null != meg) {
                customParams.put("accountingstandards", meg.get("accountingstandards"));
                customParams.put("newrule", meg.get("newrule"));
                customParams.put("registeraddress", meg.get("registeraddress"));
            }
        }
        FormShowParameter param = this.createShowParameter(focuspage, orgId, sksqq, sksqz, customParams);
        if (param == null) {
            return;
        }
        if ("2".equals(focuspage)) {
            QFilter filter3;
            QFilter filter2;
            QFilter filter1;
            DynamicObject[] dynamicObjects;
            DeclareRequestModel requestModel = this.getDeclareRequestModel(orgId, actionStatus, nsrxx, sksqq, sksqz, template);
            if (EDIT_KEY.equalsIgnoreCase(actionStatus)) {
                requestModel.setOperation(EDIT_KEY);
            }
            if (customCalMap != null) {
                requestModel.setBusinessMap(customCalMap);
            }
            if (EmptyCheckUtils.isEmpty(nsrxx) && FR0005.equals(templateType) && EmptyCheckUtils.isNotEmpty(dynamicObjects = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)"id, skssqq,skssqz,org.id", (QFilter[])new QFilter[]{filter1 = new QFilter("org.id", "=", (Object)Long.parseLong(orgId)), filter2 = new QFilter(TYPE, "=", (Object)"FR0002"), filter3 = new QFilter("templateid", "=", (Object)templateid)}, (String)"modifytime desc", (int)1))) {
                requestModel.getBusinessMap().put("kjzzsbbid", String.valueOf(dynamicObjects[0].getLong("id")));
            }
            if (!(ObjectUtils.isEmpty((Object)requestModel) || ObjectUtils.isEmpty((Object)requestModel.getId()) || ObjectUtils.isEmpty((Object)requestModel.getId()))) {
                DynamicObject nsrxxObject = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)requestModel.getId())});
                if (!ObjectUtils.isEmpty((Object)nsrxxObject)) {
                    String billno = nsrxxObject.getString("billno");
                    if (!billno.startsWith("FIN")) {
                        String number = DeclareServiceHelper.generateSBBNo((String)"tcvvt_main_declare_list");
                        requestModel.setBillNo(number);
                    }
                } else {
                    String number = DeclareServiceHelper.generateSBBNo((String)"tcvvt_main_declare_list");
                    requestModel.setBillNo(number);
                }
            }
            Map metaMap = TemplateFormulaServiceHelper.getMetaDataListByTmpId((Long)Long.parseLong(templateid));
            requestModel.setMetaDataMap(metaMap);
            requestModel.getBusinessMap().put("needremark", "true");
            DeclareRequestServiceImpl declareRequestService = new DeclareRequestServiceImpl();
            requestModel = declareRequestService.build(SerializationUtils.toJsonString((Object)requestModel));
            customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
        }
        customParams.put(SELECTIDS, this.getModel().getValue(SELECTIDS));
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(CONTENT_TAB);
        String pageid = param.getPageId();
        this.getPageCache().put("declarepageid", pageid);
        this.lightenForStatus(focuspage, status, actionStatus, nsrxx);
        this.getView().showForm(param);
    }

    private String getStatus(String orgid, String startdate, String enddate) {
        List<QFilter> list = this.buildQFilters(orgid, startdate, enddate);
        DynamicObject object = QueryServiceHelper.queryOne((String)TCVVT_MESSAGE, (String)"id,status", (QFilter[])list.toArray(new QFilter[0]));
        if (object != null) {
            return object.getString(STATUS);
        }
        String cacheStatus = this.getPageCache().get(MAX_STATUS);
        if (cacheStatus != null) {
            return cacheStatus;
        }
        return "1";
    }

    private DeclareRequestModel getDeclareRequestModel(String orgId, String actionStatus, DynamicObject dynamicObject, String startdate, String enddate, DynamicObject template) {
        int i;
        String newSelectidsStr;
        DeclareRequestModel requestModel = new DeclareRequestModel();
        requestModel.setId(dynamicObject != null ? Long.valueOf(dynamicObject.getLong("id")) : MainReportUtil.generateSBBId("tcvat_nsrxx"));
        requestModel.setOrgId(Long.valueOf(Long.parseLong(orgId)));
        requestModel.setTemplateType(ObjectUtils.isNotEmpty((Object)template) ? template.getString("type.number") : "");
        requestModel.setTemplateId(ObjectUtils.isNotEmpty((Object)template) ? Long.valueOf(template.getLong("id")) : null);
        requestModel.setSkssqq(startdate);
        requestModel.setSkssqz(enddate);
        requestModel.setOperation(actionStatus);
        boolean refresh = OperationStatus.EDIT.name().equalsIgnoreCase(actionStatus) && dynamicObject == null;
        requestModel.setRefresh(Boolean.valueOf(refresh));
        if (dynamicObject != null && "2".equalsIgnoreCase(dynamicObject.getString("datatype"))) {
            requestModel.setRefresh(Boolean.valueOf(false));
        }
        List selectedIds = new ArrayList();
        String string = newSelectidsStr = this.getModel().getValue(SELECTIDS) != null ? (String)this.getModel().getValue(SELECTIDS) : "";
        if (StringUtil.isNotEmpty((CharSequence)newSelectidsStr)) {
            selectedIds = SerializationUtils.fromJsonStringToList((String)newSelectidsStr, Long.class);
        }
        DynamicObject[] selectReports = BusinessDataServiceHelper.load((Object[])selectedIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tcvvt_check_report"));
        QFilter numberf = new QFilter(TYPE, "=", (Object)template.getString(NUMBER));
        QFilter idf = new QFilter("id", "not in", selectedIds);
        DynamicObjectCollection reports = QueryServiceHelper.query((String)"tcvvt_check_report", (String)"mainname", (QFilter[])new QFilter[]{numberf, idf});
        DynamicObject[] tcvvtCheckReports = new DynamicObject[reports.size()];
        for (int i2 = 0; i2 < reports.size(); ++i2) {
            tcvvtCheckReports[i2] = (DynamicObject)reports.get(i2);
        }
        StringBuilder name = new StringBuilder();
        for (i = 0; i < tcvvtCheckReports.length; ++i) {
            name.append(tcvvtCheckReports[i].getString("mainname"));
            if (i == tcvvtCheckReports.length - 1) continue;
            name.append(",");
        }
        name.append("-");
        for (i = 0; i < selectReports.length; ++i) {
            name.append(selectReports[i].getString("mainname"));
            if (i == selectReports.length - 1) continue;
            name.append(",");
        }
        requestModel.setSheetName(name.toString());
        requestModel.getBusinessMap().put("needremark", "true");
        return requestModel;
    }

    private void initStartAndEndDate(boolean orgChange) {
        Date skssqz;
        Date skssqq;
        String taxLimit = this.getTaxLimits((String)this.getModel().getValue(REPORTTYPE));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get(SKSSQQ) != null && customParams.get(SKSSQZ) != null && !orgChange) {
            skssqq = DateUtils.stringToDate(customParams.get(SKSSQQ).toString(), "yyyy-MM-dd");
            skssqz = DateUtils.stringToDate(customParams.get(SKSSQZ).toString(), "yyyy-MM-dd");
        } else {
            switch (taxLimit) {
                case "year": {
                    skssqq = DateUtils.getFirstDateOfYear(DateUtils.addYear(new Date(), -1));
                    skssqz = DateUtils.getLastDateOfYear(skssqq);
                    break;
                }
                case "season": {
                    skssqq = DateUtils.getFirstDateOfSeason(DateUtils.addMonth(new Date(), -3));
                    skssqz = DateUtils.getLastDateOfSeason(skssqq);
                    break;
                }
                case "month": {
                    skssqq = DateUtils.getFirstDateOfMonth(DateUtils.addMonth(new Date(), -1));
                    skssqz = DateUtils.getLastDateOfMonth(skssqq);
                    break;
                }
                default: {
                    skssqq = null;
                    skssqz = null;
                }
            }
        }
        if (orgChange && !StringUtil.equals((CharSequence)DateUtils.format(skssqq), (CharSequence)DateUtils.format((Date)this.getModel().getValue(START_DATE)))) {
            this.getPageCache().put("code_change_start2", "true");
        }
        this.getModel().setValue(START_DATE, (Object)skssqq);
        if (orgChange && !StringUtil.equals((CharSequence)DateUtils.format(skssqz), (CharSequence)DateUtils.format((Date)this.getModel().getValue(END_DATE)))) {
            this.getPageCache().put("code_change_end2", "true");
        }
        this.getModel().setValue(END_DATE, (Object)skssqz);
    }

    private FormShowParameter createShowParameter(String focuspage, String orgId, String startdate, String enddate, Map<String, Object> customParams) {
        DeclarePageType declarePageType = this.declarePageMap.get(focuspage);
        String entity = declarePageType.getEntity();
        switch (declarePageType.getShowType()) {
            case "Form": {
                if (Objects.equals(customParams.get(STATUS), "2")) {
                    customParams.put("refresh", Boolean.FALSE);
                } else {
                    customParams.put("refresh", Boolean.TRUE);
                    this.getStatusService().updateStatus(orgId, startdate, enddate, "2");
                }
                FormShowParameter param = new FormShowParameter();
                param.setFormId(entity);
                return param;
            }
            case "Bill": {
                BillShowParameter billParam = new BillShowParameter();
                billParam.setStatus(OperationStatus.VIEW);
                DynamicObject object = this.getStatusService().queryOne(orgId, startdate, enddate);
                if (object != null) {
                    billParam.setPkId(object.get("id"));
                }
                billParam.setFormId(entity);
                return billParam;
            }
            case "BillList": {
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setBillFormId("bos_list");
                listShowParameter.setFormId(entity);
                return listShowParameter;
            }
        }
        return null;
    }

    private void lightenForStatus(String focuspage, String status, String actionStatus, DynamicObject nsrxx) {
        DeclareStepsUtils.resetSteps((int)this.declarePageMap.size(), (String)focuspage, (String)status, (IFormView)this.getView());
        this.setButtonVisible(focuspage, actionStatus, nsrxx);
    }

    private void saveStepOne(String orgId, String sksqq, String sksqz, DynamicObject template) {
        NsrxxValidatorUtils.nsrxxReviewed((Long)Long.parseLong(orgId));
        if (MainReportUtil.isImport(orgId, sksqq, sksqz)) {
            return;
        }
        List<QFilter> qFilters = this.getStatusService().buildQFilters(orgId, sksqq, sksqz);
        String type = ObjectUtils.isNotEmpty((Object)template) ? template.getString("type.number") : "";
        String templateid = ObjectUtils.isNotEmpty((Object)template) ? template.getString("id") : "";
        QFilter nsrtypeQ = new QFilter(TYPE, "=", (Object)type);
        QFilter templateidQ = new QFilter("templateid", "=", (Object)templateid);
        qFilters.add(nsrtypeQ);
        qFilters.add(templateidQ);
        DynamicObject dynamicObjectNew = BusinessDataServiceHelper.loadSingle((String)TCVVT_MESSAGE, (String)"status,orgid,startdate,enddate,reporttype,accountingstandards,newrule,registeraddress,declaretype,entryentity.selectid,type,templateid", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (dynamicObjectNew == null) {
            dynamicObjectNew = BusinessDataServiceHelper.newDynamicObject((String)TCVVT_MESSAGE);
        }
        Date startdate = DateUtils.stringToDate(sksqq, "yyyy-MM-dd");
        Date enddate = DateUtils.stringToDate(sksqz, "yyyy-MM-dd");
        dynamicObjectNew.set(STATUS, (Object)"2");
        dynamicObjectNew.set(ORGID_KEY, (Object)Long.parseLong(orgId));
        dynamicObjectNew.set(START_DATE, (Object)startdate);
        dynamicObjectNew.set(END_DATE, (Object)enddate);
        String reportType = (String)this.getModel().getValue(REPORTTYPE);
        dynamicObjectNew.set(REPORTTYPE, (Object)reportType);
        dynamicObjectNew.set(TYPE, (Object)type);
        dynamicObjectNew.set("templateid", (Object)templateid);
        QFilter orgFilter = new QFilter(ORGID_KEY, "=", (Object)Long.parseLong(orgId));
        dynamicObjectNew.set("accountingstandards", ObjectUtils.isNotEmpty((Object)this.getPageCache().get("cache_accountingstandards")) ? this.getPageCache().get("cache_accountingstandards") : null);
        dynamicObjectNew.set("newrule", (Object)this.getPageCache().get("cache_newrule"));
        dynamicObjectNew.set("registeraddress", ObjectUtils.isNotEmpty((Object)this.getPageCache().get("cache_registeraddress")) ? Long.valueOf(this.getPageCache().get("cache_registeraddress")) : null);
        dynamicObjectNew.set("declaretype", (Object)this.getPageCache().get("declaretype"));
        DynamicObjectCollection entryentityAdd = dynamicObjectNew.getDynamicObjectCollection(ENTRYENTITY);
        String newSelectidsStr = this.getModel().getValue(SELECTIDS) != null ? (String)this.getModel().getValue(SELECTIDS) : "";
        List selectidsNew = new ArrayList();
        if (StringUtil.isNotEmpty((CharSequence)newSelectidsStr)) {
            selectidsNew = SerializationUtils.fromJsonStringToList((String)newSelectidsStr, Long.class);
            entryentityAdd.removeIf(dynamicObject -> true);
            for (Long dynamicObject2 : selectidsNew) {
                entryentityAdd.addNew().set("selectid", (Object)dynamicObject2);
            }
        }
        OperationServiceHelper.executeOperate((String)SAVE_KEY, (String)TCVVT_MESSAGE, (DynamicObject[])new DynamicObject[]{dynamicObjectNew}, (OperateOption)OperateOption.create());
        this.saveAdjust(orgId, sksqq, sksqz);
        this.getPageCache().remove("updateCellMap");
    }

    private void showConfirm(String listenerKey, String mainDesc, String cancelDesc, String yesDesc, String scence) {
        this.getPageCache().put(SHOW_CONFIRM_SCENE, scence);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(listenerKey, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), cancelDesc);
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), yesDesc);
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        this.getView().showConfirm(mainDesc, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    private void saveDeclare(boolean showSucc) {
        Map update_cellvalue;
        NsrxxValidatorUtils.nsrxxReviewed((Long)this.getModel().getDataEntity().getLong("org.id"));
        String pageid = this.getPageCache().get("declarepageid");
        IFormView childView = this.getView().getView(pageid);
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)childView.getService(FormViewPluginProxy.class);
        IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
        DeclareResponseModel responseModel = (DeclareResponseModel)SerializationUtils.fromJsonString((String)childPageCache.get(CACHE_DECLARE_DATA), DeclareResponseModel.class);
        String updata_cellid = childPageCache.get("updata_cellid");
        if (!ObjectUtils.isEmpty((Object)updata_cellid)) {
            Map updata = (Map)SerializationUtils.fromJsonString((String)updata_cellid, Map.class);
            responseModel.getData().putAll(updata);
        }
        if (!ObjectUtils.isEmpty((Object)(update_cellvalue = (Map)TreeUtils.getCache((IPageCache)childPageCache, (String)CACHE_UPDATA_CELLID_SAVE, Map.class)))) {
            responseModel.getData().putAll(update_cellvalue);
        }
        DeclareRequestModel requestModel = (DeclareRequestModel)SerializationUtils.fromJsonString((String)childPageCache.get(CACHE_DECLARE_REQUEST), DeclareRequestModel.class);
        if (!ObjectUtils.isEmpty((Object)this.getPageCache().get(ISINIT)) && "1".equalsIgnoreCase(this.getPageCache().get(ISINIT))) {
            requestModel.setRefresh(Boolean.valueOf(true));
            TcvvtMainPlugin.deleteInitReport(requestModel.getOrgId(), requestModel.getSkssqq(), requestModel.getSkssqz(), requestModel.getTemplateType());
            String middlesbbid = "";
            if (!ObjectUtils.isEmpty((Object)this.getPageCache().get(MIDDLESBBID))) {
                middlesbbid = this.getPageCache().get(MIDDLESBBID);
            }
            TcvvtMainPlugin.saveInitReport(requestModel.getOrgId(), requestModel.getSkssqq(), requestModel.getSkssqz(), requestModel.getTemplateType(), middlesbbid);
        } else {
            requestModel.setRefresh(Boolean.valueOf(false));
        }
        TreeUtils.putCache((IPageCache)childPageCache, (String)CACHE_DECLARE_REQUEST, (Object)requestModel);
        List pluginList = pluginProxy.getPlugIns();
        Object taxDeclarePlugin = null;
        for (IFormPlugin plugin : pluginList) {
            String name = plugin.getPluginName();
            if (!name.endsWith("TaxDeclarePlugin")) continue;
            taxDeclarePlugin = plugin;
            break;
        }
        if (taxDeclarePlugin != null) {
            Class<?> pluginClass = taxDeclarePlugin.getClass();
            try {
                String orgId;
                Method saveClick = pluginClass.getMethod("saveClick", IPageCache.class, DeclareRequestModel.class);
                DeclareRequestModel declareRequestModel = this.getDeclareRequestModel();
                String string = orgId = this.getModel().getValue(ORG_SEL) == null ? null : ((DynamicObject)this.getModel().getValue(ORG_SEL)).getString("id");
                if (MainReportUtil.isZeroDeclareOrg(orgId)) {
                    DeclareResponseModel declareResponseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)childPageCache, (String)CACHE_DECLARE_DATA, DeclareResponseModel.class);
                    declareResponseModel.getData().put("tcvat_nsrxx#1#zerodeclare", "1");
                    TreeUtils.putCache((IPageCache)childPageCache, (String)CACHE_DECLARE_DATA, (Object)declareResponseModel);
                }
                saveClick.invoke(taxDeclarePlugin, childPageCache, declareRequestModel);
                if (showSucc) {
                    this.getPageCache().put(ACTION_STATUS, OperationStatus.VIEW.name());
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TcvvtMainPlugin_18", (String)"taxc-tcvvt", (Object[])new Object[0]));
                    this.releaseMutexLock(EDIT_KEY, orgId, requestModel.getSkssqq(), requestModel.getSkssqz());
                }
            }
            catch (Exception e) {
                String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                logger.error("\u4fdd\u5b58\u6570\u636e\u51fa\u73b0\u5f02\u5e38:" + exceptionStackTraceMessage);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"TcvvtMainPlugin_19", (String)"taxc-tcvvt", (Object[])new Object[0]));
            }
        }
        this.getModel().setDataChanged(false);
    }

    private DeclareRequestModel getDeclareRequestModel() {
        DeclareRequestModel declareRequestModel = new DeclareRequestModel();
        String orgId = this.getModel().getValue(ORG_SEL) == null ? null : ((DynamicObject)this.getModel().getValue(ORG_SEL)).getString("id");
        Date startdate = (Date)this.getModel().getValue(START_DATE);
        Date enddate = (Date)this.getModel().getValue(END_DATE);
        String sksqq = DateUtils.format(startdate, "yyyy-MM-dd");
        String sksqz = DateUtils.format(enddate, "yyyy-MM-dd");
        DynamicObject declare = MainReportUtil.queryNsrxx(orgId, sksqq, sksqz);
        declareRequestModel.setId(declare != null ? Long.valueOf(declare.getLong("id")) : null);
        declareRequestModel.setTemplateId(declare != null ? Long.valueOf(Long.parseLong(declare.getString("templateid"))) : null);
        declareRequestModel.setOrgId(Long.valueOf(Long.parseLong(orgId)));
        DynamicObject template = MainReportUtil.getTemplateType(orgId, sksqq, sksqz);
        declareRequestModel.setTemplateId(Long.valueOf(template.getLong("id")));
        declareRequestModel.setTemplateType(template.getString("type.number"));
        declareRequestModel.setSkssqq(sksqq);
        declareRequestModel.setSkssqz(sksqz);
        declareRequestModel.getBusinessMap().put("needremark", "true");
        return declareRequestModel;
    }

    private void submit(boolean doOrCancel, String action, String orgId, String sksqq, String sksqz, String key) {
        DynamicObject declare = MainReportUtil.queryNsrxx(orgId, sksqq, sksqz);
        if (declare == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62a5\u8868\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u91cd\u7f6e,\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002", (String)"TcvvtMainPlugin_20", (String)"taxc-tcvvt", (Object[])new Object[0]));
            return;
        }
        if (this.checkLockedMutexLock(declare.getString("id"))) {
            return;
        }
        ArrayList<String> msgList = new ArrayList<String>();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"tcvat_nsrxx", (String)MetadataUtil.getAllFieldToQuery((String)"tcvat_nsrxx"), (QFilter[])new QFilter[]{new QFilter("id", "=", declare.get("id"))});
        DeclareCheckFacility.setErrorMsgListWhenNSRXXOpt(msgList, key, dynamicObject);
        if (msgList.size() > 0) {
            this.getView().showErrorNotification((String)msgList.get(0));
            return;
        }
        String sbbid = declare.getString("id");
        if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)sbbid)) {
            ArrayList<String> pklist = new ArrayList<String>();
            pklist.add(sbbid);
            if (doOrCancel) {
                boolean submit = DeclareUtils.submit((IFormView)this.getView(), pklist, (String)action, (String)"tcvat_nsrxx", (boolean)false);
                if (!submit) {
                    return;
                }
            } else {
                declare = BusinessDataServiceHelper.loadSingle((Object)sbbid, (String)"tcvat_nsrxx");
                declare.set("billstatus", (Object)"A");
                declare.set("modifier", (Object)RequestContext.get().getCurrUserId());
                declare.set("modifytime", (Object)new Date());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{declare});
            }
            this.showInnerTbPage((String)this.getModel().getValue(FOCUS_PAGE), orgId, null);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62a5\u8868\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u91cd\u7f6e,\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002", (String)"TcvvtMainPlugin_20", (String)"taxc-tcvvt", (Object[])new Object[0]));
        }
    }

    private void recalc() {
        NsrxxValidatorUtils.nsrxxReviewed((Long)this.getModel().getDataEntity().getLong("org.id"));
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(RECALC_KEY, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"TcvvtMainPlugin_21", (String)"taxc-tcvvt", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"TcvvtMainPlugin_22", (String)"taxc-tcvvt", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u7ee7\u7eed\u64cd\u4f5c\u5c06\u91cd\u65b0\u8ba1\u7b97\u5e76\u4fdd\u5b58\u62a5\u8868\u6570\u636e\uff0c\u786e\u5b9a\u8981\u91cd\u7f6e\u5417\uff1f", (String)"TcvvtMainPlugin_23", (String)"taxc-tcvvt", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    private void recalCallBack(MessageBoxClosedEvent e, String orgId, String startdate, String enddate) {
        if (e.getResult() == MessageBoxResult.Yes) {
            if (orgId == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"TcvvtMainPlugin_24", (String)"taxc-tcvvt", (Object[])new Object[0]));
                return;
            }
            DynamicObject nsrxx = MainReportUtil.queryNsrxx(orgId, startdate, enddate);
            if (nsrxx == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62a5\u8868\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u91cd\u7f6e,\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002", (String)"TcvvtMainPlugin_20", (String)"taxc-tcvvt", (Object[])new Object[0]));
                return;
            }
            String billStatus = nsrxx.getString("billstatus");
            if (!"A".equals(billStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u7f16\u8f91\u6682\u5b58\u72b6\u6001\u4e0b\u7684\u62a5\u8868\u6570\u636e\u3002", (String)"TcvvtMainPlugin_14", (String)"taxc-tcvvt", (Object[])new Object[0]));
                return;
            }
            ArrayList<DynamicObject> accountList = new ArrayList<DynamicObject>();
            boolean calDataResult = this.calData(orgId, startdate, enddate, accountList);
            if (calDataResult) {
                List<QFilter> qFilters = this.buildQFilters(orgId, startdate, enddate);
                DeclareRequestModel declareRequestModel = new DeclareRequestModel();
                declareRequestModel.setId(Long.valueOf(nsrxx.getLong("id")));
                declareRequestModel.setTemplateType(nsrxx.getString(TYPE));
                declareRequestModel.setTemplateId(Long.valueOf(Long.parseLong(nsrxx.getString("templateid"))));
                declareRequestModel.setOrgId(Long.valueOf(Long.parseLong(orgId)));
                declareRequestModel.setSkssqq(startdate);
                declareRequestModel.setSkssqz(enddate);
                DynamicObject template = MainReportUtil.getTemplateType(orgId, startdate, enddate);
                TcvvtDeclareServiceHelper.resetBySbbId(declareRequestModel);
                DeleteServiceHelper.delete((String)TCVVT_MESSAGE, (QFilter[])qFilters.toArray(new QFilter[0]));
                QFilter idFilter = new QFilter("id", "=", nsrxx.get("id"));
                DeleteServiceHelper.delete((String)"tcvat_nsrxx", (QFilter[])new QFilter[]{idFilter});
                TcvvtMainPlugin.deleteInitReport(Long.parseLong(orgId), startdate, enddate, nsrxx.getString(TYPE));
                this.getPageCache().put(ACTION_STATUS, OperationStatus.EDIT.name());
                String actionStatus = this.getPageCache().get(ACTION_STATUS);
                DeclareRequestModel requestModel = this.getDeclareRequestModel(orgId, actionStatus, nsrxx, startdate, enddate, template);
                String number = DeclareServiceHelper.generateSBBNo((String)"tcvvt_main_declare_list");
                requestModel.setBillNo(number);
                requestModel.setRefresh(Boolean.valueOf(true));
                HashMap<String, String> customCalMap = new HashMap<String, String>();
                accountList.forEach(m -> customCalMap.put(m.getString("formulakey"), m.getString("fetchamount")));
                if (FR0005.equals(template.getString(NUMBER))) {
                    QFilter filter1 = new QFilter("org.id", "=", (Object)Long.parseLong(orgId));
                    QFilter filter2 = new QFilter(TYPE, "=", (Object)"FR0002");
                    QFilter filter3 = new QFilter("templateid", "=", (Object)template.getString("id"));
                    QFilter startDateQ = new QFilter(SKSSQQ, "!=", (Object)DateUtils.stringToDate(startdate));
                    DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)"id, skssqq,skssqz,org.id", (QFilter[])new QFilter[]{filter1, filter2, filter3, startDateQ}, (String)"modifytime desc", (int)1);
                    if (EmptyCheckUtils.isNotEmpty(dynamicObjects)) {
                        customCalMap.put("kjzzsbbid", String.valueOf(dynamicObjects[0].getLong("id")));
                    }
                }
                QFilter taxTypeFilter = new QFilter("taxtype", "=", (Object)template.getString("type.number"));
                QFilter formulaname = new QFilter("formula", "like", (Object)"{P%");
                QFilter formulaTypeFilter = new QFilter("formulatype", "=", (Object)"1");
                DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bdtaxr_formula_edit", (String)"id,formulaname,formulakey", (QFilter[])new QFilter[]{taxTypeFilter, formulaname, formulaTypeFilter});
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    if (customCalMap.containsKey(dynamicObject.getString("formulakey"))) continue;
                    customCalMap.put(dynamicObject.getString("formulakey"), "0.00");
                }
                requestModel.setBusinessMap(customCalMap);
                requestModel.getBusinessMap().put("needremark", "true");
                String pageid = this.getPageCache().get("declarepageid");
                IFormView childView = this.getView().getView(pageid);
                IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
                DeclareResponseModel responseModel = TcvvtDeclareServiceHelper.queryData(requestModel);
                TreeUtils.putCache((IPageCache)childPageCache, (String)CACHE_UPDATA_CELLID_SAVE, (Object)responseModel.getData());
                TreeUtils.putCache((IPageCache)childPageCache, (String)CACHE_DECLARE_REQUEST, (Object)requestModel);
                TreeUtils.putCache((IPageCache)childPageCache, (String)CACHE_DECLARE_DATA, (Object)responseModel);
                FormulaServiceImpl formulaService = new FormulaServiceImpl();
                List checkFormulaList = formulaService.checkFormulasNew(requestModel, responseModel.getData(), responseModel.getParamMap(), null);
                childPageCache.put(CHECK_RESULT_LIST, SerializationUtils.toJsonString((Object)checkFormulaList));
                this.saveStepOne(orgId, startdate, enddate, template);
                this.getPageCache().put(ISINIT, "0");
                this.saveDeclare(false);
                this.getPageCache().put(ACTION_STATUS, OperationStatus.VIEW.name());
                this.showInnerTbPage("2", orgId, null);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u7f6e\u6210\u529f\u3002", (String)"TcvvtMainPlugin_25", (String)"taxc-tcvvt", (Object[])new Object[0]));
            } else {
                this.showInnerTbPage("1", orgId, null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u91cd\u7f6e\u5931\u8d25\uff0c\u8bf7\u5220\u9664\u5bf9\u5e94\u62a5\u8868\u540e\u518d\u64cd\u4f5c\u3002", (String)"TcvvtMainPlugin_26", (String)"taxc-tcvvt", (Object[])new Object[0]), Integer.valueOf(2000));
            }
        }
    }

    private void initData() {
        NsrxxValidatorUtils.nsrxxReviewed((Long)this.getModel().getDataEntity().getLong("org.id"));
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(INIT_KEY, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"TcvvtMainPlugin_21", (String)"taxc-tcvvt", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"TcvvtMainPlugin_22", (String)"taxc-tcvvt", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u64cd\u4f5c\u4f1a\u5c06\u7a0e\u5c40\u7aef\u9884\u586b\u6570\u636e\u8986\u76d6\u81f3\u5f53\u524d\u7f16\u5236\u7684\u7533\u62a5\u8868\uff0c\u8bf7\u786e\u8ba4\u5f53\u524d\u62a5\u8868\u7ef4\u62a4\u7684\u6570\u636e\u5df2\u4fdd\u5b58\uff0c\u786e\u5b9a\u7ee7\u7eed\u6267\u884c\u521d\u59cb\u5316\uff1f", (String)"TcvvtMainPlugin_27", (String)"taxc-tcvvt", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    private void initData(MessageBoxClosedEvent e, String orgId, String skssqq, String skssqz, String reportType) {
        if (e.getResult() == MessageBoxResult.Yes) {
            ArrayList<DynamicObject> accountList;
            boolean calDataResult;
            QFilter templateTypeFiiter;
            QFilter skssqzFiiter;
            QFilter skssqqFilter;
            String templateType;
            String billStatus;
            if (orgId == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"TcvvtMainPlugin_24", (String)"taxc-tcvvt", (Object[])new Object[0]));
                return;
            }
            DynamicObject nsrxx = MainReportUtil.queryNsrxx(orgId, skssqq, skssqz);
            if (!ObjectUtils.isEmpty((Object)nsrxx) && !"A".equals(billStatus = nsrxx.getString("billstatus"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u7f16\u8f91\u6682\u5b58\u72b6\u6001\u4e0b\u7684\u62a5\u8868\u6570\u636e\u3002", (String)"TcvvtMainPlugin_14", (String)"taxc-tcvvt", (Object[])new Object[0]));
                return;
            }
            DynamicObject template = MainReportUtil.getTemplateType(orgId, skssqq, skssqz);
            String string = templateType = ObjectUtils.isEmpty((Object)template) ? null : template.getString("type.number");
            if (!INITREPORTTYPELIST.contains(templateType)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u521d\u59cb\u5316\u64cd\u4f5c\u5bf9\u5e94\u6570\u636e\uff0c\u8bf7\u5728\u7a0e\u4f01\u76f4\u8fde\u7ef4\u62a4\u3002", (String)"TcvvtMainPlugin_28", (String)"taxc-tcvvt", (Object[])new Object[0]));
                return;
            }
            QFilter orgFilter = new QFilter(ORG_SEL, "=", (Object)Long.parseLong(orgId));
            QFilter[] qFilters = new QFilter[]{orgFilter, skssqqFilter = new QFilter(SKSSQQ, "=", (Object)DateUtils.stringToDate(skssqq)), skssqzFiiter = new QFilter(SKSSQZ, "=", (Object)DateUtils.stringToDate(skssqz)), templateTypeFiiter = new QFilter(TYPE, "=", (Object)templateType)};
            DynamicObject sbb = QueryServiceHelper.queryOne((String)"bdtaxr_taxbureau_sbb", (String)"id,declaredata_tag,type,declaredatatype", (QFilter[])qFilters);
            if (ObjectUtils.isEmpty((Object)sbb)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u521d\u59cb\u5316\u64cd\u4f5c\u5bf9\u5e94\u6570\u636e\uff0c\u8bf7\u5728\u7a0e\u4f01\u76f4\u8fde\u7ef4\u62a4\u3002", (String)"TcvvtMainPlugin_28", (String)"taxc-tcvvt", (Object[])new Object[0]));
                return;
            }
            String data = sbb.getString("declaredata_tag");
            String middleSbbid = "";
            if (!ObjectUtils.isEmpty((Object)template) && !ObjectUtils.isEmpty((Object)template.getString(NUMBER))) {
                String templateNum = template.getString(NUMBER);
                middleSbbid = TcvvtInitReportDataBusinessImpl.saveTcvvtFinanceBureauData(Long.parseLong(orgId), skssqq, skssqz, templateNum, data);
            }
            if (calDataResult = this.calData(orgId, skssqq, skssqz, accountList = new ArrayList<DynamicObject>())) {
                String billno;
                this.getPageCache().put(ACTION_STATUS, OperationStatus.EDIT.name());
                String actionStatus = this.getPageCache().get(ACTION_STATUS);
                DeclareRequestModel requestModel = this.getDeclareRequestModel(orgId, actionStatus, nsrxx, skssqq, skssqz, template);
                String number = "";
                number = !ObjectUtils.isEmpty((Object)nsrxx) ? (!(billno = nsrxx.getString("billno")).startsWith("FIN") ? DeclareServiceHelper.generateSBBNo((String)"tcvvt_main_declare_list") : billno) : DeclareServiceHelper.generateSBBNo((String)"tcvvt_main_declare_list");
                requestModel.setBillNo(number);
                requestModel.setRefresh(Boolean.valueOf(true));
                HashMap<String, String> customCalMap = new HashMap<String, String>();
                accountList.forEach(m -> customCalMap.put(m.getString("formulakey"), m.getString("fetchamount")));
                customCalMap.put(ISINIT, "1");
                if (!ObjectUtils.isEmpty((Object)middleSbbid)) {
                    customCalMap.put(MIDDLESBBID, middleSbbid);
                }
                if (!ObjectUtils.isEmpty((Object)nsrxx)) {
                    customCalMap.put(CURRENTSBBID, String.valueOf(nsrxx.getLong("id")));
                }
                if ("0".equalsIgnoreCase(sbb.getString("declaredatatype"))) {
                    this.getPageCache().put(ISINIT, "1");
                    this.getPageCache().put(MIDDLESBBID, middleSbbid);
                    this.getPageCache().put("needRuleFeatch", "1");
                }
                requestModel.setBusinessMap(customCalMap);
                requestModel.getBusinessMap().put("needremark", "true");
                DeclareResponseModel responseModel = TcvvtDeclareServiceHelper.queryData(requestModel);
                customCalMap.put(CACHE_DECLARE_DATA, SerializationUtils.toJsonString((Object)responseModel));
                this.showInnerTbPage("2", orgId, customCalMap);
            }
        }
    }

    private void fowardStepCallBack(MessageBoxClosedEvent e, String orgId, Long taxauthority, String sksqq, String sksqz, String reportType) {
        if (e.getResult() == MessageBoxResult.Yes) {
            boolean checkResult = this.checkBeforeOpt(orgId, taxauthority, reportType, sksqq, sksqz, true, true);
            if (checkResult) {
                this.saveStepOne(orgId, sksqq, sksqz, MainReportUtil.getTemplateType(orgId, sksqq, sksqz));
                this.saveDeclare(true);
                this.showInnerTbPage("1", orgId, null);
            }
        } else {
            this.showInnerTbPage("1", orgId, null);
        }
    }

    private void reduceCallBack(MessageBoxClosedEvent e, String orgId, String sksqq, String sksqz) {
        String scene;
        if (e.getResult() == MessageBoxResult.Yes) {
            this.saveStepOne(orgId, sksqq, sksqz, MainReportUtil.getTemplateType(orgId, sksqq, sksqz));
            this.saveDeclare(true);
            this.getPageCache().put(ACTION_STATUS, OperationStatus.EDIT.name());
        }
        if ((scene = this.getPageCache().get(SHOW_CONFIRM_SCENE)) == null) {
            scene = "";
        }
        switch (scene) {
            case "save": {
                this.getPageCache().put(ACTION_STATUS, OperationStatus.EDIT.name());
                this.showInnerTbPage("2", orgId, null);
                break;
            }
            case "cancel_edit": {
                this.getPageCache().put(ACTION_STATUS, OperationStatus.VIEW.name());
                this.showInnerTbPage("2", orgId, null);
                break;
            }
            case "close": {
                this.getView().close();
                break;
            }
            case "forward": {
                this.showInnerTbPage("1", orgId, null);
                break;
            }
        }
        this.getPageCache().remove(SHOW_CONFIRM_SCENE);
    }

    private void closePageCallBack(MessageBoxResult messageBoxResult, String orgId, Long taxauthority, String sksqq, String sksqz) {
        this.getPageCache().put("hasShowCloseModal", "Y");
        if (messageBoxResult.equals((Object)MessageBoxResult.Yes)) {
            boolean checkResult;
            String value = (String)this.getModel().getValue(FOCUS_PAGE);
            if ("2".equals(value) && (checkResult = this.checkBeforeOpt(orgId, taxauthority, (String)this.getModel().getValue(REPORTTYPE), sksqq, sksqz, true, true))) {
                this.saveStepOne(orgId, sksqq, sksqz, MainReportUtil.getTemplateType(orgId, sksqq, sksqz));
                this.saveDeclare(true);
                this.getView().close();
            }
        } else {
            this.getView().close();
        }
    }

    private void cancelEditCallBack(MessageBoxResult result, String orgId, Long taxauthority, String sksqq, String sksqz, String reportType) {
        String focusPage = (String)this.getModel().getValue(FOCUS_PAGE);
        if ("1".equals(focusPage)) {
            return;
        }
        if (result.equals((Object)MessageBoxResult.Yes)) {
            boolean checkResult = this.checkBeforeOpt(orgId, taxauthority, reportType, sksqq, sksqz, true, true);
            if (checkResult) {
                this.saveStepOne(orgId, sksqq, sksqz, MainReportUtil.getTemplateType(orgId, sksqq, sksqz));
                this.saveDeclare(true);
                this.getPageCache().put(ACTION_STATUS, OperationStatus.VIEW.name());
                this.showInnerTbPage(focusPage, orgId, null);
            }
        } else {
            boolean hasNsrxxInfo;
            this.getPageCache().remove("updateCellMap");
            boolean bl = hasNsrxxInfo = MainReportUtil.queryNsrxx(orgId, sksqq, sksqz) != null;
            if (!hasNsrxxInfo) {
                this.getPageCache().put("hasShowCloseModal", "Y");
                this.getView().close();
            } else {
                this.setSelectIds(orgId, sksqq, sksqz);
                this.getPageCache().put(ACTION_STATUS, OperationStatus.VIEW.name());
                this.showInnerTbPage(focusPage, orgId, null);
            }
        }
        this.releaseMutexLock(EDIT_KEY, orgId, sksqq, sksqz);
    }

    public void releaseMutexLock(String operateKey, String orgId, String sksqq, String sksqz) {
        DynamicObject declare = MainReportUtil.queryNsrxx(orgId, sksqq, sksqz);
        if (ObjectUtils.isNotEmpty((Object)declare)) {
            MutexServiceImpl.releaseMutexLock((String)declare.getString("id"), (String)operateKey, (Long)RequestContext.get().getCurrUserId());
        }
    }

    public boolean checkLockedMutexLock(String sbbid) {
        DynamicObject dynamicObject = MutexServiceImpl.getMutexData((QFilter)new QFilter("objectid", "=", (Object)sbbid));
        if (dynamicObject != null) {
            String user = dynamicObject.getString("user.name");
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"TcvvtMainPlugin_30", (String)"taxc-tcvvt", (Object[])new Object[0]), user));
            return true;
        }
        return false;
    }

    public void pageRelease(EventObject e) {
        String sbbid = this.getPageCache().get("sbbid");
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)sbbid)) {
            MutexServiceImpl.releaseMutexLock((String)sbbid, (String)EDIT_KEY, (Long)RequestContext.get().getCurrUserId());
        }
    }

    private List<QFilter> buildQFilters(String orgId, String sksqq, String sksqz) {
        List<QFilter> qFilters = this.getStatusService().buildQFilters(orgId, sksqq, sksqz);
        DynamicObject template = TcvvtTemplateUtils.getTemplateType(orgId, DateUtils.stringToDate(sksqq), DateUtils.stringToDate(sksqz));
        QFilter nsrtypeQ = new QFilter(TYPE, "=", ObjectUtils.isNotEmpty((Object)template) ? template.getString("type.number") : null);
        QFilter templateidQ = new QFilter("templateid", "=", ObjectUtils.isNotEmpty((Object)template) ? template.getString("id") : null);
        qFilters.add(nsrtypeQ);
        qFilters.add(templateidQ);
        return qFilters;
    }

    private void zeroDeclareCheckAndTipNotification(String orgId, String startdate, String enddate) {
        boolean zeroDeclareOrg;
        DynamicObject declare = MainReportUtil.queryNsrxx(orgId, startdate, enddate);
        String declarestatus = "";
        if (declare != null) {
            declarestatus = declare.getString("declarestatus");
        }
        if ((zeroDeclareOrg = MainReportUtil.isZeroDeclareOrg(orgId)) && !declarestatus.equalsIgnoreCase("declared")) {
            DynamicObject name = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bastax_taxorg");
            String orgName = name.getString("org.name");
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u7533\u62a5\u8868\u91d1\u989d\u9ed8\u8ba4\u4e3a0\u3002", (String)"TcvvtMainPlugin_29", (String)"taxc-tcvvt", (Object[])new Object[0]), orgName), Integer.valueOf(6000));
        }
    }

    private void cacheTcvvtMessage(String orgId, String sksqq, String sksqz) {
        QFilter templateidQ;
        DynamicObject template;
        QFilter nsrtypeQ;
        QFilter endFilter;
        QFilter startFilter;
        Date start = DateUtils.stringToDate(sksqq, "yyyy-MM-dd");
        Date end = DateUtils.stringToDate(sksqz, "yyyy-MM-dd");
        QFilter orgQ = new QFilter(ORGID_KEY, "=", (Object)Long.parseLong(orgId));
        DynamicObject tcvvtMessage = QueryServiceHelper.queryOne((String)TCVVT_MESSAGE, (String)"accountingstandards,newrule,registeraddress", (QFilter[])new QFilter[]{orgQ, startFilter = new QFilter(START_DATE, "=", (Object)start), endFilter = new QFilter(END_DATE, "=", (Object)end), nsrtypeQ = new QFilter(TYPE, "=", ObjectUtils.isNotEmpty((Object)(template = TcvvtTemplateUtils.getTemplateType(orgId, DateUtils.stringToDate(sksqq), DateUtils.stringToDate(sksqz)))) ? template.getString("type.number") : null), templateidQ = new QFilter("templateid", "=", ObjectUtils.isNotEmpty((Object)template) ? template.getString("id") : null)});
        if (null != tcvvtMessage) {
            this.getPageCache().put("cache_accountingstandards", tcvvtMessage.getString("accountingstandards"));
            this.getPageCache().put("cache_newrule", tcvvtMessage.getString("newrule"));
            this.getPageCache().put("cache_registeraddress", tcvvtMessage.getString("registeraddress"));
        } else {
            QFilter orgFilter = new QFilter(ORGID_KEY, "=", (Object)Long.parseLong(orgId));
            DynamicObject dTctb = QueryServiceHelper.queryOne((String)TCTB_TAX_MAIN, (String)"accountingstandards,newrule,registeraddress", (QFilter[])new QFilter[]{orgFilter});
            if (dTctb != null) {
                this.getPageCache().put("cache_accountingstandards", dTctb.getString("accountingstandards"));
                this.getPageCache().put("cache_newrule", dTctb.getString("newrule"));
                this.getPageCache().put("cache_registeraddress", dTctb.getString("registeraddress"));
            }
        }
    }

    private static void saveInitReport(Long org, String skssqq, String skssqz, String templatetype, String sbbid) {
        DynamicObject initReport = BusinessDataServiceHelper.newDynamicObject((String)TCVVT_FINANCE_INIT_RECORD);
        initReport.set(SKSSQQ, (Object)DateUtils.stringToDate(skssqq));
        initReport.set(SKSSQZ, (Object)DateUtils.stringToDate(skssqz));
        initReport.set(TYPE, (Object)templatetype);
        initReport.set(ORG_SEL, (Object)org);
        if (!ObjectUtils.isEmpty((Object)sbbid)) {
            initReport.set("sbbid", (Object)sbbid);
        }
        initReport.set("isinit", (Object)"1");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{initReport});
    }

    private static void deleteInitReport(Long org, String skssqq, String skssqz, String templatetype) {
        QFilter orgF = new QFilter(ORG_SEL, "=", (Object)org);
        QFilter ssqqF = new QFilter(SKSSQQ, "=", (Object)DateUtils.stringToDate(skssqq));
        QFilter ssqzF = new QFilter(SKSSQZ, "=", (Object)DateUtils.stringToDate(skssqz));
        QFilter typeF = new QFilter(TYPE, "=", (Object)templatetype);
        DeleteServiceHelper.delete((String)TCVVT_FINANCE_INIT_RECORD, (QFilter[])new QFilter[]{orgF, ssqqF, ssqzF, typeF});
    }

    private boolean setReportTypeBy(Date skssqq, Date skssqz) {
        boolean flag = false;
        String reporttype = "";
        if (DateUtils.validDateRange("month", skssqq, skssqz)) {
            reporttype = "aysb";
        }
        if (DateUtils.validDateRange("season", skssqq, skssqz)) {
            reporttype = "ajsb";
        }
        if (DateUtils.validDateRange("year", skssqq, skssqz)) {
            reporttype = "ansb";
        }
        if (!ObjectUtils.isEmpty((Object)reporttype)) {
            this.getModel().setValue(REPORTTYPE, (Object)reporttype);
            this.getPageCache().put("reporttypeChanged", "false");
            flag = true;
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b8c\u6574\u7684\u6708\u5ea6\u3001\u5b63\u5ea6\u6216\u5e74\u5ea6\u7a0e\u671f\u3002", (String)"TcvvtMainPlugin_31", (String)"taxc-tcvvt", (Object[])new Object[0]));
        }
        return flag;
    }

    private String getBillno(Date skssqz, String org) {
        String entry = "tcvvt_main_declare_list";
        DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)entry);
        dyo.set(SKSSQZ, (Object)skssqz);
        return CodeRuleServiceHelper.getNumber((String)entry, (DynamicObject)dyo, (String)org);
    }
}

