/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.facility;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.NsrxxValidatorUtils;
import kd.taxc.tcvvt.business.taxorg.TcvvtTaxOrgCommonBusiness;
import kd.taxc.tcvvt.common.constant.TemplateTypeConstant;
import kd.taxc.tcvvt.common.util.DateUtils;
import kd.taxc.tcvvt.common.util.MainReportUtil;
import kd.taxc.tcvvt.common.util.PermissionUtils;
import kd.taxc.tcvvt.common.util.StringUtil;
import kd.taxc.tcvvt.common.util.TcvvtTemplateUtils;
import kd.taxc.tcvvt.common.util.table.YbnsrService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class DeclareCheckFacility {
    private static final String[] TAX_LIMITS = new String[]{"month", "season", "year"};
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    public static final String SUBMIT = "submit";
    public static final String UNSUBMIT = "unsubmit";
    public static final String AUDIT = "audit";
    public static final String UNAUDIT = "unaudit";
    public static final String APPLY = "apply";
    public static final String CANCELAPPLY = "cancelapply";
    private static final String BILLSTATUS = "billstatus";
    private static final String DECLARESTATUS = "declarestatus";
    private static final String ORG = "org";
    private static final String TYPE = "type";
    private static final String DECLARETYPE = "declaretype";
    private static final String CANCEL_SUBMIT = "cancel_submit";
    private static Map<String, String> NSR_TYPE_MAP = TemplateTypeConstant.getMap();
    private static Map<String, String> canNotUnAuditOrApplyMap = new HashMap<String, String>();

    public static void setErrorMsgListWhenNSRXXOpt(List<String> msgList, String operationKey, DynamicObject dynamicObject) {
        String billStatus = dynamicObject.getString(BILLSTATUS);
        String declareStatus = dynamicObject.getString(DECLARESTATUS);
        String errorMsg = null;
        String orgName = dynamicObject.getDynamicObject(ORG).getString("name");
        String startDate = DateUtils.format(dynamicObject.getDate(SKSSQQ), new DateUtils().yyyymmddChinese());
        String endDate = DateUtils.format(dynamicObject.getDate(SKSSQZ), new DateUtils().yyyymmddChinese());
        String declareType = dynamicObject.getString(DECLARETYPE);
        String declareTypeStr = NSR_TYPE_MAP.get(dynamicObject.getString(TYPE));
        if (SUBMIT.equals(operationKey)) {
            if ("C".equals(billStatus)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5ba1\u6838\uff0c\u8bf7\u5148\u53d6\u6d88\u5ba1\u6838\uff1a%1$s %2$s %3$s\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"DeclareCheckFacility_4", (String)"taxc-tcvvt", (Object[])new Object[0]), orgName, declareTypeStr, startDate + "-" + endDate);
            } else if ("B".equals(billStatus)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u63d0\u4ea4\uff0c\u65e0\u9700\u91cd\u590d\u63d0\u4ea4\uff1a%1$s %2$s %3$s\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"DeclareCheckFacility_5", (String)"taxc-tcvvt", (Object[])new Object[0]), orgName, declareTypeStr, startDate + "-" + endDate);
            }
        } else if (CANCEL_SUBMIT.equals(operationKey)) {
            if (!"B".equals(billStatus)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u672a\u63d0\u4ea4\uff0c\u65e0\u6cd5\u64a4\u9500\u63d0\u4ea4\uff1a%1$s %2$s %3$s\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"DeclareCheckFacility_6", (String)"taxc-tcvvt", (Object[])new Object[0]), orgName, declareTypeStr, startDate + "-" + endDate);
            }
        } else if (AUDIT.equals(operationKey)) {
            if ("C".equals(billStatus)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5ba1\u6838\uff0c\u65e0\u9700\u91cd\u590d\u5ba1\u6838\uff1a%1$s %2$s %3$s\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"DeclareCheckFacility_7", (String)"taxc-tcvvt", (Object[])new Object[0]), orgName, declareTypeStr, startDate + "-" + endDate);
            }
        } else if (UNAUDIT.equals(operationKey)) {
            if (!"C".equals(billStatus)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u4ec5\u5df2\u5ba1\u6838\u6570\u636e\u53ef\u53cd\u5ba1\u6838\uff1a%1$s %2$s %3$s\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"DeclareCheckFacility_8", (String)"taxc-tcvvt", (Object[])new Object[0]), orgName, declareTypeStr, startDate + "-" + endDate);
            } else if (canNotUnAuditOrApplyMap.containsKey(declareStatus)) {
                String declareStatusChiStr = canNotUnAuditOrApplyMap.get(declareStatus);
                errorMsg = String.format(ResManager.loadKDString((String)"%1$s %2$s\u5c5e\u671f\u62a5\u8868 \u201c%3$s\u201d\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"DeclareCheckFacility_9", (String)"taxc-tcvvt", (Object[])new Object[0]), orgName, startDate + "-" + endDate, declareStatusChiStr);
            }
        } else if (APPLY.equals(operationKey)) {
            if (!"C".equals(billStatus)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u6570\u636e\u624d\u80fd\u786e\u8ba4\u7533\u62a5\uff1a%1$s %2$s %3$s\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"DeclareCheckFacility_10", (String)"taxc-tcvvt", (Object[])new Object[0]), orgName, declareTypeStr, startDate + "-" + endDate);
            } else if (canNotUnAuditOrApplyMap.containsKey(declareStatus)) {
                String declareStatusChiStr = canNotUnAuditOrApplyMap.get(declareStatus);
                errorMsg = String.format(ResManager.loadKDString((String)"%1$s %2$s\u5c5e\u671f\u62a5\u8868 \u201c%3$s\u201d\uff0c\u4e0d\u80fd\u786e\u8ba4\u7533\u62a5\u3002", (String)"DeclareCheckFacility_11", (String)"taxc-tcvvt", (Object[])new Object[0]), orgName, startDate + "-" + endDate, declareStatusChiStr);
            }
        } else if (CANCELAPPLY.equals(operationKey)) {
            if (!"declared".equals(declareStatus)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u6210\u529f\u7684\u6570\u636e\u53ef\u53d6\u6d88\u7533\u62a5\uff1a %1$s %2$s %3$s\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"DeclareCheckFacility_12", (String)"taxc-tcvvt", (Object[])new Object[0]), orgName, declareTypeStr, startDate + "-" + endDate);
            } else if (!"0".equals(declareType)) {
                msgList.add(String.format(ResManager.loadKDString((String)"\u7533\u62a5\u65b9\u5f0f\u4e3a\u624b\u5de5\u7533\u62a5\u624d\u80fd\u53d6\u6d88\u7533\u62a5\uff1a %1$s %2$s %3$s\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"DeclareCheckFacility_13", (String)"taxc-tcvvt", (Object[])new Object[0]), orgName, declareTypeStr, startDate + "-" + endDate));
            }
        }
        if (StringUtils.isNotEmpty(errorMsg)) {
            msgList.add(errorMsg);
        }
    }

    public static void updateData(List<DynamicObject> updateList, String operationKey) {
        if (CollectionUtils.isEmpty(updateList)) {
            return;
        }
        for (DynamicObject obj : updateList) {
            if (AUDIT.equalsIgnoreCase(operationKey)) {
                obj.set(BILLSTATUS, (Object)"C");
                obj.set("auditdate", (Object)new Date());
                obj.set("auditor", (Object)RequestContext.get().getCurrUserId());
            }
            if (SUBMIT.equals(operationKey)) {
                obj.set(BILLSTATUS, (Object)"B");
            }
            if (UNSUBMIT.equals(operationKey)) {
                obj.set(BILLSTATUS, (Object)"A");
            }
            if (UNAUDIT.equals(operationKey)) {
                obj.set(BILLSTATUS, (Object)"A");
                obj.set("auditdate", null);
                obj.set("auditor", null);
            }
            if (APPLY.equals(operationKey)) {
                obj.set(DECLARESTATUS, (Object)"declared");
                obj.set(DECLARETYPE, (Object)"0");
                obj.set("sbrq", (Object)new Date());
                obj.set("declarer", (Object)RequestContext.get().getCurrUserId());
            }
            if (CANCELAPPLY.equals(operationKey)) {
                obj.set(DECLARESTATUS, (Object)"editing");
                obj.set("paystatus", null);
                obj.set(DECLARETYPE, null);
                obj.set("paytype", null);
                obj.set("sbrq", null);
                obj.set("paydate", null);
                obj.set("payer", null);
                obj.set("declarer", null);
            }
            obj.set("modifier", (Object)RequestContext.get().getCurrUserId());
            obj.set("modifytime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
    }

    public static void checkOrgAndDate(DynamicObject template, String orgId, Long taxauthority, String reporttype, Date startDate, Date endDate, IFormView view) throws KDBizException {
        String enddateStr;
        String startdateStr;
        DynamicObjectCollection collection;
        if (StringUtil.isEmpty((CharSequence)orgId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"DeclareCheckFacility_14", (String)"taxc-tcvvt", (Object[])new Object[0]));
        }
        if (startDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u5c5e\u671f\u8d77\u4e0d\u5b58\u5728\u3002", (String)"DeclareCheckFacility_15", (String)"taxc-tcvvt", (Object[])new Object[0]));
        }
        if (endDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u5c5e\u671f\u6b62\u4e0d\u5b58\u5728\u3002", (String)"DeclareCheckFacility_16", (String)"taxc-tcvvt", (Object[])new Object[0]));
        }
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(view);
        List hasPermOrgs = hasPermOrgResult.getHasPermOrgs();
        if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgs.contains(Long.parseLong(orgId))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7528\u6237\u6388\u6743\u3002", (String)"DeclareCheckFacility_17", (String)"taxc-tcvvt", (Object[])new Object[0]), orgId));
        }
        if (!DeclareCheckFacility.checkIsTaxpayer(orgId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u975e\u53ef\u7528\u7eb3\u7a0e\u4e3b\u4f53\uff0c\u8bf7\u68c0\u67e5\u7eb3\u7a0e\u4eba\u4fe1\u606f\u7684\u6b63\u786e\u6027\u3002", (String)"DeclareCheckFacility_18", (String)"taxc-tcvvt", (Object[])new Object[0]));
        }
        NsrxxValidatorUtils.nsrxxReviewed((Long)Long.parseLong(orgId));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)Long.parseLong(orgId));
        DynamicObject dTctb = QueryServiceHelper.queryOne((String)"tctb_tax_main", (String)"accountingstandards,newrule,registertime", (QFilter[])new QFilter[]{orgFilter});
        if (dTctb != null) {
            String newrule = dTctb.getString("newrule");
            long accountingstandards = dTctb.getLong("accountingstandards");
            if (accountingstandards == 1072508277482326016L && (StringUtil.isEmpty((CharSequence)newrule) || "empty".equalsIgnoreCase(newrule))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u57fa\u7840\u8bbe\u7f6e-\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406-\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u9009\u62e9\u7ef4\u62a4\u201c\u6267\u884c\u65b0\u51c6\u5219\u201d\u7684\u76f8\u5173\u4fe1\u606f\uff0c\u518d\u8fdb\u884c\u586b\u62a5\u3002", (String)"DeclareCheckFacility_19", (String)"taxc-tcvvt", (Object[])new Object[0]));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8bbe\u7f6e\u8fdb\u884c\u914d\u7f6e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DeclareCheckFacility_20", (String)"taxc-tcvvt", (Object[])new Object[0]));
        }
        DeclareCheckFacility.isCHNTaxationsys(Long.parseLong(orgId));
        boolean isOpenTaxMainFinancial = MainReportUtil.isOpenTaxMainFinancial(orgId);
        if (!isOpenTaxMainFinancial) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u8d22\u52a1\u62a5\u8868\u62a5\u9001\u672a\u542f\u7528\uff0c\u8bf7\u5230\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u7ef4\u62a4\u3002", (String)"DeclareCheckFacility_21", (String)"taxc-tcvvt", (Object[])new Object[0]));
        }
        MainReportUtil.allRequiredFieldValidator(orgId);
        if (Objects.isNull(template) && null == (template = DeclareCheckFacility.getTemplateType(orgId, startDate, endDate)) && (collection = YbnsrService.queryYbnsr(orgId, TcvvtTemplateUtils.TEMPALTE_TYPE, startdateStr = DateUtils.format(startDate, "yyyy-MM-dd"), enddateStr = DateUtils.format(endDate, "yyyy-MM-dd"), Collections.emptyMap())).size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6240\u5c5e\u7a0e\u671f\u7533\u62a5\u8868\u5b58\u5728\u591a\u4efd\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DeclareCheckFacility_22", (String)"taxc-tcvvt", (Object[])new Object[0]));
        }
        if (Objects.isNull(template)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u5c5e\u7a0e\u671f\u7533\u62a5\u8868\u6a21\u677f\u5c1a\u672a\u7ef4\u62a4\u6216\u8be5\u51c6\u5219\u9002\u7528\u7684\u8d22\u52a1\u62a5\u8868\u529f\u80fd\u5c1a\u672a\u4e0a\u7ebf\uff0c\u656c\u8bf7\u671f\u5f85\u3002", (String)"DeclareCheckFacility_23", (String)"taxc-tcvvt", (Object[])new Object[0]));
        }
        if (startDate.compareTo(endDate) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u586b\u5199\u9519\u8bef\u3002", (String)"DeclareCheckFacility_24", (String)"taxc-tcvvt", (Object[])new Object[0]));
        }
        Date now = new Date();
        if (now.compareTo(startDate) <= 0 || now.compareTo(endDate) < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u5fc5\u987b\u2264\u5f53\u524d\u65f6\u95f4\u3002", (String)"DeclareCheckFacility_25", (String)"taxc-tcvvt", (Object[])new Object[0]));
        }
        Date tempStartDate = template.getDate("startdate");
        Date tempEndDate = template.getDate("enddate");
        if (tempStartDate.compareTo(endDate) > 0 || tempEndDate != null && tempEndDate.compareTo(startDate) < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u4e0d\u5728\u6a21\u677f\u6709\u6548\u671f\u8303\u56f4\u5185\u3002", (String)"DeclareCheckFacility_26", (String)"taxc-tcvvt", (Object[])new Object[0]));
        }
        Date fregistertime = dTctb.getDate("registertime");
        if (fregistertime != null && fregistertime.after(endDate)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u5e94\u2265\u4f01\u4e1a\u767b\u8bb0\u65f6\u95f4\u3002", (String)"DeclareCheckFacility_27", (String)"taxc-tcvvt", (Object[])new Object[0]));
        }
        if (reporttype == null) {
            reporttype = DeclareCheckFacility.getReportType(startDate, endDate);
        }
        if (reporttype == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u9700\u4e3a\u6708\u5ea6\u3001\u5b63\u5ea6\u6216\u5e74\u5ea6\u671f\u95f4\uff0c\u8bf7\u68c0\u67e5\u6240\u5c5e\u65f6\u671f\u7684\u6b63\u786e\u6027\u3002", (String)"DeclareCheckFacility_28", (String)"taxc-tcvvt", (Object[])new Object[0]));
        }
        QFilter orgIdFilter = new QFilter(ORG, "=", (Object)Long.parseLong(orgId));
        boolean exists = false;
        QFilter typeFilter = new QFilter(TYPE, "in", (Object)Lists.newArrayList((Object[])new String[]{"FR0001", "FR0002", "FR0003", "FR0004", "FR0011"}));
        if ("aysb".equalsIgnoreCase(reporttype)) {
            QFilter taxLimitFilter = new QFilter("taxlimit", "=", (Object)"season");
            QFilter skssqqzFilter = new QFilter(SKSSQQ, "<=", (Object)startDate).and(new QFilter(SKSSQZ, ">=", (Object)startDate));
            exists = QueryServiceHelper.exists((String)"tcvat_nsrxx", (QFilter[])new QFilter[]{orgIdFilter, typeFilter, taxLimitFilter, skssqqzFilter});
        } else if ("ajsb".equalsIgnoreCase(reporttype)) {
            QFilter taxLimitFilter = new QFilter("taxlimit", "=", (Object)"month");
            QFilter skssqqzFilter = new QFilter(SKSSQQ, ">=", (Object)startDate).and(new QFilter(SKSSQZ, "<=", (Object)endDate));
            exists = QueryServiceHelper.exists((String)"tcvat_nsrxx", (QFilter[])new QFilter[]{orgIdFilter, typeFilter, taxLimitFilter, skssqqzFilter});
        }
        if (exists) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6309\u6708\u6216\u5b63\u7533\u62a5\u65f6\uff0c\u6240\u5c5e\u7a0e\u671f\u4e0d\u80fd\u5b58\u5728\u4ea4\u96c6\uff0c\u8bf7\u4fee\u6539\u3002", (String)"DeclareCheckFacility_29", (String)"taxc-tcvvt", (Object[])new Object[0]));
        }
        if ("ansb".equalsIgnoreCase(reporttype) && "FR0003".equalsIgnoreCase(template.getString("type.number"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5c0f\u4f01\u4e1a\u4f1a\u8ba1\u5236\u5ea6\u6309\u5e74\u7533\u62a5\u65b9\u5f0f\u3002", (String)"DeclareCheckFacility_30", (String)"taxc-tcvvt", (Object[])new Object[0]));
        }
    }

    private static boolean checkIsTaxpayer(String orgId) {
        return TcvvtTaxOrgCommonBusiness.isTaxcOrgExistByOrgIdAndIsTaxpayer(Long.parseLong(orgId));
    }

    private static boolean checkIsAudit(String orgId) {
        return (Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)Long.parseLong(orgId)).getData();
    }

    private static String getReportType(Date startDate, Date endDate) {
        int dayDiff = DateUtils.getDayDiff(startDate, endDate);
        if (dayDiff > 366) {
            return null;
        }
        for (String taxLimit : TAX_LIMITS) {
            if (!DateUtils.validDateRange(taxLimit, startDate, endDate)) continue;
            return DeclareCheckFacility.getReportType(taxLimit);
        }
        return null;
    }

    public static String getReportType(String taxLimit) {
        if ("season".equals(taxLimit)) {
            return "ajsb";
        }
        if ("year".equals(taxLimit)) {
            return "ansb";
        }
        if ("month".equals(taxLimit)) {
            return "aysb";
        }
        return null;
    }

    private static String showDateErrorMsg(String reporttype) {
        String errorMsg = null;
        String taxLimit = DeclareCheckFacility.getTaxLimits(reporttype);
        if ("season".equals(taxLimit)) {
            errorMsg = ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u9700\u4e3a\u6574\u5b63\u5ea6\u3002", (String)"DeclareCheckFacility_31", (String)"taxc-tcvvt", (Object[])new Object[0]);
        } else if ("month".equals(taxLimit)) {
            errorMsg = ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u9700\u4e3a\u6574\u6708\u3002", (String)"DeclareCheckFacility_32", (String)"taxc-tcvvt", (Object[])new Object[0]);
        } else if ("year".equals(taxLimit)) {
            errorMsg = ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u9700\u4e3a\u6574\u5e74\u3002", (String)"DeclareCheckFacility_33", (String)"taxc-tcvvt", (Object[])new Object[0]);
        }
        return errorMsg;
    }

    private static String getTaxLimits(String reporttype) {
        if ("ajsb".equals(reporttype)) {
            return "season";
        }
        if ("ansb".equals(reporttype)) {
            return "year";
        }
        if ("aysb".equals(reporttype)) {
            return "month";
        }
        return " ";
    }

    public static DynamicObject getTemplateType(String orgid, Date sksqq, Date sksqz) {
        return TcvvtTemplateUtils.getTemplateType(orgid, sksqq, sksqz);
    }

    private static DynamicObject getTemplateTypeFromTp(String orgid, Date sksqq, Date sksqz) {
        QFilter orgFilter = new QFilter("orgid", "=", (Object)Long.parseLong(orgid));
        QFilter startFilter = new QFilter("startdate", "=", (Object)sksqq);
        QFilter endFilter = new QFilter("enddate", "=", (Object)sksqz);
        DynamicObject massageTp = BusinessDataServiceHelper.loadSingle((String)"tcvvt_message", (String)"id,accountingstandards,newrule,registeraddress", (QFilter[])new QFilter[]{orgFilter, startFilter, endFilter});
        if (massageTp != null) {
            return TcvvtTemplateUtils.getTemplateType(massageTp.getLong("accountingstandards.id"), massageTp.getString("newrule"), orgid, sksqq, sksqz);
        }
        return null;
    }

    private static void isCHNTaxationsys(Long orgId) {
        TaxResult listTaxResult = TaxcMainDataServiceHelper.queryTaxcMainByOrgIdsAndTaxpayer(Collections.singletonList(orgId));
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)orgId);
        String orgName = ((DynamicObject)result.getData()).getString("maincompany");
        Boolean isCHNTaxationsys = false;
        if (!ObjectUtils.isEmpty((Object)listTaxResult) && !ObjectUtils.isEmpty((Object)listTaxResult.getData())) {
            List data = (List)listTaxResult.getData();
            for (DynamicObject dyo : data) {
                long taxationsys = dyo.getLong("taxationsys.id");
                if (!TaxationsysMappingEnum.CHN.getId().equals(taxationsys)) continue;
                isCHNTaxationsys = true;
            }
        }
        if (!isCHNTaxationsys.booleanValue()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u65e0\u4e2d\u56fd\u5927\u9646\u7a0e\u5236\u4fe1\u606f\uff0c\u8bf7\u524d\u5f80\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u9875\u9762\u8fdb\u884c\u914d\u7f6e\u3002", (String)"DeclareCheckFacility_34", (String)"taxc-tcvvt", (Object[])new Object[0]), orgName));
        }
    }

    static {
        canNotUnAuditOrApplyMap.put("declaring", ResManager.loadKDString((String)"\u7533\u62a5\u4e2d", (String)"DeclareCheckFacility_0", (String)"taxc-tcvvt", (Object[])new Object[0]));
        canNotUnAuditOrApplyMap.put("declared", ResManager.loadKDString((String)"\u7533\u62a5\u6210\u529f\u3002", (String)"DeclareCheckFacility_1", (String)"taxc-tcvvt", (Object[])new Object[0]));
        canNotUnAuditOrApplyMap.put("submitted", ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u5f85\u7533\u62a5", (String)"DeclareCheckFacility_2", (String)"taxc-tcvvt", (Object[])new Object[0]));
        canNotUnAuditOrApplyMap.put("importing", ResManager.loadKDString((String)"\u5df2\u7533\u62a5\u672a\u5bfc\u5165", (String)"DeclareCheckFacility_3", (String)"taxc-tcvvt", (Object[])new Object[0]));
    }
}

