/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.group;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.plugin.AbstractTreePlugin;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;

@Deprecated
public abstract class AbstractOrgGroupSelectPlugin
extends AbstractTreePlugin {
    private static final String BTN_GO = "btngo";
    private static final String BTN_BACK = "btnback";
    private static final String TREE_LEFT = "tree_left";
    private static final String TREE_RIGHT = "tree_right";

    public void initialize() {
        TreeView rightTreeView = (TreeView)this.getView().getControl(TREE_RIGHT);
        rightTreeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addTreeNodeDragListener(new String[]{TREE_RIGHT});
    }

    public void registerListener(EventObject e) {
        super.addEnterListener(new String[]{TREE_LEFT, TREE_RIGHT});
        this.addClickListeners(new String[]{BTN_GO, BTN_BACK, "submit"});
        this.addClickListeners(new String[]{"searchbefore_tree_left", "searchnext_tree_left", "searchbefore_tree_right", "searchnext_tree_right"});
    }

    public void afterCreateNewData(EventObject e) {
        this.loadLeftTree();
        this.loadRightTree(ResManager.loadKDString((String)"\u6c47\u603b\u7ec4\u7ec7", (String)"AbstractOrgGroupSelectPlugin_0", (String)"taxc-tcvvt", (Object[])new Object[0]));
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_GO.equals(key)) {
            this.goClick();
        } else if (BTN_BACK.equals(key)) {
            this.removeOrg();
        }
        if (key.startsWith("searchbefore_") || key.startsWith("searchnext_")) {
            super.click(evt);
        }
        if ("submit".equals(key)) {
            if (!this.checkOrgConf()) {
                return;
            }
            if (!this.validate()) {
                return;
            }
            this.getView().close();
        }
    }

    public List<String> getTreeOrg(TreeNode treeNode) {
        ArrayList<String> idlist = new ArrayList<String>();
        if (treeNode != null && !CollectionUtils.isEmpty((Collection)treeNode.getChildren())) {
            for (TreeNode node : treeNode.getChildren()) {
                idlist.addAll(this.childList(node));
            }
        }
        return idlist;
    }

    private List<String> childList(TreeNode treeNode) {
        ArrayList<String> idlist = new ArrayList<String>();
        if (treeNode != null) {
            idlist.add((String)((Map)treeNode.getData()).get("orgcode"));
            if (!CollectionUtils.isEmpty((Collection)treeNode.getChildren())) {
                for (TreeNode node : treeNode.getChildren()) {
                    idlist.addAll(this.childList(node));
                }
            }
        }
        return idlist;
    }

    public boolean checkOrgConf() {
        TreeNode root = this.getRoot(TREE_RIGHT);
        List<String> orgs = this.getTreeOrg(root);
        DynamicObject[] orgAar = BusinessDataServiceHelper.load((String)"tctb_tax_main", (String)"orgid.number", (QFilter[])new QFilter[]{new QFilter("orgid.number", "in", orgs)});
        ArrayList<String> existNumberList = new ArrayList<String>(16);
        for (int i = 0; i < orgAar.length; ++i) {
            existNumberList.add(orgAar[i].getString("orgid.number"));
        }
        ArrayList<String> noExistList = new ArrayList<String>();
        for (String number : orgs) {
            if (existNumberList.contains(number)) continue;
            noExistList.add(number);
        }
        if (noExistList.size() > 0) {
            String join = StringUtils.join((Object[])noExistList.toArray(), (char)'\u3001');
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u8bf7\u5148\u5728\u57fa\u7840\u8bbe\u7f6e-\u7a0e\u52a1\u4fe1\u606f\u4e2d\u5b8c\u5584\u7a0e\u52a1\u4fe1\u606f\u3002", (String)"AbstractOrgGroupSelectPlugin_1", (String)"taxc-tcvvt", (Object[])new Object[0]), join));
            return false;
        }
        return true;
    }

    public abstract boolean validate();

    public void removeOrg() {
        this.backClick(ResManager.loadKDString((String)"\u6c47\u603b\u7ec4\u7ec7", (String)"AbstractOrgGroupSelectPlugin_0", (String)"taxc-tcvvt", (Object[])new Object[0]));
    }

    public void goClick() {
        TreeView leftTreeView = (TreeView)this.getView().getControl(TREE_LEFT);
        List selectIds = leftTreeView.getTreeState().getSelectedNodeId();
        if (selectIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5de6\u6811\u8282\u70b9\u3002", (String)"AbstractOrgGroupSelectPlugin_2", (String)"taxc-tcvvt", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_tax_main", (String)"orgid,taxorg.status as status", (QFilter[])new QFilter[]{new QFilter("orgid", "in", selectIds.stream().map(v -> Long.parseLong(v)).distinct().collect(Collectors.toList()))});
        Map<String, String> collect = collection.stream().collect(Collectors.toMap(k -> k.getString("orgid"), v -> v.getString("status")));
        String currId = this.getCurrentNodeId(TREE_RIGHT);
        TreeNode currNode = this.getNode(TREE_RIGHT, currId);
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView(), (String)"tctb_org_group_latest", (String)"47150e89000000ac");
        for (String nodeId : selectIds) {
            TreeNode treeMode = this.getNode(TREE_LEFT, nodeId);
            if (!hasPermOrgResult.hasAllOrgPerm() && !hasPermOrgResult.getHasPermOrgs().contains(Long.parseLong(nodeId))) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u201c%s\u201d\u7684\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7528\u6237\u6388\u6743\u3002", (String)"AbstractOrgGroupSelectPlugin_3", (String)"taxc-tcvvt", (Object[])new Object[0]), treeMode.getText()));
                continue;
            }
            if ("3".equals(collect.get(nodeId))) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801:%1$s\u7ec4\u7ec7\u540d\u79f0:%2$s\u5df2\u7981\u7528\uff0c\u5982\u9700\u8bbe\u4e3a\u6c47\u603b\u7ec4\u7ec7\uff0c\u8bf7\u5148\u5728\u7a0e\u52a1\u7ec4\u7ec7\u4e2d\u542f\u7528\u3002", (String)"AbstractOrgGroupSelectPlugin_4", (String)"taxc-tcvvt", (Object[])new Object[0]), ((Map)treeMode.getData()).get("orgcode"), treeMode.getText()));
                continue;
            }
            TreeNode node = new TreeNode();
            node.setId(treeMode.getId());
            node.setText(treeMode.getText());
            node.setParentid(currNode.getId());
            node.setData(treeMode.getData());
            currNode.addChild(node);
            this.addNode(TREE_RIGHT, currId, node);
        }
        this.expand(TREE_RIGHT, currId);
    }

    public void backClick(String rootName) {
        TreeView rightTreeView = (TreeView)this.getView().getControl(TREE_RIGHT);
        List selectIds = rightTreeView.getTreeState().getSelectedNodeId();
        rightTreeView.deleteNodes(selectIds);
        if (selectIds.contains("-1")) {
            TreeNode root = new TreeNode();
            root.setId("-1");
            root.setText(rootName);
            root.setParentid("");
            rightTreeView.deleteAllNodes();
            rightTreeView.addNode(root);
            this.setRoot(TREE_RIGHT, root);
        } else {
            TreeNode root = this.getRoot(TREE_RIGHT);
            for (String id : selectIds) {
                root.deleteChildNode(id);
            }
            rightTreeView.deleteNodes(selectIds);
            this.setRoot(TREE_RIGHT, root);
        }
        rightTreeView.treeNodeClick("", "-1");
    }

    public void loadLeftTree() {
        DynamicObjectCollection dcs = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)"status", (Object)"1"));
        if (dcs == null || dcs.isEmpty()) {
            return;
        }
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        for (DynamicObject obj : dcs) {
            TreeNode leftRoot = new TreeNode();
            String id = obj.getString("id");
            String name = obj.getString("name");
            String parentid = obj.getString("parentid");
            leftRoot.setParentid(parentid);
            leftRoot.setId(id);
            leftRoot.setText(name);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("orgname", name);
            data.put("orgcode", obj.getString("number"));
            leftRoot.setData(data);
            nodeList.add(leftRoot);
        }
        this.bind(TREE_LEFT, nodeList);
        TreeUtils.expandAll((TreeView)((TreeView)this.getView().getControl(TREE_LEFT)), (TreeNode)this.getRoot(TREE_LEFT));
    }

    public void loadRightTree(String rootName) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        JSONArray jSONArray = (JSONArray)customParams.get("listNode");
        ArrayList<TreeNode> listNode = new ArrayList<TreeNode>(jSONArray.size());
        for (int i = 0; i < jSONArray.size(); ++i) {
            JSONObject jsonObj = jSONArray.getJSONObject(i);
            TreeNode node = new TreeNode();
            node.setId(jsonObj.getString("orgid"));
            node.setText(jsonObj.getString("orgname"));
            node.setParentid(jsonObj.getString("parentid"));
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("orgname", jsonObj.getString("orgname"));
            data.put("orgcode", jsonObj.getString("orgcode"));
            node.setData(data);
            listNode.add(node);
        }
        TreeNode rootRight = new TreeNode();
        rootRight.setId("-1");
        rootRight.setText(rootName);
        rootRight.setParentid("");
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        nodeList.add(rootRight);
        nodeList.addAll(listNode);
        rootRight.setIsOpened(true);
        this.bind(TREE_RIGHT, nodeList);
        TreeView treeView = (TreeView)this.getControl(TREE_RIGHT);
        treeView.focusNode(rootRight);
        treeView.treeNodeClick(null, rootRight.getId());
    }
}

