/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.monthly;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.finance.TcvvtCategoryInfoBusinessImpl;
import kd.taxc.bdtaxr.common.taxdeclare.NsrxxValidatorUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.tcvvt.business.monthly.MounthlyDeclareBusinessImpl;
import kd.taxc.tcvvt.common.util.DateUtils;
import kd.taxc.tcvvt.common.util.MainReportUtil;
import kd.taxc.tcvvt.common.util.StringUtil;
import kd.taxc.tcvvt.formplugin.taxdeclare.AbstractDeclareReportPluginNew;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class MonthlyDeclarePlugin
extends AbstractDeclareReportPluginNew
implements BeforeF7SelectListener,
AfterF7SelectListener {
    @Override
    public String getTemplateId(String templateType) {
        return null;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public String getMainEntity() {
        return "tcvvt_month_declare_list";
    }

    @Override
    public void init() {
        this.getPageCache().put("templatetype", this.getTemplateType());
        this.getPageCache().put("accessProjectEntity", "tpo_qhbbxm");
    }

    @Override
    public String setBillno(Date skssqz, String orgid) {
        String entry = this.getMainEntity();
        DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)entry);
        dyo.set("skssqz", (Object)skssqz);
        return CodeRuleServiceHelper.getNumber((String)entry, (DynamicObject)dyo, (String)orgid);
    }

    @Override
    public String getTaxType() {
        return null;
    }

    @Override
    public String getTemplateType() {
        String orgId = this.getPageCache().get("orgid");
        String startDate = this.getPageCache().get("skssqq");
        String endDate = this.getPageCache().get("skssqz");
        String templateType = "qhjtydbs";
        this.getPageCache().put("templatetype" + orgId + startDate + endDate, templateType);
        return templateType;
    }

    @Override
    public void clientCallBackMethod(Map<String, String> dataMap, String sheetid) {
    }

    @Override
    public void initPeriod(IDataModel getModel, IPageCache getPageCache, String orgId, Map<String, Object> customParams) {
        Date endDate;
        Date startDate;
        if (Boolean.TRUE.equals(customParams.get("readonly"))) {
            startDate = DateUtils.stringToDate((String)customParams.get("skssqq"));
            endDate = DateUtils.stringToDate((String)customParams.get("skssqz"));
        } else {
            Map<String, Date> map = MonthlyDeclarePlugin.preTaxPeriod(orgId, new Date());
            startDate = map.get("startDate");
            endDate = map.get("endDate");
        }
        getPageCache.put("dateChanged", "false");
        getModel.setValue("skssqq", (Object)startDate);
        getPageCache.put("dateChanged", "false");
        getModel.setValue("skssqz", (Object)endDate);
        getPageCache.put("skssqq", DateUtils.format(startDate));
        getPageCache.put("skssqz", DateUtils.format(endDate));
    }

    private static Map<String, Date> preTaxPeriod(String orgId, Date now) {
        HashMap<String, Date> result = new HashMap<String, Date>();
        Date lastMonth = DateUtils.addMonth(now, -1);
        Date startDate = DateUtils.getFirstDateOfMonth(lastMonth);
        Date endDate = DateUtils.getLastDateOfMonth(lastMonth);
        result.put("startDate", startDate);
        result.put("endDate", endDate);
        return result;
    }

    @Override
    protected Map<String, String> getBizParams(String operationType, boolean refresh) {
        Map<String, String> map = super.getBizParams(operationType, refresh);
        String skssqq = this.getPageCache().get("skssqq");
        Date currentDate = DateUtils.stringToDate(skssqq);
        Date lastMonth = DateUtils.addMonth(currentDate, -1);
        Date lastYearMonth = DateUtils.addYear(currentDate, -1);
        map.put("sqStartDate", DateUtils.format(DateUtils.getFirstDateOfMonth(lastMonth)));
        map.put("sqEndDate", DateUtils.format(DateUtils.getLastDateOfMonth(lastMonth)));
        map.put("sntqStartDate", DateUtils.format(DateUtils.getFirstDateOfMonth(lastYearMonth)));
        map.put("sntqEndDate", DateUtils.format(DateUtils.getLastDateOfMonth(lastYearMonth)));
        if (StringUtil.equalsIgnoreCase((CharSequence)operationType, (CharSequence)"edit")) {
            DynamicObject sqObject = this.queryNsrxx(this.getPageCache().get("orgid"), DateUtils.format(DateUtils.getFirstDateOfMonth(lastMonth)), DateUtils.format(DateUtils.getLastDateOfMonth(lastMonth)));
            DynamicObject sntqObject = this.queryNsrxx(this.getPageCache().get("orgid"), DateUtils.format(DateUtils.getFirstDateOfMonth(lastYearMonth)), DateUtils.format(DateUtils.getLastDateOfMonth(lastYearMonth)));
            map.put("sqSbbId", null != sqObject ? sqObject.getString("id") : "");
            map.put("sntqSbbId", null != sntqObject ? sntqObject.getString("id") : "");
            map.put("userid", String.valueOf(RequestContext.get().getCurrUserId()));
            map.put("reportdate", DateUtils.format(currentDate, new DateUtils().yyyymmChinese()));
        }
        return map;
    }

    @Override
    protected Map<String, String> getFetchConfigParams() {
        Map<String, String> map = super.getFetchConfigParams();
        String orgId = this.getPageCache().get("orgid");
        if (ObjectUtils.isEmpty((Object)orgId)) {
            return map;
        }
        Date skssqq = DateUtils.stringToDate(this.getPageCache().get("skssqq"));
        Date skssqz = DateUtils.stringToDate(this.getPageCache().get("skssqz"));
        MounthlyDeclareBusinessImpl mounthlyBusiness = new MounthlyDeclareBusinessImpl();
        map.putAll(mounthlyBusiness.getFetchAmountParamsTask(Long.valueOf(orgId), skssqq, skssqz, this.getTemplateType(), MounthlyDeclareBusinessImpl.getRuleFetchBusiness(), null, null, null));
        return map;
    }

    @Override
    protected String getBillno(String enddate, String type, String billno, String orgId) {
        if (!ObjectUtils.isEmpty((Object)billno) && billno.startsWith("NTGE")) {
            return billno;
        }
        String entity = this.getMainEntity();
        Date date = DateUtils.stringToDate(enddate);
        DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)entity);
        dyo.set("skssqz", (Object)date);
        return DeclareServiceHelper.generateSBBNo((String)this.getMainEntity(), (DynamicObject)dyo, (String)orgId);
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        if ("save".equalsIgnoreCase(evt.getItemKey())) {
            NsrxxValidatorUtils.nsrxxReviewed((Long)this.getModel().getDataEntity().getLong("org.id"));
            String pageid = this.getPageCache().get("declarepageid");
            IFormView childView = this.getView().getView(pageid);
            String changeDataParams = (String)childView.getPageCache().getAll().get("changeDataParams");
            Map map2 = (Map)JSONObject.parseObject((String)this.getPageCache().get("showData"), Map.class);
            String bqOld = "";
            if (!ObjectUtils.isEmpty((Object)map2) && !ObjectUtils.isEmpty(map2.get("tcvvt_monthly_other#1#bq"))) {
                bqOld = String.valueOf(map2.get("tcvvt_monthly_other#1#bq"));
            }
            String bq = "0";
            if (bqOld != null && bqOld.contains(",")) {
                bqOld = StringUtils.remove((String)bqOld, (String)",");
            }
            if (bqOld != null && bqOld.matches("^[0-9]*[1-9][0-9]*$")) {
                bq = bqOld;
            }
            if (!StringUtil.isEmpty((CharSequence)changeDataParams)) {
                Map map = (Map)JSONObject.parseObject((String)((String)childView.getPageCache().getAll().get("changeDataParams")), Map.class);
                if (ObjectUtils.isNotEmpty((Object)map) && map.get("cellKey").toString().equalsIgnoreCase("tcvvt_monthly_other#1#bq")) {
                    bq = String.valueOf(map.get("value"));
                }
            } else {
                Map declareData = (Map)TreeUtils.getCache((IPageCache)childView.getPageCache(), (String)"updata_cellid_save", Map.class);
                if (declareData != null) {
                    bq = (String)declareData.get("tcvvt_monthly_other#1#bq");
                }
            }
            if (bq == null || !bq.replace(",", "").matches("^[0-9]*[1-9][0-9]*$") || "0".equalsIgnoreCase(bq)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u201c\u7b2c20\u884c\u804c\u5de5\u4eba\u6570\uff08\u4e2a\uff09\u5fc5\u987b\u4e3a\u201c\u6b63\u6574\u6570\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"MonthlyDeclarePlugin_0", (String)"taxc-tcvvt", (Object[])new Object[0]));
                return;
            }
        }
        super.itemClick(evt);
    }

    @Override
    protected boolean check(String orgid) {
        boolean checkResult = super.check(orgid);
        if (checkResult) {
            return checkResult;
        }
        DynamicObject dynamicObject = TcvvtCategoryInfoBusinessImpl.queryqhjtCategoryInfoByOrgId((String)orgid);
        if (ObjectUtils.isNotEmpty((Object)dynamicObject) && !ObjectUtils.isEmpty((Object)dynamicObject.getDynamicObjectCollection("categoryentryentity"))) {
            boolean bl = checkResult = !((DynamicObject)dynamicObject.getDynamicObjectCollection("categoryentryentity").get(0)).getBoolean("enable");
            if (checkResult) {
                String name = dynamicObject.getDynamicObject("taxorg").getString("org.name");
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u7ec7\u7684\u201c\u5343\u6237\u96c6\u56e2\u201d=\u201c\u5426\u201d\uff0c\u8bf7\u5230\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u7ef4\u62a4\u3002", (String)"MonthlyDeclarePlugin_1", (String)"taxc-tcvvt", (Object[])new Object[0]), name));
                return checkResult;
            }
        }
        return checkResult;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("org".equalsIgnoreCase(name)) {
            List<Long> isTaxpayerOrg = this.getIsTaxpayerOrg();
            QFilter qFilter = new QFilter("id", "in", isTaxpayerOrg);
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(qFilter);
            formShowParameter.getTreeFilterParameter().getQFilters().add(qFilter);
        }
    }

    @Override
    protected QFilter getOrgFilters(List<Long> orgList) {
        List ids = TcvvtCategoryInfoBusinessImpl.queryqhjtCategoryInfoByOrgIds(orgList);
        QFilter qFilter = new QFilter("orgid", "in", (Object)ids);
        QFilter qFilter1 = new QFilter("billstatus", "=", (Object)"C");
        return qFilter.and(qFilter1);
    }

    @Override
    public Long getSbbid() {
        return DeclareServiceHelper.generateSBBId((String)this.getMainEntity());
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        String orgid = afterF7SelectEvent.getListSelectedRowCollection().get(0).getPrimaryKeyValue().toString();
        MainReportUtil.allRequiredFieldValidator(orgid);
    }
}

