/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.qcye;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.plugin.support.util.ObjectUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.list.ListView;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.view.ViewDataServiceHelper;
import kd.taxc.tcvvt.business.qcye.TcvvtCollectQcyeBusiness;
import kd.taxc.tcvvt.common.collection.CollectionCommonMethod;
import kd.taxc.tcvvt.common.helper.ISCDataCopyHelper;
import kd.taxc.tcvvt.common.util.DateUtils;
import kd.taxc.tcvvt.common.util.EmptyCheckUtils;
import org.apache.commons.lang3.StringUtils;

public class TcvvtCollectQcyePlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String TCVVT_VOUCHER = "tcvvt_voucher";
    private static final String TCVVT_CLIQUE_QCYE = "tcvvt_clique_qcye";
    private static final String ACCOUNTLEVEL = "accountlevel";
    private static final String ISCOLLECT = "iscollect";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.setVisiable();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.setVisiable();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        CollectionCommonMethod.setAccountancyOrgView(evt, this.getView());
    }

    public void beforeBindData(EventObject e) {
        CollectionCommonMethod.validatorAndSetOrg(this.getView(), this.getModel());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing && "sure".equals(((Donothing)args.getSource()).getOperateKey())) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            MulBasedataDynamicObjectCollection colls = (MulBasedataDynamicObjectCollection)dataEntity.get("org");
            List<Long> oids = colls.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            String year = DateUtils.getFirstDateOfMonthStr(dataEntity.getDate("nd_dm"), "yyyy");
            String isCollect = dataEntity.getString(ISCOLLECT);
            String kjqj = StringUtils.isEmpty((CharSequence)dataEntity.getString("kjqj")) ? "1,2,3,4,5,6,7,8,9,10,11,12" : dataEntity.getString("kjqj");
            String accountLevel = dataEntity.getString(ACCOUNTLEVEL);
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            StringBuilder detailMessages = new StringBuilder();
            HashMap<Long, Long> orgidToLevel = new HashMap<Long, Long>(512);
            HashMap<Long, String> orgidToName = new HashMap<Long, String>(512);
            String detailMessage = ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%s", (String)"TcvvtCollectQcyePlugin_0", (String)"taxc-tcvvt", (Object[])new Object[0]);
            DynamicObjectCollection accounts = TcvvtCollectQcyeBusiness.QueryAccountByOrgIdsAndNddm(oids, year);
            TaxResult result = ViewDataServiceHelper.queryOrgUnitByOrgIdsAndViewNumber(oids, (String)"10");
            if (result.isSuccess()) {
                DynamicObject[] orgs;
                for (DynamicObject org : orgs = (DynamicObject[])result.getData()) {
                    String orgName = org.getString("name");
                    Long orgid = org.getLong("id");
                    orgidToName.put(orgid, orgName);
                }
            }
            for (Long oid : oids) {
                orgidToLevel.put(oid, 0L);
            }
            if (!ObjectUtils.isEmpty((Object)accounts)) {
                for (DynamicObject account : accounts) {
                    Long orgid = account.getLong("org.id");
                    Long level = account.getLong("level");
                    Long maxLevel = (Long)orgidToLevel.get(orgid);
                    if (ObjectUtils.isEmpty((Object)maxLevel)) {
                        orgidToLevel.put(orgid, level);
                        continue;
                    }
                    if (level <= maxLevel) continue;
                    orgidToLevel.put(orgid, level);
                }
            }
            if (!ObjectUtils.isEmpty((Object)accountLevel)) {
                for (Map.Entry entry : orgidToLevel.entrySet()) {
                    if ((Long)entry.getValue() >= Long.parseLong(accountLevel)) continue;
                    detailMessages.append(String.format(detailMessage, orgidToName.get(entry.getKey()))).append("\r\n");
                }
            }
            if (!ObjectUtils.isEmpty((Object)accountLevel) && !ObjectUtils.isEmpty((Object)detailMessages)) {
                this.showConfirmTips(((ListView)this.getView().getParentView()).getBillFormId(), detailMessages);
                return;
            }
            this.excuteIntegrationScheme(accountLevel, params, year, isCollect, kjqj, oids);
        }
    }

    private void setVisiable() {
        if (!ObjectUtils.isEmpty(this.getView().getFormShowParameter().getCustomParams().get("entityId"))) {
            String entityId = this.getView().getFormShowParameter().getCustomParams().get("entityId").toString();
            if (ObjectUtils.isEmpty((Object)this.getModel().getValue(ACCOUNTLEVEL))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
                ((ComboEdit)this.getControl(ISCOLLECT)).setMustInput(false);
                this.getModel().setValue(ISCOLLECT, null);
            } else if (TCVVT_CLIQUE_QCYE.equalsIgnoreCase(entityId)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
                ((ComboEdit)this.getControl(ISCOLLECT)).setMustInput(true);
            }
        }
    }

    private void showConfirmTips(String entityId, StringBuilder detailMessages) {
        String msg = "";
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("collect", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"TcvvtCollectQcyePlugin_1", (String)"taxc-tcvvt", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"TcvvtCollectQcyePlugin_2", (String)"taxc-tcvvt", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        if (entityId.equalsIgnoreCase(TCVVT_CLIQUE_QCYE)) {
            msg = ResManager.loadKDString((String)"\u5f53\u524d\u91c7\u96c6\u671f\u521d\u4f59\u989d\u6570\u636e\u79d1\u76ee\u7ea7\u6b21\u5927\u4e8e\u5df2\u91c7\u96c6\u79d1\u76ee\u6570\u636e\u7ea7\u6b21\uff0c\u65e0\u6cd5\u5b8c\u6574\u91c7\u96c6\uff0c\u786e\u8ba4\u6267\u884c\u91c7\u96c6\u64cd\u4f5c\uff1f", (String)"TcvvtCollectQcyePlugin_3", (String)"taxc-tcvvt", (Object[])new Object[0]);
        }
        if (entityId.equalsIgnoreCase(TCVVT_VOUCHER)) {
            msg = ResManager.loadKDString((String)"\u5f53\u524d\u91c7\u96c6\u51ed\u8bc1\u6570\u636e\u79d1\u76ee\u7ea7\u6b21\u5927\u4e8e\u5df2\u91c7\u96c6\u79d1\u76ee\u6570\u636e\u7ea7\u6b21\uff0c\u65e0\u6cd5\u5b8c\u6574\u91c7\u96c6\uff0c\u786e\u8ba4\u6267\u884c\u91c7\u96c6\u64cd\u4f5c\uff1f", (String)"TcvvtCollectQcyePlugin_4", (String)"taxc-tcvvt", (Object[])new Object[0]);
        }
        this.getView().showConfirm(msg, detailMessages.toString(), options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String result = messageBoxClosedEvent.getResult().name();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        MulBasedataDynamicObjectCollection colls = (MulBasedataDynamicObjectCollection)dataEntity.get("org");
        List<Long> oids = colls.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        String year = DateUtils.getFirstDateOfMonthStr(dataEntity.getDate("nd_dm"), "yyyy");
        String isCollect = dataEntity.getString(ISCOLLECT);
        String kjqj = StringUtils.isEmpty((CharSequence)dataEntity.getString("kjqj")) ? "1,2,3,4,5,6,7,8,9,10,11,12" : dataEntity.getString("kjqj");
        String accountLevel = dataEntity.getString(ACCOUNTLEVEL);
        if ("Yes".equalsIgnoreCase(result)) {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            this.excuteIntegrationScheme(accountLevel, params, year, isCollect, kjqj, oids);
        }
    }

    private void excuteIntegrationScheme(String accountLevel, Map<String, Object> params, String year, String isCollect, String kjqj, List<Long> oids) {
        if (kd.bos.dataentity.utils.ObjectUtils.isEmpty((Object)accountLevel)) {
            params.put("accountLevel", 0);
        } else {
            params.put("accountLevel", Integer.parseInt(accountLevel));
        }
        params.put("year", year);
        params.put("isCollect", isCollect);
        ArrayList<String> periods = new ArrayList<String>();
        for (String monthStr : kjqj.split(",")) {
            if (!StringUtils.isNotEmpty((CharSequence)monthStr)) continue;
            periods.add(Long.parseLong(monthStr) < 10L ? "0" + monthStr : monthStr);
        }
        params.put("period", periods);
        String number = "KDflow_CliqueQcye(IERP-IERP)";
        String entityId = Optional.ofNullable(this.getView().getFormShowParameter().getCustomParams().get("entityId")).orElse("").toString();
        if (TCVVT_VOUCHER.equalsIgnoreCase(entityId)) {
            number = "KDflow_CliqueVoucherSyncStream(IERP-IERP)";
        }
        try {
            if (EmptyCheckUtils.isNotEmpty(oids)) {
                for (Long orgid : oids) {
                    ArrayList<Object> input = new ArrayList<Object>(oids.size());
                    params.put("orgList", Collections.singletonList(orgid));
                    input.add(params);
                    ISCDataCopyHelper.asyncInvokeBizByIscFlowServiceWithParams(number, input);
                }
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff0c\u5df2\u89e6\u53d1\u540e\u53f0\u91c7\u96c6\u4efb\u52a1\u3002", (String)"TcvvtCollectQcyePlugin_5", (String)"taxc-tcvvt", (Object[])new Object[0]));
                this.getView().close();
            }
        }
        catch (Exception ex) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u91c7\u96c6\u5931\u8d25\uff1a%1$s", (String)"TcvvtCollectQcyePlugin_6", (String)"taxc-tcvvt", (Object[])new Object[0]), ex.getMessage()));
        }
    }
}

