/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.qhjt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tcvvt.common.util.DateUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class QhjtBookListPlugin
extends AbstractListPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey = evt.getOperateKey();
        if ("whjt".equals(operateKey)) {
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.MainNewTabPage);
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"tcvvt_qhjt", (boolean)true, (int)0, (boolean)false);
            showParameter.setOpenStyle(openStyle);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if ("syncdata".equals(operateKey)) {
            this.showModal();
        }
    }

    private void showModal() {
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("tcvvt_syncqhjtdata_dialog");
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formshowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "sure"));
        this.getView().showForm(formshowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (MapUtils.isNotEmpty((Map)returnData) && returnData.containsKey("success")) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refreshData();
        }
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if ("currentstatus".equals(columnDesc.getKey())) {
            Date startdate = data.getDate("startdate");
            Date enddate = data.getDate("enddate");
            String valid = this.setValid(startdate, enddate);
            e.setFormatValue((Object)valid);
            data.set("currentstatus", (Object)valid);
        }
    }

    private String setValid(Date startDate, Date endDate) {
        Date now = DateUtils.getDayFirst(new Date());
        if (startDate != null && now.compareTo(startDate) >= 0 && (endDate == null || endDate.compareTo(now) >= 0)) {
            return "1";
        }
        return "0";
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters() == null ? new ArrayList() : e.getQFilters();
        Date now = DateUtils.getDayFirst(new Date());
        Iterator iterator = qFilters.iterator();
        Date startDateReq = null;
        Date endDateReq = null;
        ArrayList<String> statusList = new ArrayList<String>();
        while (iterator.hasNext()) {
            QFilter qFilter = (QFilter)iterator.next();
            if ("currentstatus".equals(qFilter.getProperty())) {
                String currentstatus = qFilter.getValue().toString();
                if ("0".equalsIgnoreCase(currentstatus) || "[0]".equalsIgnoreCase(currentstatus)) {
                    statusList.add("0");
                } else if ("1".equalsIgnoreCase(currentstatus) || "[1]".equalsIgnoreCase(currentstatus)) {
                    statusList.add("1");
                }
                iterator.remove();
                continue;
            }
            if (!"startdate".equals(qFilter.getProperty())) continue;
            startDateReq = (Date)qFilter.getValue();
            if (qFilter.getNests(false) != null && qFilter.getNests(false).size() > 0) {
                endDateReq = (Date)((QFilter.QFilterNest)qFilter.getNests(false).get(0)).getFilter().getValue();
                String cp = ((QFilter.QFilterNest)qFilter.getNests(false).get(0)).getFilter().getCP();
                if (cp.equalsIgnoreCase("<")) {
                    endDateReq = DateUtils.addDay(endDateReq, -1);
                }
            }
            iterator.remove();
        }
        DynamicObjectCollection allGroups = QueryServiceHelper.query((String)"tcvvt_group", (String)"startdate,enddate,id,nsrmc", (QFilter[])new QFilter[0]);
        ArrayList<Long> ids = new ArrayList<Long>();
        if (startDateReq != null && endDateReq != null) {
            for (DynamicObject group : allGroups) {
                Date startdate = group.getDate("startdate");
                Date enddate = group.getDate("enddate");
                if (enddate == null && endDateReq.compareTo(startdate) >= 0) {
                    ids.add(group.getLong("id"));
                    continue;
                }
                if (enddate == null || startdate.compareTo(endDateReq) > 0 || startDateReq.compareTo(enddate) > 0) continue;
                ids.add(group.getLong("id"));
            }
            e.getQFilters().add(new QFilter("id", "in", ids));
        }
        for (String status : statusList) {
            QFilter endFilter;
            QFilter startFilter;
            if ("1".equalsIgnoreCase(status)) {
                startFilter = new QFilter("startdate", "<=", (Object)now);
                endFilter = new QFilter("enddate", "=", null).or(new QFilter("enddate", ">=", (Object)now));
                e.getQFilters().add(startFilter);
                e.getQFilters().add(endFilter);
                continue;
            }
            if (!"0".equalsIgnoreCase(status)) continue;
            startFilter = new QFilter("startdate", ">", (Object)now);
            endFilter = new QFilter("enddate", "is not null", null).and(new QFilter("enddate", "<", (Object)now));
            e.getQFilters().add(startFilter.or(endFilter));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FilterContainerInitEvent contInitEvent = args.getFilterContainerInitEvent();
        List commonFilterColumns = contInitEvent.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn filter;
            List comboItems;
            String fieldName = filterColumn.getFieldName();
            if (!fieldName.equals("jt_mc.groupname") || !CollectionUtils.isNotEmpty((Collection)(comboItems = (filter = (CommonFilterColumn)filterColumn).getComboItems()))) continue;
            filter.setDefaultValues(new Object[]{((ComboItem)comboItems.get(0)).getValue()});
        }
    }
}

