/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.qhjt;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;
import kd.taxc.tcvvt.common.util.PermissionUtils;
import kd.taxc.tcvvt.common.util.StringUtil;

public class QhjtBookPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit reporttype = (BasedataEdit)this.getControl("nsrmc");
        reporttype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit accessproject = (BasedataEdit)this.getControl("sjnsrmc");
        accessproject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)"nsrmc") || StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)"sjnsrmc")) {
            DynamicObjectCollection col = this.eligibleOrg();
            List<Object> ids = new ArrayList();
            if (col != null) {
                ids = col.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            }
            QFilter idFilter = new QFilter("id", "in", ids);
            evt.addCustomQFilter(idFilter);
        }
    }

    private DynamicObjectCollection eligibleOrg() {
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs(this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
        if (null == col || col.isEmpty()) {
            return null;
        }
        List<Long> orgList = col.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        List<Long> finalOrgList = orgList = QhjtBookPlugin.mergeTaxOrgIds(orgList, "3");
        col.removeIf(o -> !finalOrgList.contains(o.getLong("id")));
        return col;
    }

    public static List<Long> mergeTaxOrgIds(List<Long> idList, String status) {
        if (StringUtils.equals((CharSequence)status, (CharSequence)"2")) {
            status = "1";
        }
        if (StringUtils.equals((CharSequence)status, (CharSequence)"3")) {
            status = "0";
        }
        QFilter statusFilter = new QFilter("status", "=", (Object)status);
        QFilter orgFilter = new QFilter("org.id", "in", idList);
        QFilter nsFilter = new QFilter("istaxpayer", "!=", (Object)"1");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bastax_taxorg", (String)"id,org.id as orgid", (QFilter[])new QFilter[]{orgFilter, statusFilter.or(nsFilter)});
        List disabledOrgList = collection.stream().map(o -> o.getLong("orgid")).collect(Collectors.toList());
        return idList.stream().filter(v -> !disabledOrgList.contains(v)).collect(Collectors.toList());
    }
}

