/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.qhjt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.operate.Donothing;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.tcvvt.business.qhjt.QhjtCommonBusiness;
import kd.taxc.tcvvt.common.constant.PageShowCommon;
import kd.taxc.tcvvt.common.util.DateUtils;
import kd.taxc.tcvvt.common.util.ExportUtil;
import kd.taxc.tcvvt.common.util.PluginUtil;
import kd.taxc.tcvvt.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;

public class VoucherListPlugin
extends AbstractListPlugin {
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        QFilter qFilter = args.getSearchClickEvent().getQFilter("year");
        Date dateStart = null;
        if (qFilter != null) {
            boolean isNotCrossYear = false;
            if (qFilter.getValue() instanceof Date) {
                dateStart = (Date)qFilter.getValue();
            }
            Date dateEnd = null;
            List qFilterNests = qFilter.getNests(false);
            if (!CollectionUtils.isEmpty((Collection)qFilterNests)) {
                dateEnd = (Date)((QFilter.QFilterNest)qFilterNests.get(0)).getFilter().getValue();
                String cp = ((QFilter.QFilterNest)qFilterNests.get(0)).getFilter().getCP();
                if ("<".equalsIgnoreCase(cp)) {
                    dateEnd = DateUtils.addDay(dateEnd, -1);
                }
            }
            if (dateEnd != null && DateUtils.getFirstDateOfYear(dateStart).compareTo(dateStart) == 0 && DateUtils.getFirstDateOfYear(dateStart).compareTo(DateUtils.getFirstDateOfYear(dateEnd)) == 0 && DateUtils.getLastDateOfYear(dateEnd).compareTo(dateEnd) == 0) {
                isNotCrossYear = true;
            }
            if (!isNotCrossYear) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b8c\u6574\u7684\u5e74\u5ea6\u3002", (String)"VoucherListPlugin_0", (String)"taxc-tcvvt", (Object[])new Object[0]));
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters() == null ? new ArrayList() : e.getQFilters();
        Date dateStart = null;
        Iterator iterator = qFilters.iterator();
        boolean singleSelectOrg = true;
        while (iterator.hasNext()) {
            QFilter qFilter = (QFilter)iterator.next();
            if (!"year".equals(qFilter.getProperty())) continue;
            if (qFilter.getValue() instanceof Date) {
                dateStart = (Date)qFilter.getValue();
            }
            iterator.remove();
        }
        e.getQFilters().add(new QFilter("nd_dm", "=", (Object)DateUtils.format(dateStart, "yyyy")));
        e.getMergeQFilters().remove(null);
        this.getPageCache().put("filterList", SerializationUtils.serializeToBase64((Object)e.getMergeQFilters()));
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey;
        switch (operateKey = evt.getOperateKey()) {
            case "collect": {
                this.showModal(evt);
                break;
            }
            case "outportcsv": {
                this.outportcsv();
                break;
            }
            case "execresult": {
                this.showExecuteResultBillList(evt);
                break;
            }
        }
    }

    private void showModal(AfterDoOperationEventArgs args) {
        if (args.getOperateKey().equals("collect") && args.getOperationResult().isSuccess()) {
            FormShowParameter formshowParameter = new FormShowParameter();
            formshowParameter.setFormId("tcvvt_clique_qcyecollect");
            formshowParameter.setCaption(ResManager.loadKDString((String)"\u91c7\u96c6\u6570\u636e", (String)"VoucherListPlugin_1", (String)"taxc-tcvvt", (Object[])new Object[0]));
            formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formshowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close"));
            HashMap<String, Object> param = new HashMap<String, Object>(12);
            List orgs = this.getControlFilters().getFilter("org.id");
            if (orgs != null && orgs.size() > 0) {
                param.put("org", orgs.get(0));
            }
            param.put("entityId", "tcvvt_voucher");
            formshowParameter.setCustomParams(param);
            formshowParameter.setCustomParam("orgFuncId", (Object)"10");
            formshowParameter.setCustomParam("orgViewSchemeNumber", (Object)"10");
            this.getView().showForm(formshowParameter);
        }
    }

    private void outportcsv() {
        BillList billlist = (BillList)this.getControl("billlistap");
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("outportcsv", (IFormPlugin)this);
        QFilter filter = null;
        if (billlist.getCurrentListAllRowCollection().size() == 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5c06\u5bfc\u51fa0\u6761\u6570\u636e\uff0c\u786e\u5b9a\u662f\u5426\u5bfc\u51fa\uff1f", (String)"VoucherListPlugin_2", (String)"taxc-tcvvt", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            return;
        }
        ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
        if (CollectionUtils.isNotEmpty((Collection)selectedRows)) {
            List pkIds = Arrays.stream(selectedRows.getPrimaryKeyValues()).distinct().collect(Collectors.toList());
            List<Long> orgCount = QhjtCommonBusiness.queryOrgCountByVoucherSetIds(new QFilter[]{new QFilter("id", "in", pkIds)});
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5c06\u5bfc\u51fa%1$s\u4e2a\u6838\u7b97\u7ec4\u7ec7\u5171%2$s\u6761\u6570\u636e\uff0c\u786e\u5b9a\u662f\u5426\u5bfc\u51fa\uff1f", (String)"VoucherListPlugin_3", (String)"taxc-tcvvt", (Object[])new Object[0]), orgCount.size(), selectedRows.size()), MessageBoxOptions.OKCancel, confirmCallBackListener);
            return;
        }
        if (StringUtil.isEmpty((CharSequence)this.getPageCache().get("filterList"))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5c06\u5bfc\u51fa0\u6761\u6570\u636e\uff0c\u786e\u5b9a\u662f\u5426\u5bfc\u51fa\uff1f", (String)"VoucherListPlugin_2", (String)"taxc-tcvvt", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            return;
        }
        List setFilter = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("filterList"));
        for (QFilter qf : setFilter) {
            if (filter != null) {
                filter.and(qf);
                continue;
            }
            filter = qf;
        }
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tcvvt_voucher", (String)"count(id) as total", (QFilter[])new QFilter[]{filter});
        List<Long> orgCount = QhjtCommonBusiness.queryOrgCountByVoucherSetIds(new QFilter[]{filter});
        this.getPageCache().put("datacount", String.valueOf(dynamicObject.getLong("total")));
        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5c06\u5bfc\u51fa%1$s\u4e2a\u6838\u7b97\u7ec4\u7ec7\u5171%2$s\u6761\u6570\u636e\uff0c\u786e\u5b9a\u662f\u5426\u5bfc\u51fa\uff1f", (String)"VoucherListPlugin_3", (String)"taxc-tcvvt", (Object[])new Object[0]), orgCount.size(), dynamicObject.getLong("total")), MessageBoxOptions.OKCancel, confirmCallBackListener);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String fieldKey = messageBoxClosedEvent.getCallBackId();
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equalsIgnoreCase((CharSequence)"outportcsv", (CharSequence)fieldKey) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            BillList billlist = (BillList)this.getControl("billlistap");
            List pkIds = Arrays.stream(billlist.getSelectedRows().getPrimaryKeyValues()).distinct().collect(Collectors.toList());
            List<Long> orgIds = QhjtCommonBusiness.queryOrgCountByVoucherSetIds(new QFilter[]{new QFilter("id", "in", pkIds)});
            Map<String, String> orgMap = QhjtCommonBusiness.queryAccountingOrgByIds(orgIds);
            QueryBuilder queryBuilder = PluginUtil.getListQueryBuilder(this, billlist);
            ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
            if (billlist.getCurrentListAllRowCollection().size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"VoucherListPlugin_4", (String)"taxc-tcvvt", (Object[])new Object[0]));
                return;
            }
            if (CollectionUtils.isNotEmpty((Collection)selectedRows)) {
                Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
                QFilter filter = new QFilter("id", "in", (Object)primaryKeyValues);
                ExportUtil.downloadKjGroupCsvFile("tcvvt_voucher", filter, this.getView(), queryBuilder.getOrderBys(), orgMap, orgIds);
                return;
            }
            if (StringUtil.isEmpty((CharSequence)this.getPageCache().get("filterList"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6\u4e3a\u7a7a\u3002", (String)"VoucherListPlugin_5", (String)"taxc-tcvvt", (Object[])new Object[0]));
                return;
            }
            this.dispatch();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"taskcloseback")) {
            this.taskCallBack(closedCallBackEvent.getReturnData());
        }
    }

    private void taskCallBack(Object returnData) {
        TaskInfo taskInfo;
        String taskInfoStr;
        Map result;
        if (returnData == null) {
            return;
        }
        if (returnData instanceof Map && (result = (Map)returnData).containsKey("taskinfo") && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
            String data = taskInfo.getData();
            Map paramData = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
            if (ObjectUtils.isEmpty(paramData.get("url"))) {
                return;
            }
            String url = (String)paramData.get("url");
            try {
                String appId = this.getView().getFormShowParameter().getAppId();
                String billFormId = ((IListView)this.getView()).getBillFormId();
                PermissionUtils.putTempFilePermissionCache((String)url, (String)appId, (String)billFormId, (String)"2BF66VAR06YX");
                this.getView().download(url);
            }
            catch (KDBizException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
            }
        }
    }

    private void dispatch() {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId("tcvvt");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName("tcvvt-export-csv");
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.taxc.tcvvt.common.task.CsvTask");
        HashMap<String, Object> params = new HashMap<String, Object>();
        BillList billlist = (BillList)this.getControl("billlistap");
        QueryBuilder queryBuilder = PluginUtil.getListQueryBuilder(this, billlist);
        List setFilter = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("filterList"));
        QFilter filter = null;
        for (QFilter qf : setFilter) {
            if (filter != null) {
                filter.and(qf);
                continue;
            }
            filter = qf;
        }
        List<Long> orgIds = QhjtCommonBusiness.queryOrgCountByVoucherSetIds(new QFilter[]{filter});
        Map<String, String> orgMap = QhjtCommonBusiness.queryAccountingOrgByIds(orgIds);
        params.put("filterList", SerializationUtils.serializeToBase64((Object)queryBuilder.getFilters()));
        params.put("datacount", this.getPageCache().get("datacount"));
        params.put("orgIds", orgIds);
        params.put("orgMap", orgMap);
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskcloseback");
        JobForm.dispatch((JobInfo)jobInfo, (IFormView)this.getView(), (CloseCallBack)closeCallBack);
    }

    private void showExecuteResultBillList(AfterDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing && Objects.equals("execresult", ((Donothing)args.getSource()).getOperateKey())) {
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("execresulttype", "KDflow_CliqueVoucherSyncStream(IERP-IERP)");
            PageShowCommon.showServiceFlowBillList(ShowType.MainNewTabPage, "isc_sf_proc_inst", this.getView(), customParams, null);
        }
    }
}

