/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.qhjt;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.tcvvt.business.impl.SubjectQueryServiceImpl;
import kd.taxc.tcvvt.common.util.DateUtils;
import kd.taxc.tcvvt.common.util.PermissionUtils;
import kd.taxc.tcvvt.common.util.StringUtil;

public class VoucherPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map sourceData = e.getSourceData();
        String y = sourceData.get("nd_dm").toString();
        if (y.length() <= 4 && y.matches("[0-9]+")) {
            if (Integer.parseInt(y) < 2000 || Integer.parseInt(y) > 2099) {
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5e74\u5ea6\u4ee3\u7801\u5fc5\u987b\u57282000~2099\u4e4b\u95f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"VoucherPlugin_0", (String)"taxc-tcvvt", (Object[])new Object[0]));
                e.setCancel(true);
            }
            sourceData.put("year", DateUtils.stringToDate(y + "-01-01"));
        } else {
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5e74\u5ea6\u4ee3\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"VoucherPlugin_1", (String)"taxc-tcvvt", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void initImportData(InitImportDataEventArgs e) {
        for (Map rowMap : e.getSourceDataList()) {
            if (!rowMap.containsKey("org") || !rowMap.containsKey("nd_dm") || !rowMap.containsKey("kmdm")) continue;
            HashMap org = (HashMap)JSONObject.parseObject((String)JSONObject.toJSONString(rowMap.get("org")), HashMap.class);
            HashMap kmdmMap = (HashMap)JSONObject.parseObject((String)JSONObject.toJSONString(rowMap.get("kmdm")), HashMap.class);
            if (!org.containsKey("number") || !kmdmMap.containsKey("number")) {
                return;
            }
            String number = org.get("number").toString();
            String kmdmNumber = kmdmMap.get("number").toString();
            String ndDm = rowMap.get("nd_dm").toString();
            Date year = this.getYear(ndDm);
            int intValue = this.getIntValue(ndDm);
            if (null == year) continue;
            if (intValue < 2000 || intValue > 2099) {
                return;
            }
            DynamicObject subject = SubjectQueryServiceImpl.getInstance().querySubject(number, ndDm, kmdmNumber);
            JSONObject kmdmJson = (JSONObject)rowMap.get("kmdm");
            if (subject != null) {
                kmdmJson.put("id", subject.get("id"));
                continue;
            }
            kmdmJson.put("id", null);
        }
    }

    private int getIntValue(String ndDm) {
        try {
            return Integer.parseInt(ndDm);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private Date getYear(String ndDm) {
        try {
            return DateUtils.stringToDate(ndDm, "yyyy");
        }
        catch (Exception e) {
            return null;
        }
    }

    public void afterCreateNewData(EventObject e) {
        HasPermOrgResult tcvvt = PermissionUtils.getAllPermOrgsByUserId("tcvvt", "tcvvt_voucher", "47156aff000000ac", RequestContext.get().getCurrUserId());
        if (!ObjectUtils.isEmpty((Object)this.getView().getParentView()) && this.getView().getParentView() instanceof ListView) {
            ListView listView = (ListView)this.getView().getParentView();
            Map filterMap = listView.getControlFilters().getFilters();
            for (Map.Entry entry : filterMap.entrySet()) {
                Object value;
                ControlFilter filter = (ControlFilter)entry.getValue();
                Object object = value = ObjectUtils.isEmpty((Object)filter.getValue()) ? null : (Object)filter.getValue().get(0);
                if (!StringUtil.equalsIgnoreCase((CharSequence)((CharSequence)entry.getKey()), (CharSequence)"org.id") || value == null || tcvvt == null || !tcvvt.hasAllOrgPerm() && !tcvvt.getHasPermOrgs().contains(Long.valueOf(value.toString()))) continue;
                this.getModel().setValue("org", value);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("year".equals(name) || "org".equals(name)) {
            this.getModel().setValue("kmdm", null);
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit kmdm = (BasedataEdit)this.getControl("kmdm");
        kmdm.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if ("kmdm".equals(key)) {
            evt.setCancel(true);
            DynamicObject value = (DynamicObject)this.getModel().getValue("org");
            if (value == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7ec4\u7ec7\u201d\u3002", (String)"VoucherPlugin_2", (String)"taxc-tcvvt", (Object[])new Object[0]));
                return;
            }
            Date year = (Date)this.getModel().getValue("year");
            if (null == year) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5e74\u5ea6\u4ee3\u7801\u201d\u3002", (String)"VoucherPlugin_3", (String)"taxc-tcvvt", (Object[])new Object[0]));
                return;
            }
            long oid = value.getLong("id");
            QFilter filter = new QFilter("org", "=", (Object)oid).and("year", "=", (Object)DateUtils.getFirstDateOfYear(year));
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(filter);
            formShowParameter.getTreeFilterParameter().getQFilters().add(filter);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("CACHE_DEFAULT_ORG", String.valueOf(oid));
            hashMap.put("year", DateUtils.format(year));
            formShowParameter.setCustomParams(hashMap);
            evt.setCancel(false);
        }
    }
}

