/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.rollinformation;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BillClosedCallBackEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tcvvt.common.util.StringUtil;

@Deprecated
public class GroupRollBillListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(GroupRollBillListPlugin.class);
    private static final String VIEW_CACHE_ID = "isFilterInit";
    private static final int NO_VALUE = 0;
    private static final String BOOLEAN_TRUE = "true";
    private static final String FILTER_SELECTED_ITEM_KEY = "selectedCommomFilterFieldValues";
    public static final String GROUPPLAN_STARTDATE = "groupplan.startdate";
    public static final String GROUPPLAN_ENDDATE = "groupplan.enddate";
    public static final String TAXPAYER = "taxpayer";
    public static final String ORG_ORGNAME = "org,orgname";
    public static final String ORGNAME = "orgname";
    public static final String ORGID_ID = "orgid,id";

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        for (int i = 0; i < qFilters.size(); ++i) {
            Iterator newQFilter;
            DynamicObjectCollection dynamicObjects;
            ArrayList<Long> parentIds;
            QFilter qFilter = (QFilter)qFilters.get(i);
            if ("isvalid".equals(qFilter.getProperty())) {
                QFilter newQFilter2;
                Date now = new Date();
                if ("1".equals(qFilter.getValue())) {
                    QFilter subQfilter = QFilter.isNotNull((String)GROUPPLAN_ENDDATE).and(new QFilter(GROUPPLAN_ENDDATE, ">=", (Object)now));
                    QFilter subQfilter2 = QFilter.isNull((String)GROUPPLAN_ENDDATE).or(subQfilter);
                    newQFilter2 = new QFilter(GROUPPLAN_STARTDATE, "<=", (Object)now).and(subQfilter2);
                    map.put(i, newQFilter2);
                } else if ("2".equals(qFilter.getValue())) {
                    newQFilter2 = new QFilter(GROUPPLAN_STARTDATE, ">=", (Object)now).or(new QFilter(GROUPPLAN_ENDDATE, "<=", (Object)now));
                    map.put(i, newQFilter2);
                }
            }
            if ("rollstatus".equals(qFilter.getProperty())) {
                List values;
                Object value = qFilter.getValue();
                if (value instanceof String) {
                    if ("1".equals(qFilter.getValue())) {
                        QFilter newQFilter3 = new QFilter("rollstatus", "=", (Object)"").or(new QFilter("rollstatus", "=", (Object)"1"));
                        map.put(i, newQFilter3);
                    }
                } else if (value instanceof List && (values = (List)value).contains("1")) {
                    values.add("");
                }
            }
            if ("superorgname".equals(qFilter.getProperty())) {
                parentIds = new ArrayList<Long>();
                dynamicObjects = QueryServiceHelper.query((String)"tcvvt_roll_list", (String)ORG_ORGNAME, (QFilter[])new QFilter[]{new QFilter(ORGNAME, qFilter.getCP(), qFilter.getValue())});
                for (DynamicObject object : dynamicObjects) {
                    parentIds.add(object.getLong("org"));
                }
                newQFilter = new QFilter("parentid", "in", parentIds);
                map.put(i, newQFilter);
            }
            if (!"taxername".equals(qFilter.getProperty())) continue;
            parentIds = new ArrayList();
            dynamicObjects = QueryServiceHelper.query((String)"tctb_tax_main", (String)ORGID_ID, (QFilter[])new QFilter[]{new QFilter(TAXPAYER, qFilter.getCP(), qFilter.getValue())});
            for (DynamicObject object : dynamicObjects) {
                parentIds.add(object.getLong("orgid"));
            }
            newQFilter = new QFilter("org", "in", parentIds);
            map.put(i, newQFilter);
        }
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            qFilters.set((Integer)entry.getKey(), entry.getValue());
        }
    }

    public void billClosedCallBack(BillClosedCallBackEvent e) {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refreshData();
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection datas = super.getData(start, limit);
                ArrayList<Long> superIds = new ArrayList<Long>();
                ArrayList<Object> orgIds = new ArrayList<Object>();
                for (DynamicObject dynamicObject : datas) {
                    orgIds.add(dynamicObject.get("org.id"));
                    long parentId = dynamicObject.getLong("parentid");
                    if (parentId == 0L) continue;
                    superIds.add(parentId);
                }
                Map taxMainInformation = GroupRollBillListPlugin.this.getTaxMainInformation(orgIds);
                Map superOrg = GroupRollBillListPlugin.this.getSuperOrg(superIds);
                for (int i = 0; i < datas.size(); ++i) {
                    long parentId;
                    DynamicObject parent;
                    DynamicObject dynamicObject = (DynamicObject)datas.get(i);
                    String rollStatus = dynamicObject.getString("rollstatus");
                    if ("".equals(rollStatus)) {
                        dynamicObject.set("rollstatus", (Object)"1");
                    }
                    long orgId = dynamicObject.getLong("org.id");
                    DynamicObject taxMain = (DynamicObject)taxMainInformation.get(orgId);
                    String taxpayer = dynamicObject.getString("taxername");
                    if (taxMain != null && StringUtil.isEmpty((CharSequence)taxpayer)) {
                        dynamicObject.set("taxername", taxMain.get(GroupRollBillListPlugin.TAXPAYER));
                    }
                    if ((parent = (DynamicObject)superOrg.get(parentId = dynamicObject.getLong("parentid"))) == null) continue;
                    dynamicObject.set("superorgname", parent.get(GroupRollBillListPlugin.ORGNAME));
                }
                return datas;
            }
        });
    }

    private Map<Long, DynamicObject> getTaxMainInformation(List<Object> ids) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>();
        if (ids != null && ids.size() > 0) {
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tctb_tax_main", (String)"taxpayer,registertype,registeraddress,codeandname,orgid,id", (QFilter[])new QFilter[]{new QFilter("orgid", "in", ids)});
            for (DynamicObject object : dynamicObjects) {
                map.put(object.getLong("orgid"), object);
            }
        }
        return map;
    }

    private Map<Long, DynamicObject> getSuperOrg(List<Object> ids) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>();
        if (ids != null && ids.size() > 0) {
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tcvvt_roll_list", (String)"orgname,org,id", (QFilter[])new QFilter[]{new QFilter("org", "in", ids)});
            for (DynamicObject object : dynamicObjects) {
                map.put(object.getLong("org"), object);
            }
        }
        return map;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FilterContainerInitEvent contInitEvent = args.getFilterContainerInitEvent();
        List commonFilterColumns = contInitEvent.getCommonFilterColumns();
        Map<String, FilterColumn> collect = commonFilterColumns.stream().collect(Collectors.toMap(FilterColumn::getFieldName, a -> a));
        CommonFilterColumn commonFilterColumn = (CommonFilterColumn)collect.get("isvalid");
        String reflectData = this.getReflectData(commonFilterColumn);
        DynamicObjectCollection groupPlanListDateSet = this.getGroupPlanListDateSet(StringUtil.isEmpty((CharSequence)reflectData) ? 0 : Integer.parseInt(reflectData));
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(groupPlanListDateSet.size());
        for (DynamicObject dy : groupPlanListDateSet) {
            ComboItem item = new ComboItem();
            item.setValue(dy.getString("id"));
            item.setCaption(new LocaleString(dy.getString("name")));
            combos.add(item);
        }
        FilterColumn filterColumn1 = collect.get("groupplan.name");
        if (filterColumn1 != null) {
            CommonBaseDataFilterColumn planColumn = (CommonBaseDataFilterColumn)filterColumn1;
            planColumn.setComboItems(combos);
            if (!BOOLEAN_TRUE.equals(this.getPageCache().get(VIEW_CACHE_ID))) {
                planColumn.setDefaultValue("");
            }
        }
        if (!BOOLEAN_TRUE.equals(this.getPageCache().get(VIEW_CACHE_ID))) {
            FilterColumn orgFlterColumn = collect.get("org.name");
            if (orgFlterColumn != null) {
                orgFlterColumn.setDefaultValue("");
            }
            this.getPageCache().put(VIEW_CACHE_ID, BOOLEAN_TRUE);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        DynamicObject rowData = BusinessDataServiceHelper.loadSingle((String)"tcvvt_roll_list", (String)"groupplan,org,electronicfileno,leverno,address,taxername,nationtaxsn,localtaxsn,creditcode,registertype,accountway,codeandname,nationtaxorg,localtaxorg,isabroad,isvirtualnode,commitername,commiterphone,grouproll,superorgname,ispointcompany,ispubliccompany,stockno", (QFilter[])new QFilter[]{new QFilter("id", "=", currentSelectedRowInfo.getPrimaryKeyValue())});
        Map customMap = this.getView().getFormShowParameter().getCustomParams();
        customMap.put("org", rowData.getString("org"));
        customMap.put("id", rowData.getLong("id"));
        customMap.put("groupplan.name", rowData.getString("groupplan.name"));
        customMap.put("superorgname", rowData.getString("superorgname"));
        customMap.put("registertype", rowData.getString("registertype"));
        customMap.put("codeandname", rowData.getString("codeandname"));
        this.showBill(rowData.getLong("id"), customMap);
    }

    private void showBill(Object pkId, Map<String, Object> customParams) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setCustomParams(customParams);
        if (pkId != null) {
            billShowParameter.setPkId(pkId);
            billShowParameter.setBillStatus(BillOperationStatus.EDIT);
        } else {
            billShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
        }
        billShowParameter.setFormId("tcvvt_roll_list");
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tcvvt_roll_list"));
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private String getReflectData(CommonFilterColumn commonFilterColumn) {
        if (!BOOLEAN_TRUE.equals(this.getPageCache().get(VIEW_CACHE_ID))) {
            return "1";
        }
        String string = null;
        try {
            if (commonFilterColumn != null) {
                Field selectedCommomFilterFieldValues = commonFilterColumn.getClass().getDeclaredField(FILTER_SELECTED_ITEM_KEY);
                AccessibleObject.setAccessible(new AccessibleObject[]{selectedCommomFilterFieldValues}, true);
                List list = (List)selectedCommomFilterFieldValues.get(commonFilterColumn);
                if (list != null && list.size() > 0) {
                    string = (String)list.get(0);
                }
            }
        }
        catch (Exception e) {
            logger.warn("getReflectData failed");
        }
        return string;
    }

    private DynamicObjectCollection getGroupPlanListDateSet(int isValid) {
        QFilter qFilter;
        Date now = new Date();
        if (isValid == 0) {
            qFilter = null;
        } else if (isValid == 1) {
            QFilter subQfilter = QFilter.isNotNull((String)"enddate").and(new QFilter("enddate", ">=", (Object)now));
            QFilter subQfilter2 = QFilter.isNull((String)"enddate").or(subQfilter);
            qFilter = new QFilter("startdate", "<=", (Object)now).and(subQfilter2);
        } else {
            qFilter = new QFilter("startdate", ">=", (Object)now).or(new QFilter("enddate", "<=", (Object)now));
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tcvvt_group_book", (String)"id,name", (QFilter[])new QFilter[]{qFilter, new QFilter("status", "=", (Object)"2")});
        return query;
    }
}

