/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.sharedplan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.impl.DataMutexImpl;
import kd.bos.org.api.IOrgService;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.finance.TcvvtCategoryInfoBusinessImpl;
import kd.taxc.bdtaxr.common.helper.bos.user.UserDataServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcvvt.business.taxorg.TcvvtTaxOrgCommonBusiness;
import kd.taxc.tcvvt.common.helper.OrgServiceHelper;
import kd.taxc.tcvvt.common.util.DynamicObjectCollectionUtil;
import kd.taxc.tcvvt.common.util.OrgUtils;
import kd.taxc.tcvvt.common.util.PermissionUtils;
import org.apache.commons.collections.CollectionUtils;

public class SharingPlanPlugin
extends AbstractFormPlugin
implements SelectRowsEventListener,
BeforeF7SelectListener,
SearchEnterListener {
    private static final Log LOGGER = LogFactory.getLog(SharingPlanPlugin.class);
    private static final String systemType = "taxc-tcvvt";
    private static final String REFRESH = "refresh";
    private static final String IMPORTDATA = "importdata";
    private static final String EXPORTDATA = "exportdata";
    private static final String SAVE = "save1";
    private static final String INDEX = "index";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String ORG = "org";
    private static final String RULE = "rule";
    private static final String ACCOUNTSTANDARD = "accountstandard";
    private static final String AUTOSHARE = "autoshare";
    private static final String CREATEORG = "createorg";
    private static final String PLANENTITY = "planentity";
    private static final String RULEENTITY = "ruleentity";
    private static final String ORGENTITY = "orgentity";
    private static final String OPT_PLANADD = "planadd";
    private static final String OPT_PLANDEL = "plandel";
    private static final String NEWROW = "newRow";
    private static final String OLDROW = "oldRow";
    private static final String ITEM_CLOSE = "bar_close";
    private static final String CARDSWITCH = "cardSwitch";
    private List<String> lockOperate = Arrays.asList("save", "plandel");
    private static final String SEARCHAP = "searchap";
    private static final String ACCOUNTSTANDARD_CHANGE = "accountstandard_change";
    private static Map<String, String> MAP;
    private static final String[] fieldNames;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"labelcreate"});
        Toolbar toolbarMain = (Toolbar)this.getControl("toolbarap");
        toolbarMain.addItemClickListener((ItemClickListener)this);
        OrgEdit taxOrgEdit = (OrgEdit)this.getControl(ORG);
        taxOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        OrgEdit taxCreateOrgEdit = (OrgEdit)this.getControl(CREATEORG);
        taxCreateOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit ruleEdit = (BasedataEdit)this.getControl(RULE);
        ruleEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        OrgEdit createOrgEdit = (OrgEdit)this.getControl(CREATEORG);
        createOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Search search = (Search)this.getControl(SEARCHAP);
        search.addEnterListener((SearchEnterListener)this);
        search.addClickListener((ClickListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u8d22\u52a1\u62a5\u8868\u5171\u4eab\u65b9\u6848", (String)"SharingPlanPlugin_0", (String)systemType, (Object[])new Object[0]));
    }

    public void initialize() {
        CardEntry planentity = (CardEntry)this.getControl(PLANENTITY);
        planentity.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put("init", "true");
        this.loadFormData();
        this.checkPermission();
    }

    public void afterBindData(EventObject e) {
        String delete = this.getPageCache().get("delete");
        String saveNumber = this.getPageCache().get("saveNomber");
        if (ObjectUtils.isEmpty((Object)delete)) {
            this.selectListRow(0);
        } else if ("true".equalsIgnoreCase(delete)) {
            String deleteAfterSelectRow = this.getPageCache().get("deleteAfterSelectRow");
            this.selectListRow(Integer.parseInt(deleteAfterSelectRow));
            this.getPageCache().put("delete", null);
        }
        if (!ObjectUtils.isEmpty((Object)saveNumber)) {
            this.getModel().updateCache();
            DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity(PLANENTITY);
            DynamicObject entryEntity = null;
            int size = entryEntitys.size();
            for (int i = 0; i < size; ++i) {
                entryEntity = (DynamicObject)entryEntitys.get(i);
                if (!entryEntity.getString("carnumber").equalsIgnoreCase(saveNumber)) continue;
                this.selectListRow(i);
                this.getPageCache().put("saveNomber", null);
                break;
            }
        }
        this.setVisible();
    }

    public void search(SearchEnterEvent event) {
        String searchText = event.getText();
        if (kd.taxc.tcvvt.common.util.StringUtil.equalsIgnoreCase((CharSequence)this.getPageCache().get("currentSearch"), (CharSequence)searchText)) {
            this.selectListRowAndPutCache();
        } else {
            this.generateCardIndexs(searchText);
            this.selectListRowAndPutCache();
        }
    }

    private void generateCardIndexs(String searchText) {
        this.getPageCache().put("currentSearch", searchText);
        ArrayList<Integer> list = new ArrayList<Integer>();
        HashMap map = new HashMap();
        String text = "%" + searchText + "%";
        QFilter nameQ = new QFilter(NAME, "like", (Object)text);
        QFilter numberQ = new QFilter(NUMBER, "like", (Object)text);
        QFilter accountstandardQ = new QFilter(ACCOUNTSTANDARD, "like", (Object)text);
        DataSet dataSet = this.buildDataSet();
        DataSet tempDataSet = dataSet.filter(nameQ.or(numberQ).or(accountstandardQ).toString());
        for (Row row : tempDataSet) {
            list.add(row.getInteger(INDEX));
        }
        tempDataSet.close();
        Collections.sort(list);
        Stream.iterate(0, i -> i + 1).limit(list.size()).forEach(i -> {
            Integer cfr_ignored_0 = (Integer)map.put(String.valueOf(i), list.get((int)i));
        });
        this.getPageCache().put("cardIndexs", SerializationUtils.toJsonString(map));
        if (!map.isEmpty()) {
            this.getPageCache().put("focusCardIndex", "-1");
        }
    }

    public List<String> getSearchList(SearchEnterEvent evt) {
        String searchText = evt.getText();
        this.generateCardIndexs(searchText);
        return this.filterDataSet(searchText);
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        List newRows = evt.getNewRows();
        List oldRows = evt.getOldRows();
        if (newRows != null && newRows.size() > 0) {
            Integer newRowIndex = (Integer)newRows.get(0);
            Integer oldRowIndex = (Integer)oldRows.get(0);
            if (this.checkChangeData((Integer)evt.getOldRows().get(0)) && !newRowIndex.equals(oldRowIndex)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CARDSWITCH, (IFormPlugin)this);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
                btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"SharingPlanPlugin_1", (String)systemType, (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"SharingPlanPlugin_2", (String)systemType, (Object[])new Object[0]));
                MessageBoxOptions options = MessageBoxOptions.YesNo;
                String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"SharingPlanPlugin_3", (String)systemType, (Object[])new Object[0]);
                this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
                this.getPageCache().put(NEWROW, String.valueOf(newRowIndex));
                this.getPageCache().put(OLDROW, String.valueOf(oldRowIndex));
                return;
            }
            this.getPageCache().put(NEWROW, String.valueOf(newRowIndex));
            this.getPageCache().put(OLDROW, newRowIndex.equals(oldRowIndex) ? String.valueOf(this.getPageCache().get(OLDROW)) : String.valueOf(oldRowIndex));
            this.resetPlanName(newRowIndex);
            this.getPageCache().put(OLDROW, String.valueOf(newRowIndex));
            this.requireLock(this.getSelectRowObj(newRowIndex));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (kd.taxc.tcvvt.common.util.StringUtil.equalsIgnoreCase((CharSequence)evt.getItemKey(), (CharSequence)ITEM_CLOSE) && this.checkChangeData(this.getSelectRows())) {
            evt.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ITEM_CLOSE, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"SharingPlanPlugin_1", (String)systemType, (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"SharingPlanPlugin_2", (String)systemType, (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.YesNo;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"SharingPlanPlugin_3", (String)systemType, (Object[])new Object[0]);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)REFRESH)) {
            this.getView().invokeOperation(REFRESH);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)IMPORTDATA)) {
            this.importData("tcvvt_sharingplan", this.getView().getFormShowParameter().getFormConfig().getCaption().getLocaleValue());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)EXPORTDATA)) {
            this.showExportDataForm("tcvvt_sharingplan");
        }
    }

    private void showExportDataForm(String entitynumber) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId(entitynumber);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setMarginRight("500");
        styleCss.setMarginLeft("500");
        styleCss.setWidth("1150");
        styleCss.setHeight("600");
        listShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EXPORTDATA));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (kd.taxc.tcvvt.common.util.StringUtil.equalsIgnoreCase((CharSequence)actionId, (CharSequence)IMPORTDATA)) {
            this.getView().invokeOperation(REFRESH);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (kd.taxc.tcvvt.common.util.StringUtil.equalsIgnoreCase((CharSequence)beforeF7SelectEvent.getProperty().getName(), (CharSequence)ORG)) {
            DynamicObject accountStandard = (DynamicObject)this.getModel().getValue(ACCOUNTSTANDARD);
            if (accountStandard == null) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4f1a\u8ba1\u51c6\u5219\u6216\u5236\u5ea6\u201d\u3002", (String)"SharingPlanPlugin_4", (String)systemType, (Object[])new Object[0]));
                return;
            }
            List<Long> permOrgs = this.getPermOrgs();
            QFilter filter = null;
            if (!ObjectUtils.isEmpty(permOrgs)) {
                filter = new QFilter("id", "in", permOrgs);
            }
            DynamicObjectCollection collection = OrgServiceHelper.queryEnableOrgs("id", filter);
            List orgIds = collection.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            List ids1 = TcvvtCategoryInfoBusinessImpl.querycwbbCategoryInfoByOrgIds(orgIds);
            QFilter qFilter = new QFilter("accountingstandards", "=", accountStandard.get("id"));
            qFilter.and(new QFilter("taxorg", "in", (Object)ids1));
            DynamicObjectCollection taxOrg = OrgUtils.queryTaxOrg("orgid.id as id", qFilter);
            HashSet ids = new HashSet();
            DynamicObjectCollection allPlan = this.getModel().getEntryEntity(PLANENTITY);
            allPlan.stream().forEach(plan -> ids.addAll(DynamicObjectCollectionUtil.getPkValueSet(plan.getDynamicObjectCollection(ORGENTITY), "org.id")));
            DynamicObject createOrg = (DynamicObject)this.getModel().getValue(CREATEORG);
            Long createOrgID = createOrg == null ? null : Long.valueOf(createOrg.getLong("id"));
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(createOrgID);
            List subOrgs = ((IOrgService)ServiceFactory.getService(IOrgService.class)).getAllSubordinateOrgs("40", list, true);
            Long accountstandard = ((DynamicObject)this.getModel().getValue(ACCOUNTSTANDARD)).getLong("id");
            List orgids = TcvvtCategoryInfoBusinessImpl.filterAccountstandardByOrgIds((List)subOrgs, (Long)accountstandard);
            QFilter inOrgFilter = new QFilter("id", "in", taxOrg.stream().map(o -> o.getLong("id")).collect(Collectors.toList()));
            QFilter notInOrgFilter = new QFilter("id", "not in", ids);
            QFilter subOrgFilter = new QFilter("id", "in", (Object)orgids);
            beforeF7SelectEvent.getCustomQFilters().add(inOrgFilter);
            beforeF7SelectEvent.getCustomQFilters().add(notInOrgFilter);
            beforeF7SelectEvent.getCustomQFilters().add(subOrgFilter);
        } else if (kd.taxc.tcvvt.common.util.StringUtil.equalsIgnoreCase((CharSequence)beforeF7SelectEvent.getProperty().getName(), (CharSequence)RULE)) {
            DynamicObject accountStandard = (DynamicObject)this.getModel().getValue(ACCOUNTSTANDARD);
            if (accountStandard == null) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4f1a\u8ba1\u51c6\u5219\u6216\u5236\u5ea6\u201d\u3002", (String)"SharingPlanPlugin_4", (String)systemType, (Object[])new Object[0]));
                return;
            }
            QFilter accountstandardFilter = new QFilter(ACCOUNTSTANDARD, "=", accountStandard.get("id"));
            DynamicObjectCollection rules = this.getModel().getEntryEntity(RULEENTITY);
            Set ids = rules.stream().filter(object -> object.getPkValue() != null && object.getDynamicObject(RULE) != null).map(o -> o.getDynamicObject(RULE).get("accessproject.id")).collect(Collectors.toSet());
            QFilter notInOrgFilter = new QFilter("accessproject.id", "not in", ids);
            beforeF7SelectEvent.getCustomQFilters().add(accountstandardFilter);
            beforeF7SelectEvent.getCustomQFilters().add(notInOrgFilter);
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("openType", (Object)"openbyf7");
        } else if (kd.taxc.tcvvt.common.util.StringUtil.equalsIgnoreCase((CharSequence)beforeF7SelectEvent.getProperty().getName(), (CharSequence)CREATEORG)) {
            DynamicObject accountStandard = (DynamicObject)this.getModel().getValue(ACCOUNTSTANDARD);
            if (accountStandard == null) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4f1a\u8ba1\u51c6\u5219\u6216\u5236\u5ea6\u201d\u3002", (String)"SharingPlanPlugin_4", (String)systemType, (Object[])new Object[0]));
                return;
            }
            List<Long> orgIds = TcvvtTaxOrgCommonBusiness.queryTaxcOrgIdsWithPerm(RequestContext.get().getCurrUserId());
            QFilter idQFilter = new QFilter("id", "in", orgIds);
            beforeF7SelectEvent.getCustomQFilters().add(idQFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject row;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        int rowIndex = this.getSelectRows();
        if (this.lockOperate.contains(operateKey) && !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)(row = this.getSelectRowObj(rowIndex))) && this.checkLock(String.valueOf(row.getLong("id")))) {
            args.setCancel(true);
            return;
        }
        if (source instanceof NewEntry && kd.taxc.tcvvt.common.util.StringUtil.equalsIgnoreCase((CharSequence)((NewEntry)source).getOperateKey(), (CharSequence)OPT_PLANADD) && this.checkChangeData(this.getSelectRows())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u8bf7\u5148\u4fdd\u5b58\u540e\u518d\u65b0\u589e\u5171\u4eab\u65b9\u6848\u3002", (String)"SharingPlanPlugin_5", (String)systemType, (Object[])new Object[0]));
            args.setCancel(true);
        } else if (source instanceof DeleteEntry && kd.taxc.tcvvt.common.util.StringUtil.equalsIgnoreCase((CharSequence)((DeleteEntry)source).getOperateKey(), (CharSequence)OPT_PLANDEL)) {
            row = (DynamicObject)this.getModel().getEntryEntity(PLANENTITY).get(this.getSelectRows());
            Long planId = row.getLong("id");
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"tcvvt_sharingplan"), (Object[])new Object[]{planId});
            int i = row.getInt(1) - 1;
            CardEntry planCardEntry = (CardEntry)this.getControl(PLANENTITY);
            int entryCount = this.getModel().getEntryRowCount(PLANENTITY);
            if (entryCount == 0 || row.getInt(1) + 1 > entryCount) {
                i = 0;
            }
            this.getPageCache().put("delete", "true");
            this.getPageCache().put("deleteAfterSelectRow", String.valueOf(i));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        this.setVisible();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        int selectRow = this.getSelectRows();
        if (kd.taxc.tcvvt.common.util.StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)OPT_PLANADD)) {
            this.selectListRow(selectRow);
            String number = this.getCodeRuleNumber(this.getModel().getValue(ACCOUNTSTANDARD, selectRow));
            this.getModel().setValue(NUMBER, (Object)number, selectRow);
            this.getModel().setValue(MAP.get(NUMBER), (Object)number, selectRow);
            Long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
            Long accountstandard = TcvvtCategoryInfoBusinessImpl.getAccountstandardByOrgId((Long)rootOrgId);
            this.getModel().setValue(CREATEORG, (Object)rootOrgId, selectRow);
            this.getModel().setValue(ACCOUNTSTANDARD, (Object)accountstandard, selectRow);
            this.getModel().setValue(MAP.get(CREATEORG), (Object)rootOrgId, selectRow);
            this.getModel().setEntryCurrentRowIndex(PLANENTITY, selectRow);
            this.getModel().createNewEntryRow(RULEENTITY);
            this.getModel().createNewEntryRow(ORGENTITY);
        } else if (kd.taxc.tcvvt.common.util.StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)OPT_PLANDEL)) {
            this.getView().invokeOperation(REFRESH);
        } else if (kd.taxc.tcvvt.common.util.StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)SAVE)) {
            OperationResult result = afterDoOperationEventArgs.getOperationResult();
            int select = this.getSelectRows();
            if (result.isSuccess()) {
                this.getModel().setDataChanged(false);
                this.save();
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Label && "labelcreate".equals(((Label)source).getKey())) {
            Button button = (Button)this.getControl("button_addplan");
            button.click();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int selectRow;
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (kd.taxc.tcvvt.common.util.StringUtil.equalsIgnoreCase((CharSequence)key, (CharSequence)ACCOUNTSTANDARD)) {
            if (null == newValue) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u4f1a\u8ba1\u51c6\u5219\u6216\u5236\u5ea6\u201d\u3002", (String)"SharingPlanPlugin_4", (String)systemType, (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put("samerow_accountstandard_value", ((DynamicObject)this.getModel().getValue(MAP.get(key), this.getSelectRows())).getString("id"));
        }
        if (MAP.containsKey(key) && (selectRow = this.getSelectRows()) >= 0) {
            if (newValue instanceof LocaleDynamicObjectCollection) {
                this.getModel().setValue(MAP.get(key), (Object)this.getLangValue(newValue), selectRow);
            } else {
                this.getModel().setValue(MAP.get(key), newValue, selectRow);
            }
            if (kd.taxc.tcvvt.common.util.StringUtil.equalsIgnoreCase((CharSequence)key, (CharSequence)ACCOUNTSTANDARD) && kd.taxc.tcvvt.common.util.StringUtil.equalsIgnoreCase((CharSequence)this.getPageCache().get(NEWROW), (CharSequence)this.getPageCache().get(OLDROW))) {
                DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
                this.showConfirmTips(key, oldValue, newValue);
            }
        }
        if (CREATEORG.equalsIgnoreCase(key)) {
            this.getModel().deleteEntryData(ORGENTITY);
            if (!ObjectUtils.isEmpty((Object)this.getModel().getValue(CREATEORG))) {
                Long creatorgid = ((DynamicObject)this.getModel().getValue(CREATEORG)).getLong("id");
                Long accountstandard = TcvvtCategoryInfoBusinessImpl.getAccountstandardByOrgId((Long)creatorgid);
                this.getModel().setValue(ACCOUNTSTANDARD, (Object)accountstandard);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String fieldKey = messageBoxClosedEvent.getCallBackId();
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)ACCOUNTSTANDARD)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getPageCache().put(ACCOUNTSTANDARD_CHANGE, "false");
                this.getModel().deleteEntryData(RULEENTITY);
                this.getModel().deleteEntryData(ORGENTITY);
                this.getModel().createNewEntryRow(RULEENTITY);
                this.getModel().createNewEntryRow(ORGENTITY);
                int selectRow = this.getSelectRows();
                String newNumber = this.getCodeRuleNumber(this.getModel().getDataEntity().getDynamicObject(ACCOUNTSTANDARD).get("id"));
                this.getModel().setValue(MAP.get(NUMBER), (Object)newNumber, selectRow);
                this.getModel().setValue(NUMBER, (Object)newNumber, selectRow);
                this.getPageCache().put("init", "false");
            } else {
                this.getPageCache().put(ACCOUNTSTANDARD_CHANGE, "true");
                this.getModel().setValue(fieldKey, (Object)this.getPageCache().get(fieldKey));
                this.getModel().setValue(NUMBER, (Object)this.getPageCache().get(NUMBER));
            }
        } else if (kd.taxc.tcvvt.common.util.StringUtil.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)ITEM_CLOSE)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getView().close();
            }
        } else if (kd.taxc.tcvvt.common.util.StringUtil.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)CARDSWITCH)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                DynamicObject oldObject;
                String oldRow = this.getPageCache().get(OLDROW);
                DynamicObjectCollection collection = this.getModel().getEntryEntity(PLANENTITY);
                Map planCacheMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(PLANENTITY), Map.class);
                Map map = (Map)planCacheMap.get((oldObject = (DynamicObject)collection.get(Integer.parseInt(oldRow))).getString("id"));
                if (null != map) {
                    List planList = (List)map.get(PLANENTITY);
                    List ruleList = (List)map.get(RULEENTITY);
                    List orgList = (List)map.get(ORGENTITY);
                    oldObject.set(MAP.get(NUMBER), planList.get(0));
                    oldObject.set(MAP.get(NAME), planList.get(1));
                    oldObject.set(MAP.get(AUTOSHARE), planList.get(3));
                    String oid = oldObject.getString("id");
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(oid), (String)"tcvvt_sharingplan");
                    oldObject.set(MAP.get(ACCOUNTSTANDARD), dynamicObject.get(ACCOUNTSTANDARD));
                    this.getModel().setEntryCurrentRowIndex(PLANENTITY, Integer.parseInt(oldRow));
                    this.getModel().deleteEntryData(RULEENTITY);
                    ruleList.stream().forEach(o -> {
                        int subRowIndex = this.getModel().createNewEntryRow(RULEENTITY);
                        this.getModel().setValue(RULE, (Object)Long.valueOf(o), subRowIndex);
                    });
                    this.getModel().deleteEntryData(ORGENTITY);
                    orgList.stream().forEach(o -> {
                        int subRowIndex = this.getModel().createNewEntryRow(ORGENTITY);
                        this.getModel().setValue(ORG, (Object)Long.valueOf(o), subRowIndex);
                    });
                    this.getView().updateView(PLANENTITY);
                } else {
                    this.getModel().deleteEntryRow(PLANENTITY, Integer.parseInt(oldRow));
                }
                this.selectListRow(Integer.parseInt(this.getPageCache().get(NEWROW)));
            } else {
                this.selectListRow(Integer.parseInt(this.getPageCache().get(OLDROW)));
            }
        }
    }

    private List<String> filterDataSet(String searchText) {
        ArrayList<String> list = new ArrayList<String>();
        String text = "%" + searchText + "%";
        QFilter nameQ = new QFilter(NAME, "like", (Object)text);
        QFilter numberQ = new QFilter(NUMBER, "like", (Object)text);
        QFilter accountstandardQ = new QFilter(ACCOUNTSTANDARD, "like", (Object)text);
        DataSet dataSet = this.buildDataSet();
        DataSet nameDataSet = dataSet.filter(nameQ.toString());
        DataSet numberDataSet = dataSet.filter(numberQ.toString());
        DataSet accountstandardDataSet = dataSet.filter(accountstandardQ.toString());
        if (!nameDataSet.isEmpty()) {
            nameDataSet.forEach(o -> list.add(o.getString(NAME)));
        }
        if (!numberDataSet.isEmpty()) {
            numberDataSet.forEach(o -> list.add(o.getString(NUMBER)));
        }
        if (!accountstandardDataSet.isEmpty()) {
            accountstandardDataSet.forEach(o -> list.add(o.getString(ACCOUNTSTANDARD)));
        }
        nameDataSet.close();
        numberDataSet.close();
        accountstandardDataSet.close();
        return list;
    }

    private DataSet buildDataSet() {
        DataType[] dataTypes = new DataType[]{DataType.IntegerType, DataType.StringType, DataType.StringType, DataType.StringType};
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fieldNames, (DataType[])dataTypes);
        ArrayList<Object[]> coll = new ArrayList<Object[]>(16);
        int entryRowCount = this.getModel().getEntryRowCount(PLANENTITY);
        for (int i = 0; i < entryRowCount; ++i) {
            Object[] value = new Object[fieldNames.length];
            DynamicObject planEntry = (DynamicObject)this.getModel().getEntryEntity(PLANENTITY).get(i);
            value[0] = i;
            value[1] = planEntry.getString(MAP.get(NUMBER));
            value[2] = planEntry.getString(MAP.get(NAME));
            value[3] = planEntry.getDynamicObject(MAP.get(ACCOUNTSTANDARD)).getString("projectname");
            coll.add(value);
        }
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        DataSet dataSet = Algo.create((String)"tcvvt_sharingplan").createDataSet(new Input[]{inputs});
        return dataSet;
    }

    private void showConfirmTips(String fieldKey, DynamicObject oldValue, Object newValue) {
        if (!"true".equals(this.getPageCache().get(ACCOUNTSTANDARD_CHANGE))) {
            this.getPageCache().put(fieldKey, ObjectUtils.isEmpty((Object)oldValue) ? "" : oldValue.getString("id"));
            this.getPageCache().put(NUMBER, (String)this.getModel().getValue(NUMBER));
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(fieldKey, (IFormPlugin)this);
            DynamicObjectCollection ruleRows = this.getModel().getEntryEntity(RULEENTITY);
            DynamicObjectCollection orgRows = this.getModel().getEntryEntity(ORGENTITY);
            DynamicObject newObject = (DynamicObject)newValue;
            if (kd.taxc.tcvvt.common.util.StringUtil.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)ACCOUNTSTANDARD) && kd.taxc.tcvvt.common.util.StringUtil.equalsIgnoreCase((CharSequence)newObject.getString("id"), (CharSequence)this.getPageCache().get("samerow_accountstandard_value"))) {
                return;
            }
            if (!ObjectUtils.isEmpty((Object)ruleRows) && ruleRows.size() > 0 || !ObjectUtils.isEmpty((Object)orgRows) && orgRows.size() > 0) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u4f1a\u8ba1\u51c6\u5219\u6216\u5236\u5ea6\u5c06\u6e05\u7a7a\u5171\u4eab\u89c4\u5219\u53ca\u5171\u4eab\u7ec4\u7ec7\uff0c\u60a8\u786e\u5b9a\u8981\u4fee\u6539\u5417\uff1f", (String)"SharingPlanPlugin_6", (String)systemType, (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            } else {
                int selectRow = this.getSelectRows();
                String newNumber = this.getCodeRuleNumber(this.getModel().getDataEntity().getDynamicObject(ACCOUNTSTANDARD).get("id"));
                this.getModel().setValue(MAP.get(NUMBER), (Object)newNumber, selectRow);
                this.getModel().setValue(NUMBER, (Object)newNumber, selectRow);
            }
        } else {
            this.getPageCache().put(ACCOUNTSTANDARD_CHANGE, "false");
        }
    }

    private void resetPlanName(Integer startRowIndex) {
        DynamicObject[] planentities;
        if (-1 == startRowIndex) {
            startRowIndex = 0;
        }
        if ((planentities = this.getModel().getEntryEntity(PLANENTITY, startRowIndex.intValue(), startRowIndex + 1)) != null && planentities.length > 0) {
            this.getModel().setValue(NUMBER, planentities[0].get(MAP.get(NUMBER)));
            this.getModel().setValue(NAME, planentities[0].get(MAP.get(NAME)));
            this.getModel().setValue(ACCOUNTSTANDARD, planentities[0].get(MAP.get(ACCOUNTSTANDARD)));
            this.getModel().setValue(AUTOSHARE, planentities[0].get(MAP.get(AUTOSHARE)));
            this.getModel().beginInit();
            this.getModel().setValue(CREATEORG, planentities[0].get(MAP.get(CREATEORG)));
            this.getModel().endInit();
            if (planentities[0].getLong("id") == 0L) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{CREATEORG});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{CREATEORG});
            }
        } else {
            this.getModel().setValue(NUMBER, (Object)"");
            this.getModel().setValue(NAME, (Object)"");
            this.getModel().setValue(ACCOUNTSTANDARD, null);
        }
        this.getView().updateView(NUMBER);
        this.getView().updateView(NAME);
        this.getView().updateView(ACCOUNTSTANDARD);
        this.getView().updateView(AUTOSHARE);
        this.getModel().beginInit();
        this.getView().updateView(CREATEORG);
        this.getModel().endInit();
    }

    private void loadFormData() {
        DynamicObject[] planRows = BusinessDataServiceHelper.load((String)"tcvvt_sharingplan", (String)"id,number,name,accountstandard,creator,createtime,ruleentity,ruleentity.rule,ruleentity.id,orgentity,orgentity.org,orgentity.id,autoshare,createorg", (QFilter[])new QFilter[0], (String)"number asc");
        if (planRows.length > 0) {
            this.getModel().deleteEntryData(PLANENTITY);
            Arrays.stream(planRows).forEach(planRow -> {
                int rowIndex = this.getModel().createNewEntryRow(PLANENTITY);
                this.getModel().setValue("id", planRow.get("id"), rowIndex);
                this.getModel().setValue(MAP.get(NUMBER), planRow.get(NUMBER), rowIndex);
                this.getModel().setValue(MAP.get(NAME), planRow.get(NAME), rowIndex);
                this.getModel().setValue(MAP.get(ACCOUNTSTANDARD), planRow.get(ACCOUNTSTANDARD), rowIndex);
                this.getModel().setValue("creator", planRow.get("creator"), rowIndex);
                this.getModel().setValue("createtime", planRow.get("createtime"), rowIndex);
                this.getModel().setValue("modifier", (Object)RequestContext.get().getCurrUserId(), rowIndex);
                this.getModel().setValue("modifytime", (Object)new Date(), rowIndex);
                this.getModel().setValue(MAP.get(AUTOSHARE), (Object)planRow.getString(AUTOSHARE), rowIndex);
                this.getModel().setValue(MAP.get(CREATEORG), (Object)planRow.getDynamicObject(CREATEORG), rowIndex);
                this.getModel().setEntryCurrentRowIndex(PLANENTITY, rowIndex);
                DynamicObjectCollection ruleCol = planRow.getDynamicObjectCollection(RULEENTITY);
                ruleCol.stream().forEach(ruleRow -> {
                    int subRowIndex = this.getModel().createNewEntryRow(RULEENTITY);
                    this.getModel().setValue(RULE, ruleRow.get(RULE), subRowIndex);
                    this.getModel().setValue("ruleentryid", ruleRow.get("id"), subRowIndex);
                });
                DynamicObjectCollection orgCol = planRow.getDynamicObjectCollection(ORGENTITY);
                orgCol.stream().forEach(orgRow -> {
                    int subRowIndex = this.getModel().createNewEntryRow(ORGENTITY);
                    this.getModel().setValue(ORG, orgRow.get(ORG), subRowIndex);
                    this.getModel().setValue("orgentryid", orgRow.get("id"), subRowIndex);
                });
            });
            this.getView().updateView(RULEENTITY);
            this.getView().updateView(ORGENTITY);
        }
        this.getPageCache().put(PLANENTITY, SerializationUtils.toJsonString(this.getPlanCacheMap(planRows)));
    }

    private void setVisible() {
        int row = this.getModel().getEntryRowCount(PLANENTITY);
        if (row > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexnodata"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexdata", PLANENTITY});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexnodata"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexdata", PLANENTITY});
        }
    }

    private void save() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(PLANENTITY);
        if (collection.isEmpty()) {
            return;
        }
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            ArrayList<DynamicObject> forSaveObjArr = new ArrayList<DynamicObject>(10);
            DynamicObject row = (DynamicObject)collection.get(this.getSelectRows());
            QFilter filter1 = new QFilter("createorg.id", "=", (Object)((DynamicObject)row.get(MAP.get(CREATEORG))).getLong("id"));
            QFilter filter2 = new QFilter(AUTOSHARE, "=", (Object)"1");
            QFilter filter3 = new QFilter("id", "!=", (Object)row.getLong("id"));
            QFilter filter4 = new QFilter(ACCOUNTSTANDARD, "=", (Object)((DynamicObject)row.get(MAP.get(ACCOUNTSTANDARD))).getLong("id"));
            if (Boolean.TRUE.equals(row.get(MAP.get(AUTOSHARE))) && QueryServiceHelper.exists((String)"tcvvt_sharingplan", (QFilter[])new QFilter[]{filter1, filter2, filter3, filter4})) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u4e00\u521b\u5efa\u7ec4\u7ec7\u540c\u4e00\u4f1a\u8ba1\u51c6\u5219\u6216\u5236\u5ea6\u53ea\u5141\u8bb8\u5b58\u5728\u4e00\u5957\u81ea\u52a8\u5171\u4eab\u65b9\u6848\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SharingPlanPlugin_7", (String)systemType, (Object[])new Object[0]));
                row.set(MAP.get(AUTOSHARE), (Object)"0");
                return;
            }
            try {
                Long planId = row.getLong("id");
                DynamicObject planObject = BusinessDataServiceHelper.newDynamicObject((String)"tcvvt_sharingplan");
                if (!ObjectUtils.isEmpty((Object)planId) && planId > 0L) {
                    planObject = BusinessDataServiceHelper.loadSingle((Object)planId, (String)"tcvvt_sharingplan");
                } else {
                    planObject.set("creator", row.get("creator"));
                    planObject.set("createtime", row.get("createtime"));
                }
                planObject.set(NUMBER, row.get(MAP.get(NUMBER)));
                this.getPageCache().put("saveNomber", row.get(MAP.get(NUMBER)).toString());
                planObject.set(NAME, row.get(MAP.get(NAME)));
                planObject.set(ACCOUNTSTANDARD, ((DynamicObject)row.get(MAP.get(ACCOUNTSTANDARD))).get("id"));
                planObject.set("modifier", row.get("modifier"));
                planObject.set("modifytime", row.get("modifytime"));
                planObject.set("status", (Object)"C");
                planObject.set("enable", (Object)1);
                planObject.set(AUTOSHARE, row.get(MAP.get(AUTOSHARE)));
                planObject.set(CREATEORG, row.get(MAP.get(CREATEORG)));
                DynamicObjectCollection ruleCol = row.getDynamicObjectCollection(RULEENTITY);
                DynamicObjectCollection ruleCollection = planObject.getDynamicObjectCollection(RULEENTITY);
                ruleCollection.clear();
                Stream.iterate(0, i -> i + 1).limit(ruleCol.size()).forEach(index -> {
                    DynamicObject rule = (DynamicObject)ruleCol.get(index.intValue());
                    DynamicObject ruleRow = ruleCollection.addNew();
                    ruleRow.set("seq", index);
                    ruleRow.set("id", rule.get("ruleentryid"));
                    ruleRow.set(RULE, ((DynamicObject)rule.get(RULE)).get("id"));
                });
                DynamicObjectCollection orgCol = row.getDynamicObjectCollection(ORGENTITY);
                DynamicObjectCollection orgCollection = planObject.getDynamicObjectCollection(ORGENTITY);
                orgCollection.clear();
                Stream.iterate(0, i -> i + 1).limit(orgCol.size()).forEach(index -> {
                    DynamicObject org = (DynamicObject)orgCol.get(index.intValue());
                    DynamicObject orgRow = orgCollection.addNew();
                    orgRow.set("seq", index);
                    orgRow.set("id", org.get("orgentryid"));
                    orgRow.set(ORG, ((DynamicObject)org.get(ORG)).get("id"));
                });
                forSaveObjArr.add(planObject);
                OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"tcvvt_sharingplan", (DynamicObject[])forSaveObjArr.toArray(new DynamicObject[forSaveObjArr.size()]), (OperateOption)OperateOption.create());
                if (result.isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SharingPlanPlugin_8", (String)systemType, (Object[])new Object[0]), Integer.valueOf(3000));
                    this.getView().invokeOperation(REFRESH);
                } else {
                    List errors = result.getAllErrorInfo();
                    List vas = result.getValidateResult().getValidateErrors();
                    StringBuilder error = new StringBuilder(result.getMessage());
                    for (OperateErrorInfo opError : errors) {
                        error.append(opError.getMessage());
                    }
                    for (ValidateResult va : vas) {
                        for (OperateErrorInfo operr : va.getAllErrorInfo()) {
                            error.append(operr.getMessage());
                        }
                    }
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%1$s", (String)"SharingPlanPlugin_9", (String)systemType, (Object[])new Object[0]), error));
                }
            }
            catch (Throwable e1) {
                LOGGER.error(e1);
                h.markRollback();
                throw e1;
            }
        }
    }

    private void selectListRow(int rowIndex) {
        CardEntry planCardEntry = (CardEntry)this.getControl(PLANENTITY);
        int entryCount = this.getModel().getEntryRowCount(PLANENTITY);
        if (entryCount == 0 || rowIndex + 1 > entryCount) {
            return;
        }
        int nowRow = this.getSelectRows();
        planCardEntry.selectCard(Integer.valueOf(rowIndex));
        planCardEntry.selectRowsChanged(Collections.singletonList(rowIndex), Collections.singletonList(nowRow));
    }

    private int getSelectRows() {
        int rowIndex = 0;
        EntryGrid planEntry = (EntryGrid)this.getControl(PLANENTITY);
        int[] ids = planEntry.getSelectRows();
        if (!ObjectUtils.isEmpty((Object)ids)) {
            rowIndex = ids[0];
        }
        return rowIndex;
    }

    private String getLangValue(Object object) {
        String value = null;
        String lang = RequestContext.get().getLang().toString();
        if (object instanceof LocaleDynamicObjectCollection) {
            LocaleDynamicObjectCollection valueCol = (LocaleDynamicObjectCollection)object;
            for (DynamicObject langObj : valueCol) {
                String localeid = langObj.getString("localeid");
                String version = langObj.getString(NAME);
                if (lang == null || !lang.equals(localeid)) continue;
                value = version;
                break;
            }
        }
        return value;
    }

    private List<Long> getPermOrgs() {
        List orgIds = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"40", (boolean)false);
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(this.getView());
        if (!hasPermOrgResult.hasAllOrgPerm() && hasPermOrgResult.getHasPermOrgs().size() > 0) {
            orgIds = hasPermOrgResult.getHasPermOrgs();
        }
        return orgIds;
    }

    private String getCodeRuleNumber(Object accountstandard) {
        DynamicObject dataInfo = BusinessDataServiceHelper.newDynamicObject((String)"tcvvt_sharingplan");
        dataInfo.set(ACCOUNTSTANDARD, accountstandard);
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        String number = codeRuleService.readNumber("tcvvt_sharingplan", dataInfo, null);
        return number;
    }

    private void importData(String entityId, String entityName) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_importstart");
        showParameter.setCustomParam("BillFormId", (Object)entityId);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        ArrayList plugins = new ArrayList();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("Enabled", Boolean.TRUE);
        plugins.add(map);
        showParameter.setCustomParam("ListName", (Object)entityName);
        showParameter.setCustomParam("plugins", plugins);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORTDATA));
        this.getView().showForm(showParameter);
    }

    private boolean checkChangeData(int row) {
        DynamicObject planRow;
        boolean change = false;
        DynamicObjectCollection collection = this.getModel().getEntryEntity(PLANENTITY);
        if (collection.isEmpty()) {
            return change;
        }
        Map planCacheMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(PLANENTITY), Map.class);
        Map map = (Map)planCacheMap.get((planRow = (DynamicObject)collection.get(row)).getString("id"));
        if (null == map) {
            change = true;
        } else {
            List<String> planList = Arrays.asList(planRow.getString(MAP.get(NUMBER)), planRow.getString(MAP.get(NAME)), planRow.getString("caraccountstandard.id"), planRow.getString(MAP.get(AUTOSHARE)), planRow.getString("carcreateorg.id"));
            ArrayList ruleList = new ArrayList();
            ArrayList orgList = new ArrayList();
            DynamicObjectCollection ruleCol = planRow.getDynamicObjectCollection(RULEENTITY);
            ruleCol.stream().forEach(ruleRow -> ruleList.add(ruleRow.getString("rule.id")));
            DynamicObjectCollection orgCol = planRow.getDynamicObjectCollection(ORGENTITY);
            orgCol.stream().forEach(orgRow -> orgList.add(orgRow.getString("org.id")));
            List planCacheList = (List)map.get(PLANENTITY);
            List ruleCacheList = (List)map.get(RULEENTITY);
            List orgCacheList = (List)map.get(ORGENTITY);
            if (!(CollectionUtils.isEqualCollection(planList, (Collection)planCacheList) && CollectionUtils.isEqualCollection(ruleList, (Collection)ruleCacheList) && CollectionUtils.isEqualCollection(orgList, (Collection)orgCacheList))) {
                change = true;
            }
        }
        return change;
    }

    private Map<String, Map<String, List<String>>> getPlanCacheMap(DynamicObject[] rows) {
        HashMap<String, Map<String, List<String>>> planCacheMap = new HashMap<String, Map<String, List<String>>>();
        Arrays.stream(rows).forEach(planRow -> {
            HashMap<String, List<String>> planEntityMap = new HashMap<String, List<String>>();
            ArrayList ruleList = new ArrayList();
            ArrayList orgList = new ArrayList();
            DynamicObjectCollection ruleCol = planRow.getDynamicObjectCollection(RULEENTITY);
            ruleCol.stream().forEach(ruleRow -> ruleList.add(ruleRow.getString("rule.id")));
            DynamicObjectCollection orgCol = planRow.getDynamicObjectCollection(ORGENTITY);
            orgCol.stream().forEach(orgRow -> orgList.add(orgRow.getString("org.id")));
            planEntityMap.put(PLANENTITY, Arrays.asList(planRow.getString(NUMBER), planRow.getString(NAME), planRow.getString("accountstandard.id"), planRow.getString(AUTOSHARE), planRow.getString("createorg.id")));
            planEntityMap.put(RULEENTITY, ruleList);
            planEntityMap.put(ORGENTITY, orgList);
            planCacheMap.put(planRow.getString("id"), planEntityMap);
        });
        return planCacheMap;
    }

    private void checkPermission() {
        if (!PermissionUtils.hasSpecificPerm(this.getView(), "4730fc9f000003ae")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{IMPORTDATA});
        }
        if (!PermissionUtils.hasSpecificPerm(this.getView(), "4730fc9f000004ae")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{EXPORTDATA});
        }
    }

    private void selectListRowAndPutCache() {
        Map map = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("cardIndexs"), Map.class);
        if (!map.isEmpty()) {
            Integer focusCardIndex = Integer.valueOf(this.getPageCache().get("focusCardIndex"));
            if (map.size() - 1 > focusCardIndex) {
                String nextFocusCardIndex = String.valueOf(focusCardIndex + 1);
                this.selectListRow((Integer)map.get(nextFocusCardIndex));
                this.getPageCache().put("focusCardIndex", nextFocusCardIndex);
            } else if (map.size() - 1 == focusCardIndex) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u641c\u7d22\u5230\u6700\u540e\u4e00\u884c\u3002", (String)"SharingPlanPlugin_10", (String)systemType, (Object[])new Object[0]));
            }
        }
    }

    public void pageRelease(EventObject e) {
        this.releaseLock();
    }

    protected boolean checkLock(String objectId) {
        if (StringUtil.isEmpty((CharSequence)objectId)) {
            return false;
        }
        DataMutexImpl dataMutex = new DataMutexImpl();
        Map lockInfo = dataMutex.getLockInfo(objectId, "default_netctrl", this.getSharePlanEntityName());
        if (lockInfo != null && !((String)lockInfo.get("userid")).equals(String.valueOf(RequestContext.get().getCurrUserId()))) {
            String username = "";
            TaxResult result = UserDataServiceHelper.queryUserNameByIds((Long)Long.valueOf((String)lockInfo.get("userid")));
            if (result != null && result.isSuccess()) {
                username = (String)result.getData();
            }
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"SharingPlanPlugin_11", (String)systemType, (Object[])new Object[0]), username));
            return true;
        }
        return false;
    }

    protected void requireLock(DynamicObject object) {
        if (object == null) {
            return;
        }
        this.releaseLock();
        if (object.getLong("id") == 0L) {
            return;
        }
        String objectId = String.valueOf(object.getLong("id"));
        boolean newMutexLocked = MutexHelper.require((String)this.getSharePlanEntityName(), (Object)objectId, (String)"modify", (boolean)Boolean.FALSE, (StringBuilder)new StringBuilder());
        if (!newMutexLocked) {
            if (this.checkLock(objectId)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"flexdata"});
            }
        } else {
            this.getPageCache().put("id_lock", objectId);
            this.getView().setEnable(Boolean.TRUE, new String[]{"flexdata"});
        }
    }

    protected void releaseLock() {
        DataMutexImpl dataMutex;
        Map lockInfo;
        String lockId = this.getPageCache().get("id_lock");
        if (StringUtil.isNotEmpty((CharSequence)lockId) && !"null".equalsIgnoreCase(lockId) && (lockInfo = (dataMutex = new DataMutexImpl()).getLockInfo(lockId, "default_netctrl", this.getSharePlanEntityName())) != null && ((String)lockInfo.get("userid")).equals(String.valueOf(RequestContext.get().getCurrUserId()))) {
            MutexHelper.release((String)this.getSharePlanEntityName(), (String)"modify", (String)lockId);
        }
    }

    protected DynamicObject getSelectRowObj(int rowIndex) {
        DynamicObjectCollection planEntity = this.getModel().getEntryEntity(PLANENTITY);
        if (rowIndex < 0 || rowIndex >= planEntity.size()) {
            return null;
        }
        DynamicObject row = (DynamicObject)planEntity.get(rowIndex);
        return row;
    }

    protected String getSharePlanEntityName() {
        return "tcvvt_sharingplan";
    }

    static {
        fieldNames = new String[]{INDEX, NUMBER, NAME, ACCOUNTSTANDARD};
        MAP = new HashMap<String, String>();
        MAP.put(NAME, "carname");
        MAP.put(NUMBER, "carnumber");
        MAP.put(ACCOUNTSTANDARD, "caraccountstandard");
        MAP.put(AUTOSHARE, "carautoshare");
        MAP.put(CREATEORG, "carcreateorg");
    }
}

