/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.subject;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tcvvt.common.util.PermissionUtils;

public class KeyFieldsCheckPlugin
extends BatchImportPlugin {
    private static final String BOS_IMPORT = "bos-import";
    private static final String BOS_ORG = "bos_org";
    HashMap<String, Long> orgMaps = new HashMap(16);
    HashMap<String, List<String>> sysSetMap = new HashMap(512);

    public List<ComboItem> getOverrideFieldsConfig() {
        return super.getOverrideFieldsConfig().stream().filter(new Predicate<ComboItem>(){

            @Override
            public boolean test(ComboItem comboItem) {
                return "org".equalsIgnoreCase(comboItem.getValue()) || "nd_dm".equalsIgnoreCase(comboItem.getValue()) || "number".equalsIgnoreCase(comboItem.getValue()) || "name".equalsIgnoreCase(comboItem.getValue()) || "kmlx".equalsIgnoreCase(comboItem.getValue()) || "kmfx".equalsIgnoreCase(comboItem.getValue()) || "parent".equalsIgnoreCase(comboItem.getValue()) || "enable".equalsIgnoreCase(comboItem.getValue()) || "datasource".equalsIgnoreCase(comboItem.getValue());
            }
        }).collect(Collectors.toList());
    }

    protected ApiResult save(List<ImportBillData> datas, ImportLogger importlogs) {
        Map option = this.ctx.getOption();
        if (!"new".equals(option.get("importtype").toString())) {
            boolean selectFields;
            String keyFields = option.get("KeyFields").toString();
            boolean bl = selectFields = keyFields.contains("org") && keyFields.contains("nd_dm") && keyFields.contains("number");
            if (!selectFields) {
                return this.mockResult(ResManager.loadKDString((String)"\u201c\u66f4\u65b0\u5df2\u6709\u6570\u636e\u201d\u3001\u201c\u66f4\u65b0\u5df2\u6709\u6570\u636e\u5e76\u6dfb\u52a0\u65b0\u6570\u636e\u201d\u65f6\uff0c\u201c\u6570\u636e\u66ff\u6362\u89c4\u5219\u201d\u7684\u552f\u4e00\u503c\u4e0b\u62c9\u9009\u9879\u4e2d\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3001\u201c\u5e74\u5ea6\u4ee3\u7801\u201d\u3001\u201c\u79d1\u76ee\u4ee3\u7801\u201d\u4e3a\u5fc5\u9009\u9879\u3002", (String)"KeyFieldsCheckPlugin_5", (String)"taxc-tcvvt", (Object[])new Object[0]));
            }
        }
        return super.save(datas, importlogs);
    }

    private ApiResult mockResult(String resultData) {
        ApiResult result = new ApiResult();
        result.setMessage(resultData);
        result.setSuccess(false);
        return result;
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        if (billdatas != null && billdatas.size() > 0) {
            HasPermOrgResult orgsByUserId = PermissionUtils.getAllPermOrgsByUserId("tcvvt", "tcvvt_clique_account", "47156aff000000ac", RequestContext.get().getCurrUserId());
            Map option = this.ctx.getOption();
            boolean newImport = !"new".equals(option.get("importtype").toString());
            int partlimit = 500;
            if (partlimit < billdatas.size()) {
                List partitionList = Lists.partition(billdatas, (int)partlimit);
                for (int i = 0; i < partitionList.size(); ++i) {
                    List partList = (List)partitionList.get(i);
                    this.checkData(partList, orgsByUserId, newImport, logger);
                }
            } else {
                this.checkData(billdatas, orgsByUserId, newImport, logger);
            }
        }
    }

    private void checkData(List<ImportBillData> partList, HasPermOrgResult orgsByUserId, boolean newImport, ImportLogger logger) {
        DynamicObject[] hsOrgs;
        HashMap map;
        ArrayList<String> orgNumbers = new ArrayList<String>(partList.size());
        for (ImportBillData idata : partList) {
            HashMap dataMap = (HashMap)JSONObject.parseObject((String)JSONObject.toJSONString((Object)idata.getData()), HashMap.class);
            Map orgMap = (Map)JSONObject.parseObject((String)JSONObject.toJSONString(((HashMap)JSONObject.parseObject((String)JSONObject.toJSONString((Object)idata.getData()), HashMap.class)).get("org")), Map.class);
            String number = orgMap.get("number").toString();
            if (this.orgMaps.containsKey(number)) continue;
            orgNumbers.add(number);
        }
        if (orgNumbers.size() > 0 && !(map = Arrays.stream(hsOrgs = BusinessDataServiceHelper.load((String)BOS_ORG, (String)"id,number,fisaccounting", (QFilter[])new QFilter[]{new QFilter("fisaccounting", "=", (Object)"1").and("number", "in", orgNumbers)})).collect(HashMap::new, (m, v) -> m.put(v.getString("number"), v.getLong("id")), HashMap::putAll)).isEmpty()) {
            this.orgMaps.putAll(map);
        }
        Iterator<ImportBillData> importdatas = partList.iterator();
        while (importdatas.hasNext()) {
            ImportBillData data = importdatas.next();
            int startIndex = data.getStartIndex();
            HashMap dataMap = (HashMap)JSONObject.parseObject((String)JSONObject.toJSONString((Object)data.getData()), HashMap.class);
            Map orgMap = (Map)JSONObject.parseObject((String)JSONObject.toJSONString(((HashMap)JSONObject.parseObject((String)JSONObject.toJSONString((Object)data.getData()), HashMap.class)).get("org")), Map.class);
            String km = dataMap.get("number").toString();
            String nd_dm = dataMap.get("nd_dm").toString();
            String number = orgMap.get("number").toString();
            if (!this.orgMaps.containsKey(number)) {
                logger.log(Integer.valueOf(startIndex), ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u662f\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"KeyFieldsCheckPlugin_2", (String)"taxc-tcvvt", (Object[])new Object[0]));
                logger.fail();
                if (!ObjectUtils.isEmpty(partList)) {
                    importdatas.remove();
                    continue;
                }
            }
            if (orgsByUserId != null && !orgsByUserId.hasAllOrgPerm()) {
                long orgId = this.orgMaps.get(number);
                List hasPermOrgs = orgsByUserId.getHasPermOrgs();
                if (!hasPermOrgs.contains(orgId)) {
                    logger.log(Integer.valueOf(startIndex), String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7528\u6237\u6388\u6743\u3002", (String)"KeyFieldsCheckPlugin_3", (String)"taxc-tcvvt", (Object[])new Object[0]), number));
                    logger.fail();
                    if (!ObjectUtils.isEmpty(partList)) {
                        importdatas.remove();
                        continue;
                    }
                }
            }
            if (!newImport) continue;
            StringBuilder sb = new StringBuilder(String.valueOf(this.orgMaps.get(number))).append(nd_dm);
            boolean flag = false;
            if (this.sysSetMap.get(sb.toString()) != null && this.sysSetMap.get(sb.toString()).contains(km)) {
                flag = true;
            } else {
                Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"tcvvt_clique_account", (String)"datasource", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)this.orgMaps.get(number)).and("nd_dm", "=", (Object)nd_dm).and("datasource", "=", (Object)"1")});
                if (!loadFromCache.isEmpty()) {
                    Collection values = loadFromCache.values();
                    List numberList = values.stream().map(o -> o.getString("number")).collect(Collectors.toList());
                    this.sysSetMap.put(sb.toString(), numberList);
                    if (numberList.contains(km)) {
                        flag = true;
                    }
                }
            }
            if (!flag) continue;
            logger.log(Integer.valueOf(startIndex), ResManager.loadKDString((String)"\u91c7\u96c6\u6570\u636e\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"KeyFieldsCheckPlugin_4", (String)"taxc-tcvvt", (Object[])new Object[0]));
            logger.fail();
            if (ObjectUtils.isEmpty(partList)) continue;
            importdatas.remove();
        }
    }
}

