/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.subject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.TemplateTreePlugin;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.taxc.tcvvt.common.util.DateUtils;
import org.apache.commons.lang3.ObjectUtils;

public class SameNumberTreePlugin
extends TemplateTreePlugin {
    private static final String CACHE_DEFAULT_ORG = "CACHE_DEFAULT_ORG";
    private static final String ENABLE = "enable";

    public void refreshNode(RefreshNodeEvent e) {
        Map customParams;
        String parentView;
        String defaultOrg = this.getPageCache().get(CACHE_DEFAULT_ORG);
        List orgId = null;
        if (!ObjectUtils.isEmpty((Object)defaultOrg)) {
            orgId = Arrays.stream(this.getPageCache().get(CACHE_DEFAULT_ORG).replace("[", "").replace("]", "").trim().split(",")).map(o -> Long.parseLong(String.valueOf(o))).collect(Collectors.toList());
        }
        String year = this.getPageCache().get("year");
        if (this.getView().getParentView() != null && ("tcvvt_voucher".equalsIgnoreCase(parentView = this.getView().getParentView().getEntityId()) || "tcvvt_clique_qcye".equalsIgnoreCase(parentView) || "tcvvt_clique_account".equalsIgnoreCase(parentView)) && StringUtils.isNotBlank((customParams = this.getView().getFormShowParameter().getCustomParams()).get(CACHE_DEFAULT_ORG)) && StringUtils.isNotBlank(customParams.get("year"))) {
            String[] orgIds = customParams.get(CACHE_DEFAULT_ORG).toString().replace("[", "").replace("]", "").trim().split(",");
            orgId = Arrays.stream(orgIds).map(o -> Long.parseLong(String.valueOf(o))).collect(Collectors.toList());
            year = customParams.get("year").toString();
        }
        if (StringUtils.isNotBlank(orgId)) {
            TreeListModel source = (TreeListModel)e.getSource();
            QFilter qFilter = new QFilter("org", "in", orgId).and("year", "=", (Object)DateUtils.stringToDate(year));
            source.getTreeFilter().add(qFilter);
            TreeListModel treeListModel = (TreeListModel)this.getTreeModel();
            treeListModel.getQueryParas().put("order", "number");
        }
    }

    public DynamicObjectCollection getChildrenDynamicObject(BeforeDoOperationEventArgs args, BasedataEntityType entityType) {
        ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
        Object[] ids = new Object[listSelectedRowCollection.size()];
        for (int i = 0; i < listSelectedRowCollection.size(); ++i) {
            ids[i] = listSelectedRowCollection.get(i).getPrimaryKeyValue();
        }
        return this.getChildrenDynamicObject(ids, entityType);
    }

    private DynamicObjectCollection getChildrenDynamicObject(Object[] ids, BasedataEntityType entityType) {
        ORM orm = ORM.create();
        String number = entityType.getNumberProperty();
        if (entityType.getProperty("longnumber") != null) {
            String entityName = entityType.getName();
            String selectFields = "id,longnumber,parent.longnumber," + number + ",enable";
            String orderBy = "longnumber desc";
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)ids)};
            DynamicObjectCollection collection = orm.query(entityName, selectFields, filters, orderBy);
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)collection.get(i);
                if (dynamicObject.getString("longnumber") == null || "".equals(dynamicObject.getString("longnumber").trim())) continue;
                list.add(dynamicObject.getString("longnumber"));
            }
            selectFields = "id,longnumber,parent.longnumber," + number + ",enable";
            QFilter baseQfilter = null;
            ParentBasedataProp parentProp = null;
            DataEntityPropertyCollection props = entityType.getProperties();
            for (Object[] prop : props) {
                if (!(prop.getParent() instanceof MainEntityType) || !(prop instanceof ParentBasedataProp)) continue;
                parentProp = (ParentBasedataProp)prop;
                break;
            }
            String longNumberDLM = ".";
            if (parentProp != null) {
                longNumberDLM = parentProp.getLongNumberDLM();
            }
            for (Object id : ids) {
                if (baseQfilter == null) {
                    baseQfilter = new QFilter("id", "=", id);
                    continue;
                }
                baseQfilter.or(new QFilter("id", "=", id));
            }
            for (int i = 0; i < list.size(); ++i) {
                if (baseQfilter == null) {
                    baseQfilter = new QFilter("longnumber", "like", (Object)((String)list.get(i) + longNumberDLM + "%"));
                    continue;
                }
                baseQfilter.or(new QFilter("longnumber", "like", (Object)((String)list.get(i) + longNumberDLM + "%")));
            }
            if (baseQfilter == null) {
                return collection;
            }
            String[] orgIds = this.getPageCache().get(CACHE_DEFAULT_ORG).replace("[", "").replace("]", "").trim().split(",");
            List orgId = Arrays.stream(orgIds).map(o -> Long.parseLong(String.valueOf(o))).collect(Collectors.toList());
            String year = this.getPageCache().get("year");
            if (StringUtils.isNotBlank(orgId)) {
                return orm.query(entityName, selectFields, new QFilter[]{baseQfilter, new QFilter("org", "in", orgId).and("year", "=", (Object)DateUtils.stringToDate(year))}, orderBy);
            }
            return orm.query(entityName, selectFields, new QFilter[]{baseQfilter}, orderBy);
        }
        return null;
    }
}

