/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.subject;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.errorcode.TaxcErrorCode;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.tcvvt.common.collection.CollectionCommonMethod;
import kd.taxc.tcvvt.common.helper.ISCDataCopyHelper;
import kd.taxc.tcvvt.common.util.DateUtils;
import kd.taxc.tcvvt.common.util.EmptyCheckUtils;

public class TcvvtCollectPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String SURE = "sure";

    public void registerListener(EventObject e) {
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        CollectionCommonMethod.setAccountancyOrgView(evt, this.getView());
    }

    public void beforeBindData(EventObject e) {
        CollectionCommonMethod.validatorAndSetOrg(this.getView(), this.getModel());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing && SURE.equals(((Donothing)args.getSource()).getOperateKey())) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            MulBasedataDynamicObjectCollection colls = (MulBasedataDynamicObjectCollection)dataEntity.get("org");
            List<Long> orgids = colls.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            String year = DateUtils.getFirstDateOfMonthStr(dataEntity.getDate("nd_dm"), "yyyy");
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            String accountLevel = dataEntity.getString("accountlevel");
            if (ObjectUtils.isEmpty((Object)accountLevel)) {
                params.put("accountLevel", 0);
            } else {
                params.put("accountLevel", Integer.parseInt(accountLevel));
            }
            params.put("year", year);
            try {
                if (EmptyCheckUtils.isNotEmpty(orgids)) {
                    DynamicObjectCollection subjectList = this.queryParentSubject(orgids);
                    Map<Object, Object> idMap = new HashMap(orgids.size());
                    Map<Object, Object> disableCollect = new HashMap(orgids.size());
                    if (EmptyCheckUtils.isNotEmpty(subjectList)) {
                        DynamicObjectCollection query;
                        Map<Object, Object> collectOrg = new HashMap(orgids.size());
                        if (EmptyCheckUtils.isNotEmpty(accountLevel) && EmptyCheckUtils.isNotEmpty(query = QueryServiceHelper.query((String)"tcvvt_clique_account", (String)"id,org,nd_dm,enable", (QFilter[])new QFilter[]{new QFilter("org", "in", orgids), new QFilter("nd_dm", "=", (Object)year)}, (String)"longnumber"))) {
                            List data;
                            idMap = query.stream().collect(Collectors.groupingBy(r -> r.getLong("org") + r.getString("nd_dm"))).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> ((List)v.getValue()).stream().map(e -> e.getLong("id")).collect(Collectors.toList())));
                            disableCollect = query.stream().filter(e -> StringUtils.equals((CharSequence)"0", (CharSequence)e.getString("enable"))).collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getString("enable"), (k1, k2) -> k1));
                            TaxResult taxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgIds(orgids);
                            if (EmptyCheckUtils.isNotEmpty(taxResult) && StringUtils.equals((CharSequence)TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), (CharSequence)taxResult.getCode()) && EmptyCheckUtils.isNotEmpty(data = (List)taxResult.getData())) {
                                collectOrg = data.stream().collect(Collectors.toMap(k -> k.getLong("org.id"), v -> v.getString("org.name"), (k1, k2) -> k1));
                            }
                        }
                        Map orgmap = subjectList.stream().collect(Collectors.groupingBy(r -> r.getLong("org"), Collectors.toList()));
                        for (Map.Entry entry : orgmap.entrySet()) {
                            Long orgid = entry.getKey();
                            if (EmptyCheckUtils.isNotEmpty(accountLevel) && EmptyCheckUtils.isNotEmpty(idMap)) {
                                if (EmptyCheckUtils.isNotEmpty(disableCollect)) {
                                    this.getView().getParentView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u79d1\u76ee\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TcvvtCollectPlugin_0", (String)"taxc-tcvvt", (Object[])new Object[0]), collectOrg.get(orgid)));
                                    return;
                                }
                                OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"tcvvt_clique_account", (Object[])((List)idMap.get(orgid + year)).toArray(new Long[0]), (OperateOption)OperateOption.create());
                                if (EmptyCheckUtils.isNotEmpty(result) && !result.isSuccess()) {
                                    this.getView().getParentView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u5e74\u5ea6\u79d1\u76ee\u5df2\u88ab\u671f\u521d\u4f59\u989d\u548c\u51ed\u8bc1\u5f15\u7528\uff0c\u8bf7\u5148\u5220\u9664\u5bf9\u5e94\u6570\u636e\u3002", (String)"TcvvtCollectPlugin_1", (String)"taxc-tcvvt", (Object[])new Object[0]), collectOrg.get(orgid), year));
                                    return;
                                }
                            }
                            params.put("orgList", Collections.singletonList(orgid));
                            for (DynamicObject subject : entry.getValue()) {
                                String itemNumber = subject.getString("number");
                                params.put("number", itemNumber);
                                ISCDataCopyHelper.asyncInvokeBizByIscFlowServiceWithParams("KDflow_CliqueAccount(IERP-IERP)", Collections.singletonList(params));
                            }
                        }
                    }
                    this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff0c\u5df2\u89e6\u53d1\u540e\u53f0\u91c7\u96c6\u4efb\u52a1\u3002", (String)"TcvvtCollectPlugin_2", (String)"taxc-tcvvt", (Object[])new Object[0]));
                }
            }
            catch (Exception ex) {
                this.getView().getParentView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u91c7\u96c6\u5931\u8d25\uff1a", (String)"TcvvtCollectPlugin_3", (String)"taxc-tcvvt", (Object[])new Object[0]), ex.getMessage()));
                return;
            }
        }
    }

    private DynamicObjectCollection queryParentSubject(List<Long> orgids) {
        QFilter orgFilter = new QFilter("org", "in", orgids);
        QFilter parentFilter = new QFilter("parent", "=", (Object)"0").or(new QFilter("parent", "=", (Object)" "));
        return QueryServiceHelper.query((String)"tdm_account", (String)"org,number", (QFilter[])new QFilter[]{orgFilter, parentFilter});
    }
}

