/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.subject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.operate.Donothing;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tcvvt.business.qhjt.QhjtCommonBusiness;
import kd.taxc.tcvvt.common.constant.PageShowCommon;
import kd.taxc.tcvvt.common.util.DateUtils;
import kd.taxc.tcvvt.common.util.ExportUtil;
import kd.taxc.tcvvt.common.util.PermissionUtils;
import kd.taxc.tcvvt.common.util.PluginUtil;

public class TcvvtSubjectListPlugin
extends AbstractListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing && "outportcsv".equals(((Donothing)args.getSource()).getOperateKey())) {
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("outportcsv", (IFormPlugin)this);
            if (selectedRows != null && selectedRows.size() > 0) {
                List pkIds = Arrays.stream(selectedRows.getPrimaryKeyValues()).distinct().collect(Collectors.toList());
                List<Long> orgCount = QhjtCommonBusiness.queryOrgCountBySubjectIds(new QFilter[]{new QFilter("id", "in", pkIds)});
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5c06\u5bfc\u51fa%1$s\u6761\u6570\u636e\uff0c\u786e\u5b9a\u662f\u5426\u5bfc\u51fa\uff1f", (String)"TcvvtSubjectListPlugin_0", (String)"taxc-tcvvt", (Object[])new Object[0]), orgCount.size(), selectedRows.size()), MessageBoxOptions.OKCancel, confirmCallBackListener);
            } else if (billlist.getCurrentListAllRowCollection().size() == 0) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5c06\u5bfc\u51fa0\u6761\u6570\u636e\uff0c\u786e\u5b9a\u662f\u5426\u5bfc\u51fa\uff1f", (String)"TcvvtSubjectListPlugin_1", (String)"taxc-tcvvt", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                args.setCancel(true);
            } else {
                QueryBuilder queryBuilder = PluginUtil.getListQueryBuilder(this, billlist);
                QFilter[] qFilters = queryBuilder.getFilters();
                DynamicObject[] configObjs = BusinessDataServiceHelper.load((String)"tcvvt_clique_account", (String)"number", (QFilter[])qFilters);
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5c06\u5bfc\u51fa%1$s\u6761\u6570\u636e\uff0c\u786e\u5b9a\u662f\u5426\u5bfc\u51fa\uff1f", (String)"TcvvtSubjectListPlugin_0", (String)"taxc-tcvvt", (Object[])new Object[0]), configObjs.length), MessageBoxOptions.OKCancel, confirmCallBackListener);
            }
        } else if (args.getSource() instanceof Donothing && Objects.equals("execresult", ((Donothing)args.getSource()).getOperateKey())) {
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("execresulttype", "KDflow_CliqueAccount(IERP-IERP)");
            PageShowCommon.showServiceFlowBillList(ShowType.MainNewTabPage, "isc_sf_proc_inst", this.getView(), customParams, null);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String fieldKey = messageBoxClosedEvent.getCallBackId();
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equalsIgnoreCase((CharSequence)"outportcsv", (CharSequence)fieldKey) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            BillList billlist = (BillList)this.getControl("billlistap");
            List pkIds = Arrays.stream(billlist.getSelectedRows().getPrimaryKeyValues()).distinct().collect(Collectors.toList());
            List orgIds = QhjtCommonBusiness.queryOrgCountBySubjectIds(new QFilter[]{new QFilter("id", "in", pkIds)});
            Map<String, String> orgMap = QhjtCommonBusiness.queryAccountingOrgByIds(orgIds);
            QueryBuilder queryBuilder = PluginUtil.getListQueryBuilder(this, billlist);
            ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
            QFilter filter = null;
            if (selectedRows != null && selectedRows.size() > 0) {
                Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
                filter = new QFilter("id", "in", (Object)primaryKeyValues);
                ExportUtil.downloadKjGroupCsvFile("tcvvt_clique_account", filter, this.getView(), queryBuilder.getOrderBys(), orgMap, orgIds);
            } else if (billlist.getCurrentListAllRowCollection().size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"TcvvtSubjectListPlugin_2", (String)"taxc-tcvvt", (Object[])new Object[0]));
            } else {
                QFilter[] filters = queryBuilder.getFilters();
                QFilter qFilter = new QFilter("1", "=", (Object)1);
                for (QFilter filter1 : filters) {
                    qFilter.and(filter1);
                }
                orgIds = billlist.getSelectedMainOrgIds();
                orgMap = QhjtCommonBusiness.queryAccountingOrgByIds(orgIds);
                ExportUtil.downloadKjGroupCsvFile("tcvvt_clique_account", qFilter, this.getView(), queryBuilder.getOrderBys(), orgMap, orgIds);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperateKey().equals("collect") && args.getOperationResult().isSuccess()) {
            FormShowParameter formshowParameter = new FormShowParameter();
            formshowParameter.setFormId("tcvvt_clique_collect");
            formshowParameter.setCaption(ResManager.loadKDString((String)"\u91c7\u96c6\u6570\u636e", (String)"TcvvtSubjectListPlugin_3", (String)"taxc-tcvvt", (Object[])new Object[0]));
            formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formshowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close"));
            HashMap param = new HashMap(12);
            List orgs = this.getControlFilters().getFilter("org.id");
            if (orgs != null && orgs.size() > 0) {
                param.put("org", orgs.get(0));
            }
            formshowParameter.setCustomParams(param);
            formshowParameter.setCustomParam("orgFuncId", (Object)"10");
            formshowParameter.setCustomParam("orgViewSchemeNumber", (Object)"10");
            this.getView().showForm(formshowParameter);
        } else if (args.getOperateKey().equals("multiorgoutportcsv") && args.getOperationResult().isSuccess()) {
            FormShowParameter formshowParameter = new FormShowParameter();
            formshowParameter.setFormId("tcvvt_multi_org_outportcs");
            formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formshowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close"));
            formshowParameter.setCustomParam("orgFuncId", (Object)"10");
            formshowParameter.setCustomParam("orgViewSchemeNumber", (Object)"10");
            this.getView().showForm(formshowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closeEvent) {
        if ("close".equals(closeEvent.getActionId())) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        List perm = new ArrayList();
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(this.getView());
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            HasPermOrgResult tcvvt = PermissionUtils.getAllPermOrgsByUserId("tcvvt", "tcvvt_clique_account", "47150e89000000ac", RequestContext.get().getCurrUserId());
            if (tcvvt != null) {
                perm = tcvvt.getHasPermOrgs();
            }
            QFilter q = new QFilter("id", "in", perm);
            args.getCustomQFilters().add(q);
        }
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        QFilter qFilter = args.getQFilter("year");
        if (qFilter != null) {
            Date startdata = (Date)qFilter.getValue();
            if (qFilter.getNests(false) != null && qFilter.getNests(false).size() > 0) {
                Date enddata = (Date)((QFilter.QFilterNest)qFilter.getNests(false).get(0)).getFilter().getValue();
                Date endresult = DateUtils.getFirstDateOfYear(DateUtils.addYear(startdata, 1));
                if (startdata.getTime() > DateUtils.getFirstDateOfYear(startdata).getTime() || enddata.getTime() != endresult.getTime()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b8c\u6574\u7684\u5e74\u5ea6\u3002", (String)"TcvvtSubjectListPlugin_4", (String)"taxc-tcvvt", (Object[])new Object[0]));
                }
                if (DateUtils.getYearOfDate(enddata) - DateUtils.getYearOfDate(startdata) > 0 && enddata.getTime() > DateUtils.getFirstDateOfYear(enddata).getTime()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u8de8\u5e74\u5ea6\u67e5\u8be2\u3002", (String)"TcvvtSubjectListPlugin_5", (String)"taxc-tcvvt", (Object[])new Object[0]));
                }
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        Object o;
        if (this.getControlFilters().getFilters().get("org.id") != null && (o = ((ControlFilter)this.getControlFilters().getFilters().get("org.id")).getValue().get(0)) != null) {
            e.getParameter().getShowParameter().getCustomParams().put("org", o);
        }
    }

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("number");
    }
}

