/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.subject;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.taxc.tcvvt.business.qhjt.QhjtCommonBusiness;
import kd.taxc.tcvvt.business.taxorg.TcvvtTaxOrgCommonBusiness;
import kd.taxc.tcvvt.common.util.DateUtils;
import kd.taxc.tcvvt.common.util.ExportUtil;
import org.apache.commons.lang3.ObjectUtils;

public class TcvvtSubjectMultiOrgOutportCsvPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        List<Long> orgList = TcvvtTaxOrgCommonBusiness.queryOrgIdByViewWithPerm(RequestContext.get().getCurrUserId(), "10");
        QFilter qFilter = new QFilter("id", "in", orgList);
        evt.getCustomQFilters().add(qFilter);
    }

    public void beforeBindData(EventObject e) {
        TcvvtSubjectMultiOrgOutportCsvPlugin.validatorAndSetOrg(this.getView(), this.getModel());
        this.getModel().setValue("nd_dm", (Object)DateUtils.addYear(new Date(), -1));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperateKey().equals("exportcsv") && args.getOperationResult().isSuccess()) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            MulBasedataDynamicObjectCollection colls = (MulBasedataDynamicObjectCollection)dataEntity.get("org");
            List<Long> orgIds = colls.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            String year = DateUtils.getFirstDateOfMonthStr(dataEntity.getDate("nd_dm"), "yyyy");
            String status = dataEntity.getString("status");
            if (ObjectUtils.isEmpty(orgIds) || ObjectUtils.isEmpty((Object)year) || ObjectUtils.isEmpty((Object)status)) {
                return;
            }
            QFilter filter = new QFilter("year", "=", (Object)DateUtils.getFirstDateOfYear(dataEntity.getDate("nd_dm")));
            if (!"2".equals(status)) {
                filter.and(new QFilter("enable", "=", (Object)status));
            }
            Map<String, String> orgMap = QhjtCommonBusiness.queryAccountingOrgByIds(orgIds);
            ExportUtil.downloadKjGroupCsvFile("tcvvt_clique_account", filter, this.getView().getParentView(), "number", orgMap, orgIds);
        }
    }

    public static void validatorAndSetOrg(IFormView view, IDataModel model) {
        Long orgId = -1L;
        List<Long> orgList = TcvvtTaxOrgCommonBusiness.queryOrgIdByViewWithPerm(RequestContext.get().getCurrUserId(), "10");
        if (ObjectUtils.isNotEmpty(orgList)) {
            long currorgId = RequestContext.get().getOrgId();
            orgId = orgList.contains(currorgId) ? Long.valueOf(currorgId) : orgList.get(0);
        }
        model.setItemValueByID("org", (Object)orgId);
    }
}

