/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.subject;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tcvvt.business.impl.SubjectQueryServiceImpl;
import kd.taxc.tcvvt.common.util.DateUtils;
import kd.taxc.tcvvt.common.util.PermissionUtils;

public class TcvvtSubjectPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String SAVE = "save";

    public void registerListener(EventObject e) {
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit fjkm = (BasedataEdit)this.getControl("parent");
        fjkm.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void initImportData(InitImportDataEventArgs e) {
        List sourceDataList = e.getSourceDataList();
        for (Map rowMap : sourceDataList) {
            if (!rowMap.containsKey("org") || !rowMap.containsKey("nd_dm") || !rowMap.containsKey("parent")) continue;
            HashMap org = (HashMap)JSONObject.parseObject((String)JSONObject.toJSONString(rowMap.get("org")), HashMap.class);
            HashMap kmdmMap = (HashMap)JSONObject.parseObject((String)JSONObject.toJSONString(rowMap.get("parent")), HashMap.class);
            String kmdm = kmdmMap.get("number").toString();
            if (!org.containsKey("number") || kmdm == null) {
                return;
            }
            String number = org.get("number").toString();
            String ndDm = rowMap.get("nd_dm").toString();
            if (ndDm.length() <= 4 && ndDm.matches("[0-9]+")) {
                if (Integer.parseInt(ndDm) < 2000 || Integer.parseInt(ndDm) > 2099) {
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5e74\u5ea6\u4ee3\u7801\u5fc5\u987b\u57282000~2099\u4e4b\u95f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TcvvtSubjectPlugin_0", (String)"taxc-tcvvt", (Object[])new Object[0]));
                    continue;
                }
                DynamicObject subject = SubjectQueryServiceImpl.getInstance().querySubject(number, ndDm, kmdm);
                JSONObject kmdmJson = (JSONObject)rowMap.get("parent");
                if (subject != null) {
                    kmdmJson.put("id", subject.get("id"));
                    continue;
                }
                kmdmJson.put("id", (Object)-1L);
                continue;
            }
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5e74\u5ea6\u4ee3\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"TcvvtSubjectPlugin_1", (String)"taxc-tcvvt", (Object[])new Object[0]));
        }
    }

    public void beforeBindData(EventObject e) {
        String datasource = this.getModel().getValue("datasource").toString();
        if (datasource != null && "1".equalsIgnoreCase(datasource)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{SAVE, "org", "year", "number", "name", "kmlx", "kmfx", "parent"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Save && SAVE.equals(((Save)args.getSource()).getOperateKey())) {
            Object pkId = this.getModel().getDataEntity().get("id");
            DynamicObject dataEntity = this.getModel().getDataEntity();
            long oid = ((DynamicObject)dataEntity.get("org")).getLong("id");
            String km = dataEntity.getString("number");
            Date year = dataEntity.getDate("year");
            dataEntity.set("nd_dm", (Object)String.valueOf(DateUtils.getYearOfDate(year)));
            DynamicObject[] subjects = BusinessDataServiceHelper.load((String)"tcvvt_clique_account", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)oid).and("year", "=", (Object)year).and("number", "=", (Object)km).and("id", "not in", pkId)});
            if (subjects != null && subjects.length > 0) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\u201c\u79d1\u76ee\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TcvvtSubjectPlugin_2", (String)"taxc-tcvvt", (Object[])new Object[0]));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("org".equals(e.getProperty().getName())) {
            this.getModel().setValue("parent", null);
        } else if ("year".equals(e.getProperty().getName())) {
            this.getModel().setValue("parent", null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if ("parent".equals(key)) {
            evt.setCancel(true);
            Date nddm = (Date)this.getModel().getValue("year");
            if (nddm != null) {
                Object value = this.getModel().getValue("org");
                if (value != null) {
                    long oid = ((DynamicObject)value).getLong("id");
                    QFilter filter = new QFilter("org", "=", (Object)oid).and("year", "=", (Object)nddm);
                    ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
                    formShowParameter.getListFilterParameter().getQFilters().add(filter);
                    ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                    qFilters.add(filter);
                    formShowParameter.getTreeFilterParameter().setQFilters(qFilters);
                    Date year = (Date)this.getModel().getValue("year");
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("CACHE_DEFAULT_ORG", String.valueOf(oid));
                    hashMap.put("year", DateUtils.format(year));
                    formShowParameter.setCustomParams(hashMap);
                    evt.setCancel(false);
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7ec4\u7ec7\u201d\u3002", (String)"TcvvtSubjectPlugin_3", (String)"taxc-tcvvt", (Object[])new Object[0]));
                }
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5e74\u5ea6\u4ee3\u7801\u201d\u3002", (String)"TcvvtSubjectPlugin_4", (String)"taxc-tcvvt", (Object[])new Object[0]));
            }
        }
    }

    public void getPermOrgResult(List<Long> ids) {
        List perm = new ArrayList();
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(this.getView());
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            HasPermOrgResult tcvvt = PermissionUtils.getAllPermOrgsByUserId("tcvvt", "tcvvt_clique_account", "47150e89000000ac", RequestContext.get().getCurrUserId());
            if (tcvvt != null) {
                perm = tcvvt.getHasPermOrgs();
            }
            ids.retainAll(perm);
        }
    }

    public void afterBindData(EventObject e) {
        Object pk = this.getModel().getDataEntity().getPkValue();
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"tcvvt_clique_account", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", pk)});
        if (load == null || load.length == 0) {
            HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(this.getView());
            if (!hasPermOrgResult.hasAllOrgPerm()) {
                boolean hasSpecificPerm = PermissionUtils.hasSpecificPerm(this.getView(), "47156aff000000ac");
                if (hasSpecificPerm) {
                    if (this.getView().getFormShowParameter().getCustomParam("org") != null) {
                        String oid = (String)this.getView().getFormShowParameter().getCustomParam("org");
                        HasPermOrgResult tcvvt = PermissionUtils.getAllPermOrgsByUserId("tcvvt", "tcvvt_clique_account", "47156aff000000ac", RequestContext.get().getCurrUserId());
                        if (tcvvt != null && tcvvt.getHasPermOrgs().contains(Long.valueOf(oid))) {
                            this.getView().getModel().setValue("org", (Object)Long.valueOf(oid));
                            this.getModel().setDataChanged(false);
                        }
                    }
                } else {
                    this.getView().getModel().setValue("org", null);
                }
            } else if (this.getView().getFormShowParameter().getCustomParam("org") != null) {
                String oid = (String)this.getView().getFormShowParameter().getCustomParam("org");
                this.getView().getModel().setValue("org", (Object)Long.valueOf(oid));
                this.getModel().setDataChanged(false);
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        HashMap parent;
        Map sourceData = e.getSourceData();
        String y = sourceData.get("nd_dm").toString();
        sourceData.put("datasource", "0");
        if (sourceData.get("parent") != null && ((parent = (HashMap)JSONObject.parseObject((String)JSONObject.toJSONString(sourceData.get("parent")), HashMap.class)).get("id") == null || "-1".equalsIgnoreCase(parent.get("id").toString()))) {
            String number = parent.get("number").toString();
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u7236\u7ea7\u79d1\u76ee\u4ee3\u7801.\u79d1\u76ee\u4ee3\u7801=%s\u5bfc\u5165\u4e0d\u6210\u529f\u3002\u7236\u7ea7\u79d1\u76ee\u4ee3\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u5bfc\u5165\u7236\u7ea7\u79d1\u76ee\u3002", (String)"TcvvtSubjectPlugin_5", (String)"taxc-tcvvt", (Object[])new Object[]{number}));
            e.setCancel(true);
        }
        if (y.length() <= 4 && y.matches("[0-9]+")) {
            if (Integer.parseInt(y) < 2000 || Integer.parseInt(y) > 2099) {
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5e74\u5ea6\u4ee3\u7801\u5fc5\u987b\u57282000~2099\u4e4b\u95f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TcvvtSubjectPlugin_0", (String)"taxc-tcvvt", (Object[])new Object[0]));
                e.setCancel(true);
            }
            sourceData.put("year", DateUtils.stringToDate(y + "-01-01"));
        } else {
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5e74\u5ea6\u4ee3\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"TcvvtSubjectPlugin_1", (String)"taxc-tcvvt", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }
}

