/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.subject;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FilterColumn;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tcvvt.common.util.DateUtils;

public class TcvvtSubjectTreeListPlugin<buildTreeListFilter>
extends AbstractTreeListPlugin {
    private static final String CACHE_DEFAULT_ORG = "CACHE_DEFAULT_ORG";
    private static final long ORG_VIEWID_TAXC_OLD = 947076820862300160L;
    private static final String VIEWID = String.valueOf(947076820862300160L);

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String flag = this.getPageCache().get("flag");
        if (flag == null) {
            List commonFilterColumns = args.getCommonFilterColumns();
            QFilter org = null;
            for (FilterColumn column : commonFilterColumns) {
                if (column.getFieldName().startsWith("org.name")) {
                    if (column.getDefaultValues().size() <= 0) continue;
                    String orgId = column.getDefaultValues().get(0).toString();
                    if (org == null) {
                        org = new QFilter("org.id", "=", (Object)Long.parseLong(orgId));
                    } else {
                        org.and("org.id", "=", (Object)Long.parseLong(orgId));
                    }
                    this.getPageCache().put(CACHE_DEFAULT_ORG, String.valueOf(orgId));
                    continue;
                }
                if (!column.getFieldName().startsWith("year") || column.getDefaultValues().size() <= 0) continue;
                int yearOfDate = DateUtils.getYearOfDate(new Date()) - 1;
                StringBuilder year = new StringBuilder(String.valueOf(yearOfDate));
                year.append("-01-01");
                if (org == null) {
                    org = new QFilter("year", "=", (Object)DateUtils.stringToDate(year.toString()));
                } else {
                    org.and("year", "=", (Object)DateUtils.stringToDate(year.toString()));
                }
                this.getPageCache().put("year", year.toString());
            }
            ITreeModel treeModel = this.getTreeModel();
            if (treeModel != null && org != null) {
                List filter = treeModel.getTreeFilter();
                filter.add(org);
                this.getTreeListView().focusRootNode();
                this.refreshTreeView();
            }
            this.getPageCache().put("flag", "refresh");
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List qFilters = args.getSearchClickEvent().getFilterParameter().getQFilters();
        Date year = null;
        for (QFilter qFilter : qFilters) {
            if (!"year".equals(qFilter.getProperty())) continue;
            year = (Date)qFilter.getValue();
            break;
        }
        QFilter org = this.getQFilter(filterValues, year);
        ITreeModel treeModel = this.getTreeModel();
        if (treeModel != null && org != null) {
            this.getTreeListView().focusRootNode();
            this.refreshTreeView();
        }
    }

    private void refreshTreeView() {
        String rid;
        TreeNode node;
        String nodeId = (String)this.getTreeModel().getCurrentNodeId();
        if (!StringUtils.isEmpty((CharSequence)nodeId) && (node = this.getTreeModel().refreshNode((Object)nodeId)) != null) {
            this.getTreeListView().getTreeView().updateNode(node);
            this.getTreeListView().getTreeView().focusNode(node);
            this.getTreeListView().getTreeView().treeNodeClick(node.getParentid(), nodeId);
        }
        if (!StringUtils.isEmpty((CharSequence)(rid = this.getTreeListView().getTreeModel().getRoot().getId()))) {
            this.getTreeModel().getRoot().setChildren(null);
            this.getTreeListView().refreshTreeView();
            this.getTreeModel().refreshNode((Object)rid);
        }
    }

    private QFilter getQFilter(Map<String, List<Map<String, List<Object>>>> filterValues, Date year) {
        List<Map<String, List<Object>>> customFiterList = filterValues.get("customfilter");
        List<Map<String, List<Object>>> schemeFilterList = filterValues.get("schemefilter");
        QFilter org = null;
        if (customFiterList != null) {
            org = this.getOrgFilterBycustom(customFiterList, year);
        } else if (schemeFilterList != null) {
            org = this.getOrgFilter(schemeFilterList);
        }
        return org;
    }

    private QFilter getOrgFilterBycustom(List<Map<String, List<Object>>> filterList, Date year) {
        QFilter org = null;
        for (Map<String, List<Object>> filter : filterList) {
            List<Object> fieldNames = filter.get("FieldName");
            if (fieldNames.get(0).toString().startsWith("org.id")) {
                List<Object> orgIds = filter.get("Value");
                List collect = orgIds.stream().map(o -> Long.parseLong(String.valueOf(o))).collect(Collectors.toList());
                if (org == null) {
                    org = new QFilter(fieldNames.get(0).toString(), "in", collect);
                } else {
                    org.and(fieldNames.get(0).toString(), "in", collect);
                }
                this.getPageCache().put(CACHE_DEFAULT_ORG, SerializationUtils.toJsonString(collect));
                continue;
            }
            if (!fieldNames.get(0).toString().startsWith("year")) continue;
            List<Object> yea = filter.get("Value");
            if (org == null) {
                org = new QFilter("year", "=", (Object)year);
            } else {
                org.and("year", "=", (Object)year);
            }
            this.getPageCache().put("year", DateUtils.format(year, "yyyy-MM-dd"));
        }
        return org;
    }

    private QFilter getOrgFilter(List<Map<String, List<Object>>> filterList) {
        QFilter org = null;
        for (Map<String, List<Object>> filter : filterList) {
            List<Object> fieldNames = filter.get("FieldName");
            if (fieldNames.get(0).toString().startsWith("org.name")) {
                List<Object> orgNames = filter.get("Value");
                String orgName = orgNames.get(0).toString();
                QFilter orgQuery = new QFilter("org.name", "=", (Object)orgName);
                QFilter viewFilter = new QFilter("view", "=", (Object)VIEWID);
                DynamicObjectCollection orgIds = QueryServiceHelper.query((String)"bos_org_structure", (String)"id,org", (QFilter[])new QFilter[]{orgQuery});
                if (orgIds.isEmpty()) continue;
                DynamicObject orgObj = (DynamicObject)orgIds.get(0);
                String orgId = orgObj.getString("org");
                if (org == null) {
                    org = new QFilter("org.id", "=", (Object)Long.parseLong(orgId));
                } else {
                    org.and("org.id", "=", (Object)Long.parseLong(orgId));
                }
                this.getPageCache().put(CACHE_DEFAULT_ORG, String.valueOf(orgIds.get(0)));
                continue;
            }
            if (!fieldNames.get(0).toString().startsWith("nd_dm")) continue;
            List<Object> year = filter.get("Value");
            if (org == null) {
                org = new QFilter(fieldNames.get(0).toString(), "=", (Object)Long.parseLong(year.get(0).toString()));
            } else {
                org.and(fieldNames.get(0).toString(), "=", (Object)year.get(0).toString());
            }
            this.getPageCache().put("year", String.valueOf(year.get(0)));
        }
        return org;
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("tblrefresh".equals(itemKey)) {
            String nodeId = (String)this.getTreeModel().getCurrentNodeId();
            this.getTreeListView().refreshTreeNode(nodeId);
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String year = this.getPageCache().get("year");
        if (year != null) {
            String[] orgIds = this.getPageCache().get(CACHE_DEFAULT_ORG).replace("[", "").replace("]", "").trim().split(",");
            List orgId = Arrays.stream(orgIds).map(o -> Long.parseLong(String.valueOf(o))).collect(Collectors.toList());
            e.getFilters().add(new QFilter("year", "=", (Object)DateUtils.stringToDate(year)).and(new QFilter("org.id", "in", orgId)));
        }
    }
}

