/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.taxdeclare;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.taxc.bdtaxr.business.serviceImpl.mutex.MutexServiceImpl;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.constant.TaxConstant;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.formula.biz.FormulaService;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandler;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandlerFactory;
import kd.taxc.bdtaxr.common.refactor.formula.utils.JsonUtils;
import kd.taxc.bdtaxr.common.taxdeclare.NsrxxValidatorUtils;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;
import kd.taxc.tcvvt.business.taxorg.TcvvtTaxOrgCommonBusiness;
import kd.taxc.tcvvt.common.helper.OrgCheckServiceHelper;
import kd.taxc.tcvvt.common.helper.OrgServiceHelper;
import kd.taxc.tcvvt.common.util.EmptyCheckUtils;
import kd.taxc.tcvvt.common.util.JsonUtil;
import kd.taxc.tcvvt.common.util.PermissionUtils;
import kd.taxc.tcvvt.common.util.table.YbnsrService;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractDeclareReportPluginNew
extends AbstractFormPlugin {
    private static final String COMMA = ResManager.loadKDString((String)"\uff0c", (String)"AbstractDeclareReportPluginNew_39", (String)"taxc-tcvvt-formplugin", (Object[])new Object[0]);
    private static Log logger = LogFactory.getLog(AbstractDeclareReportPluginNew.class);
    protected static final String ORGID_KEY = "orgid";
    private static final String CONTENT_TAB = "tabcontent";
    protected static final String SBBID = "cache_sbbid";
    protected static final String EDIT_KEY = "edit";
    protected static final String SAVE_KEY = "save";
    protected static final String CANCEL_KEY = "cancel";
    protected static final String SUBMIT_KEY = "submit";
    private static final String UNSUBMIT_KEY = "unsubmit";
    protected static final String RECALC_KEY = "recalc";
    private static final String VIEW_DRAFT_KEY = "viewdraft";
    private static final String AUDIT_KEY = "audit";
    private static final String UNAUDIT_KEY = "unaudit";
    private static final String CLOSE_KEY = "close";
    private static final String ONE_KEY_GENERATE = "onekeygenerate";
    private static final String LINK_TO_DRAFT_LIST = "linktodraftlist";
    protected static final String ORG_SEL = "org";
    protected static final String SKSSQQ = "skssqq";
    protected static final String SKSSQZ = "skssqz";
    protected static final String TCVVT_FETCH_ADJUST = "tcvvt_fetch_adjust";
    private static final String DECLARE_PAGE_ENTITY_NEW = "bdtaxr_declare";
    protected static final String BILL_STATUS = "cache_billstatus";
    private static final String CALLBACKID_MOD = "modifyOrDelete";
    private static final String CALLBACKID_MODIFY = "callback_modify";
    protected static final String TEMPLATE_TYPE = "templatetype";
    private static final String TAXPAYER_TYPE_KEY = "taxPayerType";
    protected static final String EDIT = "edit";
    protected static final String VIEW = "read";
    private String TAXAUTHORITY = "taxauthority";

    public void registerListener(EventObject e) {
        String BAR_KEY = "toolbarap";
        String TOOL_BAR_DECLARE = "toolbarapdeclare";
        this.addItemClickListeners(new String[]{BAR_KEY, TOOL_BAR_DECLARE});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"edit", SUBMIT_KEY, SAVE_KEY, CANCEL_KEY, ONE_KEY_GENERATE});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        try {
            if (customParams.get(ORGID_KEY) != null && customParams.get(SKSSQQ) != null && customParams.get(SKSSQZ) != null) {
                this.loadFromHyperLinkClick(customParams);
            } else {
                this.loadFromDeclareMenu();
            }
        }
        catch (Exception ex) {
            String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
            logger.error("\u7f16\u5236\u62a5\u8868\u52a0\u8f7d\u9875\u9762\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)exceptionStackTraceMessage);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractDeclareReportPluginNew_0", (String)"taxc-tcvvt", (Object[])new Object[0]));
        }
    }

    private void loadFromDeclareMenu() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String paramOrg = (String)customParams.get(ORGID_KEY);
        long org = StringUtil.isNotBlank((CharSequence)paramOrg) ? Long.parseLong(paramOrg) : RequestContext.get().getOrgId();
        List<TreeNode> nodeList = OrgServiceHelper.getAllPermNodes("tcvvt", this.getView().getEntityId(), null);
        String orgid = this.setOrgId(nodeList, String.valueOf(org));
        if (orgid == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8bbe\u7f6e\u8fdb\u884c\u914d\u7f6e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractDeclareReportPluginNew_1", (String)"taxc-tcvvt", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(ORGID_KEY, orgid);
        this.initPeriod(this.getModel(), this.getPageCache(), orgid, customParams);
        this.beforeOpenInnerPage(orgid, customParams);
        this.init();
    }

    private void loadFromHyperLinkClick(Map<String, Object> customParams) {
        String orgid = (String)customParams.get(ORGID_KEY);
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        TaxAppEnum licenseTaxEnum = TaxAppEnum.getEnumInstanceByAppid((String)appid);
        String categoryType = Optional.ofNullable(licenseTaxEnum).isPresent() ? licenseTaxEnum.getCategoryCode() : null;
        boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)appid, (String)categoryType);
        if (!checkResult) {
            this.getModel().setValue(ORG_SEL, (Object)orgid);
            this.getModel().setValue(this.TAXAUTHORITY, (Object)(customParams.get(this.TAXAUTHORITY) instanceof Long ? (Long)customParams.get(this.TAXAUTHORITY) : 0L));
            this.getPageCache().put(ORGID_KEY, orgid);
            String skssqqstr = (String)customParams.get(SKSSQQ);
            Date skssqq = DateUtils.stringToDate((String)skssqqstr);
            this.getModel().setValue(SKSSQQ, (Object)skssqq);
            this.getPageCache().put(SKSSQQ, skssqqstr);
            String skssqzstr = (String)customParams.get(SKSSQZ);
            Date skssqz = DateUtils.stringToDate((String)skssqzstr);
            this.getModel().setValue(SKSSQZ, (Object)skssqz);
            this.getPageCache().put(SKSSQZ, skssqzstr);
            customParams.get("refresh");
            String startDate = this.getPageCache().get(SKSSQQ);
            String endDate = this.getPageCache().get(SKSSQZ);
            Object billno = customParams.get("billno");
            if (ObjectUtils.isEmpty((Object)billno)) {
                this.getModel().setValue("billno", (Object)this.setBillno(skssqz, orgid));
            } else {
                this.getModel().setValue("billno", (Object)billno.toString());
            }
            this.getPageCache().put(TAXPAYER_TYPE_KEY, (String)customParams.get(TEMPLATE_TYPE));
            this.getPageCache().put(TEMPLATE_TYPE + orgid + this.getPageCache().get(TAXPAYER_TYPE_KEY) + startDate + endDate, (String)customParams.get(TAXPAYER_TYPE_KEY));
            this.openDeclarePage(orgid, skssqqstr, skssqzstr, "true".equals(String.valueOf(customParams.get("refresh"))));
            this.init();
        }
    }

    public abstract String setBillno(Date var1, String var2);

    private void beforeOpenInnerPage(String orgid, Map<String, Object> customParams) {
        boolean checkResult = this.check(orgid);
        if (!checkResult) {
            this.getModel().setValue(ORG_SEL, (Object)orgid);
            Date skssqz = ObjectUtils.isEmpty((Object)this.getModel().getValue(SKSSQZ)) ? null : (Date)this.getModel().getValue(SKSSQZ);
            Object billno = customParams.get("billno");
            if (!ObjectUtils.isEmpty((Object)skssqz)) {
                if (ObjectUtils.isEmpty((Object)billno)) {
                    this.getModel().setValue("billno", (Object)this.setBillno(skssqz, orgid));
                } else {
                    this.getModel().setValue("billno", (Object)billno.toString());
                }
            }
            this.setTaxauthority(orgid);
            this.getPageCache().put(ORGID_KEY, orgid);
            this.openDeclarePage(this.getPageCache().get(ORGID_KEY), this.getPageCache().get(SKSSQQ), this.getPageCache().get(SKSSQZ), false);
        } else {
            this.getPageCache().put(ORGID_KEY, null);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Boolean needMsg;
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        ChangeData[] changeData = e.getChangeSet();
        if (appid == null || changeData == null || changeData.length == 0) {
            return;
        }
        if (e.getProperty().getName().equals(ORG_SEL)) {
            if (ObjectUtils.isNotEmpty((Object)this.getPageCache().get("changeOrg")) && "false".equals(this.getPageCache().get("changeOrg"))) {
                return;
            }
            Object object = changeData[0].getNewValue();
            if (StringUtils.isBlank((Object)object) && null != changeData[0].getOldValue()) {
                boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)((DynamicObject)changeData[0].getOldValue()).get("id").toString(), (String)"tcvvt", (String)TaxAppEnum.getEnumInstanceByAppid((String)"tcvvt").getCategoryCode());
                if (checkResult) {
                    return;
                }
                this.getPageCache().put("changeOrg", "false");
                this.getModel().setValue(ORG_SEL, changeData[0].getOldValue());
                this.setTaxauthority(changeData[0].getOldValue() instanceof DynamicObject ? ((DynamicObject)changeData[0].getOldValue()).getString("id") : "0");
                this.getPageCache().put("changeOrg", "true");
                return;
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG_SEL);
            String orgid = org.getString("id");
            boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)appid, (String)TaxAppEnum.getEnumInstanceByAppid((String)appid).getCategoryCode());
            if (checkResult) {
                this.getPageCache().put("changeOrg", "false");
                this.getModel().setValue(ORG_SEL, changeData[0].getOldValue());
                this.setTaxauthority(changeData[0].getOldValue() instanceof DynamicObject ? ((DynamicObject)changeData[0].getOldValue()).getString("id") : "0");
                this.getPageCache().put("changeOrg", "true");
                return;
            }
            this.getPageCache().put(ORGID_KEY, orgid);
            this.initStartAndEndDate(true);
            this.setTaxauthority(orgid);
            this.loadData((Date)this.getModel().getValue(SKSSQQ), (Date)this.getModel().getValue(SKSSQZ), Boolean.FALSE);
        }
        if (e.getProperty().getName().equals(SKSSQQ)) {
            if (null == this.getModel().getValue(ORG_SEL)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDeclareReportPluginNew_2", (String)"taxc-tcvvt", (Object[])new Object[0]));
                return;
            }
            needMsg = StringUtil.isNotBlank((CharSequence)this.getPageCache().get("needMsg")) ? Boolean.valueOf(this.getPageCache().get("needMsg")) : Boolean.TRUE;
            this.loadData((Date)changeData[0].getNewValue(), (Date)this.getModel().getValue(SKSSQZ), needMsg);
        }
        if (e.getProperty().getName().equals(SKSSQZ)) {
            if (null == this.getModel().getValue(ORG_SEL)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDeclareReportPluginNew_2", (String)"taxc-tcvvt", (Object[])new Object[0]));
                return;
            }
            needMsg = StringUtil.isNotBlank((CharSequence)this.getPageCache().get("needMsg")) ? Boolean.valueOf(this.getPageCache().get("needMsg")) : Boolean.TRUE;
            this.loadData((Date)this.getModel().getValue(SKSSQQ), (Date)changeData[0].getNewValue(), needMsg);
        }
        this.getPageCache().remove("needMsg");
        this.init();
    }

    public void loadData(Date startDate, Date endDate, Boolean needMsg) {
        Boolean flag = this.isValidDates(startDate, endDate, needMsg);
        if (flag.booleanValue()) {
            this.getPageCache().put(SKSSQQ, DateUtils.format((Date)startDate));
            this.getPageCache().put(SKSSQZ, DateUtils.format((Date)endDate));
            this.openDeclarePage(this.getPageCache().get(ORGID_KEY), this.getPageCache().get(SKSSQQ), this.getPageCache().get(SKSSQZ), false);
        }
    }

    protected Boolean isValidDates(Date startDate, Date endDate, Boolean needMsg) {
        String[] taxLimits;
        boolean isvalid = Boolean.FALSE;
        for (String taxLimit : taxLimits = this.getTaxLimits()) {
            boolean temp = DateUtils.validDateRange((String)taxLimit, (Date)startDate, (Date)endDate);
            isvalid |= temp;
        }
        if (!isvalid) {
            if (needMsg.booleanValue()) {
                String errMsg = this.buildErrorMsg(taxLimits);
                this.getView().showTipNotification(errMsg);
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private String buildErrorMsg(String[] taxLimits) {
        String msgTmp = ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u5fc5\u987b\u4e3a\u201c%s\u201d\u3002", (String)"AbstractDeclareReportPluginNew_3", (String)"taxc-tcvvt", (Object[])new Object[0]);
        ArrayList nameList = new ArrayList(4);
        for (String taxLimit : taxLimits) {
            nameList.add(TaxConstant.getTaxLimitNameMap().get(taxLimit));
        }
        return String.format(msgTmp, String.join((CharSequence)"\u3001", nameList));
    }

    public void clientCallBack(ClientCallBackEvent e) {
        Map dataMap = JsonUtils.strToMap((String)this.getPageCache().get("resultData"));
        this.clientCallBackMethod(dataMap, e.getName());
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "save": {
                LocaleString saveMsg = new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u4e2d\uff0c\u8bf7\u7a0d\u7b49\uff083S\uff09\u3002", (String)"AbstractDeclareReportPluginNew_4", (String)"taxc-tcvvt", (Object[])new Object[0]));
                this.getView().showLoading(saveMsg, 3000);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage());
                }
                this.save();
                break;
            }
            case "cancel": {
                LocaleString cancelMsg = new LocaleString(ResManager.loadKDString((String)"\u53d6\u6d88\u7f16\u8f91\u4e2d\uff0c\u8bf7\u7a0d\u7b49\uff083S\uff09\u3002", (String)"AbstractDeclareReportPluginNew_5", (String)"taxc-tcvvt", (Object[])new Object[0]));
                this.getView().showLoading(cancelMsg, 3000);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage());
                }
                this.cancel();
                break;
            }
        }
    }

    private boolean isDataChanged() {
        IPageCache childPageCache;
        IFormView childPage = this.getView().getView(this.getPageCache().get("declarepageid"));
        if (childPage != null && (childPageCache = childPage.getPageCache()) != null) {
            Map updateMap = (Map)TreeUtils.getCache((IPageCache)childPageCache, (String)"updata_cellid", Map.class);
            return updateMap != null && updateMap.size() > 0;
        }
        return false;
    }

    private void cancel() {
        if (this.isDataChanged()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CANCEL_KEY, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"AbstractDeclareReportPluginNew_6", (String)"taxc-tcvvt", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u9000\u51fa\u7f16\u8f91", (String)"AbstractDeclareReportPluginNew_7", (String)"taxc-tcvvt", (Object[])new Object[0]));
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u786e\u8ba4\u76f4\u63a5\u9000\u51fa\u7f16\u8f91\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"AbstractDeclareReportPluginNew_8", (String)"taxc-tcvvt", (Object[])new Object[0]);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        } else {
            String orgId = this.getPageCache().get(ORGID_KEY);
            String startDate = this.getPageCache().get(SKSSQQ);
            String endDate = this.getPageCache().get(SKSSQZ);
            DynamicObject dyo = YbnsrService.queryYbnsr(orgId, this.getTemplateType(), startDate, endDate, null);
            if (dyo == null) {
                this.closeView();
            } else {
                this.enableSubmitBtn();
                FormulaService.cancel((IPageCache)this.getPageCache());
                this.operationSbb(VIEW);
            }
            this.releaseMutexLock("edit", this.getPageCache().get("sbbid"));
        }
    }

    public void releaseMutexLock(String operateKey, String sbbid) {
        if (ObjectUtils.isNotEmpty((Object)sbbid)) {
            MutexServiceImpl.releaseMutexLock((String)sbbid, (String)operateKey, (Long)RequestContext.get().getCurrUserId());
        }
    }

    protected void closeView() {
        this.getPageCache().put("code_close", "true");
        this.getView().close();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        if (this.getModel().getValue(ORG_SEL) == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDeclareReportPluginNew_2", (String)"taxc-tcvvt", (Object[])new Object[0]));
            return;
        }
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (key = afterDoOperationEventArgs.getOperateKey()) {
            case "edit": {
                this.edit();
                break;
            }
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                this.submit(key);
                break;
            }
            case "recalc": {
                this.recalc();
                break;
            }
            case "viewdraft": {
                this.viewDraft();
                break;
            }
            case "onekeygenerate": {
                this.onekeygenerate();
                break;
            }
        }
    }

    public String getMainEntity() {
        return "";
    }

    public void edit() {
        try {
            String sbbid = this.getPageCache().get("sbbid");
            String entityname = this.getModel().getDataEntityType().getName();
            MutexServiceImpl mutexService = new MutexServiceImpl();
            HashMap<String, String> customparam = new HashMap<String, String>();
            customparam.put("dataObjId", sbbid);
            customparam.put("entityKey", this.getMainEntity());
            customparam.put("operationKey", "edit");
            customparam.put("groupId", "declare_edit");
            mutexService.setMutexLockInfo(customparam);
            boolean isSuccessLock = mutexService.setMutexLock();
            logger.info("DynamicEntity:{},Entity:{} lock : {}", new Object[]{entityname, this.getMainEntity(), isSuccessLock});
            if (!isSuccessLock && this.checkLockedMutexLock(sbbid)) {
                return;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{SUBMIT_KEY, AUDIT_KEY, CLOSE_KEY});
        this.operationSbb("edit");
    }

    protected void viewDraft() {
        String orgid = this.getPageCache().get(ORGID_KEY);
        String startDate = this.getPageCache().get(SKSSQQ);
        String endDate = this.getPageCache().get(SKSSQZ);
        if (StringUtil.isEmpty((CharSequence)orgid)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDeclareReportPluginNew_2", (String)"taxc-tcvvt", (Object[])new Object[0]));
            return;
        }
        QFilter orgFilter = new QFilter(ORG_SEL, "=", (Object)Long.valueOf(orgid));
        QFilter startFilter = new QFilter("startdate", "=", (Object)DateUtils.stringToDate((String)startDate));
        QFilter endFilter = new QFilter("enddate", "=", (Object)DateUtils.stringToDate((String)endDate));
        String templateType = this.getTemplateType();
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)templateType);
        QFilter templateFilter = new QFilter(TEMPLATE_TYPE, "=", (Object)templateEnum.getDraftType());
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tctb_draft_main", (String)MetadataUtil.getAllFieldString((String)"tctb_draft_main"), (QFilter[])new QFilter[]{orgFilter, templateFilter, startFilter, endFilter});
        if (dynamicObject == null) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(VIEW_DRAFT_KEY, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AbstractDeclareReportPluginNew_9", (String)"taxc-tcvvt", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"AbstractDeclareReportPluginNew_10", (String)"taxc-tcvvt", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG_SEL);
            String orgName = org != null ? org.getString("name") : "";
            String msg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5c1a\u672a\u7f16\u5236\u8ba1\u7a0e\u5e95\u7a3f\uff0c\u662f\u5426\u524d\u5f80\u7f16\u5236\uff1f", (String)"AbstractDeclareReportPluginNew_11", (String)"taxc-tcvvt", (Object[])new Object[0]), orgName);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        } else {
            HashMap<String, String> customParams = new HashMap<String, String>();
            customParams.put(ORGID_KEY, orgid);
            customParams.put(SKSSQQ, startDate);
            customParams.put(SKSSQZ, endDate);
            customParams.put("type", dynamicObject.getString("type"));
            customParams.put(TEMPLATE_TYPE, templateEnum.getDraftType());
            PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)templateEnum.getDraftPage(), (IFormView)this.getView(), customParams, (IFormPlugin)this);
        }
    }

    public void operationSbb(String operationType) {
        String oldPageId = this.getPageCache().get("declarepageid");
        IFormView childView = this.getView().getView(oldPageId);
        IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
        String sheetId = childPageCache.get("sheetid");
        String sheetname = childPageCache.get("sheetname");
        Map customParams = childView.getFormShowParameter().getCustomParams();
        FormShowParameter param = new FormShowParameter();
        customParams.put("operation", operationType);
        customParams.put("sheetid", sheetId);
        customParams.put("refresh", "false");
        if (StringUtils.isNotBlank((CharSequence)sheetname)) {
            customParams.put("sheetname", sheetname);
        }
        String orgId = this.getPageCache().get(ORGID_KEY);
        String startDate = this.getPageCache().get(SKSSQQ);
        String endDate = this.getPageCache().get(SKSSQZ);
        DeclareRequestModel requestModel = new DeclareRequestModel();
        Long sbbid = AbstractDeclareReportPluginNew.getSbbid(null, orgId, startDate, endDate, customParams.get(TEMPLATE_TYPE));
        if (operationType.equals("edit") && sbbid == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5f53\u524d\u6761\u4ef6\u4e0b\u7684\u7533\u62a5\u8868\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AbstractDeclareReportPluginNew_12", (String)"taxc-tcvvt", (Object[])new Object[0]));
            return;
        }
        requestModel.setId(sbbid);
        requestModel.setOrgId(Long.valueOf(Long.parseLong(orgId)));
        requestModel.setTemplateType((String)customParams.get(TEMPLATE_TYPE));
        requestModel.setOperation(operationType);
        requestModel.setSkssqq(startDate);
        requestModel.setSkssqz(endDate);
        requestModel.setRefresh(Boolean.valueOf(false));
        requestModel.getBusinessMap().putAll(this.getBizParams(operationType, false));
        customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
        param.setFormId(this.getDeclareFormId());
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(CONTENT_TAB);
        String pageid = param.getPageId();
        this.getPageCache().put("declarepageid", pageid);
        customParams.put("declarepageid", pageid);
        param.setCustomParams(customParams);
        this.getView().showForm(param);
        if ("edit".equals(operationType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"edit", CLOSE_KEY, SUBMIT_KEY, AUDIT_KEY});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{VIEW_DRAFT_KEY, RECALC_KEY, SAVE_KEY, CANCEL_KEY, ONE_KEY_GENERATE});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"edit", VIEW_DRAFT_KEY, SUBMIT_KEY, CLOSE_KEY});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{AUDIT_KEY, SAVE_KEY, CANCEL_KEY, RECALC_KEY, ONE_KEY_GENERATE});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{SUBMIT_KEY});
        }
    }

    protected Map<String, String> getBizParams(String operationType, boolean refresh) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        if (refresh) {
            map.putAll(this.getFetchConfigParams());
        }
        return map;
    }

    protected Map<String, String> getFetchConfigParams() {
        return new HashMap<String, String>(1);
    }

    public void save() {
        NsrxxValidatorUtils.nsrxxReviewed((Long)this.getModel().getDataEntity().getLong("org.id"));
        String pageid = this.getPageCache().get("declarepageid");
        IFormView childView = this.getView().getView(pageid);
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)childView.getService(FormViewPluginProxy.class);
        IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
        List pluginList = pluginProxy.getPlugIns();
        Object taxDeclarePlugin = null;
        for (IFormPlugin plugin : pluginList) {
            String name = plugin.getPluginName();
            if (!name.endsWith("TaxDeclarePlugin")) continue;
            taxDeclarePlugin = plugin;
            break;
        }
        if (taxDeclarePlugin != null) {
            Class<?> pluginClass = taxDeclarePlugin.getClass();
            try {
                Method saveClick = pluginClass.getMethod("saveClick", IPageCache.class, DeclareRequestModel.class);
                DeclareRequestModel declareRequestModel = new DeclareRequestModel();
                String orgId = this.getPageCache().get(ORGID_KEY);
                String startDate = this.getPageCache().get(SKSSQQ);
                String endDate = this.getPageCache().get(SKSSQZ);
                String sbbid = this.getPageCache().get("sbbid");
                Object type = childView.getFormShowParameter().getCustomParams().get(TEMPLATE_TYPE);
                DeclareRequestModel requestModel = (DeclareRequestModel)SerializationUtils.fromJsonString((String)childPageCache.get("declareRequest"), DeclareRequestModel.class);
                TreeUtils.putCache((IPageCache)childPageCache, (String)"declareRequest", (Object)requestModel);
                DynamicObject declareMain = AbstractDeclareReportPluginNew.getDeclareMain(orgId, startDate, endDate, type);
                if (declareMain != null && !"A".equals(declareMain.getString("billstatus"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u5df2\u7ecf\u63d0\u4ea4\u6216\u5df2\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4fdd\u5b58\u3002", (String)"AbstractDeclareReportPluginNew_13", (String)"taxc-tcvvt", (Object[])new Object[0]));
                    return;
                }
                Long id = null;
                if (!sbbid.equalsIgnoreCase("0")) {
                    id = Long.parseLong(sbbid);
                }
                declareRequestModel.setId(id);
                declareRequestModel.setOrgId(Long.valueOf(Long.parseLong(orgId)));
                declareRequestModel.setTemplateType(this.getTemplateType());
                declareRequestModel.setRefresh(Boolean.valueOf(true));
                declareRequestModel.setOperation("edit");
                declareRequestModel.setSkssqq(startDate);
                declareRequestModel.setSkssqz(endDate);
                declareRequestModel.getBusinessMap().putAll(this.getBizParams("edit", false));
                this.saveAdjust(orgId, startDate, endDate);
                childPageCache.remove("updateCellMap");
                BaseResult resultMap = (BaseResult)saveClick.invoke(taxDeclarePlugin, childPageCache, declareRequestModel);
                if (500 == resultMap.getCode()) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"AbstractDeclareReportPluginNew_14", (String)"taxc-tcvvt", (Object[])new Object[0]), resultMap.getMessage()));
                    return;
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AbstractDeclareReportPluginNew_15", (String)"taxc-tcvvt", (Object[])new Object[0]));
                DynamicObject org = (DynamicObject)this.getModel().getValue(ORG_SEL);
                String orgname = org.getString("name");
                AppLogInfo appLogInfo = new AppLogInfo();
                appLogInfo.setBizAppID("/Z0U6BXKR4Y+");
                appLogInfo.setBizObjID("tccit_seasonal_declare2");
                ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
                appLogInfo.setOpName(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"AbstractDeclareReportPluginNew_16", (String)"taxc-tcvvt", (Object[])new Object[0]));
                appLogInfo.setOpDescription(String.format(ResManager.loadKDString((String)"\u5c5e\u671f%1$s\u81f3%2$s\uff0c\u7ec4\u7ec7%3$s\u7684\u7533\u62a5\u8868\u4fdd\u5b58\u6210\u529f\u3002", (String)"AbstractDeclareReportPluginNew_17", (String)"taxc-tcvvt", (Object[])new Object[0]), startDate, endDate, orgname));
                service.addLog(appLogInfo);
                this.releaseMutexLock("edit", this.getPageCache().get("sbbid"));
            }
            catch (Exception e) {
                logger.error("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"AbstractDeclareReportPluginNew_18", (String)"taxc-tcvvt", (Object[])new Object[0]);
                if (e instanceof InvocationTargetException && ((InvocationTargetException)e).getTargetException() instanceof KDBizException) {
                    Throwable targetException = ((InvocationTargetException)e).getTargetException();
                    this.getView().showErrorNotification(msg + COMMA + targetException.getMessage());
                } else {
                    this.getView().showErrorNotification(msg);
                }
                return;
            }
            this.operationSbb(VIEW);
        }
        this.enableSubmitBtn();
    }

    public void enableSubmitBtn() {
        this.getView().setVisible(Boolean.TRUE, new String[]{SUBMIT_KEY});
    }

    public void submit(String key) {
        String sbbid = null;
        DynamicObject declare = this.queryNsrxx(this.getPageCache().get(ORGID_KEY), this.getPageCache().get(SKSSQQ), this.getPageCache().get(SKSSQZ));
        if (declare != null) {
            sbbid = declare.getString("id");
        }
        if (!StringUtils.isEmpty(sbbid)) {
            if (this.checkLockedMutexLock(sbbid)) {
                return;
            }
            ArrayList<String> pklist = new ArrayList<String>();
            pklist.add(sbbid);
            boolean flag = DeclareUtils.submit((IFormView)this.getView(), pklist, (String)key, (String)"tcvat_nsrxx", (boolean)false);
            if (flag) {
                String orgId = this.getPageCache().get(ORGID_KEY);
                String startDate = this.getPageCache().get(SKSSQQ);
                String endDate = this.getPageCache().get(SKSSQZ);
                this.setBtnStatus(orgId, startDate, endDate, VIEW);
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u672a\u751f\u6210\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u3002", (String)"AbstractDeclareReportPluginNew_19", (String)"taxc-tcvvt", (Object[])new Object[0]));
        }
    }

    protected DynamicObject queryNsrxx(String orgId, String startdate, String enddate) {
        if (StringUtils.isBlank((CharSequence)orgId) || StringUtils.isBlank((CharSequence)startdate) || StringUtils.isBlank((CharSequence)enddate)) {
            return null;
        }
        return YbnsrService.queryYbnsr(orgId, this.getTemplateType(), startdate, enddate, Collections.emptyMap());
    }

    private void recalc() {
        NsrxxValidatorUtils.nsrxxReviewed((Long)this.getModel().getDataEntity().getLong("org.id"));
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(RECALC_KEY, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AbstractDeclareReportPluginNew_9", (String)"taxc-tcvvt", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"AbstractDeclareReportPluginNew_10", (String)"taxc-tcvvt", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7b97\u5c06\u5bfc\u81f4\u539f\u6709\u7533\u62a5\u6570\u636e\u88ab\u6e05\u7a7a\u4e14\u91cd\u65b0\u8ba1\u7b97\uff0c\u662f\u5426\u8981\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"AbstractDeclareReportPluginNew_20", (String)"taxc-tcvvt", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    private void onekeygenerate() {
        String orgid = this.getPageCache().get(ORGID_KEY);
        if (LicenseCheckServiceHelper.check((Object)orgid, (IFormView)this.getView(), (String)"tcdrs")) {
            return;
        }
        String skssqq = this.getPageCache().get(SKSSQQ);
        String skssqz = this.getPageCache().get(SKSSQZ);
        String draftpurpose = this.getPageCache().get("draftpurpose") != null ? this.getPageCache().get("draftpurpose") : "nssb";
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)this.getTemplateType());
        String draftType = templateEnum.getDraftType();
        DynamicObject draft = StatusUtils.queryOne((String)draftType, (String)orgid, (String)skssqq, (String)skssqz, (String)draftpurpose);
        if (draft != null) {
            DynamicObject orgObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(orgid), (String)"bos_org");
            String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5728\u201c%2$s\u201d\u81f3\u201c%3$s\u201d\u5df2\u5b58\u5728\u5e95\u7a3f\u6570\u636e\uff0c\u91cd\u65b0\u751f\u6210\u5c06\u5bfc\u81f4\u539f\u6709\u7684\u5e95\u7a3f\u548c\u7533\u62a5\u8868\u6570\u636e\u88ab\u6e05\u9664\uff0c\u786e\u8ba4\u8981\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"AbstractDeclareReportPluginNew_21", (String)"taxc-tcvvt", (Object[])new Object[0]), orgObj.getString("name"), skssqq, skssqz);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ONE_KEY_GENERATE, (IFormPlugin)this);
            this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBacks, null, SerializationUtils.toJsonString((Object)draft));
        } else {
            this.executeEngineHandler(orgid, skssqq, skssqz, this.getTemplateType());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        String orgId = this.getPageCache().get(ORGID_KEY);
        String skssqq = this.getPageCache().get(SKSSQQ);
        String skssqz = this.getPageCache().get(SKSSQZ);
        String draftpurpose = this.getPageCache().get("draftpurpose") != null ? this.getPageCache().get("draftpurpose") : "nssb";
        String templateType = this.getTemplateType();
        switch (callBackId) {
            case "recalc": {
                String orgname;
                if (!this.isValidDates((Date)this.getModel().getValue(SKSSQQ), (Date)this.getModel().getValue(SKSSQZ), Boolean.TRUE).booleanValue()) {
                    return;
                }
                if (e.getResult() != MessageBoxResult.Yes) break;
                if (orgId == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDeclareReportPluginNew_2", (String)"taxc-tcvvt", (Object[])new Object[0]));
                    return;
                }
                Map<String, Object> map = this.chooseDeclareFormByDataType(orgId, templateType, skssqq, skssqz);
                String taxLimitTips = DateUtils.getTaxLimitTips((Date)DateUtils.stringToDate((String)skssqq), (Date)DateUtils.stringToDate((String)skssqz));
                String string = orgname = this.getModel().getValue(ORG_SEL) == null ? "" : ((DynamicObject)this.getModel().getValue(ORG_SEL)).getString("name");
                if (StringUtils.equals((CharSequence)"2", (CharSequence)((String)map.get("datatype"))) && (StringUtils.equals((CharSequence)"B", (CharSequence)((String)map.get("billstatus"))) || StringUtils.equals((CharSequence)"C", (CharSequence)((String)map.get("billstatus"))))) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f\u7533\u62a5\u8868\u5df2\u5b58\u5728\u5bfc\u5165\u7684\u7533\u62a5\u6570\u636e\u3002", (String)"AbstractDeclareReportPluginNew_22", (String)"taxc-tcvvt", (Object[])new Object[0]), orgname, taxLimitTips));
                    return;
                }
                this.openDeclarePage(orgId, skssqq, skssqz, true);
                if (ObjectUtils.isEmpty((Object)this.getView().getParentView()) || ObjectUtils.isEmpty((Object)this.getView().getParentView().getPageCache())) break;
                this.getView().getParentView().getPageCache().put("updateCellMap", null);
                break;
            }
            case "viewdraft": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                HashMap<String, String> customParams = new HashMap<String, String>();
                customParams.put(ORGID_KEY, orgId);
                customParams.put(SKSSQQ, skssqq);
                customParams.put(SKSSQZ, skssqz);
                TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)templateType);
                customParams.put(TEMPLATE_TYPE, templateEnum.getDraftType());
                PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)templateEnum.getDraftPage(), (IFormView)this.getView(), customParams, (IFormPlugin)this);
                break;
            }
            case "callback_modify": {
                if (e.getResult() == MessageBoxResult.Yes) {
                    this.showInnerPage(orgId, skssqq, skssqz, false, "edit");
                    break;
                }
                this.closeView();
                break;
            }
            case "modifyOrDelete": {
                if (e.getResult() == MessageBoxResult.Yes) {
                    TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)templateType);
                    StatusUtils.delete((String)templateEnum.getDraftType(), (String)orgId, (String)skssqq, (String)skssqz, (String)draftpurpose);
                    HashMap<String, String> customParams = new HashMap<String, String>();
                    customParams.put(ORGID_KEY, orgId);
                    customParams.put(SKSSQQ, skssqq);
                    customParams.put(SKSSQZ, skssqz);
                    PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)templateEnum.getDraftPage(), (IFormView)this.getView(), customParams, (IFormPlugin)this);
                    this.closeView();
                    break;
                }
                if (e.getResult() == MessageBoxResult.No) {
                    this.showInnerPage(orgId, skssqq, skssqz, false, "edit");
                    break;
                }
                this.closeView();
                break;
            }
            case "onekeygenerate": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                String customVaule = e.getCustomVaule();
                JSONObject object = JSONObject.parseObject((String)customVaule);
                if (!"A".equals(object.getString("billstatus"))) {
                    String msg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u63d0\u4ea4\u5ba1\u6838\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u662f\u5426\u9700\u8981\u524d\u5f80\u5e95\u7a3f\u67e5\u8be2\u754c\u9762\u4fee\u6539\uff1f", (String)"AbstractDeclareReportPluginNew_23", (String)"taxc-tcvvt", (Object[])new Object[0]), object.getString("billno"));
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(LINK_TO_DRAFT_LIST, (IFormPlugin)this);
                    this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks, null, object.getString("billno"));
                    break;
                }
                this.executeEngineHandler(orgId, skssqq, skssqz, templateType);
                break;
            }
            case "linktodraftlist": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                String draftQueryPage = TemplateEnum.getEnumByDeclareType((String)this.getTemplateType()).getDraftQueryPage();
                HashMap<String, Comparable<Long>> customParams = new HashMap<String, Comparable<Long>>();
                customParams.put(ORGID_KEY, Long.valueOf(Long.parseLong(orgId)));
                customParams.put("startdate", DateUtils.stringToDate((String)skssqq));
                customParams.put("enddate", DateUtils.stringToDate((String)skssqz));
                PageShowCommon.showBillList((ShowType)ShowType.MainNewTabPage, (String)draftQueryPage, (IFormView)this.getView(), customParams);
                break;
            }
            case "handle_onekey_generate_exception": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                String declareType = this.getTemplateType();
                String draftPage = TemplateEnum.getEnumByDeclareType((String)declareType).getDraftPage();
                HashMap<String, String> customParams = new HashMap<String, String>();
                customParams.put(ORGID_KEY, orgId);
                customParams.put(SKSSQQ, skssqq);
                customParams.put(SKSSQZ, skssqz);
                PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)draftPage, (IFormView)this.getView(), customParams, (IFormPlugin)this);
                break;
            }
            case "cancel": {
                DynamicObject dyo = YbnsrService.queryYbnsr(orgId, templateType, skssqq, skssqz, null);
                if (e.getResult() != MessageBoxResult.Yes) break;
                if (dyo == null) {
                    this.closeView();
                } else {
                    this.enableSubmitBtn();
                    FormulaService.cancel((IPageCache)this.getPageCache());
                    this.operationSbb(VIEW);
                }
                this.releaseMutexLock("edit", this.getPageCache().get("sbbid"));
                break;
            }
            case "close": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                this.closeView();
                this.releaseMutexLock("edit", this.getPageCache().get("sbbid"));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String code_close = this.getPageCache().get("code_close");
        if (this.isDataChanged() && !"true".equals(code_close)) {
            e.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CLOSE_KEY, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"AbstractDeclareReportPluginNew_6", (String)"taxc-tcvvt", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u9000\u51fa\u7f16\u8f91", (String)"AbstractDeclareReportPluginNew_7", (String)"taxc-tcvvt", (Object[])new Object[0]));
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u786e\u8ba4\u76f4\u63a5\u9000\u51fa\u7f16\u8f91\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"AbstractDeclareReportPluginNew_8", (String)"taxc-tcvvt", (Object[])new Object[0]);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
    }

    private void executeEngineHandler(String orgId, String skssqq, String skssqz, String templateType) {
        EngineHandler handler = EngineHandlerFactory.createHandler((String)templateType);
        EngineModel engineModel = this.buildEngineModel(orgId, skssqq, skssqz, templateType, this.getPageCache());
        try {
            handler.validate(engineModel);
            handler.execute(engineModel);
        }
        catch (KDBizException exception) {
            handler.handleException(exception, this.getView(), (IFormPlugin)this);
            return;
        }
        this.openDeclarePage(orgId, skssqq, skssqz, true);
    }

    private boolean isDeclared(String rootPageId, String orgId, String startdate, String enddate) {
        DynamicObject declare = this.queryNsrxx(orgId, startdate, enddate);
        IFormView rootView = this.getView().getView(rootPageId);
        IPageCache rootCache = (IPageCache)rootView.getService(IPageCache.class);
        rootCache.put(BILL_STATUS, "A");
        this.getPageCache().remove("templateid");
        if (declare != null) {
            if (StringUtil.isNotEmpty((CharSequence)declare.getString("templateid"))) {
                this.getPageCache().put("templateid", declare.getString("templateid"));
            }
            String status = declare.getString("declarestatus");
            String billstatus = declare.getString("billstatus");
            String id = declare.getString("id");
            rootCache.put(BILL_STATUS, billstatus);
            rootCache.put(SBBID, id);
            if (StringUtils.isNotBlank((CharSequence)billstatus) && !"A".equals(billstatus)) {
                DynamicObject org = (DynamicObject)rootView.getModel().getValue(ORG_SEL);
                String orgName = null != org ? org.getString("name") : "";
                String statusName = this.getStatusLocaleName(status, billstatus);
                String taxlimitStr = DateUtils.getTaxLimitTips((Date)DateUtils.stringToDate((String)startdate), (Date)DateUtils.stringToDate((String)enddate));
                if (!taxlimitStr.equals("")) {
                    String msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f\u7533\u62a5\u8868\u5df2%3$s\uff0c\u4e0d\u652f\u6301\u4fee\u6539\u3002", (String)"AbstractDeclareReportPluginNew_24", (String)"taxc-tcvvt", (Object[])new Object[0]), orgName, taxlimitStr, statusName);
                    rootView.showTipNotification(msg, Integer.valueOf(5000));
                    this.getView().sendFormAction(rootView);
                }
                return true;
            }
        }
        return false;
    }

    private String getStatusLocaleName(String status, String billstatus) {
        String statusName = ResManager.loadKDString((String)"\u63d0\u4ea4\u5ba1\u6279", (String)"AbstractDeclareReportPluginNew_25", (String)"taxc-tcvvt", (Object[])new Object[0]);
        if ("C".equals(billstatus)) {
            statusName = ResManager.loadKDString((String)"\u5ba1\u6279", (String)"AbstractDeclareReportPluginNew_26", (String)"taxc-tcvvt", (Object[])new Object[0]);
        }
        if ("declared".equals(status)) {
            statusName = ResManager.loadKDString((String)"\u7533\u62a5", (String)"AbstractDeclareReportPluginNew_27", (String)"taxc-tcvvt", (Object[])new Object[0]);
        }
        return statusName;
    }

    protected String[] getTaxLimits() {
        return new String[]{"month"};
    }

    protected void initStartAndEndDate(boolean orgChange) {
        Date skssqz;
        Date skssqq;
        String taxLimit;
        switch (taxLimit = this.getTaxLimits()[0]) {
            case "year": {
                skssqq = DateUtils.getFirstDateOfYear((Date)DateUtils.addYear((Date)new Date(), (int)-1));
                skssqz = DateUtils.getLastDateOfYear((Date)skssqq);
                break;
            }
            case "halfyear": {
                skssqq = DateUtils.getFirstDateOfHalfYear((Date)DateUtils.addMonth((Date)new Date(), (int)-6));
                skssqz = DateUtils.getLastDateOfHalfYear((Date)skssqq);
                break;
            }
            case "season": {
                skssqq = DateUtils.getFirstDateOfSeason((Date)DateUtils.addMonth((Date)new Date(), (int)-3));
                skssqz = DateUtils.getLastDateOfSeason((Date)skssqq);
                break;
            }
            default: {
                skssqq = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)-1));
                skssqz = DateUtils.getLastDateOfMonth((Date)skssqq);
            }
        }
        this.getPageCache().put("needMsg", "false");
        this.getModel().setValue(SKSSQQ, (Object)skssqq);
        this.getPageCache().put(SKSSQQ, DateUtils.format((Date)skssqq));
        this.getModel().setValue(SKSSQZ, (Object)skssqz);
        this.getPageCache().put(SKSSQZ, DateUtils.format((Date)skssqz));
    }

    private void openDeclarePage(String orgid, String skssqq, String skssqz, boolean refresh) {
        if (!this.checkOrgTaxConfig(orgid, skssqq, skssqz)) {
            return;
        }
        String templateType = this.getTemplateType();
        Map<String, Object> map = this.chooseDeclareFormByDataType(orgid, templateType, skssqq, skssqz);
        if (StringUtils.equals((CharSequence)"2", (CharSequence)((String)map.get("datatype")))) {
            if (StringUtils.equals((CharSequence)"A", (CharSequence)((String)map.get("billstatus")))) {
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                String taxLimitTips = DateUtils.getTaxLimitTips((Date)DateUtils.stringToDate((String)skssqq), (Date)DateUtils.stringToDate((String)skssqz));
                String orgname = this.getModel().getValue(ORG_SEL) == null ? "" : ((DynamicObject)this.getModel().getValue(ORG_SEL)).getString("name");
                String msg = ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f\u7533\u62a5\u8868\u5df2\u5b58\u5728\u5bfc\u5165\u7684\u7533\u62a5\u6570\u636e\uff0c\u53ef\u9009\u62e9\u4ee5\u4e0b\u64cd\u4f5c\u3002", (String)"AbstractDeclareReportPluginNew_28", (String)"taxc-tcvvt", (Object[])new Object[0]);
                if ("yhs".equals(templateType) || "qhjtydbs".equals(templateType) || "zdsybs_yd".equals(templateType) || "zdsybs_jd".equals(templateType)) {
                    btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u9875\u9762", (String)"AbstractDeclareReportPluginNew_29", (String)"taxc-tcvvt", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e", (String)"AbstractDeclareReportPluginNew_30", (String)"taxc-tcvvt", (Object[])new Object[0]));
                    this.getView().showConfirm(String.format(msg, orgname, taxLimitTips), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e\uff1a\u624b\u52a8\u4fee\u6539\u5bfc\u5165\u7684\u7533\u62a5\u6570\u636e", (String)"AbstractDeclareReportPluginNew_31", (String)"taxc-tcvvt", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Save, new ConfirmCallBackListener(CALLBACKID_MODIFY, (IFormPlugin)this), btnNameMaps);
                } else {
                    btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u9875\u9762", (String)"AbstractDeclareReportPluginNew_29", (String)"taxc-tcvvt", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e", (String)"AbstractDeclareReportPluginNew_30", (String)"taxc-tcvvt", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7a0e", (String)"AbstractDeclareReportPluginNew_32", (String)"taxc-tcvvt", (Object[])new Object[0]));
                    this.getView().showConfirm(String.format(msg, orgname, taxLimitTips), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e\uff1a\u624b\u52a8\u4fee\u6539\u5bfc\u5165\u7684\u7533\u62a5\u6570\u636e\n\u91cd\u65b0\u8ba1\u7a0e\uff1a\u6e05\u7a7a\u5bfc\u5165\u7684\u7533\u62a5\u6570\u636e\uff0c\u5e76\u4f7f\u7528\u81ea\u52a8\u8ba1\u7a0e\u3002", (String)"AbstractDeclareReportPluginNew_33", (String)"taxc-tcvvt", (Object[])new Object[0]), MessageBoxOptions.YesNoCancel, ConfirmTypes.Delete, new ConfirmCallBackListener(CALLBACKID_MOD, (IFormPlugin)this), btnNameMaps);
                }
            } else {
                this.showInnerPage(orgid, skssqq, skssqz, refresh, VIEW);
            }
        } else if (StringUtil.isBlank((CharSequence)((String)map.get("billstatus")))) {
            this.showInnerPage(orgid, skssqq, skssqz, true, "edit");
        } else if ("A".equals(map.get("billstatus"))) {
            this.showInnerPage(orgid, skssqq, skssqz, refresh, refresh ? "edit" : VIEW);
        } else {
            this.showInnerPage(orgid, skssqq, skssqz, false, VIEW);
        }
    }

    public boolean checkOrgTaxConfig(String orgid, String skssqq, String skssqz) {
        return true;
    }

    private Map<String, Object> chooseDeclareFormByDataType(String orgid, String type, String startDate, String endDate) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        DynamicObject dyo = YbnsrService.queryYbnsr(orgid, type, startDate, endDate, null);
        String declareStatus = "";
        String billstatus = "";
        String datatype = "";
        if (null != dyo) {
            declareStatus = dyo.getString("declarestatus");
            billstatus = dyo.getString("billstatus");
            datatype = dyo.getString("datatype");
        }
        map.put("declarestatus", declareStatus);
        map.put("billstatus", billstatus);
        map.put("datatype", datatype);
        return map;
    }

    private void showInnerPage(String orgid, String startDate, String endDate, boolean refresh, String operationStatus) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("rootPageId", this.getView().getPageId());
        String taxLimit = DateUtils.getTaxLimit((Date)DateUtils.stringToDate((String)startDate), (Date)DateUtils.stringToDate((String)endDate));
        customParams.put("taxlimit", taxLimit);
        String templateType = this.getTemplateType();
        customParams.put(TEMPLATE_TYPE, templateType);
        customParams.put("ParentCache", "true");
        boolean readonly = false;
        boolean isDeclare = this.isDeclared(this.getView().getPageId(), orgid, startDate, endDate);
        if (isDeclare) {
            readonly = true;
        }
        customParams.put("readonly", readonly);
        customParams.put("templateid", this.getPageCache().get("templateid"));
        customParams.put(TEMPLATE_TYPE, this.getTemplateType());
        String templateId = this.getTemplateId(templateType);
        if (!ObjectUtils.isEmpty((Object)templateId)) {
            customParams.put("templateid", templateId);
        }
        FormShowParameter param = new FormShowParameter();
        DeclareRequestModel requestModel = new DeclareRequestModel();
        Long sbbid = AbstractDeclareReportPluginNew.getSbbid(null, orgid, startDate, endDate, customParams.get(TEMPLATE_TYPE));
        DynamicObject declareMain = AbstractDeclareReportPluginNew.getDeclareMain(orgid, startDate, endDate, customParams.get(TEMPLATE_TYPE));
        this.getPageCache().put("sbbid", ObjectUtils.isNotEmpty((Object)sbbid) ? sbbid.toString() : "0");
        this.getPageCache().put("taxlimit", taxLimit);
        requestModel.setId(sbbid);
        String billno = "";
        if (!ObjectUtils.isEmpty((Object)declareMain)) {
            billno = declareMain.getString("billno");
        }
        Long id = null;
        if (ObjectUtils.isEmpty((Object)sbbid)) {
            id = this.getSbbid();
        }
        requestModel.setId(id);
        requestModel.setOrgId(Long.valueOf(Long.parseLong(orgid)));
        requestModel.setBillNo(this.getBillno(endDate, taxLimit, billno, orgid));
        requestModel.setOrgId(Long.valueOf(Long.parseLong(orgid)));
        requestModel.setTemplateType((String)customParams.get(TEMPLATE_TYPE));
        if (!ObjectUtils.isEmpty(customParams.get("templateid"))) {
            requestModel.setTemplateId(Long.valueOf(Long.parseLong((String)customParams.get("templateid"))));
        }
        requestModel.setOperation(operationStatus);
        requestModel.setSkssqq(startDate);
        requestModel.setSkssqz(endDate);
        requestModel.setRefresh(Boolean.valueOf(refresh));
        requestModel.getBusinessMap().putAll(this.getBizParams(operationStatus, refresh));
        customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
        param.setFormId(this.getDeclareFormId());
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(CONTENT_TAB);
        String pageid = param.getPageId();
        this.getPageCache().put("declarepageid", pageid);
        param.setCustomParams(customParams);
        this.getView().showForm(param);
        this.getView().updateView(CONTENT_TAB);
        this.setBtnStatus(orgid, startDate, endDate, operationStatus);
    }

    protected abstract String getBillno(String var1, String var2, String var3, String var4);

    private boolean isYzZjgDraftExist() {
        String orgid = this.getPageCache().get(ORGID_KEY);
        String startDateStr = this.getPageCache().get(SKSSQQ);
        String endDateStr = this.getPageCache().get(SKSSQZ);
        Date startDate = DateUtils.stringToDate((String)startDateStr);
        Date endDate = DateUtils.stringToDate((String)endDateStr);
        DynamicObject declarePlanObject = OrgUtils.getOrgDeclarePlan((Long)Long.parseLong(orgid), (Date)startDate, (Date)endDate);
        if (declarePlanObject == null) {
            return false;
        }
        DynamicObjectCollection orgrow = declarePlanObject.getDynamicObjectCollection("orgrow");
        Optional<DynamicObject> mainObj = orgrow.stream().filter(o -> "2".equals(o.getString("declaration"))).findFirst();
        if (!mainObj.isPresent()) {
            return false;
        }
        orgid = mainObj.get().getDynamicObject(ORGID_KEY).getString("id");
        QFilter orgFilter = new QFilter(ORG_SEL, "=", (Object)Long.valueOf(orgid));
        QFilter startFilter = new QFilter("startdate", "=", (Object)startDate);
        QFilter endFilter = new QFilter("enddate", "=", (Object)endDate);
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)"qhjtbs");
        QFilter templateFilter = new QFilter(TEMPLATE_TYPE, "=", (Object)templateEnum.getDraftType());
        return QueryServiceHelper.exists((String)"tctb_draft_main", (QFilter[])new QFilter[]{orgFilter, templateFilter, startFilter, endFilter});
    }

    public String getDeclareFormId() {
        return DECLARE_PAGE_ENTITY_NEW;
    }

    private void setBtnStatus(String orgid, String startDate, String endDate, String operationStatus) {
        String templateType = this.getTemplateType();
        DynamicObject dyo = YbnsrService.queryYbnsr(orgid, templateType, startDate, endDate, null);
        if (dyo != null && VIEW.equals(operationStatus)) {
            String billstatus = dyo.getString("billstatus");
            if ("A".equals(billstatus)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"edit", VIEW_DRAFT_KEY, SUBMIT_KEY, CLOSE_KEY});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{AUDIT_KEY, SAVE_KEY, CANCEL_KEY, RECALC_KEY, ONE_KEY_GENERATE});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{SUBMIT_KEY});
            }
            if ("B".equals(billstatus)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{AUDIT_KEY, VIEW_DRAFT_KEY, SUBMIT_KEY, CLOSE_KEY});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"edit", SAVE_KEY, CANCEL_KEY, RECALC_KEY, ONE_KEY_GENERATE});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{SUBMIT_KEY});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{AUDIT_KEY});
            }
            if ("C".equals(billstatus)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{AUDIT_KEY, VIEW_DRAFT_KEY, CLOSE_KEY});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"edit", SAVE_KEY, CANCEL_KEY, RECALC_KEY, SUBMIT_KEY, ONE_KEY_GENERATE});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{AUDIT_KEY});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"edit", CLOSE_KEY, SUBMIT_KEY, AUDIT_KEY});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{VIEW_DRAFT_KEY, RECALC_KEY, SAVE_KEY, CANCEL_KEY, ONE_KEY_GENERATE});
        }
    }

    public static Long getSbbid(OperationStatus operationStatus, String orgid, String startDate, String endDate, Object type) {
        DynamicObject declareMain = AbstractDeclareReportPluginNew.getDeclareMain(orgid, startDate, endDate, type);
        if (declareMain != null) {
            return declareMain.getLong("id");
        }
        return null;
    }

    public static DynamicObject getDeclareMain(String orgid, String startDate, String endDate, Object type) {
        QFilter q1 = new QFilter(ORG_SEL, "=", (Object)Long.valueOf(orgid));
        QFilter q2 = new QFilter(SKSSQQ, "=", (Object)DateUtils.stringToDate((String)startDate));
        QFilter q3 = new QFilter(SKSSQZ, "=", (Object)DateUtils.stringToDate((String)endDate));
        QFilter q4 = new QFilter("type", "=", type);
        DynamicObject object = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id,billno,billstatus", (QFilter[])new QFilter[]{q1, q2, q3, q4});
        return object;
    }

    protected EngineModel buildEngineModel(String orgId, String skssqq, String skssqz, String templateType, IPageCache pageCache) {
        return new EngineModel(orgId, skssqq, skssqz, templateType, pageCache);
    }

    public abstract void init();

    public abstract String getTaxType();

    public abstract String getTemplateType();

    public abstract String getTemplateId(String var1);

    public abstract void clientCallBackMethod(Map<String, String> var1, String var2);

    public abstract void initPeriod(IDataModel var1, IPageCache var2, String var3, Map<String, Object> var4);

    protected boolean check(String orgid) {
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)appid, (String)TaxAppEnum.getEnumInstanceByAppid((String)appid).getCategoryCode());
        return checkResult;
    }

    private String setOrgId(List<TreeNode> nodeList, String currOrgId) {
        boolean checkOrgAndEnable = false;
        List<Long> taxpayerIds = this.getIsTaxpayerOrg();
        if (!CollectionUtils.isEmpty(taxpayerIds) && taxpayerIds.contains(Long.parseLong(currOrgId))) {
            boolean bl = checkOrgAndEnable = !OrgCheckServiceHelper.checkOrgAndEnable(this.getView(), currOrgId, false);
        }
        if (!checkOrgAndEnable) {
            for (TreeNode node : nodeList) {
                if (!taxpayerIds.contains(Long.parseLong(node.getId()))) continue;
                currOrgId = node.getId();
                checkOrgAndEnable = true;
                break;
            }
            if (!checkOrgAndEnable) {
                List roots = TreeUtils.findRoot(nodeList);
                currOrgId = CollectionUtils.isEmpty((Collection)roots) ? null : ((TreeNode)roots.get(0)).getId();
            }
        }
        return currOrgId;
    }

    protected List<Long> getIsTaxpayerOrg() {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs(this.getView());
        List<Long> ids = EmptyCheckUtils.isNotEmpty(hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm() && EmptyCheckUtils.isNotEmpty(hasPermOrgResult.getHasPermOrgs()) ? TcvvtTaxOrgCommonBusiness.queryTaxcOrgByOrgIdAndIsTaxpayer(hasPermOrgResult.getHasPermOrgs()) : TcvvtTaxOrgCommonBusiness.queryTaxcOrgIdByIsTaxpayer();
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Long>();
        }
        QFilter orgFilters = this.getOrgFilters(ids);
        return TcvvtTaxOrgCommonBusiness.queryTaxcMainByCustomFilter(null, new QFilter[]{orgFilters});
    }

    protected QFilter getOrgFilters(List<Long> orgIds) {
        return new QFilter(ORGID_KEY, "in", orgIds);
    }

    private void saveAdjust(String orgid, String startdate, String enddate) {
        try {
            NsrxxValidatorUtils.nsrxxReviewed((Long)Long.parseLong(orgid));
            IFormView childPage = this.getView().getView(this.getPageCache().get("declarepageid"));
            IPageCache childPageCache = childPage.getPageCache();
            Map updateMap = (Map)TreeUtils.getCache((IPageCache)childPageCache, (String)"updata_cellid", Map.class);
            Date skssqq = DateUtils.stringToDate((String)startdate);
            Date skssqz = DateUtils.stringToDate((String)enddate);
            if (updateMap == null) {
                return;
            }
            String updateCellListStr = childPageCache.get("updateCellMap");
            Map updateCellMap = ObjectUtils.isEmpty((Object)updateCellListStr) ? new HashMap() : JsonUtil.fromJson(updateCellListStr, Map.class);
            for (Map.Entry entry : updateCellMap.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                this.saveAdjust(orgid, skssqq, skssqz, key, new BigDecimal(value));
            }
        }
        catch (Exception e) {
            String exceptionStackTraceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            logger.error("\u4fdd\u5b58\u4e34\u65f6\u4fee\u6539\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)exceptionStackTraceMessage);
        }
    }

    private void saveAdjust(String orgid, Date skssqq, Date skssqz, String cellId, BigDecimal value) {
        QFilter orgFilter = new QFilter(ORG_SEL, "=", (Object)Long.parseLong(orgid));
        QFilter startFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
        QFilter endFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
        QFilter cellIdFilter = new QFilter("cellid", "=", (Object)cellId);
        QFilter[] filters = new QFilter[]{orgFilter, startFilter, endFilter, cellIdFilter};
        DynamicObject adjust = BusinessDataServiceHelper.loadSingle((String)TCVVT_FETCH_ADJUST, (String)"adjustamount", (QFilter[])filters);
        if (adjust == null) {
            this.saveNewAdjust(cellId, Long.parseLong(orgid), skssqq, skssqz, value);
        } else {
            adjust.set("adjustamount", (Object)value);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{adjust});
        }
    }

    private void saveNewAdjust(String cellId, Object orgid, Date skssqq, Date skssqz, BigDecimal value) {
        DynamicObject adjustObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCVVT_FETCH_ADJUST));
        adjustObj.set(ORG_SEL, orgid);
        adjustObj.set("cellid", (Object)cellId);
        adjustObj.set(SKSSQQ, (Object)skssqq);
        adjustObj.set(SKSSQZ, (Object)skssqz);
        adjustObj.set("titlename", (Object)ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u91d1\u989d", (String)"AbstractDeclareReportPluginNew_34", (String)"taxc-tcvvt", (Object[])new Object[0]));
        adjustObj.set("adjustamount", (Object)value);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{adjustObj});
    }

    public boolean checkLockedMutexLock(String sbbid) {
        DynamicObject dynamicObject = MutexServiceImpl.getMutexData((QFilter)new QFilter("objectid", "=", (Object)sbbid));
        if (dynamicObject != null) {
            String user = dynamicObject.getString("user.name");
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"AbstractDeclareReportPluginNew_35", (String)"taxc-tcvvt", (Object[])new Object[0]), user));
            return true;
        }
        return false;
    }

    public void pageRelease(EventObject e) {
        String sbbid = this.getPageCache().get("sbbid");
        if (StringUtils.isNotBlank((CharSequence)sbbid)) {
            MutexServiceImpl.releaseMutexLock((String)sbbid, (String)"edit", (Long)RequestContext.get().getCurrUserId());
        }
    }

    public abstract Long getSbbid();

    private Long setTaxauthority(String orgId) {
        Long taxauthorityid = null;
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainByCustomFilter(Collections.singletonList(Long.parseLong(orgId)), (Long)TaxationsysMappingEnum.CHN.getId(), (String)"taxoffice", null, null);
        if (!ObjectUtils.isEmpty((Object)result) && !ObjectUtils.isEmpty((Object)result.getData())) {
            DynamicObject dyo = (DynamicObject)((DynamicObjectCollection)result.getData()).get(0);
            taxauthorityid = dyo.getLong("taxoffice");
        }
        this.getModel().setValue(this.TAXAUTHORITY, taxauthorityid);
        return taxauthorityid;
    }
}

