/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.taxdeclare;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.taxdeclare.NsrxxValidatorUtils;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;
import kd.taxc.tcvvt.common.model.response.DeclareResponseModel;
import kd.taxc.tcvvt.common.util.DateUtils;
import kd.taxc.tcvvt.common.util.JsonUtil;
import kd.taxc.tcvvt.common.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class RuleFetchDetailPlugin
extends AbstractFormPlugin
implements SelectRowsEventListener {
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String RULEID = "ruleid";
    private static final String ENTRYENTITY_CARD = "entryentitycard";
    private static final String ENTRYENTITY_LIST = "entryentitylist";

    public void initialize() {
        CardEntry cardEntry = (CardEntry)this.getControl(ENTRYENTITY_CARD);
        cardEntry.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Object templatetype;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String orgId = customParams.get("org").toString();
        BigDecimal cellvalue = new BigDecimal("0.00");
        if (!StringUtil.isEmpty((CharSequence)customParams.get("cellvalue").toString())) {
            cellvalue = new BigDecimal(customParams.get("cellvalue").toString());
        }
        if ((templatetype = this.getView().getParentView().getFormShowParameter().getCustomParam("templatetype")) != null && "qhjtydbs".equalsIgnoreCase(templatetype.toString())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"ysz_yy", "jgz_yy", ""});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"ysz_y", "jgz_y"});
            this.getDateSource();
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"ysz_yy", "jgz_yy", ""});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"ysz_y", "jgz_y"});
            this.getDateSource();
        }
        Date skssqq = DateUtils.stringToDate((String)customParams.get(SKSSQQ));
        Date skssqz = DateUtils.stringToDate((String)customParams.get(SKSSQZ));
        String cellId = customParams.get("cellid").toString();
        String operation = customParams.get("operation") != null ? customParams.get("operation").toString() : "";
        this.getModel().setValue("operation", (Object)operation);
        this.setCancelVisible(operation);
        ImmutablePair<String, String> immutablePair = this.getAccessprojectidAndSerialno();
        String accessprojectid = (String)immutablePair.left;
        String serialNo = (String)immutablePair.right;
        if (serialNo == null) {
            this.getModel().setValue("containsitem", (Object)"true");
        }
        this.setCartModel(Long.parseLong(orgId), skssqq, skssqz, cellId, cellvalue, accessprojectid, serialNo);
        this.clearEntry(ENTRYENTITY_LIST);
        if (StringUtils.isNotEmpty((CharSequence)serialNo)) {
            this.setEntryentitylist(Long.parseLong(orgId), skssqq, skssqz, serialNo);
        }
    }

    private void setCancelVisible(String type) {
        if ("edit".equalsIgnoreCase(type)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"close"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btncancel"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btncancel"});
        }
    }

    private void getDateSource() {
        QFilter templatetypeidFilter;
        QFilter endDataFilter;
        QFilter startDataFilter;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String templatetype = this.getView().getParentView().getParentView().getPageCache().get("templatetype");
        String orgId = customParams.get("org").toString();
        Date skssqq = DateUtils.stringToDate((String)customParams.get(SKSSQQ));
        Date skssqz = DateUtils.stringToDate((String)customParams.get(SKSSQZ));
        QFilter orgidFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        DynamicObject declare = BusinessDataServiceHelper.loadSingle((String)"tcvvt_tras_declare_list", (String)"id,datatype", (QFilter[])new QFilter[]{orgidFilter, startDataFilter = new QFilter(SKSSQQ, "=", (Object)skssqq), endDataFilter = new QFilter(SKSSQZ, "=", (Object)skssqz), templatetypeidFilter = new QFilter("type", "=", (Object)templatetype)});
        if (declare != null && "2".equalsIgnoreCase(declare.getString("datatype"))) {
            this.getModel().setValue("containsitem", (Object)"true");
        }
    }

    private void setCartModel(Long orgId, Date skssqq, Date skssqz, String cellId, BigDecimal cellValue, String accessprojectid, String serialNo) {
        boolean hasSaveOldValue = this.hasSaveOldValue(orgId, skssqq, skssqz, null);
        if (!hasSaveOldValue) {
            DeclareResponseModel declareData = (DeclareResponseModel)TreeUtils.getCache((IPageCache)this.getView().getParentView().getPageCache(), (String)"declareData", DeclareResponseModel.class);
            List<String> cellIdList = this.getCellIdList();
            Map<String, String> stringMap = declareData.getData().entrySet().stream().filter(m -> cellIdList.contains(m.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            List<DynamicObject> dynamicObjects = stringMap.entrySet().stream().map(entry -> this.saveNewAdjust((String)entry.getKey(), orgId, skssqq, skssqz, new BigDecimal(StringUtil.isNotEmpty((CharSequence)((CharSequence)entry.getValue())) ? (String)entry.getValue() : "0"))).collect(Collectors.toList());
            if (dynamicObjects.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
            }
        } else {
            hasSaveOldValue = this.hasSaveOldValue(orgId, skssqq, skssqz, cellId);
            if (!hasSaveOldValue) {
                DynamicObject newAdjust = this.saveNewAdjust(cellId, orgId, skssqq, skssqz, cellValue);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newAdjust});
            }
        }
        int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY_CARD);
        String titleName = this.getTitleName(accessprojectid, serialNo);
        this.getModel().setValue("titlename", (Object)titleName, rowIndex);
        BigDecimal amount = this.getAmount(orgId, skssqq, skssqz, cellId, serialNo);
        this.getModel().setValue("amount", (Object)amount, rowIndex);
        BigDecimal sumAmount = this.getSumAmount(orgId, skssqq, skssqz, cellId);
        this.getModel().setValue("sumamount", (Object)sumAmount);
        this.getModel().setValue("adjustsumamount", (Object)cellValue);
        BigDecimal adjustamount = this.getAdjustamount(orgId, skssqq, skssqz, cellId, serialNo, sumAmount, cellValue);
        this.getModel().setValue("adjustamount", (Object)adjustamount, rowIndex);
        BigDecimal totalAmount = this.getTotalAmount(amount, adjustamount);
        this.getModel().setValue("totalamount", (Object)totalAmount, rowIndex);
        this.getModel().setValue(RULEID, (Object)serialNo);
    }

    private DynamicObject saveNewAdjust(String cellId, Object orgid, Date skssqq, Date skssqz, BigDecimal value) {
        String templatetype = this.getView().getParentView().getParentView().getPageCache().get("templatetype");
        DynamicObject adjustObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcvvt_fetch_adjust"));
        adjustObj.set("org", orgid);
        adjustObj.set("cellid", (Object)cellId);
        adjustObj.set(SKSSQQ, (Object)skssqq);
        adjustObj.set(SKSSQZ, (Object)skssqz);
        adjustObj.set("titlename", (Object)ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u91d1\u989d", (String)"RuleFetchDetailPlugin_0", (String)"taxc-tcvvt", (Object[])new Object[0]));
        adjustObj.set("oldamount", (Object)value);
        adjustObj.set("templatetype", (Object)templatetype);
        return adjustObj;
    }

    private boolean hasSaveOldValue(Long orgId, Date skssqq, Date skssqz, String cellValue) {
        QFilter qFilter = new QFilter("org", "=", (Object)orgId).and(new QFilter(SKSSQQ, "=", (Object)skssqq)).and(new QFilter(SKSSQZ, "=", (Object)skssqz));
        if (StringUtils.isNotEmpty((CharSequence)cellValue)) {
            qFilter.and(new QFilter("cellid", "=", (Object)cellValue));
        }
        return QueryServiceHelper.exists((String)"tcvvt_fetch_adjust", (QFilter[])qFilter.toArray());
    }

    private List<String> getCellIdList() {
        String templatetype = this.getView().getParentView().getParentView().getPageCache().get("templatetype");
        if (StringUtils.isEmpty((CharSequence)templatetype)) {
            return new ArrayList<String>();
        }
        QFilter qFilter = new QFilter("taxtype", "=", (Object)templatetype).and(new QFilter("celltype", "=", (Object)"6"));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tpo_formula_edit", (String)"formulakey", (QFilter[])qFilter.toArray());
        return dynamicObjects.stream().map(m -> m.getString("formulakey")).collect(Collectors.toList());
    }

    private String getTitleName(String accessprojectid, String serialNo) {
        String accessProjectEntity = this.getView().getParentView().getParentView().getPageCache().get("accessProjectEntity");
        if (StringUtils.isEmpty((CharSequence)serialNo)) {
            return ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165\u8c03\u6574\u91d1\u989d", (String)"RuleFetchDetailPlugin_0", (String)"taxc-tcvvt", (Object[])new Object[0]);
        }
        QFilter idFilter = new QFilter("id", "=", (Object)Long.parseLong(accessprojectid));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)accessProjectEntity, (String)"name", (QFilter[])new QFilter[]{idFilter});
        return dynamicObject.getString("name");
    }

    private BigDecimal getAmount(Long orgId, Date skssqq, Date skssqz, String cellId, String serialNo) {
        if (StringUtil.isEmpty((CharSequence)serialNo)) {
            return BigDecimal.ZERO;
        }
        DynamicObjectCollection calDetailList = this.getDetailData(orgId, skssqq, skssqz, serialNo);
        BigDecimal sum = calDetailList.stream().map(s -> s.getBigDecimal("reportingamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sum.setScale(2, 4);
    }

    private BigDecimal getAdjustamount(Long orgId, Date skssqq, Date skssqz, String cellId, String serialNo, BigDecimal sumAmount, BigDecimal cellValue) {
        Map<String, String> updateCellMap;
        if (this.getView().getParentView() == null) {
            return BigDecimal.ZERO;
        }
        IPageCache parentCache = this.getView().getParentView().getPageCache();
        String updateCellListStr = parentCache.get("updateCellMap");
        Map map = updateCellMap = StringUtils.isEmpty((CharSequence)updateCellListStr) ? new HashMap() : JsonUtil.fromJson(updateCellListStr, Map.class);
        if (StringUtil.isEmpty((CharSequence)serialNo)) {
            BigDecimal subtract = cellValue.subtract(sumAmount);
            updateCellMap.put(cellId, subtract.toString());
            parentCache.put("updateCellMap", JsonUtil.toJson(updateCellMap));
            return subtract;
        }
        String value = (String)updateCellMap.get(cellId);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            return new BigDecimal(value);
        }
        DynamicObject adjustData = this.getAdjustData(orgId, skssqq, skssqz, cellId);
        if (adjustData != null) {
            return adjustData.getBigDecimal("adjustamount");
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getTotalAmount(BigDecimal amount, BigDecimal adjustAmount) {
        return amount.add(adjustAmount);
    }

    private BigDecimal getSumAmount(Long orgId, Date skssqq, Date skssqz, String cellId) {
        DynamicObject adjustDetail = this.getAdjustData(orgId, skssqq, skssqz, cellId);
        if (adjustDetail != null) {
            return adjustDetail.getBigDecimal("oldamount");
        }
        return BigDecimal.ZERO;
    }

    private DynamicObject getAdjustData(Long orgId, Date skssqq, Date skssqz, String cellId) {
        String templatetype = (String)this.getView().getParentView().getFormShowParameter().getCustomParam("templatetype");
        String selectPrope = "id,org,skssqq,skssqz,cellid,titlename,adjustamount,oldamount";
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId).and(new QFilter(SKSSQQ, "=", (Object)skssqq)).and(new QFilter(SKSSQZ, "=", (Object)skssqz)).and(new QFilter("cellid", "=", (Object)cellId)).and(new QFilter("templatetype", "=", (Object)templatetype));
        return QueryServiceHelper.queryOne((String)"tcvvt_fetch_adjust", (String)selectPrope, (QFilter[])orgFilter.toArray());
    }

    private DynamicObjectCollection getDetailData(Long orgId, Date skssqq, Date skssqz, String serialno) {
        String templatetype = this.getView().getParentView().getParentView().getPageCache().get("templatetype");
        String selectPrope = "skssqq,absolute,bizname,table,amountfield,datadirection,fetchamount,filtercondition,ruleid,serialno,reportingamount,exrate";
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId).and(new QFilter(SKSSQQ, "=", (Object)skssqq)).and(new QFilter(SKSSQZ, "=", (Object)skssqz)).and(new QFilter("serialno", "=", (Object)serialno)).and(new QFilter("templatetype", "=", (Object)templatetype));
        return QueryServiceHelper.query((String)"tcvvt_fetch_detail", (String)selectPrope, (QFilter[])orgFilter.toArray());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if ("adjustamount".equals(name) || "totalamount".equals(name)) {
            if ("adjustamount".equals(name)) {
                BigDecimal adjustamount = (BigDecimal)changeData.getNewValue();
                BigDecimal amount = (BigDecimal)this.getModel().getValue("amount", rowIndex);
                this.getModel().setValue("totalamount", (Object)adjustamount.add(amount), rowIndex);
            } else {
                BigDecimal totalamount = (BigDecimal)changeData.getNewValue();
                BigDecimal amount = (BigDecimal)this.getModel().getValue("amount", rowIndex);
                BigDecimal adjustamount = totalamount.subtract(amount);
                this.getModel().setValue("adjustamount", (Object)adjustamount, rowIndex);
            }
            this.refreshAdjustSumAmount();
        }
    }

    private void refreshAdjustSumAmount() {
        DynamicObjectCollection entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD);
        BigDecimal adjustsumamount = entryentitycard.stream().map(s -> s.getBigDecimal("totalamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue("adjustsumamount", (Object)adjustsumamount);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing && "save".equals(((Donothing)args.getSource()).getOperateKey())) {
            NsrxxValidatorUtils.nsrxxReviewed((Long)Long.parseLong(this.getView().getFormShowParameter().getCustomParams().get("org").toString()));
            IPageCache parentCache = this.getView().getParentView().getPageCache();
            String updateCellListStr = parentCache.get("updateCellMap");
            Map<String, String> updateCellMap = StringUtils.isEmpty((CharSequence)updateCellListStr) ? new HashMap() : JsonUtil.fromJson(updateCellListStr, Map.class);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object cellId = customParams.get("cellid");
            BigDecimal adjustamount = (BigDecimal)this.getModel().getValue("adjustamount");
            updateCellMap.put(cellId.toString(), adjustamount.toString());
            parentCache.put("updateCellMap", JsonUtil.toJson(updateCellMap));
            customParams.put("adjustsumamout", this.getModel().getValue("adjustsumamount").toString());
            customParams.put("adjustamount", this.getModel().getValue("adjustamount"));
            this.getView().returnDataToParent((Object)customParams);
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().close();
        }
    }

    private void setEntryentitylist(Long orgId, Date skssqq, Date skssqz, String serialno) {
        DynamicObjectCollection collection = this.getDetailData(orgId, skssqq, skssqz, serialno);
        String startDate = DateUtils.format(skssqq, new DateUtils().yyyymmChinese());
        String endDate = DateUtils.format(skssqz, new DateUtils().yyyymmChinese());
        String taxperiod = startDate + "-" + endDate;
        for (DynamicObject object : collection) {
            int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY_LIST);
            this.getModel().setValue("taxperiod", (Object)taxperiod, rowIndex);
            this.getModel().setValue("bizname", object.get("bizname"), rowIndex);
            this.getModel().setValue("table", object.get("table"), rowIndex);
            this.getModel().setValue("amountfield", object.get("amountfield"), rowIndex);
            this.getModel().setValue("absolute", object.get("absolute"), rowIndex);
            this.getModel().setValue("datadirection", object.get("datadirection"), rowIndex);
            this.getModel().setValue("fetchamount", object.get("fetchamount"), rowIndex);
            this.getModel().setValue("exrate", object.get("exrate"), rowIndex);
            this.getModel().setValue("reportingamount", object.get("reportingamount"), rowIndex);
            this.getModel().setValue("filtercondition", (Object)Optional.ofNullable(object.getString("filtercondition")).orElse("").replace(" ", ""), rowIndex);
            this.getModel().setValue("filtercondition_tag", (Object)Optional.ofNullable(object.getString("filtercondition")).orElse("").replace(" ", ""), rowIndex);
        }
    }

    private void clearEntry(String ... entryNames) {
        for (String entry : entryNames) {
            this.getModel().deleteEntryData(entry);
        }
    }

    private ImmutablePair<String, String> getAccessprojectidAndSerialno() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String templatetype = this.getView().getParentView().getParentView().getPageCache().get("templatetype");
        QFilter templatetypeFilter = new QFilter("templatetype", "=", (Object)templatetype);
        String cellId = customParams.get("cellid").toString();
        String orgId = customParams.get("org").toString();
        Date skssqq = DateUtils.stringToDate((String)customParams.get(SKSSQQ));
        Date skssqz = DateUtils.stringToDate((String)customParams.get(SKSSQZ));
        QFilter orgidFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        QFilter startDataFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
        QFilter endDataFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
        QFilter formulakeyFilter = new QFilter("formulakey", "=", (Object)cellId);
        DynamicObject mainAccount = QueryServiceHelper.queryOne((String)"tcvvt_fetch_summary", (String)"id,serialno,datasource,accessprojectid", (QFilter[])new QFilter[]{orgidFilter, startDataFilter, endDataFilter, formulakeyFilter, templatetypeFilter});
        if (mainAccount == null) {
            return ImmutablePair.of(null, null);
        }
        return ImmutablePair.of((Object)mainAccount.getString("accessprojectid"), (Object)mainAccount.getString("serialno"));
    }

    public void showDetailDialog(String cellid, JSONObject params, IFormView view, IFormPlugin plugin) {
        String replaceCellId = cellid.replace("#", "_");
        IPageCache childPageCache = view.getPageCache();
        Map updateMap = (Map)TreeUtils.getCache((IPageCache)childPageCache, (String)"updata_cellid", Map.class);
        if (!CollectionUtils.isEmpty((Map)updateMap) && updateMap.containsKey(replaceCellId)) {
            params.put("cellvalue", (Object)updateMap.get(replaceCellId).toString());
        }
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)32);
        Map viewParams = view.getFormShowParameter().getCustomParams();
        DeclareRequestModel declareModel = (DeclareRequestModel)SerializationUtils.fromJsonString((String)((String)viewParams.get("declareRequestData")), DeclareRequestModel.class);
        customParams.put("org", declareModel.getOrgId().toString());
        customParams.put(SKSSQQ, declareModel.getSkssqq());
        customParams.put(SKSSQZ, declareModel.getSkssqz());
        customParams.put("operation", params.getString("operation"));
        for (Map.Entry entry : params.entrySet()) {
            customParams.put(entry.getKey(), entry.getValue());
        }
        customParams.put("cellid", cellid);
        customParams.put("fromForm", "tcvvt_fetch_detail_dialog");
        FormShowParameter param = new FormShowParameter();
        param.setFormId("tcvvt_fetch_detail_dialog");
        param.setCustomParams((Map)customParams);
        if (customParams.get("customCaption") != null) {
            param.setCaption((String)customParams.get("customCaption"));
        }
        param.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack(plugin, "cell_click_popup");
        param.setCloseCallBack(closeCallBack);
        view.showForm(param);
    }
}

