/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.taxdeclare;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.dto.AdvanceConfDto;
import kd.taxc.bdtaxr.common.taxdeclare.ruleconfig.RuleTemplateService;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class RuleTemplateNewPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ENTRY_ENTITY = "entryentity1";
    private static final String KEY_FILTERCONDITION = "filtercondition1";
    private static final String KEY_CONDITIONJSON = "conditionjson1";
    private static final String ADVANCED_CONF = "advancedconf1";
    public static final String ADVANCED_CONF_JSON = "advancedconfjson1";
    public static final String DATA_TYPE = "datatype1";
    public static final String VATRATE = "vatrate1";
    public static final String YZ_VATRATE = "yzvatrate1";
    public static final String JSBL = "jsbl1";
    public static final String EXRATEJSON = "exratejson1";
    public static final String CONVERT_RATE_JSON = "convert_rate_json";
    private static final List<String> ORG_NULLABLE_ENTITY_NAME_LIST = Arrays.asList("tcvvt_accessconfig", "tcvvt_tax_accessconfig", "tcvvt_qh_accessconfig", "itp_accessconfig", "gtcp_accessconfig");

    public void initialize() {
        BasedataEdit amountfield = (BasedataEdit)this.getControl("amountfield1");
        amountfield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit tablefield = (BasedataEdit)this.getControl("table1");
        tablefield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            String key = ((Donothing)args.getSource()).getOperateKey();
            if (!"set1".equals(key) && !"setadvancedconf1".equals(key)) {
                return;
            }
            EntryGrid entryentity = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int focusRow = entryentity.getEntryState().getFocusRow();
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table1", focusRow);
            if (tabletype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"RuleTemplateNewPlugin_0", (String)"taxc-tcvvt", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (!"set1".equals(operateKey) && !"setadvancedconf1".equals(operateKey)) {
            return;
        }
        if (args.getOperationResult().isSuccess()) {
            EntryGrid entryentity = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int focusRow = entryentity.getEntryState().getFocusRow();
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table1", focusRow);
            Long tableEntityId = tabletype.getLong("id");
            if ("set1".equals(operateKey)) {
                String ischild = tabletype.getString("ischild");
                String entityNumber = tabletype.getString("name");
                if ("false".equals(ischild) && StringUtil.isNotBlank((CharSequence)tabletype.getString("subname"))) {
                    entityNumber = tabletype.getString("subname");
                }
                this.openSettingPage(focusRow, tabletype.getLong("id"), entityNumber, ENTRY_ENTITY, KEY_CONDITIONJSON, "set1");
            }
            if ("setadvancedconf1".equals(operateKey)) {
                DynamicObject amountfield = (DynamicObject)this.getModel().getValue("amountfield1", focusRow);
                String advancedconfjson = (String)this.getModel().getValue(ADVANCED_CONF_JSON, focusRow);
                String datatype = (String)this.getModel().getValue(DATA_TYPE, focusRow);
                BigDecimal vatrate = BigDecimal.ZERO;
                BigDecimal jsbl = BigDecimal.ONE;
                BigDecimal yzvatrate = BigDecimal.ZERO;
                if (((Donothing)args.getSource()).getEntityId().equalsIgnoreCase("tcvvt_tax_accessconfig") || ((Donothing)args.getSource()).getEntityId().equalsIgnoreCase("tcvvt_qh_accessconfig")) {
                    jsbl = (BigDecimal)this.getModel().getValue(JSBL, focusRow);
                }
                if (datatype.equals("jsflqs") || datatype.equals("cysldsqs") || datatype.equals("sehshsj")) {
                    vatrate = (BigDecimal)this.getModel().getValue(VATRATE, focusRow);
                } else if (datatype.equals("gjqs")) {
                    jsbl = (BigDecimal)this.getModel().getValue(JSBL, focusRow);
                } else if (datatype.equals("yjjsflqs")) {
                    vatrate = (BigDecimal)this.getModel().getValue(VATRATE, focusRow);
                    yzvatrate = (BigDecimal)this.getModel().getValue(YZ_VATRATE, focusRow);
                }
                AdvanceConfDto advanceConfDto = new AdvanceConfDto(advancedconfjson, datatype, vatrate, jsbl, yzvatrate);
                if (this.getModel().getDataEntityType().getAllFields().containsKey(EXRATEJSON)) {
                    String exratejson = (String)this.getModel().getValue(EXRATEJSON, focusRow);
                    advanceConfDto.setConvertExrateJson(exratejson);
                }
                RuleTemplateNewPlugin.operationConfigClick(advanceConfDto, args, entryentity, amountfield, tableEntityId, this.getView(), focusRow, ENTRY_ENTITY, (IFormPlugin)this);
            }
        }
    }

    protected void openSettingPage(int rowIndex, long entityId, String entityNumber, String entityfield, String conditionjson, String actionId) {
        DynamicObject selectedRow = this.getModel().getEntryRowEntity(entityfield, rowIndex);
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("bdtaxr_filtercondition");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.setCustomParam("entityId", (Object)entityId);
        formshowParameter.setCustomParam("entityNumber", (Object)entityNumber);
        formshowParameter.setCustomParam("filterJson", selectedRow.get(conditionjson));
        formshowParameter.setCustomParam("description", selectedRow.get(KEY_FILTERCONDITION));
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Object ruleType = this.getView().getFormShowParameter().getCustomParams().get("ruletype");
        if (ORG_NULLABLE_ENTITY_NAME_LIST.contains(this.getView().getEntityId()) && org == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"RuleTemplateNewPlugin_1", (String)"taxc-tcvvt", (Object[])new Object[0]));
            return;
        }
        if (null != ruleType) {
            formshowParameter.setCustomParam("ruletype", ruleType);
        }
        if (org != null) {
            formshowParameter.setCustomParam("orgid", (Object)org.getString("id"));
        }
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        int currentRowIndex;
        Map filterData;
        super.closedCallBack(evt);
        if ("set1".equals(evt.getActionId()) && (filterData = (Map)evt.getReturnData()) != null) {
            currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            this.getModel().setValue(KEY_FILTERCONDITION, filterData.get("filterdescription"), currentRowIndex);
            this.getModel().setValue(KEY_CONDITIONJSON, filterData.get("filtervalue"), currentRowIndex);
        }
        if ("setadvancedconf1".equals(evt.getActionId()) && (filterData = (Map)evt.getReturnData()) != null) {
            Object datatype;
            currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            this.getModel().setValue(ADVANCED_CONF, filterData.get("advancedconf"), currentRowIndex);
            this.getModel().setValue(ADVANCED_CONF_JSON, filterData.get("advancedconfjson"), currentRowIndex);
            if (("tcvvt_tax_accessconfig".equalsIgnoreCase(this.getView().getEntityId()) || "tcvvt_qh_accessconfig".equalsIgnoreCase(this.getView().getEntityId())) && filterData.get("jsbl") != null) {
                this.getModel().setValue(JSBL, filterData.get("jsbl"), currentRowIndex);
            }
            if (this.getModel().getDataEntityType().getAllFields().containsKey(EXRATEJSON)) {
                this.getModel().setValue(EXRATEJSON, filterData.get(CONVERT_RATE_JSON), currentRowIndex);
            }
            if ((datatype = this.getModel().getValue(DATA_TYPE, currentRowIndex)).equals("jsflqs") || datatype.equals("cysldsqs") || datatype.equals("sehshsj")) {
                this.getModel().setValue(VATRATE, filterData.get("vatrate"), currentRowIndex);
            } else if (datatype.equals("gjqs")) {
                this.getModel().setValue(JSBL, filterData.get("jsbl"), currentRowIndex);
            } else if (datatype.equals("yjjsflqs")) {
                this.getModel().setValue(VATRATE, filterData.get("vatrate"), currentRowIndex);
                this.getModel().setValue(YZ_VATRATE, filterData.get("yzvatrate"), currentRowIndex);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if (!"leasecontractno".equals(key)) {
            RuleTemplateService.setRuleConfig((BeforeF7SelectEvent)evt, (IDataModel)this.getModel(), (IFormView)this.getView());
        }
    }

    public static void operationConfigClick(AdvanceConfDto advanceConfDto, AfterDoOperationEventArgs args, EntryGrid entryentity, DynamicObject amountfield, Long tableEntityId, IFormView formView, int focusRow, String entity, IFormPlugin plugin) {
        String entitySuffix = ((Donothing)args.getSource()).getOperateKey();
        entitySuffix = entitySuffix.replace("setadvancedconf1", "");
        if (amountfield == null) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u91d1\u989d\u3002", (String)"RuleTemplateNewPlugin_2", (String)"taxc-tcvvt", (Object[])new Object[0]));
            return;
        }
        Long fieldEntityId = amountfield.getLong("id");
        QFilter tableFilter = new QFilter("id", "=", (Object)tableEntityId);
        String fieldNumber = amountfield.getString("fieldname");
        QFilter fieldFilter = new QFilter("entryentity.id", "=", (Object)fieldEntityId);
        DynamicObject obj = QueryServiceHelper.queryOne((String)"tctb_custom_datasource", (String)"entryentity.accesslogic", (QFilter[])new QFilter[]{tableFilter, fieldFilter});
        RuleTemplateNewPlugin.openAdvancedConfPage(advanceConfDto, formView, focusRow, tableEntityId, entity, "setadvancedconf1" + entitySuffix, plugin, obj.getString("entryentity.accesslogic"));
    }

    public static void openAdvancedConfPage(AdvanceConfDto advanceConfDto, IFormView formView, int rowIndex, long entityId, String entityNumber, String actionId, IFormPlugin plugin, String accesslogic) {
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("bdtaxr_advancedconf");
        CloseCallBack closeCallBack = new CloseCallBack(plugin, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.setCustomParam("entityId", (Object)entityId);
        formshowParameter.setCustomParam("entityNumber", (Object)advanceConfDto.getTableNumber());
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formshowParameter.getCustomParams().put("advancedConfData", accesslogic);
        formshowParameter.getCustomParams().put("advancedConfValue", advanceConfDto.getAdvancedconfjson());
        formshowParameter.getCustomParams().put("datatype", advanceConfDto.getDatatype());
        formshowParameter.getCustomParams().put("vatrate", advanceConfDto.getVatrate());
        formshowParameter.getCustomParams().put("yzvatrate", advanceConfDto.getYzvatrate());
        formshowParameter.getCustomParams().put("jsbl", advanceConfDto.getJsbl());
        formshowParameter.getCustomParams().put("advanceconfKey", advanceConfDto.getAdvanceconfKey());
        formshowParameter.getCustomParams().put(CONVERT_RATE_JSON, advanceConfDto.getConvertExrateJson());
        formshowParameter.getCustomParams().put("onlyRead", advanceConfDto.getOnlyRead());
        formshowParameter.getCustomParams().put("differenceinvoice", advanceConfDto.getDifferenceInvoice());
        formView.showForm(formshowParameter);
    }
}

