/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.tras;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.enums.TcvvtTrasProductProjectUnit;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.tcvvt.business.tras.TrasStaffDeclareBusinessImpl;
import kd.taxc.tcvvt.common.enums.TcvvtTrasProductEnum;
import org.apache.commons.lang3.ObjectUtils;

public class TcvvtProductFetchDataPlugin
extends AbstractDynamicListBasePlugin {
    private Map<String, String> formulakeyMapBn = Collections.synchronizedMap(new HashMap());
    private Map<String, String> formulakeyMapSn = Collections.synchronizedMap(new HashMap());
    private Map<Integer, Map<String, String>> projectGroupMap = new HashMap<Integer, Map<String, String>>(512);
    private Map<String, Set<String>> accessConfigGroupMap = new HashMap<String, Set<String>>(512);
    private List<String> projectIdList = new ArrayList<String>(8);
    private List<String> formulakeyList = new ArrayList<String>();
    private static final String PROCUCTPPREFIX = "tcvvt_product#";
    private static final String ENTRYENTITYBN = "entryentity";
    private static final String ENTRYENTITYSN = "entryentity1";

    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        String key;
        Map<Long, String> projectcaliberMap = TcvvtProductFetchDataPlugin.getProjectcaliberMap();
        Map<String, String> projectunitMap = this.getProjectunitMap();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
        Long orgId = Long.parseLong(bussinessParamsVo.getOrgId());
        Date startDate = bussinessParamsVo.getStartDate();
        Date endDate = bussinessParamsVo.getEndDate();
        String templatetype = (String)bussinessParamsVo.getExtendParams().get("templatetype");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        String templateNum = "";
        if ("zdsybs_yd".equalsIgnoreCase(templatetype)) {
            templateNum = calendar.get(1) >= 2024 ? "ZDSYBSYD2024" : (calendar.get(1) == 2023 ? "ZDSYBSYD2023" : "ZDSYBSYD2020");
        }
        if ("zdsybs_jd".equalsIgnoreCase(templatetype)) {
            templateNum = calendar.get(1) >= 2024 ? "ZDSYBSJD2024" : (calendar.get(1) == 2023 ? "ZDSYBSJD2023" : "ZDSYBSJD2020");
        }
        TrasStaffDeclareBusinessImpl trasStaffDeclareBusiness = new TrasStaffDeclareBusinessImpl();
        QFilter qFilter = new QFilter("reporttype", "=", (Object)"product");
        List<DynamicObject> accessConfigList = trasStaffDeclareBusiness.queryMatchAccessConfig(orgId, qFilter);
        for (DynamicObject dynamicObject : accessConfigList) {
            Set<Object> projectcaliber;
            long l = dynamicObject.getLong("projectcaliber.id");
            String accessprojectId = dynamicObject.getString("accessproject.id");
            String projectcaliberKey = accessprojectId + "-" + l;
            DynamicObjectCollection collectionBn = dynamicObject.getDynamicObjectCollection(ENTRYENTITYBN);
            DynamicObjectCollection collectionSn = dynamicObject.getDynamicObjectCollection(ENTRYENTITYSN);
            if (this.accessConfigGroupMap.containsKey(accessprojectId)) {
                projectcaliber = this.accessConfigGroupMap.get(accessprojectId);
                if (!ObjectUtils.isEmpty((Object)collectionBn)) {
                    projectcaliber.add((String)projectcaliberKey + "-bybn");
                }
                if (!ObjectUtils.isEmpty((Object)collectionSn)) {
                    projectcaliber.add((String)projectcaliberKey + "-bysn");
                }
                this.accessConfigGroupMap.put(accessprojectId, projectcaliber);
                continue;
            }
            projectcaliber = new HashSet();
            if (!ObjectUtils.isEmpty((Object)collectionBn)) {
                projectcaliber.add((String)projectcaliberKey + "-bybn");
            }
            if (!ObjectUtils.isEmpty((Object)collectionSn)) {
                projectcaliber.add((String)projectcaliberKey + "-bysn");
            }
            this.accessConfigGroupMap.put(accessprojectId, projectcaliber);
        }
        int j = 2;
        for (Map.Entry<String, Set<String>> entry : this.accessConfigGroupMap.entrySet()) {
            Set<String> set = entry.getValue();
            key = entry.getKey();
            this.projectIdList.add(key);
            for (String s : set) {
                String[] split = s.split("-");
                String id = split[0] + "-" + split[1];
                String formulakey = PROCUCTPPREFIX + j + "#" + projectcaliberMap.get(Long.parseLong(split[1])) + split[2];
                if (s.contains("bybn")) {
                    this.formulakeyMapBn.put(id, formulakey);
                    this.formulakeyList.add(formulakey);
                }
                if (!s.contains("bysn")) continue;
                this.formulakeyMapSn.put(id, formulakey);
                this.formulakeyList.add(formulakey);
            }
            ++j;
        }
        Map<String, String> map = trasStaffDeclareBusiness.getFetchAmountParamsTask(orgId, startDate, endDate, templatetype, TrasStaffDeclareBusinessImpl.getRuleFetchBusiness(), this.formulakeyMapBn, this.formulakeyMapSn, templateNum);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Map<Object, Object> projectcaliberNameMap;
            key = entry.getKey();
            String value = entry.getValue();
            if (!this.formulakeyList.contains(key)) continue;
            String[] split = key.split("#");
            int row = Integer.parseInt(split[1]);
            String projectcaliberName = split[2];
            if (this.projectGroupMap.containsKey(row)) {
                projectcaliberNameMap = this.projectGroupMap.get(row);
                projectcaliberNameMap.put(projectcaliberName, value);
                this.projectGroupMap.put(row, projectcaliberNameMap);
                continue;
            }
            projectcaliberNameMap = new HashMap<String, String>();
            projectcaliberNameMap.put(projectcaliberName, value);
            this.projectGroupMap.put(row, projectcaliberNameMap);
        }
        for (Map.Entry<Integer, Map<String, String>> entry : this.projectGroupMap.entrySet()) {
            int row = entry.getKey();
            String projectId = this.projectIdList.get(row - 2);
            HashMap<String, String> map2 = new HashMap<String, String>(512);
            map2.put(PROCUCTPPREFIX + row + "#cpmc", projectId);
            map2.put(PROCUCTPPREFIX + row + "#unit", projectunitMap.get(projectId));
            Map<String, String> caliberMap = entry.getValue();
            for (Map.Entry<String, String> caliberEntry : caliberMap.entrySet()) {
                String key2 = caliberEntry.getKey();
                String value = caliberEntry.getValue();
                map2.put(PROCUCTPPREFIX + row + "#" + key2, value);
            }
            list.add(map2);
        }
        return list;
    }

    private Map<String, String> getProjectunitMap() {
        HashMap<String, String> projectuniMap = new HashMap<String, String>(512);
        for (TcvvtTrasProductProjectUnit value : TcvvtTrasProductProjectUnit.values()) {
            projectuniMap.put(String.valueOf(value.getId()), value.getUnit().getDescription());
        }
        return projectuniMap;
    }

    public static Map<Long, String> getProjectcaliberMap() {
        HashMap<Long, String> projectcaliberMap = new HashMap<Long, String>(512);
        for (TcvvtTrasProductEnum value : TcvvtTrasProductEnum.values()) {
            projectcaliberMap.put(value.getId(), value.getName());
        }
        return projectcaliberMap;
    }
}

