/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.formplugin.tras;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.finance.TcvvtCategoryInfoBusinessImpl;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.tcvvt.business.rulefetch.DeclareBusinessImpl;
import kd.taxc.tcvvt.business.tras.TrasQueryRecentlyDeclareChangeBusinessImpl;
import kd.taxc.tcvvt.business.tras.TrasStaffDeclareBusinessImpl;
import kd.taxc.tcvvt.common.util.DateUtils;
import kd.taxc.tcvvt.common.util.StringUtil;
import kd.taxc.tcvvt.common.util.table.YbnsrService;
import kd.taxc.tcvvt.formplugin.taxdeclare.AbstractDeclareReportPluginNew;
import org.apache.commons.lang3.ObjectUtils;

public class TrasStaffDeclarePlugin
extends AbstractDeclareReportPluginNew
implements BeforeF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public String getMainEntity() {
        return "tcvvt_tras_declare_list";
    }

    @Override
    public void initPeriod(IDataModel getModel, IPageCache getPageCache, String orgId, Map<String, Object> customParams) {
        Date endDate;
        Date startDate;
        if (Boolean.TRUE.equals(customParams.get("readonly"))) {
            startDate = DateUtils.stringToDate((String)customParams.get("skssqq"));
            endDate = DateUtils.stringToDate((String)customParams.get("skssqz"));
        } else {
            Map<String, Date> map = TrasStaffDeclarePlugin.preTaxPeriod(orgId, new Date());
            startDate = map.get("startDate");
            endDate = map.get("endDate");
        }
        getPageCache.put("dateChanged", "false");
        getModel.setValue("skssqq", (Object)startDate);
        getPageCache.put("dateChanged", "false");
        getModel.setValue("skssqz", (Object)endDate);
        getPageCache.put("skssqq", DateUtils.format(startDate));
        getPageCache.put("skssqz", DateUtils.format(endDate));
    }

    @Override
    public void init() {
        this.getPageCache().put("templatetype", this.getTemplateType());
        this.getPageCache().put("accessProjectEntity", "tpo_keytaxsrc");
    }

    @Override
    public String setBillno(Date skssqz, String orgid) {
        String entry = this.getMainEntity();
        DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)entry);
        dyo.set("skssqz", (Object)skssqz);
        return CodeRuleServiceHelper.getNumber((String)entry, (DynamicObject)dyo, (String)orgid);
    }

    @Override
    public String getTaxType() {
        return null;
    }

    @Override
    public String getTemplateType() {
        String orgId = this.getPageCache().get("orgid");
        String startDate = this.getPageCache().get("skssqq");
        String endDate = this.getPageCache().get("skssqz");
        String templateType = "zdsybs_yd";
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.stringToDate(startDate));
        switch (calendar.get(2) + 1) {
            case 3: 
            case 6: 
            case 9: 
            case 12: {
                templateType = "zdsybs_jd";
            }
        }
        this.getPageCache().put("templatetype" + orgId + startDate + endDate, templateType);
        return templateType;
    }

    @Override
    public String getTemplateId(String templateType) {
        String orgId = this.getPageCache().get("orgid");
        String startDate = this.getPageCache().get("skssqq");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateUtils.stringToDate(startDate));
        String templateNum = "";
        if ("zdsybs_yd".equalsIgnoreCase(templateType)) {
            templateNum = calendar.get(1) >= 2024 ? "ZDSYBSYD2024" : (calendar.get(1) == 2023 ? "ZDSYBSYD2023" : "ZDSYBSYD2020");
        }
        if ("zdsybs_jd".equalsIgnoreCase(templateType)) {
            templateNum = calendar.get(1) >= 2024 ? "ZDSYBSJD2024" : (calendar.get(1) == 2023 ? "ZDSYBSJD2023" : "ZDSYBSJD2020");
        }
        return TrasQueryRecentlyDeclareChangeBusinessImpl.gettemplateidBynumber(templateNum);
    }

    @Override
    protected Map<String, String> getBizParams(String operationType, boolean refresh) {
        Map<String, String> map = super.getBizParams(operationType, refresh);
        String orgId = this.getPageCache().get("orgid");
        Date skssqq = DateUtils.stringToDate(this.getPageCache().get("skssqq"));
        Date skssqz = DateUtils.stringToDate(this.getPageCache().get("skssqz"));
        Date lastYearMonth = DateUtils.addYear(skssqq, -1);
        map.put("userid", String.valueOf(RequestContext.get().getCurrUserId()));
        new DateUtils();
        map.put("bnmc", DateUtils.format(skssqq, DateUtils.yyyyChinese()));
        new DateUtils();
        map.put("snmc", DateUtils.format(lastYearMonth, DateUtils.yyyyChinese()));
        map.put("bnyljmc", DateUtils.format(skssqq, new DateUtils().yYMmAddUpChinese()));
        map.put("snyljmc", DateUtils.format(lastYearMonth, new DateUtils().yYMmAddUpChinese()));
        map.put("yqmmc", DateUtils.format(lastYearMonth, new DateUtils().mmEndTermChinese()));
        Date surveyZbycYear = skssqq;
        Date surveyZbxyycYear = skssqq;
        int monthOfDateStart = DateUtils.getMonthOfDate(skssqq);
        surveyZbycYear = 12 == monthOfDateStart ? DateUtils.getFirstDateOfYear(DateUtils.addYear(skssqq, 1)) : DateUtils.addMonth(surveyZbycYear, 1);
        surveyZbxyycYear = 11 == monthOfDateStart ? DateUtils.getFirstDateOfYear(DateUtils.addYear(skssqq, 1)) : DateUtils.addMonth(surveyZbxyycYear, 2);
        map.put("tbnyycmc", DateUtils.format(surveyZbycYear, new DateUtils().yyyymmYcChinese()));
        map.put("tbsnysjwcmc", DateUtils.format(DateUtils.addYear(surveyZbycYear, -1), new DateUtils().yyyymmSjwcChinese()));
        map.put("tbnqnycmc", DateUtils.format(surveyZbycYear, new DateUtils().yyyyQnycChinese()));
        map.put("tbsnqnsjmc", DateUtils.format(DateUtils.addYear(surveyZbycYear, -1), new DateUtils().yyyyQnsjChinese()));
        map.put("tbnyxyycmc", DateUtils.format(surveyZbxyycYear, DateUtils.YYYYMM_YC_CHINESE));
        map.put("tbsnyxysjwcmc", DateUtils.format(DateUtils.addYear(surveyZbxyycYear, -1), DateUtils.YYYYMM_SJWC_CHINESE));
        map.put("tbnxyqnycmc", DateUtils.format(surveyZbxyycYear, DateUtils.YYYY_QNYC_CHINESE));
        map.put("tbsnxyqnsjmc", DateUtils.format(DateUtils.addYear(surveyZbxyycYear, -1), DateUtils.YYYY_QNSJ_CHINESE));
        String resentlyChangeReport = TrasQueryRecentlyDeclareChangeBusinessImpl.getResentlyDeclareChangeIdByOrgIdAndDate(Long.valueOf(orgId), skssqq);
        map.put("resentlychangesbbid", resentlyChangeReport);
        if (StringUtil.equalsIgnoreCase((CharSequence)operationType, (CharSequence)"edit")) {
            QFilter orgQ = new QFilter("taxorg", "=", (Object)Long.valueOf(orgId));
            DynamicObject[] objects = BusinessDataServiceHelper.load((String)"tctb_tax_main", (String)"registertime,categoryentryentity.taxtype,categoryentryentity.deadline,categoryentryentity.enable", (QFilter[])new QFilter[]{orgQ});
            if (ObjectUtils.isNotEmpty((Object)objects)) {
                DynamicObject object = objects[0];
                map.put("registertime", ObjectUtils.isEmpty((Object)object.get("registertime")) ? "" : DateUtils.format(object.getDate("registertime")));
                DynamicObjectCollection collection = object.getDynamicObjectCollection("categoryentryentity");
                collection.stream().forEach(o -> {
                    if (StringUtil.equalsIgnoreCase((CharSequence)o.getString("taxtype"), (CharSequence)"zzs")) {
                        map.put("zzs_deadline", o.getString("deadline"));
                    } else if (StringUtil.equalsIgnoreCase((CharSequence)o.getString("taxtype"), (CharSequence)"qysds")) {
                        Boolean cardEnable = o.getBoolean("enable");
                        String qysdsDeadline = o.getString("deadline");
                        if (cardEnable.booleanValue()) {
                            switch (qysdsDeadline) {
                                case "aysb": {
                                    map.put("qysds_deadline", "1");
                                    break;
                                }
                                case "ajsb": {
                                    map.put("qysds_deadline", "2");
                                    break;
                                }
                            }
                        } else {
                            map.put("qysds_deadline", "0");
                        }
                    }
                });
            }
            map.put("surveysbbid", "0");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("org", "=", (Object)Long.valueOf(orgId)));
            qFilters.add(new QFilter("type", "=", (Object)"zdsybs_yd").or("type", "=", (Object)"zdsybs_jd"));
            qFilters.add(new QFilter("taxlimit", "=", (Object)DateUtils.getTaxLimit(skssqq, skssqz)));
            DynamicObjectCollection surveyCol = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]), (String)"modifytime desc", (int)1);
            if (ObjectUtils.isNotEmpty((Object)surveyCol)) {
                map.put("surveysbbid", ((DynamicObject)surveyCol.get(0)).getString("id"));
            }
            Date surveyZbycSkssqq = skssqq;
            Date surveyZbycSkssqz = skssqz;
            if (12 == monthOfDateStart) {
                surveyZbycSkssqz = DateUtils.addMonth(DateUtils.addYear(surveyZbycSkssqz, 1), -1);
            } else {
                surveyZbycSkssqq = DateUtils.getFreeDateByYear(DateUtils.addYear(skssqq, -1), "-12-01 00:00:00");
                surveyZbycSkssqz = DateUtils.getFreeDateByYear(skssqz, "-11-30 00:00:00");
            }
            map.put("surveyzbycsbbid", "0");
            ArrayList<QFilter> surveyZbycFilters = new ArrayList<QFilter>();
            surveyZbycFilters.add(new QFilter("org", "=", (Object)Long.valueOf(orgId)));
            surveyZbycFilters.add(new QFilter("type", "=", (Object)"zdsybs_yd").or("type", "=", (Object)"zdsybs_jd"));
            surveyZbycFilters.add(new QFilter("taxlimit", "=", (Object)DateUtils.getTaxLimit(skssqq, skssqz)));
            surveyZbycFilters.add(new QFilter("skssqq", ">=", (Object)surveyZbycSkssqq));
            surveyZbycFilters.add(new QFilter("skssqz", "<=", (Object)surveyZbycSkssqz));
            DynamicObjectCollection surveyZbycCol = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id", (QFilter[])surveyZbycFilters.toArray(new QFilter[surveyZbycFilters.size()]), (String)"modifytime desc", (int)1);
            if (ObjectUtils.isNotEmpty((Object)surveyZbycCol)) {
                map.put("surveyzbycsbbid", ((DynamicObject)surveyZbycCol.get(0)).getString("id"));
            }
            Date firstdayofjan = DateUtils.getFirstDateOfYear(skssqq);
            Date enddayoflastmonth = DateUtils.getLastDateOfMonth(DateUtils.addMonth(skssqq, -1));
            DynamicObjectCollection bnljCol = YbnsrService.queryDateRangeSbbId(orgId, null, DateUtils.getTaxLimit(skssqq, skssqz), firstdayofjan, enddayoflastmonth);
            StringBuilder bnljSbbIds = new StringBuilder();
            StringBuilder ids = new StringBuilder();
            if (ObjectUtils.isNotEmpty((Object)bnljCol)) {
                bnljCol.stream().forEach(o -> ids.append("'").append(o.getString("id")).append("',"));
                bnljSbbIds.append(ids.substring(0, ids.lastIndexOf(",")));
            } else {
                bnljSbbIds.append("''");
            }
            map.put("bnljsbbids", bnljSbbIds.toString());
            String isFirstSeason = "0";
            String isFirstMonth = "0";
            String isJanuray = "0";
            TaxResult zzs = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(Long.parseLong(orgId)));
            String deadline = "";
            int monthOfDate = DateUtils.getMonthOfDate(skssqq);
            String prePeriodSbbid = "";
            if (!ObjectUtils.isEmpty((Object)zzs) && !ObjectUtils.isEmpty((Object)zzs.getData())) {
                DynamicObjectCollection categoryentryentity = (DynamicObjectCollection)((DynamicObject)((List)zzs.getData()).get(0)).get("categoryentryentity");
                if (!ObjectUtils.isEmpty((Object)categoryentryentity)) {
                    deadline = ((DynamicObject)((DynamicObjectCollection)((DynamicObject)((List)zzs.getData()).get(0)).get("categoryentryentity")).get(0)).getString("deadline");
                }
                if ("ajsb".equalsIgnoreCase(deadline) && monthOfDate <= 3) {
                    isFirstSeason = "1";
                }
                if ("aysb".equalsIgnoreCase(deadline) && monthOfDate == 1) {
                    isFirstMonth = "1";
                }
                if (monthOfDate == 1) {
                    isJanuray = "1";
                }
                prePeriodSbbid = DeclareBusinessImpl.QueryPrePirodSbbidByOrgAndDate(Long.parseLong(orgId), skssqq);
                map.put("isJanuray", isJanuray);
                map.put("isFirstSeason", isFirstSeason);
                map.put("isFirstMonth", isFirstMonth);
                map.put("prePeriodSbbid", prePeriodSbbid);
            }
        }
        return map;
    }

    @Override
    public void clientCallBackMethod(Map<String, String> dataMap, String sheetid) {
    }

    private static Map<String, Date> preTaxPeriod(String orgId, Date now) {
        HashMap<String, Date> result = new HashMap<String, Date>();
        Date lastMonth = DateUtils.addMonth(now, -1);
        Date startDate = DateUtils.getFirstDateOfMonth(lastMonth);
        Date endDate = DateUtils.getLastDateOfMonth(lastMonth);
        result.put("startDate", startDate);
        result.put("endDate", endDate);
        return result;
    }

    @Override
    protected Map<String, String> getFetchConfigParams() {
        Map<String, String> map = super.getFetchConfigParams();
        String orgId = this.getPageCache().get("orgid");
        if (ObjectUtils.isEmpty((Object)orgId)) {
            return map;
        }
        Date skssqq = DateUtils.stringToDate(this.getPageCache().get("skssqq"));
        Date skssqz = DateUtils.stringToDate(this.getPageCache().get("skssqz"));
        Date lastYearMonth = DateUtils.addYear(skssqq, -1);
        DynamicObject snNsrxx = this.queryNsrxx(orgId, DateUtils.format(DateUtils.getFirstDateOfMonth(lastYearMonth)), DateUtils.format(DateUtils.getLastDateOfMonth(lastYearMonth)));
        map.put("snsbbid", null != snNsrxx ? snNsrxx.getString("id") : "");
        this.gainSnTqAmount(map.get("snsbbid"), map);
        if (StringUtil.equalsIgnoreCase((CharSequence)this.getTemplateType(), (CharSequence)"zdsybs_jd")) {
            this.gainCwbSnAmount(map.get("snsbbid"), map);
            Date snDecEndDate = DateUtils.getLastDateOfYear(lastYearMonth);
            DynamicObject snDecNsrxx = this.queryNsrxx(orgId, DateUtils.format(DateUtils.getFirstDateOfMonth(snDecEndDate)), DateUtils.format(DateUtils.getLastDateOfMonth(snDecEndDate)));
            map.put("sndecsbbid", null != snDecNsrxx ? snDecNsrxx.getString("id") : "");
            this.gainBnncAmount(map.get("sndecsbbid"), map);
        }
        TrasStaffDeclareBusinessImpl trasStaffDeclareBusiness = new TrasStaffDeclareBusinessImpl();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(skssqq);
        String templateNum = "";
        String templateType = this.getTemplateType();
        if ("zdsybs_yd".equalsIgnoreCase(templateType)) {
            templateNum = calendar.get(1) >= 2024 ? "ZDSYBSYD2024" : (calendar.get(1) == 2023 ? "ZDSYBSYD2023" : "ZDSYBSYD2020");
        }
        if ("zdsybs_jd".equalsIgnoreCase(templateType)) {
            templateNum = calendar.get(1) >= 2024 ? "ZDSYBSJD2024" : (calendar.get(1) == 2023 ? "ZDSYBSJD2023" : "ZDSYBSJD2020");
        }
        map.putAll(trasStaffDeclareBusiness.getFetchAmountParamsTask(Long.valueOf(orgId), skssqq, skssqz, this.getTemplateType(), TrasStaffDeclareBusinessImpl.getRuleFetchBusiness(), null, null, templateNum));
        this.makeUpMap(this.getTemplateType(), templateNum, map);
        return map;
    }

    @Override
    protected boolean check(String orgid) {
        boolean checkResult = super.check(orgid);
        if (checkResult) {
            return checkResult;
        }
        DynamicObject dynamicObject = TcvvtCategoryInfoBusinessImpl.queryzdsyCategoryInfoByOrgId((String)orgid);
        if (ObjectUtils.isNotEmpty((Object)dynamicObject) && !ObjectUtils.isEmpty((Object)dynamicObject.getDynamicObjectCollection("categoryentryentity"))) {
            boolean bl = checkResult = !((DynamicObject)dynamicObject.getDynamicObjectCollection("categoryentryentity").get(0)).getBoolean("enable");
            if (checkResult) {
                String name = dynamicObject.getDynamicObject("taxorg").getString("org.name");
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u7ec7\u7684\u201c\u91cd\u70b9\u7a0e\u6e90\u201d=\u201c\u5426\u201d\uff0c\u8bf7\u5230\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u7ef4\u62a4\u3002", (String)"TrasStaffDeclarePlugin_0", (String)"taxc-tcvvt", (Object[])new Object[0]), name));
                return checkResult;
            }
        }
        return checkResult;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("org".equalsIgnoreCase(name)) {
            List<Long> isTaxpayerOrg = this.getIsTaxpayerOrg();
            QFilter qFilter = new QFilter("id", "in", isTaxpayerOrg);
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(qFilter);
            formShowParameter.getTreeFilterParameter().getQFilters().add(qFilter);
        }
    }

    @Override
    protected QFilter getOrgFilters(List<Long> orgList) {
        List ids = TcvvtCategoryInfoBusinessImpl.queryzdsyCategoryInfoByOrgIds(orgList);
        QFilter qFilter = new QFilter("orgid", "in", (Object)ids);
        QFilter qFilter1 = new QFilter("billstatus", "=", (Object)"C");
        return qFilter.and(qFilter1);
    }

    private void gainSnTqAmount(String snsbbid, Map<String, String> map) {
        if (StringUtil.isNotEmpty((CharSequence)snsbbid)) {
            QFilter snsbbIdQ = new QFilter("sbbid", "=", (Object)snsbbid);
            DynamicObjectCollection sntqCollection = QueryServiceHelper.query((String)"tcvvt_tax", (String)"ewblxh,bnbq,bnlj", (QFilter[])new QFilter[]{snsbbIdQ});
            sntqCollection.stream().forEach(row -> {
                String number = row.getString("ewblxh");
                map.put("tcvvt_tax#" + number + "#snbq", row.getString("bnbq"));
                map.put("tcvvt_tax#" + number + "#snlj", row.getString("bnlj"));
            });
        }
    }

    private void gainCwbSnAmount(String snsbbid, Map<String, String> map) {
        if (StringUtil.isNotEmpty((CharSequence)snsbbid)) {
            QFilter snsbbIdQ = new QFilter("sbbid", "=", (Object)snsbbid);
            DynamicObjectCollection sntqCollection = QueryServiceHelper.query((String)"tcvvt_debty", (String)"ewblxh,bnylj,bnnc,bnyqm", (QFilter[])new QFilter[]{snsbbIdQ});
            sntqCollection.stream().forEach(row -> {
                String number = row.getString("ewblxh");
                map.put("tcvvt_debty#" + number + "#snylj", row.getString("bnylj"));
                map.put("tcvvt_debty#" + number + "#snnc", row.getString("bnnc"));
                map.put("tcvvt_debty#" + number + "#snyqm", row.getString("bnyqm"));
            });
        }
    }

    private void gainBnncAmount(String sndecsbbid, Map<String, String> map) {
        if (StringUtil.isNotEmpty((CharSequence)sndecsbbid)) {
            QFilter snsbbIdQ = new QFilter("sbbid", "=", (Object)sndecsbbid);
            DynamicObjectCollection sntqCollection = QueryServiceHelper.query((String)"tcvvt_debty", (String)"ewblxh,bnyqm", (QFilter[])new QFilter[]{snsbbIdQ});
            sntqCollection.stream().forEach(row -> {
                String number = row.getString("ewblxh");
                map.put("tcvvt_debty#" + number + "#bnnc", row.getString("bnyqm"));
            });
        }
    }

    private void makeUpMap(String templateType, String templateNub, Map<String, String> map) {
        QFilter taxTypeFilter = new QFilter("taxtype.number", "=", (Object)templateType);
        QFilter formulaname = new QFilter("formula", "like", (Object)"%{P%");
        QFilter formulaTypeFilter = new QFilter("formulatype", "=", (Object)"1");
        QFilter templatenum = new QFilter("templatenum", "=", (Object)templateNub);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tpo_formula_edit", (String)"id,formulaname,formulakey", (QFilter[])new QFilter[]{taxTypeFilter, formulaname, formulaTypeFilter, templatenum});
        for (DynamicObject dyo : collection) {
            String formulaKey;
            if (!StringUtil.isOnlyNumber(dyo.getString("formulaname")) || map.containsKey(formulaKey = dyo.getString("formulakey"))) continue;
            map.put(formulaKey, String.valueOf(BigDecimal.ZERO));
        }
    }

    @Override
    protected String getBillno(String enddate, String type, String billno, String orgId) {
        if (!ObjectUtils.isEmpty((Object)billno) && billno.startsWith("LBTA")) {
            return billno;
        }
        String entity = this.getMainEntity();
        Date date = DateUtils.stringToDate(enddate);
        DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)entity);
        dyo.set("skssqz", (Object)date);
        return DeclareServiceHelper.generateSBBNo((String)this.getMainEntity(), (DynamicObject)dyo, (String)orgId);
    }

    @Override
    public Long getSbbid() {
        return DeclareServiceHelper.generateSBBId((String)this.getMainEntity());
    }
}

