/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.opplugin.group;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tcvvt.common.util.DateUtils;

public class GroupBookOp
extends AbstractOperationServicePlugIn {
    private static final String FIELD_EFFECTDATE = "startdate";
    private static final String FIELD_INVALIDDATE = "enddate";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_NAME = "name";
    private static final String ID = "id";
    private static final String ENTRYGRID_NAME = "orgrow";
    private static final String FIELD_ORGID = "orgid";

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    Map map;
                    QFilter q;
                    DynamicObject entity = dataEntity.getDataEntity();
                    Date startdate = entity.getDate(GroupBookOp.FIELD_EFFECTDATE);
                    Date enddate = entity.getDate(GroupBookOp.FIELD_INVALIDDATE);
                    OrmLocaleValue name = (OrmLocaleValue)entity.get(GroupBookOp.FIELD_NAME);
                    String number = (String)entity.get(GroupBookOp.FIELD_NUMBER);
                    String fields = "id,name,number";
                    if (enddate != null && startdate.compareTo(enddate) > 0) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u8d77\u5fc5\u987b\u2264\u6709\u6548\u671f\u6b62\u3002", (String)"GroupBookOp_0", (String)"taxc-tcvvt", (Object[])new Object[0]));
                        return;
                    }
                    QFilter idFilter = new QFilter(GroupBookOp.ID, "!=", entity.get(GroupBookOp.ID) == null ? Long.valueOf(0L) : entity.get(GroupBookOp.ID));
                    QFilter numberFilter = new QFilter(GroupBookOp.FIELD_NUMBER, "=", (Object)number).or(new QFilter(GroupBookOp.FIELD_NAME, "=", (Object)name.getLocaleValue()));
                    DynamicObjectCollection currentGroup = QueryServiceHelper.query((String)"tcvvt_group_book", (String)fields, (QFilter[])new QFilter[]{numberFilter, idFilter});
                    if (currentGroup != null) {
                        for (DynamicObject obj : currentGroup) {
                            if (number.equals(obj.getString(GroupBookOp.FIELD_NUMBER))) {
                                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65b9\u6848\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\u3002", (String)"GroupBookOp_1", (String)"taxc-tcvvt", (Object[])new Object[0]));
                                return;
                            }
                            if (!name.getLocaleValue().equals(obj.getString(GroupBookOp.FIELD_NAME))) continue;
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\u3002", (String)"GroupBookOp_2", (String)"taxc-tcvvt", (Object[])new Object[0]));
                            return;
                        }
                    }
                    String fields2 = "id,status,number,name,orgrow.orgid as orgid,orgrow.orgcode as orgcode,orgrow.orgname as orgname";
                    if (enddate == null) {
                        QFilter qfil = new QFilter(GroupBookOp.FIELD_EFFECTDATE, ">=", (Object)startdate);
                        QFilter qfil1 = new QFilter(GroupBookOp.FIELD_EFFECTDATE, "<=", (Object)startdate);
                        QFilter qfil2 = new QFilter(GroupBookOp.FIELD_EFFECTDATE, "<=", (Object)startdate);
                        qfil2 = qfil2.and(QFilter.isNull((String)GroupBookOp.FIELD_INVALIDDATE));
                        qfil1 = qfil1.and(new QFilter(GroupBookOp.FIELD_INVALIDDATE, ">=", (Object)startdate));
                        q = qfil.or(qfil1).or(qfil2);
                    } else {
                        QFilter qfilter1 = new QFilter(GroupBookOp.FIELD_INVALIDDATE, ">=", (Object)startdate);
                        qfilter1 = qfilter1.and(new QFilter(GroupBookOp.FIELD_INVALIDDATE, "<=", (Object)enddate));
                        QFilter qfilter2 = new QFilter(GroupBookOp.FIELD_EFFECTDATE, ">=", (Object)startdate);
                        qfilter2 = qfilter2.and(new QFilter(GroupBookOp.FIELD_INVALIDDATE, "<=", (Object)enddate));
                        QFilter qfilter3 = new QFilter(GroupBookOp.FIELD_EFFECTDATE, "<=", (Object)startdate);
                        qfilter3 = qfilter3.and(new QFilter(GroupBookOp.FIELD_INVALIDDATE, ">=", (Object)enddate));
                        Object qfilter4 = new QFilter(GroupBookOp.FIELD_EFFECTDATE, ">=", (Object)startdate);
                        qfilter4 = qfilter4.and(new QFilter(GroupBookOp.FIELD_EFFECTDATE, "<=", (Object)enddate));
                        q = qfilter1.or(qfilter2).or(qfilter3).or((QFilter)qfilter4);
                    }
                    DynamicObjectCollection existsCollection = QueryServiceHelper.query((String)"tcvvt_group_book", (String)fields2, (QFilter[])new QFilter[]{idFilter, q});
                    HashMap<String, Object> existsMap = new HashMap<String, Object>();
                    DataEntityPropertyCollection propertyCollection = null;
                    for (DynamicObject object : existsCollection) {
                        if (propertyCollection == null) {
                            propertyCollection = object.getDynamicObjectType().getProperties();
                        }
                        HashMap map2 = new HashMap();
                        for (IDataEntityProperty property : propertyCollection) {
                            map2.put(property.getName(), object.getString(property.getName()));
                        }
                        existsMap.put(object.getString(GroupBookOp.FIELD_ORGID), map2);
                    }
                    DynamicObjectCollection entryList = entity.getDynamicObjectCollection(GroupBookOp.ENTRYGRID_NAME);
                    ArrayList<Map> existsList = new ArrayList<Map>();
                    if (entryList != null) {
                        for (DynamicObject obj : entryList) {
                            Object orgIdObj = obj.get(GroupBookOp.FIELD_ORGID);
                            String orgId = null;
                            if (orgIdObj instanceof DynamicObject) {
                                DynamicObject org = (DynamicObject)orgIdObj;
                                orgId = org.getString(GroupBookOp.ID);
                            } else {
                                orgId = obj.getString(GroupBookOp.ID);
                            }
                            if ((map = (Map)existsMap.get(orgId)) == null) continue;
                            existsList.add(map);
                        }
                    }
                    if (existsList.isEmpty()) continue;
                    StringBuilder orgName = new StringBuilder();
                    ArrayList planList = new ArrayList();
                    int count = 3;
                    for (int i = 0; i < count && i < existsList.size(); ++i) {
                        map = (Map)existsList.get(i);
                        if (!"".equals(orgName.toString())) {
                            orgName.append(',');
                        }
                        orgName.append((String)map.get("orgname"));
                        if (planList.contains(map.get(GroupBookOp.FIELD_NAME))) continue;
                        planList.add(map.get(GroupBookOp.FIELD_NAME));
                    }
                    if (existsList.size() > count) {
                        orgName.append(ResManager.loadKDString((String)"......\u7b49", (String)"GroupBookOp_3", (String)"taxc-tcvvt", (Object[])new Object[0]));
                        orgName.append(existsList.size());
                        orgName.append(ResManager.loadKDString((String)"\u4e2a", (String)"GroupBookOp_4", (String)"taxc-tcvvt", (Object[])new Object[0]));
                    }
                    this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u96c6\u56e2\u65b9\u6848\u6709\u6548\u671f%1$s\u81f3%2$s\u5185\uff0c\u7ec4\u7ec7\u201c%3$s\u201d\u5728\u65b9\u6848\u201c%4$s\u201d\u4e2d\u5df2\u88ab\u914d\u7f6e\uff0c\u8bf7\u52ff\u91cd\u590d\u914d\u7f6e\u3002", (String)"GroupBookOp_5", (String)"taxc-tcvvt", (Object[])new Object[0]), DateUtils.format(startdate), DateUtils.format(enddate), orgName.toString(), String.join((CharSequence)",", planList)));
                    return;
                }
            }
        });
    }
}

