/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.opplugin.group;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tcvvt.common.constant.PatternUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class GroupOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        final List<Long> finalIdSet = this.getDisabledOrgList();
        e.addValidator(new AbstractValidator(){

            public void validate() {
                DynamicObjectCollection entityList = new DynamicObjectCollection();
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject dataFromDb;
                    Long sjnsrmcid;
                    String quoofreview;
                    String cellphoneno;
                    DynamicObjectCollection dyoList;
                    QFilter filter;
                    String loginaccount;
                    DynamicObject entity = dataEntity.getDataEntity();
                    Date startdate = entity.getDate("startdate");
                    Date enddate = entity.getDate("enddate");
                    String datasource = entity.getString("datasource");
                    if (enddate != null && startdate.compareTo(enddate) > 0) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u8d77\u5fc5\u987b\u2264\u6709\u6548\u671f\u6b62\u3002", (String)"GroupOp_0", (String)"taxc-tcvvt", (Object[])new Object[0]));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(loginaccount = entity.getString("loginaccount")))) {
                        filter = new QFilter("loginaccount", "=", (Object)loginaccount);
                        if (dataEntity.getBillPkId() != null) {
                            QFilter idFilter = new QFilter("id", "!=", dataEntity.getBillPkId());
                            filter.and(idFilter);
                        }
                        dyoList = QueryServiceHelper.query((String)"tcvvt_group", (String)"startdate,enddate,id,loginaccount", (QFilter[])new QFilter[]{filter});
                        List sameLoginaccountDyoList = entityList.stream().filter(dynamicObject -> loginaccount.equals(dynamicObject.getString("loginaccount")) && !dynamicObject.get("id").equals(dataEntity.getBillPkId())).collect(Collectors.toList());
                        if (CollectionUtils.isNotEmpty(sameLoginaccountDyoList)) {
                            dyoList.addAll(sameLoginaccountDyoList);
                        }
                        if (GroupOp.this.check(dyoList, startdate, enddate)) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u5185\u5df2\u5b58\u5728\u76f8\u540c\u7684\u201c\u4f01\u4e1a\u767b\u5f55\u8d26\u53f7\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"GroupOp_1", (String)"taxc-tcvvt", (Object[])new Object[0]));
                        }
                    }
                    Long id = entity.getLong("nsrmc.id");
                    filter = new QFilter("nsrmc", "=", entity.get("nsrmc.id"));
                    if (dataEntity.getBillPkId() != null) {
                        QFilter idFilter = new QFilter("id", "!=", dataEntity.getBillPkId());
                        filter.and(idFilter);
                    }
                    dyoList = QueryServiceHelper.query((String)"tcvvt_group", (String)"startdate,enddate,id,nsrmc", (QFilter[])new QFilter[]{filter});
                    List sameNsrmcDyoList = entityList.stream().filter(dynamicObject -> id.compareTo(dynamicObject.getLong("nsrmc.id")) == 0 && !dynamicObject.get("id").equals(dataEntity.getBillPkId())).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(sameNsrmcDyoList)) {
                        dyoList.addAll(sameNsrmcDyoList);
                    }
                    if (GroupOp.this.check(dyoList, startdate, enddate)) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u5185\u5df2\u5b58\u5728\u76f8\u540c\u7684\u201c\u7eb3\u7a0e\u4eba\u540d\u79f0\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"GroupOp_2", (String)"taxc-tcvvt", (Object[])new Object[0]));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(cellphoneno = entity.getString("cellphoneno")))) {
                        cellphoneno = cellphoneno.replaceAll(" ", "");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)cellphoneno)) {
                        if (cellphoneno.contains("-")) {
                            cellphoneno = cellphoneno.split("-")[1];
                        }
                        if (!GroupOp.isPhone(cellphoneno)) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7\u7801 \u3002", (String)"GroupOp_3", (String)"taxc-tcvvt", (Object[])new Object[0]));
                        }
                    }
                    if (!"1".equals(quoofreview = entity.getString("quoofreview")) && !"0".equals(quoofreview)) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4f01\u4e1a\u96c6\u56e2\u786e\u8ba4\u60c5\u51b5\u3002", (String)"GroupOp_4", (String)"taxc-tcvvt", (Object[])new Object[0]));
                    }
                    if (finalIdSet.contains(id)) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u7eb3\u7a0e\u4eba\u540d\u79f0\u7ec4\u7ec7\u4e0d\u53ef\u7528\u3002", (String)"GroupOp_5", (String)"taxc-tcvvt", (Object[])new Object[0]));
                    }
                    if (finalIdSet.contains(sjnsrmcid = Long.valueOf(entity.getLong("sjnsrmc.id")))) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u4e0a\u7ea7\u4f01\u4e1a\u540d\u79f0\u7ec4\u7ec7\u4e0d\u53ef\u7528\u3002", (String)"GroupOp_6", (String)"taxc-tcvvt", (Object[])new Object[0]));
                    }
                    if ("sjtb".equals(datasource) && (dataFromDb = QueryServiceHelper.queryOne((String)"tcvvt_group", (String)"nsrmc.id", (QFilter[])new QFilter[]{new QFilter("id", "=", entity.get("id"))})) != null && id.longValue() != dataFromDb.getLong("nsrmc.id")) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u7c7b\u578b\u7684\u6570\u636e\u4e0d\u80fd\u4fee\u6539\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"GroupOp_7", (String)"taxc-tcvvt", (Object[])new Object[0]));
                    }
                    entityList.add((Object)entity);
                }
            }
        });
    }

    public static boolean isPhone(CharSequence value) {
        return GroupOp.isMobile(value) || GroupOp.isMobileHk(value) || GroupOp.isMobileTw(value) || GroupOp.isMobileMo(value);
    }

    public static boolean isMobile(CharSequence value) {
        return GroupOp.isMatch(PatternUtils.MOBILE, value);
    }

    public static boolean isMobileHk(CharSequence value) {
        return GroupOp.isMatch(PatternUtils.MOBILE_HK, value);
    }

    public static boolean isMobileTw(CharSequence value) {
        return GroupOp.isMatch(PatternUtils.MOBILE_TW, value);
    }

    public static boolean isMobileMo(CharSequence value) {
        return GroupOp.isMatch(PatternUtils.MOBILE_MO, value);
    }

    public static boolean isMatch(Pattern pattern, CharSequence content) {
        if (content == null || pattern == null) {
            return false;
        }
        return pattern.matcher(content).matches();
    }

    private boolean check(DynamicObjectCollection dynamicObjects, Date startDate2, Date endDate2) {
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return false;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            Date enddate;
            Date startdate = dynamicObject.getDate("startdate");
            if (!this.chekcInterDate(startdate, enddate = dynamicObject.getDate("enddate"), startDate2, endDate2)) continue;
            return true;
        }
        return false;
    }

    private boolean chekcInterDate(Date startDate, Date endDate, Date startDateInput, Date endDateInput) {
        if (endDate == null) {
            return endDateInput == null || endDateInput.compareTo(startDate) >= 0;
        }
        if (endDateInput == null) {
            return startDateInput.compareTo(endDate) <= 0;
        }
        return startDateInput.compareTo(endDate) <= 0 && endDateInput.compareTo(startDate) >= 0;
    }

    private List<Long> getDisabledOrgList() {
        QFilter statusFilter = new QFilter("status", "=", (Object)"3");
        QFilter nsQFilter = new QFilter("istaxpayer", "!=", (Object)"1");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bastax_taxorg", (String)"id,org.id as orgid", (QFilter[])new QFilter[]{statusFilter.or(nsQFilter)});
        return collection.stream().map(o -> o.getLong("orgid")).collect(Collectors.toList());
    }
}

