/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.opplugin.group;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.declare.service.DeclareService;
import kd.taxc.bdtaxr.common.mq.DeclareMQMessageData;
import kd.taxc.bdtaxr.common.mq.DeclareMQSender;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvvt.common.util.TcvvtTemplateUtils;
import org.apache.commons.lang3.ObjectUtils;

public class MainReportListOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(MainReportListOp.class);
    List<String> declareTypes = Arrays.asList("FR0001", "FR0002", "FR0003", "FR0004", "FR0005", "FR0006", "FR0007", "FR0008", "FR0009", "FR0010", "FR0011");
    private List<DynamicObject> successObj = Lists.newArrayList();
    private Map<String, List<DeclareMQMessageData>> successBeforeDeleteEntryData = new HashMap<String, List<DeclareMQMessageData>>();

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        if ("delete".equals(operationKey)) {
            for (DynamicObject entity : this.successObj) {
                this.callElementFresh(entity, operationKey, this.successBeforeDeleteEntryData.get(entity.getString("id")));
            }
            Set<Object> sbbids = this.successObj.stream().map(a -> a.getLong("id")).collect(Collectors.toSet());
            new DeclareService().deleteRiskItem(sbbids);
            this.deleteTamEntry(sbbids);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operationKey = args.getOperationKey();
        if ("delete".equals(operationKey)) {
            DynamicObject[] dataEntities = args.getDataEntities();
            ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
            for (DynamicObject entity : dataEntities) {
                Object pkValue = entity.getPkValue();
                try {
                    DynamicObject declare = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)this.billEntityType.getName());
                    String templatetype = declare.getString("type");
                    this.queryBeforeDelete(pkValue.toString(), templatetype);
                    Long orgId = declare.getDynamicObject("org").getLong("id");
                    Date skssqq = declare.getDate("skssqq");
                    Date skssqz = declare.getDate("skssqz");
                    TemplateUtils.deleteReport((Long)orgId, (String)templatetype, (Date)skssqq, (Date)skssqz, null);
                    ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                    qFilters.add(new QFilter("startdate", "=", (Object)skssqq));
                    qFilters.add(new QFilter("enddate", "=", (Object)skssqz));
                    qFilters.add(new QFilter("orgid", "=", (Object)orgId));
                    DynamicObject template = TcvvtTemplateUtils.getTemplateType(String.valueOf(orgId), skssqq, skssqz);
                    QFilter nsrtypeQ = new QFilter("type", "=", ObjectUtils.isNotEmpty((Object)template) ? template.getString("type.number") : null);
                    QFilter templateidQ = new QFilter("templateid", "=", ObjectUtils.isNotEmpty((Object)template) ? template.getString("id") : null);
                    qFilters.add(nsrtypeQ);
                    qFilters.add(templateidQ);
                    DeleteServiceHelper.delete((String)"tcvvt_message", (QFilter[])qFilters.toArray(new QFilter[0]));
                    QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
                    QFilter skssqqzFilter = new QFilter("skssqq", "=", (Object)skssqq).and(new QFilter("skssqz", "=", (Object)skssqz));
                    DeleteServiceHelper.delete((String)"tcvvt_main_account", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
                    DeleteServiceHelper.delete((String)"tcvvt_main_detail", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
                    DeleteServiceHelper.delete((String)"tcvvt_main_adjust", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
                    DeleteServiceHelper.delete((String)"tcvvt_main_adjust_tp", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter});
                    DeleteServiceHelper.delete((String)"tcvvt_finance_init_record", (QFilter[])new QFilter[]{orgFilter, skssqqzFilter, nsrtypeQ});
                    successObjs.add(entity);
                    this.successObj.add(declare);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u5220\u9664\u7533\u62a5\u6570\u636e\u5931\u8d25\u3002", (String)"MainReportListOp_0", (String)"taxc-tcvvt", (Object[])new Object[0]), entity.getString("billno"));
                    ValidationErrorInfo info = new ValidationErrorInfo("", (Object)"", 0, 0, "delete_declare_error", "", msg, ErrorLevel.Error);
                    this.operationResult.addErrorInfo((OperateErrorInfo)info);
                    this.successBeforeDeleteEntryData.remove(pkValue.toString());
                }
            }
            args.setDataEntities(successObjs.toArray(new DynamicObject[0]));
        }
    }

    private void callElementFresh(DynamicObject entity, String operationKey, List<DeclareMQMessageData> queryBeforeDeleteData) {
        try {
            Date skssqq = entity.getDate("skssqq");
            Date skssqz = entity.getDate("skssqz");
            DeclareMQSender.sendMQBeforeDelete((DynamicObject)entity, (Date)skssqq, (Date)skssqz, (String)DeclareMQType.DECLARE.name(), (String)operationKey, queryBeforeDeleteData);
        }
        catch (Exception e1) {
            logger.error("\u8c03\u7528\u5143\u7d20\u5237\u65b0\u63a5\u53e3\u5931\u8d25\uff1a" + e1);
        }
    }

    private void deleteTamEntry(Set<Object> sbbIds) {
        try {
            if (EmptyCheckUtils.isNotEmpty(sbbIds)) {
                QFilter qFilter = new QFilter("id", "in", sbbIds);
                DeleteServiceHelper.delete((String)"tam_declare_entry", (QFilter[])qFilter.toArray());
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage());
        }
    }

    private void queryBeforeDelete(String sbbid, String templatetype) {
        if (this.declareTypes.contains(templatetype)) {
            QFilter sbbidFilter = new QFilter("id", "=", (Object)Long.parseLong(sbbid));
            DynamicObject sbbdyo = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id,skssqq,skssqz,paystatus", (QFilter[])new QFilter[]{sbbidFilter});
            ArrayList<DeclareMQMessageData> arrayList = new ArrayList<DeclareMQMessageData>();
            sbbid = sbbdyo.getString("id");
            this.fillData(sbbid, arrayList, sbbdyo);
            this.successBeforeDeleteEntryData.put(sbbid, arrayList);
        }
    }

    private void fillData(String sbbid, List<DeclareMQMessageData> arrayList, DynamicObject tcvatNsrxx) {
        DeclareMQMessageData declareMQMessageData = new DeclareMQMessageData();
        declareMQMessageData.setSbbid(sbbid);
        declareMQMessageData.setSkssqq(DateUtils.format((Date)tcvatNsrxx.getDate("skssqq")));
        declareMQMessageData.setSkssqz(DateUtils.format((Date)tcvatNsrxx.getDate("skssqz")));
        arrayList.add(declareMQMessageData);
    }
}

