/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.opplugin.group;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;
import kd.taxc.tcvvt.common.constant.TemplateTypeConstant;

public class MainReportOperateOp
extends AbstractOperationServicePlugIn {
    public static final String SUBMIT = "submit";
    public static final String UNSUBMIT = "unsubmit";
    public static final String AUDIT = "audit";
    public static final String UNAUDIT = "unaudit";
    public static final String APPLY = "apply";
    public static final String CANCELAPPLY = "cancelapply";
    private static final String TCVAT_NSRXX = "tcvat_nsrxx";
    private static final String[] TAX_LIMITS = new String[]{"month", "season", "year"};
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String BILLSTATUS = "billstatus";
    private static final String DECLARESTATUS = "declarestatus";
    private static final String ORG = "org";
    private static final String TYPE = "type";
    private static final String DECLARETYPE = "declaretype";
    private static Map<String, String> NSR_TYPE_MAP = TemplateTypeConstant.getMap();
    private static Map<String, String> canNotUnAuditOrApplyMap = new HashMap<String, String>();
    private static Log LOGGER = LogFactory.getLog(MainReportOperateOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                String operateKey = this.getOperateKey();
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject object = dataEntity.getDataEntity();
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)object.get("id"), (String)"tcvvt_main_declare_list");
                    String errorMsg = MainReportOperateOp.this.setErrorMsgListWhenNSRXXOpt(operateKey, dynamicObject);
                    if (!StringUtils.isNotBlank((CharSequence)errorMsg)) continue;
                    this.addFatalErrorMessage(dataEntity, errorMsg);
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operationKey = args.getOperationKey();
        if (APPLY.equals(operationKey) || CANCELAPPLY.equals(operationKey)) {
            DynamicObject[] dataEntities = args.getDataEntities();
            List keyList = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            DynamicObject[] loadResult = BusinessDataServiceHelper.load((Object[])keyList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCVAT_NSRXX));
            String msg = "";
            if (loadResult == null || loadResult.length < 1) {
                msg = ResManager.loadKDString((String)"\u62a5\u8868\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u91cd\u7f6e,\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c\u3002", (String)"MainReportOperateOp_4", (String)"taxc-tcvvt", (Object[])new Object[0]);
                this.operationResult.setSuccess(false);
                this.operationResult.setMessage(msg);
                this.operationResult.setShowMessage(false);
                return;
            }
            msg = this.nsrxxOpt(operationKey, loadResult);
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                this.operationResult.setSuccess(false);
                this.operationResult.setMessage(msg);
                this.operationResult.setShowMessage(false);
                return;
            }
            this.operationResult.setSuccess(true);
        }
    }

    private String nsrxxOpt(String operationKey, DynamicObject[] loadResult) {
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
        StringBuilder builder = new StringBuilder();
        for (DynamicObject dynamicObject : loadResult) {
            String errorMsg = this.setErrorMsgListWhenNSRXXOpt(operationKey, dynamicObject);
            if (StringUtils.isBlank((CharSequence)errorMsg)) {
                updateList.add(dynamicObject);
                continue;
            }
            builder.append(errorMsg).append(System.lineSeparator());
        }
        MainReportOperateOp.updateData(updateList, operationKey);
        return builder.toString();
    }

    public String setErrorMsgListWhenNSRXXOpt(String operationKey, DynamicObject dynamicObject) {
        String billStatus = dynamicObject.getString(BILLSTATUS);
        String declareStatus = dynamicObject.getString(DECLARESTATUS);
        String errorMsg = null;
        String orgName = dynamicObject.getDynamicObject(ORG).getString("name");
        String startDate = DateUtils.format((Date)dynamicObject.getDate(SKSSQQ), (String)DateUtils.YYYYMMDD_CHINESE);
        String endDate = DateUtils.format((Date)dynamicObject.getDate(SKSSQZ), (String)DateUtils.YYYYMMDD_CHINESE);
        String declareType = dynamicObject.getString(DECLARETYPE);
        String declareTypeStr = NSR_TYPE_MAP.get(dynamicObject.getString(TYPE));
        if (SUBMIT.equals(operationKey)) {
            if ("C".equals(billStatus)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5ba1\u6838\uff0c\u8bf7\u5148\u53d6\u6d88\u5ba1\u6838\uff1a%1$s %2$s %3$s\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"MainReportOperateOp_5", (String)"taxc-tcvvt", (Object[])new Object[0]), orgName, declareTypeStr, startDate + "-" + endDate);
            } else if ("B".equals(billStatus)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u63d0\u4ea4\uff0c\u65e0\u9700\u91cd\u590d\u63d0\u4ea4\uff1a%1$s %2$s %3$s\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"MainReportOperateOp_6", (String)"taxc-tcvvt", (Object[])new Object[0]), orgName, declareTypeStr, startDate + "-" + endDate);
            }
        } else if (UNSUBMIT.equals(operationKey)) {
            if (!"B".equals(billStatus)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u672a\u63d0\u4ea4\uff0c\u65e0\u6cd5\u64a4\u9500\u63d0\u4ea4\uff1a%1$s %2$s %3$s\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"MainReportOperateOp_7", (String)"taxc-tcvvt", (Object[])new Object[0]), orgName, declareTypeStr, startDate + "-" + endDate);
            }
        } else if (AUDIT.equals(operationKey)) {
            if (!"B".equals(billStatus)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u4ec5\u63d0\u4ea4\u6570\u636e\u53ef\u5ba1\u6838\uff1a%1$s %2$s %3$s\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"MainReportOperateOp_8", (String)"taxc-tcvvt", (Object[])new Object[0]), orgName, declareTypeStr, startDate + "-" + endDate);
            }
            if ("C".equals(billStatus)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5ba1\u6838\uff0c\u65e0\u9700\u91cd\u590d\u5ba1\u6838\uff1a%1$s %2$s %3$s\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"MainReportOperateOp_9", (String)"taxc-tcvvt", (Object[])new Object[0]), orgName, declareTypeStr, startDate + "-" + endDate);
            }
        } else if (UNAUDIT.equals(operationKey)) {
            if (!"C".equals(billStatus)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u4ec5\u5df2\u5ba1\u6838\u6570\u636e\u53ef\u53cd\u5ba1\u6838\uff1a%1$s %2$s %3$s\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"MainReportOperateOp_10", (String)"taxc-tcvvt", (Object[])new Object[0]), orgName, declareTypeStr, startDate + "-" + endDate);
            } else if (canNotUnAuditOrApplyMap.containsKey(declareStatus)) {
                String declareStatusChiStr = canNotUnAuditOrApplyMap.get(declareStatus);
                errorMsg = String.format(ResManager.loadKDString((String)"%1$s %2$s\u5c5e\u671f\u62a5\u8868 \u201c%3$s\u201d\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"MainReportOperateOp_11", (String)"taxc-tcvvt", (Object[])new Object[0]), orgName, startDate + "-" + endDate, declareStatusChiStr);
            }
        } else if (APPLY.equals(operationKey)) {
            if (!"C".equals(billStatus)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u6570\u636e\u624d\u80fd\u786e\u8ba4\u7533\u62a5\uff1a%1$s %2$s %3$s\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"MainReportOperateOp_12", (String)"taxc-tcvvt", (Object[])new Object[0]), orgName, declareTypeStr, startDate + "-" + endDate);
            } else if (canNotUnAuditOrApplyMap.containsKey(declareStatus)) {
                String declareStatusChiStr = canNotUnAuditOrApplyMap.get(declareStatus);
                errorMsg = String.format(ResManager.loadKDString((String)"%1$s %2$s\u5c5e\u671f\u62a5\u8868 \u201c%3$s\u201d\uff0c\u4e0d\u80fd\u786e\u8ba4\u7533\u62a5\u3002", (String)"MainReportOperateOp_13", (String)"taxc-tcvvt", (Object[])new Object[0]), orgName, startDate + "-" + endDate, declareStatusChiStr);
            }
        } else if (CANCELAPPLY.equals(operationKey)) {
            if (!"declared".equals(declareStatus)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u6210\u529f\u7684\u6570\u636e\u53ef\u53d6\u6d88\u7533\u62a5\uff1a %1$s %2$s %3$s\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"MainReportOperateOp_14", (String)"taxc-tcvvt", (Object[])new Object[0]), orgName, declareTypeStr, startDate + "-" + endDate);
            } else if (!"0".equals(declareType)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u7533\u62a5\u65b9\u5f0f\u4e3a\u624b\u5de5\u7533\u62a5\u624d\u80fd\u53d6\u6d88\u7533\u62a5\uff1a %1$s %2$s %3$s\uff0c\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"MainReportOperateOp_15", (String)"taxc-tcvvt", (Object[])new Object[0]), orgName, declareTypeStr, startDate + "-" + endDate);
            }
        }
        return errorMsg;
    }

    public static void updateData(List<DynamicObject> updateList, String operationKey) {
        if (CollectionUtils.isEmpty(updateList)) {
            return;
        }
        for (DynamicObject obj : updateList) {
            if (APPLY.equals(operationKey)) {
                obj.set(DECLARESTATUS, (Object)"declared");
                obj.set(DECLARETYPE, (Object)"0");
                obj.set("sbrq", (Object)new Date());
                obj.set("declarer", (Object)RequestContext.get().getCurrUserId());
            }
            if (CANCELAPPLY.equals(operationKey)) {
                obj.set(DECLARESTATUS, (Object)"editing");
                obj.set("paystatus", null);
                obj.set(DECLARETYPE, null);
                obj.set("paytype", null);
                obj.set("sbrq", null);
                obj.set("paydate", null);
                obj.set("payer", null);
                obj.set("declarer", null);
            }
            obj.set("modifier", (Object)RequestContext.get().getCurrUserId());
            obj.set("modifytime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        String operateKey = args.getOperationKey();
        if (SUBMIT.equals(operateKey) || UNSUBMIT.equals(operateKey) || AUDIT.equals(operateKey) || UNAUDIT.equals(operateKey)) {
            LOGGER.info("input submitop");
            DynamicObject[] dataEntities = args.getDataEntities();
            List keyList = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            ValidDataResultVo submit = DeclareUtils.submit(keyList, (String)operateKey, (String)TCVAT_NSRXX, (boolean)true);
            LOGGER.info(submit.getMessage() + submit.getSuccess());
            if (submit.getSuccess()) {
                this.operationResult.setSuccess(true);
                List<Object> ids = Arrays.stream(dataEntities).map(e -> String.valueOf(e.getPkValue())).collect(Collectors.toList());
                this.syncMbksData(operateKey, ids);
            } else if (submit.getData() == null) {
                this.operationResult.setSuccess(false);
                this.operationResult.setMessage(submit.getMessage());
                this.operationResult.setShowMessage(false);
            } else {
                OperationResult result = (OperationResult)submit.getData();
                List errorInfo = result.getAllErrorOrValidateInfo();
                if (errorInfo.size() > 1) {
                    this.operationResult.setMessage(((IOperateInfo)errorInfo.get(1)).getMessage());
                } else if (errorInfo.size() > 0) {
                    this.operationResult.setMessage(((IOperateInfo)errorInfo.get(0)).getMessage());
                } else {
                    this.operationResult.setMessage(result.getMessage());
                }
                this.operationResult.setShowMessage(false);
                this.operationResult.setSuccess(false);
            }
        }
    }

    private void syncMbksData(String operateKey, List<Object> keyList) {
        if (StringUtils.equals((CharSequence)AUDIT, (CharSequence)operateKey)) {
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tccit", (String)"MbksTaxbookSyncService", (String)"syncData", (Object[])new Object[]{keyList});
        }
    }

    static {
        canNotUnAuditOrApplyMap.put("declaring", ResManager.loadKDString((String)"\u7533\u62a5\u4e2d", (String)"MainReportOperateOp_0", (String)"taxc-tcvvt", (Object[])new Object[0]));
        canNotUnAuditOrApplyMap.put("declared", ResManager.loadKDString((String)"\u7533\u62a5\u6210\u529f\u3002", (String)"MainReportOperateOp_1", (String)"taxc-tcvvt", (Object[])new Object[0]));
        canNotUnAuditOrApplyMap.put("submitted", ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u5f85\u7533\u62a5", (String)"MainReportOperateOp_2", (String)"taxc-tcvvt", (Object[])new Object[0]));
        canNotUnAuditOrApplyMap.put("importing", ResManager.loadKDString((String)"\u5df2\u7533\u62a5\u672a\u5bfc\u5165", (String)"MainReportOperateOp_3", (String)"taxc-tcvvt", (Object[])new Object[0]));
    }
}

