/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.opplugin.group;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.finance.TcvvtCategoryInfoBusinessImpl;
import kd.taxc.tcvvt.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class SharngPlanTaxOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        final HashMap isTaxMap = new HashMap();
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    StringBuilder info;
                    DynamicObject currentObj = dataEntity.getDataEntity();
                    DynamicObjectCollection rules = currentObj.getDynamicObjectCollection("ruleentity");
                    DynamicObjectCollection orgs = currentObj.getDynamicObjectCollection("orgentity");
                    if (rules.isEmpty()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5171\u4eab\u89c4\u5219\u8303\u56f4\u201d\u3002", (String)"SharngPlanTaxOp_0", (String)"taxc-tcvvt", (Object[])new Object[0]));
                        continue;
                    }
                    if (orgs.isEmpty()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5171\u4eab\u7ec4\u7ec7\u8303\u56f4\u201d\u3002", (String)"SharngPlanTaxOp_1", (String)"taxc-tcvvt", (Object[])new Object[0]));
                        continue;
                    }
                    if (!rules.isEmpty() && ((DynamicObject)rules.get(0)).get("rule") instanceof Long) {
                        List ruleIds = rules.stream().map(o -> o.getLong("rule")).collect(Collectors.toList());
                        Iterator qFilter = new QFilter("id", "in", ruleIds);
                        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tcvvt_tax_accessconfig", (String)"id,number,accessproject.id,projectcaliber.id", (QFilter[])new QFilter[]{qFilter});
                        Set set = collection.stream().map(o -> o.getLong("accessproject.id")).collect(Collectors.toSet());
                        Set setid = collection.stream().map(o -> o.getLong("accessproject.id") + "-" + o.getLong("projectcaliber.id")).collect(Collectors.toSet());
                        if (rules.size() > setid.size()) {
                            StringBuilder info2 = new StringBuilder();
                            collection.forEach(o -> {
                                if (!setid.remove(o.getLong("accessproject.id") + "-" + o.getLong("projectcaliber.id"))) {
                                    info2.append(o.getString("number")).append(" ");
                                }
                            });
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5b58\u5728\u53d6\u6570\u9879\u76ee\u76f8\u540c\u7684\u53d6\u6570\u89c4\u5219\uff1a%1$s\u3002", (String)"SharngPlanTaxOp_2", (String)"taxc-tcvvt", (Object[])new Object[0]), info2));
                            continue;
                        }
                    }
                    if (!rules.isEmpty() && ((DynamicObject)rules.get(0)).get("rule") instanceof DynamicObject) {
                        boolean flag = false;
                        for (DynamicObject rule : rules) {
                            if (rule.get("rule") != null && !StringUtil.isEmpty((CharSequence)((DynamicObject)rule.get("rule")).getString("number"))) continue;
                            flag = true;
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5171\u4eab\u89c4\u5219\u7f16\u7801\u201d\u3002", (String)"SharngPlanTaxOp_3", (String)"taxc-tcvvt", (Object[])new Object[0]));
                        }
                        if (flag) continue;
                        Set ruleSet = rules.stream().filter(o -> null != o.getDynamicObject("rule")).map(o -> o.getDynamicObject("rule").getLong("accessproject.id")).collect(Collectors.toSet());
                        if (rules.size() > ruleSet.size()) {
                            info = new StringBuilder();
                            rules.forEach(o -> {
                                if (!ruleSet.remove(o.getLong("rule.id"))) {
                                    info.append(o.getString("rule.number")).append(" ");
                                }
                            });
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5b58\u5728\u53d6\u6570\u9879\u76ee\u76f8\u540c\u7684\u53d6\u6570\u89c4\u5219\uff1a%1$s\u3002", (String)"SharngPlanTaxOp_2", (String)"taxc-tcvvt", (Object[])new Object[0]), info));
                            continue;
                        }
                        rules.forEach(o -> {
                            if (!StringUtil.equalsIgnoreCase((CharSequence)o.getString("rule.enable"), (CharSequence)"1")) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6b64\u53d6\u6570\u89c4\u5219\u672a\u542f\u7528", (String)"SharngPlanTaxOp_4", (String)"taxc-tcvvt", (Object[])new Object[0]));
                            }
                            if (!StringUtil.equalsIgnoreCase((CharSequence)o.getString("rule.ruletype"), (CharSequence)"public")) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u53ef\u5206\u914d\u89c4\u5219\u53ef\u4ee5\u5171\u4eab\u3002", (String)"SharngPlanTaxOp_5", (String)"taxc-tcvvt", (Object[])new Object[0]));
                            }
                        });
                    }
                    if (orgs.isEmpty() || !(((DynamicObject)orgs.get(0)).get("org") instanceof DynamicObject)) continue;
                    boolean b = false;
                    for (DynamicObject org : orgs) {
                        if (org.get("org") != null && !StringUtil.isEmpty((CharSequence)((DynamicObject)org.get("org")).getString("number"))) continue;
                        b = true;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7ec4\u7ec7\u7f16\u7801\u201d\u3002", (String)"SharngPlanTaxOp_6", (String)"taxc-tcvvt", (Object[])new Object[0]));
                    }
                    if (b) continue;
                    Set orgSet = orgs.stream().map(o -> o.getLong("org.id")).collect(Collectors.toSet());
                    if (orgs.size() > orgSet.size()) {
                        info = new StringBuilder();
                        orgs.forEach(o -> {
                            if (!orgSet.remove(o.getLong("org.id"))) {
                                info.append(o.getString("org.number")).append(" ");
                            }
                        });
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u5b58\u5728\u91cd\u590d\u7684\u5171\u4eab\u7ec4\u7ec7\uff1a", (String)"SharngPlanTaxOp_7", (String)"taxc-tcvvt", (Object[])new Object[0]), info));
                        continue;
                    }
                    List orgsList = orgs.stream().map(o -> o.getLong("org.id")).collect(Collectors.toList());
                    QFilter statusQ = new QFilter("status", "!=", (Object)"1");
                    QFilter istaxpayerQ = new QFilter("istaxpayer", "!=", (Object)"1");
                    QFilter idQ = new QFilter("id", "in", (Object)orgsList.toArray());
                    DynamicObjectCollection collection = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.number,org.name", (QFilter[])new QFilter[]{statusQ.or(istaxpayerQ), idQ});
                    if (!collection.isEmpty()) {
                        StringBuilder info3 = new StringBuilder();
                        collection.stream().forEach(o -> info3.append(o.getString("org.number")).append(" "));
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7ec4\u7ec7\u975e\u201c\u53ef\u7528\u201d\u72b6\u6001\u6216\u8005\u975e\u201c\u7eb3\u7a0e\u4e3b\u4f53\u201d\u3002", (String)"SharngPlanTaxOp_8", (String)"taxc-tcvvt", (Object[])new Object[0]), info3));
                        continue;
                    }
                    for (Long orgId : orgsList) {
                        if (isTaxMap.get(orgId) != null) continue;
                        DynamicObject zdsyCategory = TcvvtCategoryInfoBusinessImpl.queryzdsyCategoryInfoByOrgId((String)String.valueOf(orgId));
                        if (!ObjectUtils.isEmpty((Object)zdsyCategory) && !ObjectUtils.isEmpty((Object)zdsyCategory.getDynamicObjectCollection("categoryentryentity"))) {
                            DynamicObject tras = (DynamicObject)zdsyCategory.getDynamicObjectCollection("categoryentryentity").get(0);
                            if (tras.get("enable").toString().equals("false")) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ec4\u7ec7\u5fc5\u987b\u4e3a\u91cd\u70b9\u7a0e\u6e90\uff1a", (String)"SharngPlanTaxOp_9", (String)"taxc-tcvvt", (Object[])new Object[0]));
                            }
                            isTaxMap.put(orgId, tras.get("enable").toString());
                            continue;
                        }
                        if (!((String)isTaxMap.get(orgId)).equals("false")) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ec4\u7ec7\u5fc5\u987b\u4e3a\u91cd\u70b9\u7a0e\u6e90\uff1a", (String)"SharngPlanTaxOp_9", (String)"taxc-tcvvt", (Object[])new Object[0]));
                    }
                    ArrayList otherOrgList = new ArrayList();
                    Arrays.stream(this.dataEntities).forEach(o -> {
                        DynamicObject obj = o.getDataEntity();
                        if (!StringUtil.equalsIgnoreCase((CharSequence)obj.getString("id"), (CharSequence)currentObj.getString("id"))) {
                            DynamicObjectCollection dynamicObjects = obj.getDynamicObjectCollection("orgentity");
                            otherOrgList.addAll(dynamicObjects.stream().map(row -> row.getLong("org.id")).collect(Collectors.toList()));
                        }
                    });
                    List intersection = (List)CollectionUtils.intersection(otherOrgList, orgsList);
                    if (intersection.isEmpty()) {
                        QFilter orgQ = new QFilter("orgentity.org", "in", orgsList);
                        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"tcvvt_tax_sharingplan", (String)"orgentity.org.id", (QFilter[])new QFilter[]{orgQ});
                        dynamicObjectCollection.stream().forEach(row -> intersection.add(row.getLong("orgentity.org.id")));
                    }
                    if (intersection.isEmpty()) continue;
                    StringBuilder error = new StringBuilder();
                    orgs.stream().forEach(o -> {
                        if (intersection.contains(o.getLong("org.id"))) {
                            error.append(o.getString("org.number")).append(" ");
                        }
                    });
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7ec4\u7ec7\u5df2\u914d\u7f6e\u5171\u4eab\u65b9\u6848", (String)"SharngPlanTaxOp_10", (String)"taxc-tcvvt", (Object[])new Object[0]), error));
                }
            }
        });
    }
}

