/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.opplugin.group;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.tcvvt.business.finance.TcvvtLicenseCheckBusinessImpl;

public class TcvvtImportReportListOP
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                List<Long> orgIds = Arrays.stream(dataEntities).map(o -> o.getDataEntity().getLong("org.id")).collect(Collectors.toList());
                Map<Long, Boolean> orgLicenseCheckMap = TcvvtLicenseCheckBusinessImpl.orgLicenseCheck(orgIds, "tcvvt");
                if (orgLicenseCheckMap.containsKey(-1L)) {
                    return;
                }
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    long oid = dataEntity.getDataEntity().getLong("org.id");
                    if (orgLicenseCheckMap.containsKey(oid) && !orgLicenseCheckMap.get(oid).booleanValue()) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u672a\u6fc0\u6d3b\u7a0e\u52a1\u4e91\u4e13\u4e1a\u8bb8\u53ef\u3002", (String)"TcvvtImportReportListOP_0", (String)"taxc-tcvvt", (Object[])new Object[0]));
                }
            }
        });
    }
}

