/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.opplugin.group;

import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tcvvt.common.util.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class VoucherOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(VoucherOp.class);

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] objects = e.getDataEntities();
        Arrays.stream(objects).forEach(dyo -> {
            if (StringUtils.isNotEmpty((CharSequence)dyo.getString("nd_dm")) && dyo.getDate("year") == null) {
                dyo.set("year", (Object)DateUtils.stringToDate(dyo.getString("nd_dm"), "yyyy"));
            }
            if (null != dyo.getDate("year") && StringUtils.isEmpty((CharSequence)dyo.getString("nd_dm"))) {
                dyo.set("nd_dm", (Object)DateUtils.format(dyo.getDate("year"), "yyyy"));
            }
        });
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        final Map vas = this.getOption().getVariables();
        final Date min = DateUtils.stringToDate("20000101", "yyyyMMdd");
        final Date max = DateUtils.stringToDate("20991231", "yyyyMMdd");
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    Date date;
                    DynamicObject entity = dataEntity.getDataEntity();
                    String yearValue = null;
                    if (null != entity.getDate("year")) {
                        yearValue = String.valueOf(DateUtils.getYearOfDate(entity.getDate("year")));
                    }
                    if (null != entity.getDate("pz_rq") && ((date = entity.getDate("pz_rq")).compareTo(min) < 0 || date.compareTo(max) > 0)) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51ed\u8bc1\u65e5\u671f\u5fc5\u987b\u57282000~2099\u4e4b\u95f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"VoucherOp_0", (String)"taxc-tcvvt", (Object[])new Object[0]));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)entity.getString("pz_rq"))) {
                        date = entity.getDate("pz_rq");
                        String month = String.valueOf(DateUtils.getMonthOfDate(date));
                        String year = String.valueOf(DateUtils.getYearOfDate(date));
                        if (StringUtils.isNotEmpty((CharSequence)entity.getString("kjqj")) && !month.equals(String.valueOf(Integer.parseInt(entity.getString("kjqj"))))) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51ed\u8bc1\u65e5\u671f\u7684\u6708\u4efd\u9700\u548c\u201c\u4f1a\u8ba1\u671f\u95f4\u201d\u4fdd\u6301\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"VoucherOp_1", (String)"taxc-tcvvt", (Object[])new Object[0]));
                        }
                        if (StringUtils.isNotEmpty((CharSequence)yearValue) && !year.equals(yearValue)) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51ed\u8bc1\u65e5\u671f\u7684\u5e74\u4efd\u9700\u548c\u201c\u5e74\u5ea6\u4ee3\u7801\u201d\u4fdd\u6301\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"VoucherOp_2", (String)"taxc-tcvvt", (Object[])new Object[0]));
                        }
                    }
                    if (entity.get("kmdm") != null) continue;
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6b64\u5e74\u5ea6\u4e0d\u5b58\u5728\u8be5\u79d1\u76ee\u4ee3\u7801\u3002", (String)"VoucherOp_3", (String)"taxc-tcvvt", (Object[])new Object[0]));
                }
            }
        });
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                if (vas.containsKey("importtype") && ("override".equals(vas.get("importtype")) || "overridenew".equals(vas.get("importtype")))) {
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        long oid = dataEntity.getDataEntity().getLong("id");
                        boolean exists = QueryServiceHelper.exists((String)"tcvvt_voucher", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)oid).and("datasource", "=", (Object)"1")});
                        if (!exists) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u91c7\u96c6\u6570\u636e\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"VoucherOp_4", (String)"taxc-tcvvt", (Object[])new Object[0]));
                    }
                }
            }
        });
    }
}

