/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.opplugin.group.accountset;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tcvvt.common.util.DateUtils;
import kd.taxc.tcvvt.common.util.PermissionUtils;

public class AccountSetOp
extends AbstractOperationServicePlugIn {
    private static final String BOS_ORG = "bos_org";
    private static final String TCVVT_QHJT = "tcvvt_qhjt";
    private static final String BASTAX_TAXORG = "bastax_taxorg";

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    Object pkId = dataEntity.getDataEntity().get("id");
                    Date year = dataEntity.getDataEntity().getDate("year");
                    String ztdm = dataEntity.getDataEntity().getString("zt_dm");
                    dataEntity.getDataEntity().set("nd_dm", (Object)String.valueOf(DateUtils.getYearOfDate(year)));
                    DynamicObject[] subjects = BusinessDataServiceHelper.load((String)"tcvvt_clique_accountset", (String)"id", (QFilter[])new QFilter[]{new QFilter("zt_dm", "=", (Object)ztdm).and("year", "=", (Object)year).and("id", "not in", pkId)});
                    if (subjects != null && subjects.length > 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\u201c\u8d26\u5957\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AccountSetOp_0", (String)"taxc-tcvvt", (Object[])new Object[0]));
                        continue;
                    }
                    String orgNumber = ((DynamicObject)dataEntity.getDataEntity().get("org")).getString("number");
                    DynamicObject hsOrg = BusinessDataServiceHelper.loadSingle((String)AccountSetOp.BOS_ORG, (String)"fisaccounting", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNumber).and("fisaccounting", "=", (Object)"1")});
                    if (hsOrg == null) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u662f\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"AccountSetOp_1", (String)"taxc-tcvvt", (Object[])new Object[0]));
                        continue;
                    }
                    String jtdmNumber = ((DynamicObject)dataEntity.getDataEntity().get("jt_dm")).getString("number");
                    DynamicObject jtdm = BusinessDataServiceHelper.loadSingle((String)AccountSetOp.TCVVT_QHJT, (String)"number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)jtdmNumber).and("enable", "=", (Object)"1")});
                    if (jtdm == null) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u96c6\u56e2\u4ee3\u7801\u4e0d\u53ef\u7528\u3002", (String)"AccountSetOp_2", (String)"taxc-tcvvt", (Object[])new Object[0]));
                        continue;
                    }
                    long taxorgNumber = ((DynamicObject)dataEntity.getDataEntity().get("taxorg")).getLong("id");
                    DynamicObject taxorg = BusinessDataServiceHelper.loadSingle((String)AccountSetOp.BASTAX_TAXORG, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taxorgNumber).and("status", "=", (Object)"1").and("istaxpayer", "=", (Object)"1")});
                    if (taxorg == null) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u53ef\u7528\u3002", (String)"AccountSetOp_3", (String)"taxc-tcvvt", (Object[])new Object[0]));
                        continue;
                    }
                    HasPermOrgResult orgsByUserId = PermissionUtils.getAllPermOrgsByUserId("tcvvt", "tcvvt_clique_accountset", "47156aff000000ac", RequestContext.get().getCurrUserId());
                    if (orgsByUserId == null || orgsByUserId.hasAllOrgPerm()) continue;
                    DynamicObject taxOrg = dataEntity.getDataEntity().getDynamicObject("taxorg");
                    long taxoid = taxOrg.getLong("id");
                    DynamicObject org = dataEntity.getDataEntity().getDynamicObject("org");
                    long oid = org.getLong("id");
                    if (!orgsByUserId.getHasPermOrgs().contains(taxoid)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7a0e\u52a1\u7ec4\u7ec7\u201c%s\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7528\u6237\u6388\u6743\u3002", (String)"AccountSetOp_4", (String)"taxc-tcvvt", (Object[])new Object[0]), taxoid));
                        continue;
                    }
                    if (orgsByUserId.getHasPermOrgs().contains(oid)) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u6838\u7b97\u7ec4\u7ec7\u201c%s\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u7528\u6237\u6388\u6743\u3002", (String)"AccountSetOp_5", (String)"taxc-tcvvt", (Object[])new Object[0]), org.getString("name")));
                }
            }
        });
    }
}

