/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.opplugin.group.qcye;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tcvvt.common.upgrade.AbstractUpgradeFormPlugin;

public class TcvvtQcyeDataUpgradeOp
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(TcvvtQcyeDataUpgradeOp.class);

    @Override
    protected IUpgradeService getService() {
        return this;
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        DynamicObject[] qcyes;
        ArrayList<String> kjqjs = new ArrayList<String>(3);
        kjqjs.add("10");
        kjqjs.add("11");
        kjqjs.add("12");
        ArrayList<DynamicObject> updateDatas = new ArrayList<DynamicObject>();
        for (DynamicObject qcye : qcyes = BusinessDataServiceHelper.load((String)"tcvvt_clique_qcye", (String)"id,org,kjqj,nd_dm", (QFilter[])new QFilter[]{new QFilter("kjqj", "not in", kjqjs)})) {
            String kjqj = qcye.getString("kjqj");
            if (kjqj.startsWith("0")) continue;
            StringBuilder sb = new StringBuilder("0").append(kjqj);
            qcye.set("kjqj", (Object)sb.toString());
            updateDatas.add(qcye);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])updateDatas.stream().toArray(DynamicObject[]::new)));
        this.addLog(INFO, ResManager.loadKDString((String)"\u5171\u5347\u7ea7%s\u6761\u6570\u636e\u3002", (String)"TcvvtQcyeDataUpgradeOp_0", (String)"taxc-tcvvt", (Object[])new Object[]{updateDatas.size()}));
        updateDatas.stream().forEach(o -> this.addLog(INFO, o.getString("org.name") + " " + o.getString("nd_dm") + " " + o.getString("kjqj")));
    }
}

