/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.mservice.declare;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleFetchConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxableListEnum;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.taxdeclare.taxrange.TaxableListQueryService;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.EngineResponse;
import kd.taxc.tcvvt.common.util.MainReportUtil;
import kd.taxc.tcvvt.common.util.TcvvtTemplateUtils;
import kd.taxc.tcvvt.mservice.impl.handler.DeclareHandlerCheckFacility;
import org.apache.commons.lang3.ObjectUtils;

public class TaxableListQueryServiceImpl
implements TaxableListQueryService {
    private static final String AJSB = "ajsb";
    private static final String AYSB = "aysb";
    private static final String CWBB_ND = "cwbbnd";
    private static final String CWBB_FND = "cwbbfnd";
    private static final String TCTB_TAX_MAIN = "tctb_tax_main";
    private static final Log LOGGER = LogFactory.getLog(TaxableListQueryServiceImpl.class);

    /*
     * WARNING - void declaration
     */
    public List<Map<String, Object>> queryDeclareTaxableList(List<Long> orgList, List<String> declareCategories, Date declareDate) {
        ArrayList<TaxableListDto> taxableListDtos = new ArrayList<TaxableListDto>(orgList.size());
        Date month = DateUtils.getFirstDateOfMonth((Date)declareDate);
        if (EmptyCheckUtils.isEmpty(orgList)) {
            return new ArrayList<Map<String, Object>>(0);
        }
        QFilter orgIdFilter = new QFilter("orgid", "in", orgList);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)TCTB_TAX_MAIN, (String)"orgid,taxoffice.id", (QFilter[])new QFilter[]{orgIdFilter});
        Map<Long, Long> taxofficeMap = collection.stream().collect(Collectors.toMap(a -> a.getLong("orgid"), b -> b.getLong("taxoffice.id"), (m, n) -> m));
        TaxResult cwbb = TaxcMainDataServiceHelper.queryTaxcMainAndCategoryByOrgIdsAndTaxtype(orgList, (String)"cwbb");
        List cwbbcategory = (List)cwbb.getData();
        Map<Long, String> financetaxperiodMap = cwbbcategory.stream().collect(Collectors.toMap(a -> a.getLong("taxorg.id"), b -> ((DynamicObject)b.getDynamicObjectCollection("categoryentryentity").get(0)).getString("declareperiod"), (m, n) -> m));
        for (Long org : orgList) {
            String orgId = String.valueOf(org);
            Date startDate = null;
            Date endDate = null;
            String string = financetaxperiodMap.get(org);
            if ("1".equalsIgnoreCase(string)) {
                String string2 = AYSB;
            } else if ("2".equalsIgnoreCase(string)) {
                String string3 = AJSB;
            }
            for (String category : declareCategories) {
                DynamicObject template;
                void var17_17;
                EngineResponse engineResponse = this.validate(orgId, startDate, endDate, (String)var17_17, category, month);
                if (!engineResponse.getSuccess().booleanValue()) continue;
                Map data = (Map)engineResponse.getData();
                startDate = Objects.isNull(data.get("skssqq")) ? null : (Date)data.get("skssqq");
                endDate = Objects.isNull(data.get("skssqz")) ? null : (Date)data.get("skssqz");
                try {
                    template = TcvvtTemplateUtils.getTemplateType((String)orgId, (Date)startDate, (Date)endDate);
                }
                catch (KDException e) {
                    LOGGER.error("nsrxx unaudited or incomplete ", (Throwable)e);
                    continue;
                }
                QFilter orgFilter = new QFilter("orgid", "=", (Object)Long.parseLong(orgId));
                DynamicObject dTctb = QueryServiceHelper.queryOne((String)TCTB_TAX_MAIN, (String)"registertime", (QFilter[])new QFilter[]{orgFilter});
                Date fregistertime = dTctb.getDate("registertime");
                if (fregistertime != null && fregistertime.after(endDate)) continue;
                TaxableListEnum taxableListEnum = null;
                if (CWBB_ND.equalsIgnoreCase(category)) {
                    taxableListEnum = TaxableListEnum.CWBB_ND;
                } else if (CWBB_FND.equalsIgnoreCase(category)) {
                    taxableListEnum = TaxableListEnum.CWBB_FND;
                }
                if (!ObjectUtils.isEmpty((Object)template) && !ObjectUtils.isEmpty((Object)template.getString("type.number")) && template.getString("type.number").equalsIgnoreCase("FR0003") && CWBB_ND.equalsIgnoreCase(category) || ObjectUtils.isEmpty((Object)taxableListEnum)) continue;
                this.buildTaxableListDto(taxableListDtos, month, taxofficeMap, org, startDate, endDate, template, taxableListEnum);
            }
        }
        ArrayList results = taxableListDtos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<TaxableListDto>(Comparator.comparing(a -> a.getOrg() + DateUtils.format((Date)a.getSkssqq()) + DateUtils.format((Date)a.getSkssqz()) + a.getTemplateid()))), ArrayList::new));
        List<Long> doOrgs = results.stream().map(TaxableListDto::getOrg).distinct().collect(Collectors.toList());
        List<String> templateIdList = results.stream().map(TaxableListDto::getTemplateid).distinct().collect(Collectors.toList());
        this.fillSbbInfo(doOrgs, results, templateIdList);
        List<Map<String, Object>> collect = results.stream().map(a -> a.transformToMap()).collect(Collectors.toList());
        for (Map map : collect) {
            map.put("taxationsys", TaxationsysMappingEnum.CHN.getId());
            map.put("taxareagroup", RuleFetchConstant.DEFALUT_TAXAREAGROUP);
        }
        return collect;
    }

    private void buildYearTaxableListDto(ArrayList<TaxableListDto> taxableListDtos, Date month, Map<Long, Long> taxofficeMap, Long org, String orgId, TaxableListEnum taxableListEnum) {
        Date startDate = DateUtils.getFirstDateOfYear((Date)DateUtils.addYear((Date)new Date(), (int)-1));
        Date endDate = DateUtils.getDayFirst((Date)DateUtils.getLastDateOfYear((Date)startDate));
        DynamicObject template = TcvvtTemplateUtils.getTemplateType((String)orgId, (Date)startDate, (Date)endDate);
        this.buildTaxableListDto(taxableListDtos, month, taxofficeMap, org, startDate, endDate, template, taxableListEnum);
    }

    private void buildTaxableListDto(ArrayList<TaxableListDto> taxableListDtos, Date month, Map<Long, Long> taxofficeMap, Long org, Date startDate, Date endDate, DynamicObject template, TaxableListEnum taxableListEnum) {
        TaxableListDto taxableListDto = new TaxableListDto();
        taxableListDto.setOrg(org);
        taxableListDto.setSkssqq(startDate);
        taxableListDto.setSkssqz(endDate);
        taxableListDto.setTaxcatetory(taxableListEnum.getBaseTaxId());
        taxableListDto.setSbbcategory(taxableListEnum.getSbbCategory());
        taxableListDto.setDgcategory(taxableListEnum.getDgCategory());
        taxableListDto.setTaxauthority(taxofficeMap.get(org));
        if (Objects.nonNull(template)) {
            taxableListDto.setTemplatetype(template.getString("type.id"));
            taxableListDto.setTemplateid(template.getString("id"));
        }
        taxableListDto.setMonth(month);
        taxableListDto.setPaystatus(TaxableListDto.PAYSTATUS_WJK);
        taxableListDto.setDeclarestatus(TaxableListDto.DECLARESTATUS_WBZ);
        taxableListDto.setDraftstatus(TaxableListDto.DRAFTSTATUS_WXBZ);
        taxableListDtos.add(taxableListDto);
    }

    /*
     * Enabled aggressive block sorting
     */
    private EngineResponse validate(String orgId, Date startDate, Date endDate, String reportType, String category, Date month) {
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        EngineResponse engineResponse = new EngineResponse(Boolean.valueOf(false), data, null, null);
        if (!DeclareHandlerCheckFacility.checkIsTaxpayer(orgId)) {
            engineResponse.setMessage(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u975e\u53ef\u7528\u7eb3\u7a0e\u4e3b\u4f53\uff0c\u8bf7\u68c0\u67e5\u7eb3\u7a0e\u4eba\u4fe1\u606f\u7684\u6b63\u786e\u6027\u3002", (String)"TaxableListQueryServiceImpl_0", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]));
            return engineResponse;
        }
        Calendar getMonth = Calendar.getInstance();
        getMonth.setTime(month);
        int i = getMonth.get(2) + 1;
        if (AYSB.equals(reportType) && CWBB_FND.equalsIgnoreCase(category)) {
            Date date = DateUtils.addMonth((Date)month, (int)-1);
            startDate = DateUtils.getFirstDateOfMonth((Date)date);
            endDate = DateUtils.getDayFirst((Date)DateUtils.getLastDateOfMonth((Date)date));
        } else if (AJSB.equals(reportType) && CWBB_FND.equalsIgnoreCase(category)) {
            if (i != 4 && i != 7 && i != 10 && i != 1) {
                engineResponse.setMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7533\u62a5\u65e5\u671f\u65e0\u53ef\u751f\u6210\u7684\u5b63\u5ea6\u8d22\u52a1\u62a5\u8868\u3002", (String)"TaxableListQueryServiceImpl_3", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]));
                return engineResponse;
            }
            Date seasondate = DateUtils.addMonth((Date)month, (int)-3);
            startDate = DateUtils.getFirstDateOfSeason((Date)seasondate);
            endDate = DateUtils.getDayFirst((Date)DateUtils.getLastDateOfSeason((Date)seasondate));
        } else if (CWBB_ND.equalsIgnoreCase(category)) {
            if (i > 5) {
                engineResponse.setMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7533\u62a5\u65e5\u671f\u65e0\u53ef\u751f\u6210\u7684\u5e74\u5ea6\u8d22\u52a1\u62a5\u8868\u3002", (String)"TaxableListQueryServiceImpl_4", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]));
                return engineResponse;
            }
            startDate = DateUtils.getFirstDateOfYear((Date)DateUtils.addYear((Date)month, (int)-1));
            endDate = DateUtils.getDayFirst((Date)DateUtils.getLastDateOfYear((Date)startDate));
        }
        if (null == startDate || null == endDate) {
            engineResponse.setMessage(ResManager.loadKDString((String)"\u7533\u62a5\u5c5e\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxableListQueryServiceImpl_1", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]));
            return engineResponse;
        }
        boolean isOpenTaxMainFinancial = MainReportUtil.isOpenTaxMainFinancial((String)orgId);
        if (!isOpenTaxMainFinancial) {
            engineResponse.setMessage(ResManager.loadKDString((String)"\u7ec4\u7ec7\u8d22\u52a1\u62a5\u8868\u62a5\u9001\u672a\u542f\u7528\uff0c\u8bf7\u5230\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u7ef4\u62a4\u3002", (String)"TaxableListQueryServiceImpl_2", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]));
            return engineResponse;
        }
        data.put("skssqq", startDate);
        data.put("skssqz", endDate);
        data.put("org", orgId);
        engineResponse.setSuccess(Boolean.valueOf(true));
        return engineResponse;
    }

    /*
     * WARNING - void declaration
     */
    private void fillSbbInfo(List<Long> doOrgs, ArrayList<TaxableListDto> results, List<String> templateIdList) {
        void var7_17;
        void var6_11;
        HashMap<Date, Date> dataMap = new HashMap<Date, Date>(512);
        for (TaxableListDto taxableListDto : results) {
            Date date = taxableListDto.getSkssqq();
            Date skssqz = taxableListDto.getSkssqz();
            if (ObjectUtils.isEmpty((Object)date) || ObjectUtils.isEmpty((Object)skssqz)) continue;
            dataMap.putIfAbsent(date, skssqz);
        }
        ArrayList<QFilter> dateFilters = new ArrayList<QFilter>(16);
        for (Map.Entry entry : dataMap.entrySet()) {
            QFilter filter = new QFilter("skssqq", "=", entry.getKey()).and("skssqz", "=", entry.getValue());
            dateFilters.add(filter);
        }
        Object var6_8 = null;
        Object var7_15 = null;
        if (!ObjectUtils.isEmpty(dateFilters)) {
            if (dateFilters.size() == 1) {
                QFilter qFilter = (QFilter)dateFilters.get(0);
            } else if (dateFilters.size() == 2) {
                QFilter qFilter = (QFilter)dateFilters.get(0);
                QFilter qFilter2 = (QFilter)dateFilters.get(1);
            }
        }
        DynamicObjectCollection sbbList1 = null;
        DynamicObjectCollection sbbList2 = null;
        DynamicObjectCollection sbbList = null;
        QFilter orgFilter = new QFilter("org", "in", doOrgs);
        QFilter typeFilter = new QFilter("templateid", "in", templateIdList);
        if (!ObjectUtils.isEmpty((Object)var6_11)) {
            sbbList1 = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"billno,paystatus,declarestatus,skssqq,skssqz,org,type,templateid", (QFilter[])new QFilter[]{var6_11, orgFilter, typeFilter});
        }
        if (!ObjectUtils.isEmpty((Object)var7_17)) {
            sbbList2 = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"billno,paystatus,declarestatus,skssqq,skssqz,org,type,templateid", (QFilter[])new QFilter[]{var7_17, orgFilter, typeFilter});
        }
        if (sbbList1 != null && !ObjectUtils.isEmpty(sbbList1) && sbbList2 != null && !ObjectUtils.isEmpty(sbbList2)) {
            sbbList1.addAll(sbbList2);
            sbbList = sbbList1;
        } else if (sbbList1 != null && !ObjectUtils.isEmpty(sbbList1)) {
            sbbList = sbbList1;
        } else if (sbbList2 != null && !ObjectUtils.isEmpty(sbbList2)) {
            sbbList = sbbList2;
        }
        Map<Object, Object> sbbMap = new HashMap();
        if (sbbList != null && !ObjectUtils.isEmpty(sbbList)) {
            sbbMap = sbbList.stream().collect(Collectors.toMap(a -> this.getUniqKey((DynamicObject)a, true), b -> b, (m, n) -> m));
        }
        for (TaxableListDto result : results) {
            String key = result.getOrg().toString() + DateUtils.format((Date)result.getSkssqq()) + DateUtils.format((Date)result.getSkssqz()) + result.getTemplateid();
            DynamicObject dynamicObject = (DynamicObject)sbbMap.get(key);
            if (dynamicObject != null) {
                result.setSbbno(dynamicObject.getString("billno"));
                result.setPaystatus(dynamicObject.getString("paystatus"));
                result.setDeclarestatus(dynamicObject.getString("declarestatus"));
                continue;
            }
            result.setPaystatus(TaxableListDto.PAYSTATUS_WJK);
            result.setDeclarestatus(TaxableListDto.DECLARESTATUS_WBZ);
        }
    }

    private String getUniqKey(DynamicObject a, boolean isDeclare) {
        return a.getString("org") + DateUtils.format((Date)a.getDate("skssqq")) + DateUtils.format((Date)a.getDate("skssqz")) + a.getString("templateid");
    }
}

