/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.mservice.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.vo.DeclareRequest;
import kd.taxc.tcvvt.mservice.BatchEngineAbstract;
import kd.taxc.tcvvt.mservice.IBatchHandler;
import kd.taxc.tcvvt.mservice.api.TcvvtMainReportService;

public class TcvvtMainReportServiceImpl
extends BatchEngineAbstract
implements TcvvtMainReportService {
    private static Log logger = LogFactory.getLog(TcvvtMainReportServiceImpl.class);
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String ORGLIST = "orglist";
    private static final String DECLARETYPE = "declaretype";
    private static final String ORGID = "orgid";
    private static final String HANDLER_IMPL = "kd.taxc.tcvvt.mservice.impl.handler.MainReportDeclareHandler";

    public static IBatchHandler createBantchHandler() {
        String className = HANDLER_IMPL;
        if (className == null) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u63a5\u53e3\u6ca1\u6709\u5b9e\u73b0", (String)"TcvvtMainReportServiceImpl_0", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]), new Object[0]));
        }
        return (IBatchHandler)TypesContainer.createInstance((String)className);
    }

    @Override
    public String generate(String request) {
        DeclareRequest declareRequest = (DeclareRequest)SerializationUtils.fromJsonString((String)request, DeclareRequest.class);
        String orgId = declareRequest.getOrgId();
        logger.info("TcvvtMainReportServiceImpl generate start orgId={}", (Object)orgId);
        String category = declareRequest.getCategory();
        Date startDate = declareRequest.getStartDate();
        Date endDate = declareRequest.getEndDate();
        IBatchHandler bantchHandler = TcvvtMainReportServiceImpl.createBantchHandler();
        return super.superGenerate(bantchHandler, orgId, category, startDate, endDate);
    }

    @Override
    protected Map<String, Object> createCustomMap(String orgId, String category, Map<String, Object> data) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put(ORGID, orgId);
        customParams.put(SKSSQQ, data.get(SKSSQQ));
        customParams.put(SKSSQZ, data.get(SKSSQZ));
        customParams.put("policy", data.get("policy"));
        customParams.put(ORGLIST, orgId);
        customParams.put(DECLARETYPE, category);
        return customParams;
    }

    @Override
    protected EngineModel createEngineModel(String orgId, String category, Map<String, Object> custom) {
        String startDate = (String)custom.get(SKSSQQ);
        String endDate = (String)custom.get(SKSSQZ);
        EngineModel engineModel = new EngineModel(orgId, startDate, endDate);
        engineModel.setDeclareType(category);
        engineModel.getCustom().putAll(custom);
        return engineModel;
    }
}

