/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.mservice.impl.handler;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tcvvt.business.taxorg.TcvvtTaxOrgCommonBusiness;
import kd.taxc.tcvvt.common.util.DateUtils;
import kd.taxc.tcvvt.common.util.MainReportUtil;
import kd.taxc.tcvvt.common.util.StringUtil;
import kd.taxc.tcvvt.common.util.TcvvtTemplateUtils;
import kd.taxc.tcvvt.common.util.table.YbnsrService;
import kd.taxc.tcvvt.mservice.pojo.DataResultVo;

public class DeclareHandlerCheckFacility {
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";

    public static DataResultVo checkOrgAndDate(DynamicObject template, String orgId, String reporttype, Date startDate, Date endDate) throws KDBizException {
        String enddateStr;
        String startdateStr;
        DynamicObjectCollection collection;
        if (StringUtil.isEmpty((CharSequence)orgId)) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"DeclareHandlerCheckFacility_0", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]));
        }
        if (startDate == null) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u6240\u5c5e\u671f\u8d77\u4e0d\u5b58\u5728", (String)"DeclareHandlerCheckFacility_1", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]));
        }
        if (endDate == null) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u6240\u5c5e\u671f\u6b62\u4e0d\u5b58\u5728", (String)"DeclareHandlerCheckFacility_2", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]));
        }
        if (!DeclareHandlerCheckFacility.checkIsTaxpayer(orgId)) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u975e\u53ef\u7528\u7eb3\u7a0e\u4e3b\u4f53\uff0c\u8bf7\u68c0\u67e5\u7eb3\u7a0e\u4eba\u4fe1\u606f\u7684\u6b63\u786e\u6027\u3002", (String)"DeclareHandlerCheckFacility_25", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]));
        }
        QFilter orgFilter = new QFilter("orgid", "=", (Object)Long.parseLong(orgId));
        DynamicObject dTctb = QueryServiceHelper.queryOne((String)"tctb_tax_main", (String)"accountingstandards,newrule,registertime", (QFilter[])new QFilter[]{orgFilter});
        if (dTctb != null) {
            String newrule = dTctb.getString("newrule");
            long accountingstandards = dTctb.getLong("accountingstandards");
            if (accountingstandards == 1072508277482326016L && (StringUtil.isEmpty((CharSequence)newrule) || "empty".equalsIgnoreCase(newrule))) {
                return DataResultVo.fail(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u57fa\u7840\u8bbe\u7f6e-\u7a0e\u52a1\u7ec4\u7ec7\u7ba1\u7406-\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u9009\u62e9\u7ef4\u62a4\u201c\u6267\u884c\u65b0\u51c6\u5219\u201d\u7684\u76f8\u5173\u4fe1\u606f\uff0c\u518d\u8fdb\u884c\u586b\u62a5\u3002", (String)"DeclareHandlerCheckFacility_5", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]));
            }
        } else {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8bbe\u7f6e\u8fdb\u884c\u914d\u7f6e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DeclareHandlerCheckFacility_6", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]));
        }
        boolean isOpenTaxMainFinancial = MainReportUtil.isOpenTaxMainFinancial((String)orgId);
        if (!isOpenTaxMainFinancial) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u7ec4\u7ec7\u8d22\u52a1\u62a5\u8868\u62a5\u9001\u672a\u542f\u7528\uff0c\u8bf7\u5230\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u7ef4\u62a4\u3002", (String)"DeclareHandlerCheckFacility_30", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]));
        }
        if (Objects.isNull(template) && null == (template = DeclareHandlerCheckFacility.getTemplateType(orgId, startDate, endDate)) && (collection = YbnsrService.queryYbnsr((String)orgId, (List)TcvvtTemplateUtils.TEMPALTE_TYPE, (String)(startdateStr = DateUtils.format((Date)startDate, (String)"yyyy-MM-dd")), (String)(enddateStr = DateUtils.format((Date)endDate, (String)"yyyy-MM-dd")), Collections.emptyMap())).size() > 1) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u5c5e\u7a0e\u671f\u7533\u62a5\u8868\u6a21\u677f\u5c1a\u672a\u7ef4\u62a4\u6216\u8be5\u51c6\u5219\u9002\u7528\u7684\u8d22\u52a1\u62a5\u8868\u529f\u80fd\u5c1a\u672a\u4e0a\u7ebf\uff0c\u656c\u8bf7\u671f\u5f85\u3002", (String)"DeclareHandlerCheckFacility_7", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]));
        }
        if (Objects.isNull(template)) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u5c5e\u7a0e\u671f\u7533\u62a5\u8868\u6a21\u677f\u5c1a\u672a\u7ef4\u62a4\u6216\u8be5\u51c6\u5219\u9002\u7528\u7684\u8d22\u52a1\u62a5\u8868\u529f\u80fd\u5c1a\u672a\u4e0a\u7ebf\uff0c\u656c\u8bf7\u671f\u5f85\u3002", (String)"DeclareHandlerCheckFacility_7", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]));
        }
        if (startDate.compareTo(endDate) > 0) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u586b\u5199\u9519\u8bef\u3002", (String)"DeclareHandlerCheckFacility_26", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]));
        }
        Date now = new Date();
        if (now.compareTo(startDate) <= 0 || now.compareTo(endDate) < 0) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u4e0d\u5f97\u665a\u4e8e\u5f53\u524d\u65f6\u95f4", (String)"DeclareHandlerCheckFacility_9", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]));
        }
        Date tempStartDate = template.getDate("startdate");
        Date tempEndDate = template.getDate("enddate");
        if (tempStartDate.compareTo(endDate) > 0 || tempEndDate != null && tempEndDate.compareTo(startDate) < 0) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u4e0d\u5728\u6a21\u677f\u6709\u6548\u671f\u8303\u56f4\u5185\u3002", (String)"DeclareHandlerCheckFacility_27", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]));
        }
        Date fregistertime = dTctb.getDate("registertime");
        if (fregistertime != null && fregistertime.after(endDate)) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u4e0d\u5f97\u65e9\u4e8e\u4f01\u4e1a\u767b\u8bb0\u65f6\u95f4\u3002", (String)"DeclareHandlerCheckFacility_28", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]));
        }
        QFilter orgIdFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        boolean exists = false;
        QFilter typeFilter = new QFilter("type", "in", (Object)Lists.newArrayList((Object[])new String[]{"FR0001", "FR0002", "FR0003", "FR0004", "FR0011"}));
        if ("aysb".equalsIgnoreCase(reporttype)) {
            QFilter taxLimitFilter = new QFilter("taxlimit", "=", (Object)"season");
            QFilter skssqqzFilter = new QFilter(SKSSQQ, "<=", (Object)startDate).and(new QFilter(SKSSQZ, ">=", (Object)startDate));
            exists = QueryServiceHelper.exists((String)"tcvat_nsrxx", (QFilter[])new QFilter[]{orgIdFilter, typeFilter, taxLimitFilter, skssqqzFilter});
        } else if ("ajsb".equalsIgnoreCase(reporttype)) {
            QFilter taxLimitFilter = new QFilter("taxlimit", "=", (Object)"month");
            QFilter skssqqzFilter = new QFilter(SKSSQQ, ">=", (Object)startDate).and(new QFilter(SKSSQZ, "<=", (Object)endDate));
            exists = QueryServiceHelper.exists((String)"tcvat_nsrxx", (QFilter[])new QFilter[]{orgIdFilter, typeFilter, taxLimitFilter, skssqqzFilter});
        }
        if (exists) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u6309\u6708\u6216\u5b63\u7533\u62a5\u65f6\uff0c\u6240\u5c5e\u7a0e\u671f\u4e0d\u80fd\u5b58\u5728\u4ea4\u96c6\uff0c\u8bf7\u4fee\u6539", (String)"DeclareHandlerCheckFacility_13", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]));
        }
        if ("ansb".equalsIgnoreCase(reporttype) && "FR0003".equalsIgnoreCase(template.getString("type.number"))) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5c0f\u4f01\u4e1a\u4f1a\u8ba1\u5236\u5ea6\u6309\u5e74\u7533\u62a5\u65b9\u5f0f", (String)"DeclareHandlerCheckFacility_14", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]));
        }
        return null;
    }

    public static boolean checkIsTaxpayer(String orgId) {
        return TcvvtTaxOrgCommonBusiness.isTaxcOrgExistByOrgIdAndIsTaxpayer((Long)Long.parseLong(orgId));
    }

    public static DynamicObject getTemplateType(String orgid, Date sksqq, Date sksqz) {
        return TcvvtTemplateUtils.getTemplateType((String)orgid, (Date)sksqq, (Date)sksqz);
    }
}

