/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.mservice.impl.handler;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.handler.QueryOrSaveDeclareHandler;
import kd.taxc.bdtaxr.common.declare.handler.QueryOrSaveDeclareServiceFactory;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.refactor.template.SpreadUtils;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcvvt.business.finance.TcvvtDeclareDataBusinessImpl;
import kd.taxc.tcvvt.business.finance.TcvvtLicenseCheckBusinessImpl;
import kd.taxc.tcvvt.common.util.MainReportUtil;
import kd.taxc.tcvvt.common.util.StringUtil;
import kd.taxc.tcvvt.common.util.datasource.TcvvtEngineUtils;
import kd.taxc.tcvvt.mservice.IBatchHandler;
import kd.taxc.tcvvt.mservice.impl.OrgHelperService;
import kd.taxc.tcvvt.mservice.impl.handler.DeclareHandlerCheckFacility;
import kd.taxc.tcvvt.mservice.pojo.DataResultVo;
import org.apache.commons.lang3.ObjectUtils;

public class MainReportDeclareHandler
implements IBatchHandler {
    private static Log logger = LogFactory.getLog(MainReportDeclareHandler.class);
    private static final String EDIT_STATUS = "edit";
    private static final String NUMBER = "number";
    private static final String TAX_TYPE = "qysds";
    private static final String REPORTTYPE = "reporttype";
    private static final String AJSB = "ajsb";
    private static final String AYSB = "aysb";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    public static final String YYYY_MM_DD_HH_MM_SS_SS = "yyyy-MM-dd HH:mm:ss.sss";
    private static OrgHelperService orgHelperService = new OrgHelperService();
    public static final String TCVVT_MESSAGE = "tcvvt_message";
    private static final String ENTRYENTITY = "entryentity";
    private static final String[] TAX_LIMITS = new String[]{"month", "season", "year"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataResultVo initData(String orgId, Date startDate, Date endDate) {
        String reportType = "";
        if (Objects.isNull(startDate) && Objects.isNull(endDate)) {
            reportType = MainReportUtil.getReportTypeByOrgId((String)orgId);
            if (AYSB.equals(reportType)) {
                Date date = DateUtils.addMonth((Date)new Date(), (int)-1);
                startDate = DateUtils.getFirstDateOfMonth((Date)date);
                endDate = DateUtils.getLastDateOfMonth((Date)date);
            } else if (AJSB.equals(reportType)) {
                Date seasondate = DateUtils.addMonth((Date)new Date(), (int)-3);
                startDate = DateUtils.getFirstDateOfSeason((Date)seasondate);
                endDate = DateUtils.getLastDateOfSeason((Date)seasondate);
            }
        }
        String sksqq = DateUtils.format((Date)startDate, (String)YYYY_MM_DD_HH_MM_SS_SS);
        String sksqz = DateUtils.format((Date)DateUtils.trunc((Date)endDate), (String)YYYY_MM_DD_HH_MM_SS_SS);
        String lockKey = String.format("financelock-%s-%s-%s-%s", orgId, DateUtils.format((Date)startDate), DateUtils.format((Date)endDate), reportType);
        DLock reentrant = DLock.createReentrant((String)lockKey, (String)"kd.taxc.tcvvt.mservice.impl.handler.MainReportDeclareHandler.initData");
        reentrant.fastMode();
        boolean b = reentrant.tryLock(1000L);
        if (!b) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u5df2\u6709\u4efb\u52a1\u5728\u6267\u884c\u751f\u6210\u6b64\u7533\u62a5\u8868", (String)"MainReportDeclareHandler_4", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]));
        }
        try {
            DataResultVo dataResultVo = this.validateCreateCondition(orgId, sksqq, sksqz);
            if (Objects.nonNull(dataResultVo)) {
                HashMap<String, String> map = new HashMap<String, String>(8);
                map.put(SKSSQQ, sksqq);
                map.put(SKSSQZ, sksqz);
                dataResultVo.setData(map);
                DataResultVo dataResultVo2 = dataResultVo;
                return dataResultVo2;
            }
            DynamicObject template = MainReportUtil.getTemplateType((String)orgId, (String)sksqq, (String)sksqz);
            DataResultVo checkOrgAndDate = DeclareHandlerCheckFacility.checkOrgAndDate(template, orgId, reportType, startDate, endDate);
            if (Objects.nonNull(checkOrgAndDate)) {
                HashMap<String, String> map = new HashMap<String, String>(8);
                map.put(SKSSQQ, sksqq);
                map.put(SKSSQZ, sksqz);
                checkOrgAndDate.setData(map);
                DataResultVo dataResultVo3 = checkOrgAndDate;
                return dataResultVo3;
            }
            ArrayList accountList = new ArrayList();
            kd.taxc.tcvvt.common.util.engine.EngineModel engineModel = new kd.taxc.tcvvt.common.util.engine.EngineModel(orgId, sksqq, sksqz);
            engineModel.setDeclareType(template.getString("type.number"));
            ArrayList<kd.taxc.tcvvt.common.util.engine.EngineModel> engineModels = new ArrayList<kd.taxc.tcvvt.common.util.engine.EngineModel>();
            engineModels.add(engineModel);
            DynamicObject queryNsrxx = MainReportUtil.queryNsrxx((String)orgId, (String)sksqq, (String)sksqz);
            RequestContext requestContext = RequestContext.getOrCreate();
            if (queryNsrxx == null) {
                try (TXHandle h = TX.requiresNew();){
                    try {
                        accountList.addAll(TcvvtEngineUtils.execute((RequestContext)requestContext, engineModels));
                    }
                    catch (Throwable t) {
                        h.markRollback();
                        logger.error("cal cause exception\uff1a" + t);
                    }
                }
            }
            HashMap<String, String> customCalMap = new HashMap<String, String>();
            accountList.forEach(m -> customCalMap.put(m.getString("formulakey"), m.getString("fetchamount")));
            QFilter taxTypeFilter = new QFilter("taxtype", "=", (Object)template.getString(NUMBER));
            QFilter formulaname = new QFilter("formula", "like", (Object)"{P%");
            QFilter formulaTypeFilter = new QFilter("formulatype", "=", (Object)"1");
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bdtaxr_formula_edit", (String)"id,formulaname,formulakey", (QFilter[])new QFilter[]{taxTypeFilter, formulaname, formulaTypeFilter});
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                if (customCalMap.containsKey(dynamicObject.getString("formulakey"))) continue;
                customCalMap.put(dynamicObject.getString("formulakey"), "0.00");
            }
            DeclareRequestModel declareRequestModel = this.getDeclareRequestModel(orgId, EDIT_STATUS, queryNsrxx, sksqq, sksqz, template);
            declareRequestModel.setBusinessMap(customCalMap);
            this.createNsrxxCalcAndSave(declareRequestModel);
            this.saveBusiness(orgId, sksqq, sksqz, template);
            HashMap<String, String> result = new HashMap<String, String>(16);
            result.put("orgid", orgId);
            result.put(SKSSQQ, sksqq);
            result.put(SKSSQZ, sksqz);
            DataResultVo dataResultVo4 = DataResultVo.success("create data success", result);
            return dataResultVo4;
        }
        catch (KDBizException e) {
            DataResultVo dataResultVo = DataResultVo.fail(e.getMessage());
            return dataResultVo;
        }
        finally {
            reentrant.unlock();
        }
    }

    private DataResultVo validateCreateCondition(String orgId, String startDate, String endDate) {
        String skssqz;
        String skssqq;
        try {
            TcvvtLicenseCheckBusinessImpl.orgLicenseCheck((String)orgId, (String)"tcvvt");
        }
        catch (KDBizException e) {
            return DataResultVo.fail(e.getMessage());
        }
        DynamicObject taxMain = orgHelperService.findTaxMain(Long.parseLong(orgId));
        if (taxMain == null) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"MainReportDeclareHandler_0", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]));
        }
        DynamicObject taxInfos = orgHelperService.findTaxInfos(taxMain, TAX_TYPE);
        if (taxInfos == null) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u4e2d\uff0c\u4f01\u4e1a\u6240\u5f97\u7a0e\u7a0e\u79cd\u5361\u7247\u4e0d\u5b58\u5728\u3002", (String)"MainReportDeclareHandler_1", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]));
        }
        if (startDate != null && endDate != null) {
            skssqq = startDate;
            skssqz = endDate;
        } else {
            skssqq = DateUtils.format((Date)DateUtils.getFirstDateOfYear((Date)DateUtils.addYear((Date)new Date(), (int)-1)));
            skssqz = DateUtils.format((Date)DateUtils.getLastDateOfYear((Date)DateUtils.stringToDate((String)skssqq)));
        }
        DynamicObject template = MainReportUtil.getTemplateType((String)orgId, (String)skssqq, (String)skssqz);
        if (Objects.isNull(template)) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u5c5e\u7a0e\u671f\u7533\u62a5\u8868\u6a21\u677f\u5c1a\u672a\u7ef4\u62a4\u6216\u8be5\u51c6\u5219\u9002\u7528\u7684\u8d22\u52a1\u62a5\u8868\u529f\u80fd\u5c1a\u672a\u4e0a\u7ebf\uff0c\u656c\u8bf7\u671f\u5f85\u3002", (String)"MainReportDeclareHandler_2", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]));
        }
        String templateType = template.getString("type.number");
        DynamicObject dyo = YbnsrService.queryYbnsr((String)orgId, (String)templateType, (String)skssqq, (String)skssqz, null);
        Boolean exist = false;
        if (!ObjectUtils.isEmpty((Object)dyo)) {
            exist = true;
        } else {
            String reporttype = MainReportDeclareHandler.getReportType(DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate));
            exist = TcvvtDeclareDataBusinessImpl.queryReportIntersection((String)orgId, (String)reporttype, (Date)DateUtils.stringToDate((String)startDate), (Date)DateUtils.stringToDate((String)endDate));
        }
        if (exist.booleanValue()) {
            return DataResultVo.fail(ResManager.loadKDString((String)"\u540c\u4e00\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u6309\u6708\u6216\u5b63\u7533\u62a5\u65f6\uff0c\u6240\u5c5e\u7a0e\u671f\u4e0d\u80fd\u5b58\u5728\u4ea4\u96c6\u3002", (String)"MainReportDeclareHandler_3", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]));
        }
        return null;
    }

    private DeclareRequestModel getDeclareRequestModel(String orgId, String actionStatus, DynamicObject dynamicObject, String startdate, String enddate, DynamicObject template) {
        DeclareRequestModel requestModel = new DeclareRequestModel();
        requestModel.setId(dynamicObject != null ? Long.valueOf(dynamicObject.getLong("id")) : MainReportUtil.generateSBBId((String)"tcvat_nsrxx"));
        String billno = DeclareServiceHelper.generateSBBNo((String)"tcvvt_main_declare_list");
        requestModel.setBillNo(billno);
        requestModel.setOrgId(Long.valueOf(Long.parseLong(orgId)));
        requestModel.setTemplateType(template.getString("type.number"));
        requestModel.setTemplateId(Long.valueOf(template.getLong("id")));
        requestModel.setSkssqq(startdate);
        requestModel.setSkssqz(enddate);
        requestModel.setOperation(actionStatus);
        boolean refresh = OperationStatus.EDIT.name().equalsIgnoreCase(actionStatus) && dynamicObject == null;
        requestModel.setRefresh(Boolean.valueOf(refresh));
        if (dynamicObject != null && "2".equalsIgnoreCase(dynamicObject.getString("datatype"))) {
            requestModel.setRefresh(Boolean.valueOf(false));
        }
        StringBuilder name = new StringBuilder();
        DynamicObject templateObject = QueryServiceHelper.queryOne((String)"bdtaxr_template_main", (String)"id,startdate,enddate,number,type,content_tag", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)template.getString(NUMBER))});
        String jsonString = templateObject.getString("content_tag");
        LinkedHashMap jsonMap = SpreadUtils.getTemplateSheetMapFromJsonString((String)jsonString);
        for (Map.Entry entry : jsonMap.entrySet()) {
            String tableName = (String)entry.getKey();
            name.append(tableName).append(",");
        }
        requestModel.setSheetName(name.toString());
        return requestModel;
    }

    public Map<String, String> createNsrxxCalcAndSave(DeclareRequestModel declareModel) {
        QueryOrSaveDeclareHandler handler = QueryOrSaveDeclareServiceFactory.create((Long)declareModel.getTemplateId());
        DeclareResponseModel responseModel = handler.query(declareModel);
        handler.save(declareModel, responseModel.getData(), responseModel.getData(), responseModel.getMetaDataMap());
        return responseModel.getData();
    }

    private void saveBusiness(String orgId, String sksqq, String sksqz, DynamicObject template) {
        QFilter orgqFilter;
        QFilter endqFilter;
        if (MainReportUtil.isImport((String)orgId, (String)sksqq, (String)sksqz)) {
            return;
        }
        QFilter startFliter = new QFilter("startdate", "=", (Object)DateUtils.stringToDate((String)sksqq));
        DynamicObject dynamicObjectNew = BusinessDataServiceHelper.loadSingle((String)TCVVT_MESSAGE, (String)"type,templateid,status,orgid,startdate,enddate,reporttype,accountingstandards,newrule,registeraddress,declaretype,entryentity.selectid", (QFilter[])new QFilter[]{startFliter, endqFilter = new QFilter("enddate", "=", (Object)DateUtils.stringToDate((String)sksqz)), orgqFilter = new QFilter("orgid", "=", (Object)Long.parseLong(StringUtil.isNotBlank((CharSequence)orgId) ? orgId : "0"))});
        if (dynamicObjectNew == null) {
            dynamicObjectNew = BusinessDataServiceHelper.newDynamicObject((String)TCVVT_MESSAGE);
        }
        Date startdate = DateUtils.stringToDate((String)sksqq, (String)"yyyy-MM-dd");
        Date enddate = DateUtils.stringToDate((String)sksqz, (String)"yyyy-MM-dd");
        dynamicObjectNew.set("status", (Object)"2");
        dynamicObjectNew.set("orgid", (Object)Long.parseLong(orgId));
        dynamicObjectNew.set("startdate", (Object)startdate);
        dynamicObjectNew.set("enddate", (Object)enddate);
        String reportType = MainReportUtil.getReportTypeByOrgId((String)orgId);
        dynamicObjectNew.set(REPORTTYPE, (Object)reportType);
        dynamicObjectNew.set("type", (Object)(ObjectUtils.isNotEmpty((Object)template) ? template.getString("type.number") : ""));
        dynamicObjectNew.set("templateid", (Object)(ObjectUtils.isNotEmpty((Object)template) ? template.getString("id") : ""));
        QFilter orgFilter = new QFilter("orgid", "=", (Object)Long.parseLong(orgId));
        DynamicObject dTctb = QueryServiceHelper.queryOne((String)"tctb_tax_main", (String)"accountingstandards,newrule,registeraddress", (QFilter[])new QFilter[]{orgFilter});
        if (dTctb != null) {
            dynamicObjectNew.set("accountingstandards", dTctb.get("accountingstandards"));
            dynamicObjectNew.set("newrule", dTctb.get("newrule"));
            dynamicObjectNew.set("registeraddress", dTctb.get("registeraddress"));
        }
        DynamicObjectCollection entryentityAdd = dynamicObjectNew.getDynamicObjectCollection(ENTRYENTITY);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tcvvt_check_report", (String)"iconsurl,fitid,mainname,introname,id", (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)template.getString(NUMBER))}, (String)"id");
        List ids = dynamicObjects.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            entryentityAdd.removeIf(dynamicObject -> true);
            for (Long dynamicObject2 : ids) {
                entryentityAdd.addNew().set("selectid", (Object)dynamicObject2);
            }
        }
        OperationServiceHelper.executeOperate((String)"save", (String)TCVVT_MESSAGE, (DynamicObject[])new DynamicObject[]{dynamicObjectNew}, (OperateOption)OperateOption.create());
    }

    @Override
    public void runTask(EngineModel engineModel) {
    }

    private static String getReportType(Date startDate, Date endDate) {
        int dayDiff = kd.taxc.tcvvt.common.util.DateUtils.getDayDiff((Date)startDate, (Date)endDate);
        if (dayDiff > 366) {
            return null;
        }
        for (String taxLimit : TAX_LIMITS) {
            if (!kd.taxc.tcvvt.common.util.DateUtils.validDateRange((String)taxLimit, (Date)startDate, (Date)endDate)) continue;
            return MainReportDeclareHandler.getReportType(taxLimit);
        }
        return null;
    }

    public static String getReportType(String taxLimit) {
        if ("season".equals(taxLimit)) {
            return AJSB;
        }
        if ("year".equals(taxLimit)) {
            return "ansb";
        }
        if ("month".equals(taxLimit)) {
            return AYSB;
        }
        return null;
    }
}

