/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.mservice.upgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.tcvvt.common.util.DBUtils;
import kd.taxc.tcvvt.mservice.upgrade.DeclareMainUpgradeService;
import org.apache.commons.lang3.ObjectUtils;

public class DeclareBillnoUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(DeclareMainUpgradeService.class);
    UpgradeResult result = new UpgradeResult();
    boolean success = true;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        this.result.setLog(DeclareBillnoUpgradeService.doUpgrade());
        this.result.setSuccess(this.success);
        return this.result;
    }

    public static String doUpgrade() {
        long start = System.currentTimeMillis();
        ArrayList<Object[]> params = new ArrayList<Object[]>(512);
        String updateSql = "update T_TCTB_DECLARE_MAIN set FBILLNO =? where FID =?";
        String zdsynxxQuerySql = "select FID,FORGID,FBILLNO,FSKSSQZ from T_TCTB_DECLARE_MAIN where FNSRTYPE in ('zdsybs_yd','zdsybs_jd') and FBILLNO not like 'LBTA%'";
        String qhjtnxxQuerySql = "select FID,FORGID,FBILLNO,FSKSSQZ from T_TCTB_DECLARE_MAIN where FNSRTYPE = 'qhjtydbs' and FBILLNO not like 'NTEG%'";
        try {
            String billno;
            String orgId;
            Date skssqz;
            Long fid;
            List zdsynxxList = DBUtils.query((String)"taxc", (String)zdsynxxQuerySql);
            List qhjtnxxList = DBUtils.query((String)"taxc", (String)qhjtnxxQuerySql);
            for (Map map : zdsynxxList) {
                fid = Long.parseLong(map.get("FID").toString());
                skssqz = (Date)map.get("FSKSSQZ");
                orgId = map.get("FORGID").toString();
                billno = DeclareBillnoUpgradeService.getzdsyBillno(skssqz, orgId);
                params.add(new Object[]{billno, fid});
            }
            for (Map map : qhjtnxxList) {
                fid = Long.parseLong(map.get("FID").toString());
                skssqz = (Date)map.get("FSKSSQZ");
                orgId = map.get("FORGID").toString();
                billno = DeclareBillnoUpgradeService.getqhjtyBillno(skssqz, orgId);
                params.add(new Object[]{billno, fid});
            }
            if (ObjectUtils.isNotEmpty(params)) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)updateSql, params);
            }
            logger.info("\u6279\u91cf\u66f4\u65b0\u7533\u62a5\u8868\u7f16\u53f7 \u603b\u4f53\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            return String.format(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\uff1a%s", (String)"DeclareMainUpgradeService_1", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]), params.size());
        }
        catch (Throwable t) {
            logger.info("\u6279\u91cf\u66f4\u65b0\u7533\u62a5\u8868\u7f16\u53f7 \u5f02\u5e38\u62a5\u9519" + t.getMessage());
            throw t;
        }
    }

    private static String getzdsyBillno(Date skssqz, String orgId) {
        String entity = "tcvvt_tras_declare_list";
        DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)entity);
        dyo.set("skssqz", (Object)skssqz);
        return DeclareServiceHelper.generateSBBNo((String)entity, (DynamicObject)dyo, (String)orgId);
    }

    private static String getqhjtyBillno(Date skssqz, String orgId) {
        String entity = "tcvvt_month_declare_list";
        DynamicObject dyo = BusinessDataServiceHelper.newDynamicObject((String)entity);
        dyo.set("skssqz", (Object)skssqz);
        return DeclareServiceHelper.generateSBBNo((String)entity, (DynamicObject)dyo, (String)orgId);
    }
}

