/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.mservice.upgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.tcvvt.common.util.DBUtils;
import kd.taxc.tcvvt.common.util.EmptyCheckUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class DeclareMainUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(DeclareMainUpgradeService.class);
    UpgradeResult result = new UpgradeResult();
    boolean success = true;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        this.result.setLog(DeclareMainUpgradeService.doUpgrade());
        this.result.setSuccess(this.success);
        return this.result;
    }

    public static String doUpgrade() {
        long start = System.currentTimeMillis();
        ArrayList<Object[]> params = new ArrayList<Object[]>(512);
        ArrayList<Object[]> registParams = new ArrayList<Object[]>(512);
        String updateSql = "update T_TCVVT_MESSAGE set FNSRTYPE =? , FTEMPLATEID =? where FORGID =? and FSTARTDATE =? and FENDDATE =? and FNSRTYPE =' ' and FTEMPLATEID =' '";
        String regUpdateSql = "update T_TCVVT_MESSAGE set FREGISTERADDRESS = ? where FORGID =? and FSTARTDATE =? and FENDDATE =? and FREGISTERADDRESS=' '";
        String nxxQuerySql = "select FORGID,FTEMPLATEID,FNSRTYPE,FSKSSQQ,FSKSSQZ from T_TCTB_DECLARE_MAIN where FNSRTYPE in ('FR0001','FR0002','FR0003','FR0004')";
        String messageQuerySql = "select FID,FORGID,FSTARTDATE,FENDDATE,FTEMPLATEID,FNSRTYPE from T_TCVVT_MESSAGE where FORGID =? and FSTARTDATE =? and FENDDATE =?";
        String mainQuerySql = "select FREGISTERADDRESS,FORGID from T_TCTB_TAX_MAIN WHERE ";
        try {
            List nxxList = DBUtils.query((String)"taxc", (String)nxxQuerySql);
            List orgidList = nxxList.stream().map(x -> x.get("FORGID")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(orgidList)) {
                return ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\uff1a\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u6570\u636e\u3002", (String)"DeclareMainUpgradeService_2", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]);
            }
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append(mainQuerySql, new Object[0]);
            sqlBuilder.appendIn("FORGID", orgidList);
            DataSet data = DB.queryDataSet((String)"DeclareMainUpgradeService", (DBRoute)DBRoute.of((String)"taxc"), (SqlBuilder)sqlBuilder);
            HashMap<Long, String> map = new HashMap<Long, String>(nxxList.size());
            while (data.hasNext()) {
                Row row = data.next();
                Long id = row.getLong("FORGID");
                String address = row.getString("FREGISTERADDRESS");
                map.put(id, address);
            }
            for (Map nxx : nxxList) {
                String templateType = (String)nxx.get("FNSRTYPE");
                String templateId = (String)nxx.get("FTEMPLATEID");
                Long orgid = (Long)nxx.get("FORGID");
                Date skssqq = (Date)nxx.get("FSKSSQQ");
                Date skssqz = (Date)nxx.get("FSKSSQZ");
                String registeraddress = (String)map.get(orgid);
                if (!"FR0002".equals(templateType)) {
                    registParams.add(new Object[]{registeraddress, orgid, skssqq, skssqz});
                    params.add(new Object[]{templateType, templateId, orgid, skssqq, skssqz});
                    continue;
                }
                List messageList = DBUtils.query((String)"taxc", (String)messageQuerySql, (Object[])new Object[]{orgid, skssqq, skssqz});
                if (Objects.nonNull(messageList) && messageList.size() == 1) {
                    registParams.add(new Object[]{registeraddress, orgid, skssqq, skssqz});
                    params.add(new Object[]{templateType, templateId, orgid, skssqq, skssqz});
                    continue;
                }
                if (!Objects.nonNull(messageList) || messageList.size() <= 1) continue;
                if (StringUtils.isNotBlank((CharSequence)registeraddress)) {
                    registParams.add(new Object[]{registeraddress, orgid, skssqq, skssqz});
                    Map<String, Object> admindivisionMap = DeclareMainUpgradeService.queryBdAdmindivision(Long.parseLong(registeraddress));
                    if (CollectionUtils.isEmpty(admindivisionMap)) continue;
                    Long id = (Long)admindivisionMap.get("FID");
                    String fullname = (String)admindivisionMap.get("FFULLNAME");
                    String province = ResManager.loadKDString((String)"\u5c71\u897f\u7701", (String)"DeclareMainUpgradeService_0", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]);
                    if (2694L == id || fullname.contains(province)) {
                        params.add(new Object[]{"FR0002", "1493333248951347200", orgid, skssqq, skssqz});
                        continue;
                    }
                    params.add(new Object[]{templateType, templateId, orgid, skssqq, skssqz});
                    continue;
                }
                params.add(new Object[]{templateType, templateId, orgid, skssqq, skssqz});
            }
            data.close();
            logger.info("\u6279\u91cf\u66f4\u65b0\u8d22\u52a1\u62a5\u8868\u62a5\u544a\u6a21\u677f\u7c7b\u578b \u5f00\u59cb\u6267\u884c");
            if (ObjectUtils.isNotEmpty(params)) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)updateSql, params);
            }
            if (ObjectUtils.isNotEmpty(registParams)) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)regUpdateSql, registParams);
            }
            logger.info("\u6279\u91cf\u66f4\u65b0\u8d22\u52a1\u62a5\u8868\u62a5\u544a\u6a21\u677f\u7c7b\u578b \u603b\u4f53\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            return String.format(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\uff1a%s", (String)"DeclareMainUpgradeService_1", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]), params.size());
        }
        catch (Throwable t) {
            logger.info("\u6279\u91cf\u66f4\u65b0\u8d22\u52a1\u62a5\u8868\u62a5\u544a\u6a21\u677f\u7c7b\u578b \u5f02\u5e38\u62a5\u9519" + t.getMessage());
            throw t;
        }
    }

    private static Map<String, Object> queryBdAdmindivision(Long registeraddress) {
        Map<String, Object> map;
        Long parentId;
        if (Objects.isNull(registeraddress)) {
            return new HashMap<String, Object>(8);
        }
        String sysQuery = "select FID ,FPARENTID,FLEVEL,FFULLNAME from T_BD_ADMINDIVISION where FID=?";
        List sysList = DBUtils.query((String)"sys", (String)sysQuery, (Object[])new Object[]{registeraddress});
        if (EmptyCheckUtils.isEmpty((Object)sysList)) {
            return new HashMap<String, Object>(8);
        }
        Object parObj = ((Map)sysList.get(0)).get("FPARENTID");
        Long l = parentId = Objects.isNull(parObj) ? null : (Long)parObj;
        if (parentId == null) {
            return new HashMap<String, Object>(8);
        }
        if (parentId != 0L && EmptyCheckUtils.isNotEmpty(map = DeclareMainUpgradeService.queryBdAdmindivision(parentId)) && (Long)map.get("FPARENTID") == 0L) {
            return map;
        }
        return (Map)sysList.get(0);
    }
}

