/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcvvt.servicehelper;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;

public class ServiceFactory {
    private static Map<String, String> serviceMap = new HashMap<String, String>();

    public static <T> T getService(Class<T> clazz) {
        return (T)ServiceFactory.getService(clazz.getSimpleName());
    }

    public static Object getService(String serviceName) {
        String className = serviceMap.get(serviceName);
        if (className == null) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"ServiceFactory_0", (String)"taxc-tcvvt-mservice", (Object[])new Object[0]), serviceName));
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    public static void setServiceMap(String serviceName, String serviceImpl) {
        serviceMap.put(serviceName, serviceImpl);
    }

    static {
        serviceMap.put("SubjectQueryService", "kd.taxc.tcvvt.business.impl.SubjectQueryServiceImpl");
        serviceMap.put("DeclareService", "kd.taxc.tcvvt.mservice.impl.TcvvtMainReportServiceImpl");
        serviceMap.put("DeclareMainUpgradeService", "kd.taxc.tcvvt.mservice.upgrade.DeclareMainUpgradeService");
        serviceMap.put("TrasAndQhjtFetchDetailUpgradeService", "kd.taxc.tcvvt.mservice.upgrade.TrasAndQhjtFetchDetailUpgradeService");
        serviceMap.put("TaxableListQueryService", "kd.taxc.tcvvt.mservice.declare.TaxableListQueryServiceImpl");
        serviceMap.put("TrasQuestinareTableNameService", "kd.taxc.tcvvt.business.tras.TrasQuestinareTableNameBusinessImpl");
        serviceMap.put("TcvvtDeclareDataMservice", "kd.taxc.tcvvt.mservice.declare.TcvvtDeclareDataServiceImpl");
        serviceMap.put("TrasAccessconfigUpgradeService", "kd.taxc.tcvvt.mservice.upgrade.TrasAccessconfigUpgradeService");
        serviceMap.put("DeclareBillnoUpgradeService", "kd.taxc.tcvvt.mservice.upgrade.DeclareBillnoUpgradeService");
    }
}

