/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.common.constant;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;

public class RequestResult
implements Serializable {
    private static final long serialVersionUID = -7971747279298311643L;
    private static final String SUCCESS = "success";
    private static final String ERROR = "fail";
    private boolean success = true;
    private Integer httpStatus;
    private Object data;
    private String message;
    private String errorCode;

    public void setSuccess(boolean success) {
        this.errorCode = success ? SUCCESS : ERROR;
        this.success = success;
    }

    public boolean getSuccess() {
        return this.success;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    protected void init(Map<String, Object> obj) {
        this.setSuccess((Boolean)obj.get(SUCCESS));
        this.setMessage((String)obj.get("message"));
        this.setData(obj.get("data"));
        this.setErrorCode((String)obj.get("errorCode"));
    }

    protected Map<String, Object> toMap() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put(SUCCESS, this.getSuccess());
        ret.put("message", this.getMessage());
        ret.put("data", this.getData());
        ret.put("errorCode", this.getErrorCode());
        return ret;
    }

    public static RequestResult fail(String msg) {
        return RequestResult.fail(msg, ERROR);
    }

    public static RequestResult fail(String msg, String errorCode) {
        RequestResult result = new RequestResult();
        result.setSuccess(false);
        result.setMessage(msg);
        result.setErrorCode(errorCode);
        return result;
    }

    public static RequestResult success(Object data) {
        RequestResult result = new RequestResult();
        result.setSuccess(true);
        result.setData(data);
        result.setErrorCode(SUCCESS);
        return result;
    }

    public static RequestResult ex(Throwable ex) {
        RequestResult result = new RequestResult();
        result.setSuccess(false);
        result.setMessage(ex.getMessage());
        result.setErrorCode(RequestResult.getErrorCode(ex));
        return result;
    }

    public static RequestResult ex(Throwable ex, boolean showStackTrace) {
        RequestResult result = new RequestResult();
        result.setSuccess(false);
        if (ex instanceof KDBizException) {
            result.setMessage(ex.getMessage());
        } else {
            result.setMessage(showStackTrace ? ImportLogger.formatException((Throwable)ex) : ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RequestResult_1", (String)"taxc-tdm-common", (Object[])new Object[0]));
        }
        result.setErrorCode(RequestResult.getErrorCode(ex));
        return result;
    }

    private static String getErrorCode(Throwable ex) {
        if (ex instanceof KDException) {
            ErrorCode errorCode = ((KDException)ex).getErrorCode();
            return errorCode != null && StringUtils.isNotBlank((CharSequence)errorCode.getCode()) ? errorCode.getCode() : ERROR;
        }
        return ERROR;
    }

    public static RequestResult fromMap(Map<String, Object> ret) {
        RequestResult apiret = new RequestResult();
        apiret.init(ret);
        return apiret;
    }

    public static Map<String, Object> toMap(RequestResult result) {
        return result.toMap();
    }

    public Integer getHttpStatus() {
        return this.httpStatus;
    }

    public void setHttpStatus(Integer httpStatus) {
        this.httpStatus = httpStatus;
    }
}

