/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;

public class FormulaModifyHelper {
    public static final String[] Operaters = new String[]{"+", "-", "*", "/", "!=", "<>", "<=", ">=", "=", "<", ">"};
    public static final String CURSOR_INDEX = "cursorIndex";
    public static final String CTRL_KEY = "ctrlKey";
    public static final String SET_TEXTAREA_CURSOR_POSITION = "setTextareaCursorPosition";
    public static final String EXPRESSION_ELEMENT_PREFIX = "${";
    public static final String EXPRESSION_ELEMENT_SUFFIX = "}";
    public static final String EXPRESSION_ELEMENT_NAME_CODE_DELIMITER = "|";

    public static List<Integer[]> getFormulaElementIndexRange(String formula) {
        ArrayList<Integer[]> result = new ArrayList<Integer[]>(16);
        FormulaModifyHelper.parseFormulaElementIndex(formula, result, 0);
        return result;
    }

    private static void parseFormulaElementIndex(String formula, List<Integer[]> elementIndexRange, int startIndex) {
        if (StringUtils.isEmpty((CharSequence)formula)) {
            return;
        }
        if (formula.indexOf(EXPRESSION_ELEMENT_PREFIX) < 0) {
            return;
        }
        Integer[] indexRange = new Integer[2];
        int prefixIndex = formula.indexOf(EXPRESSION_ELEMENT_PREFIX);
        indexRange[0] = prefixIndex + startIndex;
        formula = formula.substring(prefixIndex + EXPRESSION_ELEMENT_PREFIX.length());
        int suffixIndex = formula.indexOf(EXPRESSION_ELEMENT_SUFFIX);
        for (int i = suffixIndex + 2; i <= formula.length() && formula.substring(i - 1, i).equals(" "); ++i) {
            ++suffixIndex;
        }
        indexRange[1] = prefixIndex + EXPRESSION_ELEMENT_PREFIX.length() + suffixIndex + EXPRESSION_ELEMENT_SUFFIX.length() + startIndex;
        elementIndexRange.add(indexRange);
        FormulaModifyHelper.parseFormulaElementIndex(formula.substring(suffixIndex + EXPRESSION_ELEMENT_SUFFIX.length()), elementIndexRange, indexRange[1]);
    }

    public static List<String> getFormulaElementInfo(String formula) {
        ArrayList<String> result = new ArrayList<String>(16);
        FormulaModifyHelper.parseFormulaElementInfo(formula, result);
        return result;
    }

    private static void parseFormulaElementInfo(String formula, List<String> elementList) {
        if (StringUtils.isEmpty((CharSequence)formula)) {
            return;
        }
        if (formula.indexOf(EXPRESSION_ELEMENT_PREFIX) < 0) {
            return;
        }
        int suffixIndex = (formula = formula.substring(formula.indexOf(EXPRESSION_ELEMENT_PREFIX) + EXPRESSION_ELEMENT_PREFIX.length())).indexOf(EXPRESSION_ELEMENT_SUFFIX);
        if (suffixIndex < 0) {
            return;
        }
        String elementInfo = formula.substring(0, suffixIndex).trim();
        elementList.add(elementInfo);
        FormulaModifyHelper.parseFormulaElementInfo(formula.substring(suffixIndex + EXPRESSION_ELEMENT_SUFFIX.length()), elementList);
    }

    public static void backspaceFormula(IFormView view, String buttonKey, String textFieldKey) {
        String expression = (String)view.getModel().getValue(textFieldKey);
        if (StringUtils.isBlank((CharSequence)expression)) {
            return;
        }
        int cursorIndex = FormulaEditHelper.getCursorIndex((IFormView)view, (String)buttonKey, (String)textFieldKey);
        List<Integer[]> formulaElementIndexRange = FormulaModifyHelper.getFormulaElementIndexRange(expression);
        Integer[] indexRange = null;
        for (Integer[] elementIndexRange : formulaElementIndexRange) {
            if (elementIndexRange[0] >= cursorIndex || elementIndexRange[1] < cursorIndex) continue;
            indexRange = elementIndexRange;
            break;
        }
        if (indexRange == null) {
            indexRange = FormulaModifyHelper.getBackspaceRangeIndex(expression, cursorIndex);
        }
        if (indexRange != null) {
            expression = expression.substring(0, indexRange[0]) + expression.substring(indexRange[1]);
            FormulaModifyHelper.resetExpression(view, indexRange[0], textFieldKey, expression);
        }
    }

    private static void resetExpression(IFormView view, int cursorIndex, String textFieldKey, String expression) {
        view.getModel().setValue(textFieldKey, (Object)expression);
        HashMap<String, Object> cursorMap = new HashMap<String, Object>(2);
        cursorMap.put(CURSOR_INDEX, cursorIndex);
        cursorMap.put(CTRL_KEY, textFieldKey);
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        proxy.addAction(SET_TEXTAREA_CURSOR_POSITION, cursorMap);
    }

    private static Integer[] getBackspaceRangeIndex(String expression, int cursorIndex) {
        if (cursorIndex == 0) {
            return null;
        }
        Integer[] result = new Integer[2];
        String cursorPreStr = expression.substring(cursorIndex - 1, cursorIndex);
        if (!cursorPreStr.equals(" ") && Arrays.stream(Operaters).noneMatch(p -> p.equals(cursorPreStr))) {
            for (int i = cursorIndex + 1; i <= expression.length(); ++i) {
                String nextStr = expression.substring(i - 1, i);
                if (cursorPreStr.equals(" ") || !Arrays.stream(Operaters).noneMatch(p -> p.equals(nextStr))) break;
                ++cursorIndex;
            }
        }
        result[1] = cursorIndex;
        String preStr = expression.substring(cursorIndex - 1, cursorIndex);
        int rangeStartIndex = cursorIndex - 1;
        if (preStr.equals(" ")) {
            boolean isWhiteSpace = true;
            for (int i = cursorIndex - 1; i > 0; --i) {
                String substring = expression.substring(i - 1, i);
                if (isWhiteSpace && substring.equals(" ")) {
                    --rangeStartIndex;
                    continue;
                }
                if (Arrays.stream(Operaters).anyMatch(p -> p.equals(substring))) {
                    --rangeStartIndex;
                } else if (!substring.equals(" ") && Arrays.stream(Operaters).noneMatch(p -> p.equals(substring))) {
                    --rangeStartIndex;
                    isWhiteSpace = false;
                    continue;
                }
                break;
            }
        } else if (Arrays.stream(Operaters).noneMatch(p -> p.equals(preStr))) {
            String substring;
            for (int i = cursorIndex - 1; i > 0 && !(substring = expression.substring(i - 1, i)).equals(" ") && Arrays.stream(Operaters).noneMatch(p -> p.equals(substring)); --i) {
                --rangeStartIndex;
            }
        }
        result[0] = rangeStartIndex;
        return result;
    }
}

