/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.common.metadata;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.TextProp;
import kd.taxc.tdm.common.metadata.EntityField;
import kd.taxc.tdm.common.metadata.EntityInfo;
import org.apache.commons.lang3.StringUtils;

public class MetadataUtil {
    public static EntityInfo getEntityById(String entityid) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
        if (mainEntityType != null) {
            EntityInfo entity = new EntityInfo();
            entity.setEntityId(entityid);
            if (mainEntityType.getDisplayName() != null) {
                entity.setEntityName(mainEntityType.getDisplayName().getLocaleValue());
            }
            entity.setTableName(mainEntityType.getAlias());
            DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
            StringBuilder sb = new StringBuilder();
            for (IDataEntityProperty property : mainPros) {
                DecimalProp decProp;
                EntityField entityField = new EntityField();
                entityField.setEntityId(entityid);
                entityField.setEntityName(entity.getEntityName());
                entityField.setFieldId(property.getName());
                if (property.getDisplayName() != null) {
                    entityField.setFieldName(property.getDisplayName().getLocaleValue());
                }
                if (property instanceof FieldProp) {
                    FieldProp field = (FieldProp)property;
                    entityField.setMustInput(field.isMustInput());
                }
                entityField.setColumnName(property.getAlias());
                entityField.setFieldType(property.getClass().getSimpleName().replaceAll("Prop", ""));
                if (property instanceof DecimalProp) {
                    decProp = (DecimalProp)property;
                    entityField.setPrecision(decProp.getPrecision());
                    entityField.setScale(decProp.getScale());
                    if ("tcvat_ybnsr_zb".equals(entityid)) {
                        entityField.setScale(2);
                        entityField.setFieldType("Decimal");
                    }
                } else if (property instanceof BasedataProp) {
                    decProp = (BasedataProp)property;
                    entityField.setBaseEntityId(decProp.getBaseEntityId());
                    entityField.setDisplayProp(decProp.getDisplayProp());
                } else if (property instanceof ComboProp) {
                    entityField.setComboItems(((ComboProp)property).getComboItems());
                } else if (property instanceof TextProp) {
                    entityField.setMaxLength(((TextProp)property).getMaxLenth());
                } else if (property instanceof DateTimeProp) {
                    entityField.setFormat(((DateTimeProp)property).getDateFormat());
                }
                entity.addField(entityField);
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(property.getName());
            }
            entity.setAllFields(sb.toString());
            return entity;
        }
        return null;
    }

    public static String getAllFieldString(String entityid) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
        if (mainEntityType != null) {
            DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
            StringBuilder sb = new StringBuilder();
            for (IDataEntityProperty property : mainPros) {
                if (StringUtils.isEmpty((CharSequence)property.getAlias())) continue;
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(property.getName());
            }
            return sb.toString();
        }
        return " * ";
    }

    public static EntityInfo getEntityAllById(String entityid) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
        if (mainEntityType != null) {
            EntityInfo entity = new EntityInfo();
            entity.setEntityId(entityid);
            if (mainEntityType.getDisplayName() != null) {
                entity.setEntityName(mainEntityType.getDisplayName().getLocaleValue());
            }
            entity.setTableName(mainEntityType.getAlias());
            StringBuilder sb = new StringBuilder();
            Map allEntities = mainEntityType.getAllEntities();
            for (Map.Entry entityentry : allEntities.entrySet()) {
                EntityType value = (EntityType)entityentry.getValue();
                DataEntityPropertyCollection mainPros = value.getProperties();
                for (IDataEntityProperty property : mainPros) {
                    DecimalProp decProp;
                    String parentName = property.getParent().getName();
                    if (StringUtils.isEmpty((CharSequence)property.getAlias())) continue;
                    String name = property.getName();
                    if (entityid.equals(parentName)) {
                        sb.append(name);
                    } else {
                        name = parentName + "." + name;
                    }
                    EntityField entityField = new EntityField();
                    entityField.setEntityId(entityid);
                    entityField.setEntityName(entity.getEntityName());
                    entityField.setFieldId(name);
                    if (property.getDisplayName() != null) {
                        entityField.setFieldName(property.getDisplayName().getLocaleValue());
                    }
                    if (property instanceof FieldProp) {
                        FieldProp field = (FieldProp)property;
                        entityField.setMustInput(field.isMustInput());
                    }
                    entityField.setColumnName(property.getAlias());
                    entityField.setFieldType(property.getClass().getSimpleName().replaceAll("Prop", ""));
                    if (property instanceof DecimalProp) {
                        decProp = (DecimalProp)property;
                        entityField.setPrecision(decProp.getPrecision());
                        entityField.setScale(decProp.getScale());
                    } else if (property instanceof BasedataProp) {
                        decProp = (BasedataProp)property;
                        entityField.setBaseEntityId(decProp.getBaseEntityId());
                        entityField.setDisplayProp(decProp.getDisplayProp());
                    } else if (property instanceof ComboProp) {
                        entityField.setComboItems(((ComboProp)property).getComboItems());
                    } else if (property instanceof TextProp) {
                        entityField.setMaxLength(((TextProp)property).getMaxLenth());
                    } else if (property instanceof DateTimeProp) {
                        entityField.setFormat(((DateTimeProp)property).getDateFormat());
                    }
                    entity.addField(entityField);
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(name);
                }
            }
            entity.setAllFields(sb.toString());
            return entity;
        }
        return null;
    }

    public static String getAllSubFieldString(String entityid) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
        if (mainEntityType != null) {
            StringBuilder sb = new StringBuilder();
            Map allFieldsMap = mainEntityType.getAllFields();
            Map allEntities = mainEntityType.getAllEntities();
            allEntities.forEach((a, b) -> {
                ISimpleProperty primaryKey = b.getPrimaryKey();
                if (Objects.equals(b.getName(), entityid)) {
                    allFieldsMap.put(primaryKey.getName(), primaryKey);
                } else {
                    allFieldsMap.put(b.getName() + "." + primaryKey.getName(), primaryKey);
                }
            });
            Collection allFields = allFieldsMap.values();
            for (IDataEntityProperty property : allFields) {
                String parentName = property.getParent().getName();
                if (StringUtils.isEmpty((CharSequence)property.getAlias())) continue;
                String name = property.getName();
                if (sb.length() > 0) {
                    sb.append(',');
                }
                if (entityid.equals(parentName)) {
                    sb.append(name);
                    continue;
                }
                sb.append(parentName);
                sb.append(".");
                sb.append(name);
            }
            return sb.toString();
        }
        return " * ";
    }

    public static List<ValueMapItem> getComboItems(String entityId, String fieldId) {
        DataEntityPropertyCollection mainPros;
        IDataEntityProperty property;
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        if (mainEntityType != null && (property = (IDataEntityProperty)(mainPros = mainEntityType.getProperties()).get((Object)fieldId)) instanceof ComboProp) {
            return ((ComboProp)property).getComboItems();
        }
        return null;
    }

    public static Map<String, String> getComboItemsMap(String entityId, String fieldId) {
        HashMap<String, String> itemMap = new HashMap<String, String>();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        if (mainEntityType != null) {
            IDataEntityProperty property = null;
            if (fieldId.contains(".")) {
                Map allEntities = mainEntityType.getAllEntities();
                String[] splits = fieldId.split("\\.");
                property = ((EntityType)allEntities.get(splits[0])).getProperty(splits[1]);
            } else {
                DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
                property = (IDataEntityProperty)mainPros.get((Object)fieldId);
            }
            if (property instanceof ComboProp) {
                List items = ((ComboProp)property).getComboItems();
                for (ValueMapItem item : items) {
                    itemMap.put(item.getValue(), item.getName().getLocaleValue());
                }
            }
        }
        return itemMap;
    }

    public static Map<String, String> getSubComboItemsMap(String entityId, String fieldId) {
        HashMap<String, String> itemMap = new HashMap<String, String>();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        if (mainEntityType != null) {
            Map allEntities = mainEntityType.getAllEntities();
            for (Map.Entry entityentry : allEntities.entrySet()) {
                EntityType value = (EntityType)entityentry.getValue();
                DataEntityPropertyCollection mainPros = value.getProperties();
                IDataEntityProperty property = (IDataEntityProperty)mainPros.get((Object)fieldId);
                if (property == null || !(property instanceof ComboProp)) continue;
                List items = ((ComboProp)property).getComboItems();
                for (ValueMapItem item : items) {
                    itemMap.put(item.getValue(), item.getName().getLocaleValue());
                }
            }
        }
        return itemMap;
    }
}

