/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.common.util;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.tdm.common.entity.CheckTimeDTO;
import kd.taxc.tdm.common.util.DateFilterUtils;
import org.apache.commons.lang.StringUtils;

public class CheckTimeRepeatUtils {
    public static final String STARTDATE = "start";
    public static final String ENDDATE = "end";
    public static final String RATIO = "ratio";
    public static final String TAXDEDUCTION_NUMBER = "taxdeduction.number";
    public static final String TAXDEDUCTION_NAME = "taxdeduction.name";

    public static CheckTimeDTO checkTimeRepeat(DynamicObjectCollection entryEntitys) {
        DateFilterUtils dateFilterUtils = new DateFilterUtils();
        CheckTimeDTO checkTimeDTO = new CheckTimeDTO(true);
        BigDecimal standard = new BigDecimal(1);
        for (int i = 0; i < entryEntitys.size(); ++i) {
            for (int j = 0; j < entryEntitys.size(); ++j) {
                DynamicObject dynamicObjectj;
                DynamicObject dynamicObjecti;
                if (j <= i || dateFilterUtils.noOverlap(dynamicObjecti = (DynamicObject)entryEntitys.get(i), dynamicObjectj = (DynamicObject)entryEntitys.get(j))) continue;
                String numberi = dynamicObjecti.getString(TAXDEDUCTION_NUMBER);
                String namei = dynamicObjecti.getString(TAXDEDUCTION_NAME);
                String numberj = dynamicObjectj.getString(TAXDEDUCTION_NUMBER);
                String namej = dynamicObjectj.getString(TAXDEDUCTION_NAME);
                if (StringUtils.equals((String)namei, (String)namej) && StringUtils.equals((String)numberi, (String)numberj)) {
                    checkTimeDTO.setResult(false);
                    checkTimeDTO.setMessqge(ResManager.loadKDString((String)"\u4e0d\u5f97\u540c\u65f6\u4eab\u53d72\u6761\u76f8\u540c\u7684\u51cf\u514d\u4f18\u60e0", (String)"CheckTimeRepeatUtils_0", (String)"taxc-tdm-common", (Object[])new Object[0]));
                    return checkTimeDTO;
                }
                if (standard.compareTo(dynamicObjecti.getBigDecimal(RATIO).add(dynamicObjectj.getBigDecimal(RATIO))) < 0) {
                    checkTimeDTO.setResult(false);
                    checkTimeDTO.setMessqge(ResManager.loadKDString((String)"\u5728\u540c\u4e00\u65f6\u6bb5\u5185\uff0c\u4f18\u60e0\u51cf\u514d\u6bd4\u4f8b\u4e0d\u5f97\u5927\u4e8e100%", (String)"CheckTimeRepeatUtils_1", (String)"taxc-tdm-common", (Object[])new Object[0]));
                    return checkTimeDTO;
                }
                if (entryEntitys.size() <= 2) continue;
                CheckTimeDTO repeatTime = CheckTimeRepeatUtils.getRepeatTime(dynamicObjecti, dynamicObjectj);
                for (int k = 0; k < entryEntitys.size(); ++k) {
                    if (k == i || k == j || CheckTimeRepeatUtils.checkTimeRepeat(repeatTime, (DynamicObject)entryEntitys.get(k))) continue;
                    checkTimeDTO.setResult(false);
                    checkTimeDTO.setMessqge(ResManager.loadKDString((String)"\u4e0d\u5f97\u540c\u65f6\u4eab\u53d73\u6761\u53ca\u4ee5\u4e0a\u51cf\u514d\u4f18\u60e0", (String)"CheckTimeRepeatUtils_2", (String)"taxc-tdm-common", (Object[])new Object[0]));
                    return checkTimeDTO;
                }
            }
        }
        return checkTimeDTO;
    }

    public static CheckTimeDTO getRepeatTime(DynamicObject obj1, DynamicObject obj2) {
        CheckTimeDTO checkTimeDTO = new CheckTimeDTO();
        Date start1 = obj1.getDate(STARTDATE);
        Date end1 = obj1.getDate(ENDDATE);
        Date start2 = obj2.getDate(STARTDATE);
        Date end2 = obj2.getDate(ENDDATE);
        if (start1.before(start2)) {
            checkTimeDTO.setStart(start2);
        } else {
            checkTimeDTO.setStart(start1);
        }
        if (end1 == null) {
            checkTimeDTO.setEnd(end2);
            return checkTimeDTO;
        }
        if (end2 == null) {
            checkTimeDTO.setEnd(end1);
            return checkTimeDTO;
        }
        if (end1.before(end2)) {
            checkTimeDTO.setEnd(end1);
        } else {
            checkTimeDTO.setEnd(end2);
        }
        return checkTimeDTO;
    }

    public static boolean checkTimeRepeat(CheckTimeDTO repeatTime, DynamicObject obj2) {
        Date start1 = repeatTime.getStart();
        Date end1 = repeatTime.getEnd();
        Date start2 = obj2.getDate(STARTDATE);
        Date end2 = obj2.getDate(ENDDATE);
        if (end1 == null) {
            if (end2 == null) {
                return Boolean.FALSE;
            }
            return end2.before(start1);
        }
        if (end2 == null) {
            return end1.before(start2);
        }
        return start1.before(start2) && end1.before(start2) || start1.after(end2) && end1.after(end2);
    }
}

