/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tdm.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tdm.common.helper.OrgServiceHelper;
import kd.taxc.tdm.common.util.EmptyCheckUtils;

public class OrgUtils {
    private static final boolean DISABLED_FILTER = true;
    public static final Set<String> MUST_IS_TAXPAYER = new HashSet<String>(Arrays.asList("tccit_seasonal_declare", "tccit_seasonal_declare2", "tccit_mainpage", "tccit_newmainpage", "tcvat_draft_page", "tcvat_declare_home", "tcvat_declare_edit", "tcret_pbt_declare_home", "tcct_draft_edit", "tcct_declare_new", "tcvat_apphome", "tccit_apphome", "tcret_apphome_new", "tcct_apphome", "tsate_declare_config"));
    private static final String BASTAX_TAXORG = "bastax_taxorg";

    public static final List<String> getOrgIdByStructurePkids(List<String> structureIds) {
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "in", structureIds.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList()))});
        return EmptyCheckUtils.isEmpty(dys) ? new ArrayList<String>() : dys.stream().map(v -> v.getString("org")).collect(Collectors.toList());
    }

    public static final List<String> getStructurePkidsByOrgId(List<String> orgIds) {
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bos_org_structure", (String)"id", (QFilter[])new QFilter[]{new QFilter("org.id", "in", orgIds.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList())), OrgUtils.getDefaultTaxOrgStructureViewQfilter()});
        return EmptyCheckUtils.isEmpty(dys) ? new ArrayList<String>() : dys.stream().map(v -> v.getString("id")).distinct().collect(Collectors.toList());
    }

    public static QFilter getDefaultTaxOrgStructureViewQfilter() {
        return new QFilter("view.treetype", "=", (Object)String.valueOf(OrgServiceHelper.getDefaultViewSchemaInfoId())).and("view.number", "=", (Object)String.valueOf(OrgServiceHelper.getLocalDefaultViewId()));
    }
}

